
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/Common/LiteGraphCore/nodes/output.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'b87ebvs+rhFqYBhWRGG08PW', 'output');
// Script/Common/LiteGraphCore/nodes/output.js

"use strict";

var _litegraph = require("../../litegraph/litegraph");

var CocosMgr = _interopRequireWildcard(require("../CocosMgr"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

// import VoiceGen from '@/xfyun/VoiceGen';
//ONEVENT是节点自带的事件触发，ONToggle是通用的节点触发，节点自带的事件想要触发就只能设置为OnEvent模式，执行对应的Action
var showTextTip = /*#__PURE__*/function (_LGraphNode) {
  _inheritsLoose(showTextTip, _LGraphNode);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  function showTextTip() {
    var _this;

    _this = _LGraphNode.call(this) || this;
    _this.title = "文字提示";
    _this.desc = "弹出文字提示信息";
    _this.color = '#510';
    _this.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式
    // this.size = [80, 30];               //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")
    // this.addOutput("bool", "boolean")   //增加一个输出触点，  输出节点的名称， 值类型

    _this.addProperty("msg", ""); //增加一个变量，    变量名称， 变量名称


    _this.addInput("", _litegraph.LiteGraph.EVENT);

    _this.widget = _this.addWidget("text", "Text", "", "msg");
    _this.widgets_up = true;
    _this.size = [200, 30]; //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // this.widget = this.addWidget("toggle","value",true,"value");
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1

    return _this;
  } // Function to call when the node is executed
  //执行时的方法


  var _proto = showTextTip.prototype;

  _proto.onExecute = function onExecute() {// console.log("consoleInfo onExecute")
    //   var A = this.getInputData(0)
    //可以反向获取输入的值，不需要被动输入值，目前看来确实更合理
    // var msg = this.getInputData(0); //getInputDataByName("msg");
    // console.log('consoleInfo:', msg);
    // if (!msg) msg = this.properties.msg;
    // if (msg != null && typeof msg != "undefined") {
    //     this.properties.msg = msg;
    // }
  } // onSelected(){
  //     console.log("consoleInfo onSelected")
  // }
  //动态返回卡片显示的title
  // getTitle() {
  //    var msg = this.getInputOrProperty('msg')
  //    if(msg != null)
  //    return this.title;
  // };
  //暂不清楚用处
  ;

  _proto.setValue = function setValue(v) {
    this.setProperty("value", v);
  } // 获取可以接受的输入
  // onGetInputs() {
  // 	return [
  //         ["log", LiteGraph.ACTION],
  //         ["warn", LiteGraph.ACTION],
  //         ["error", LiteGraph.ACTION]
  //     ];
  // };
  // 当节点Toggle时调用
  ;

  _proto.onAction = function onAction(action, param) {
    var msg = this.properties.msg;
    CocosMgr.showAlert(msg); //暂时调用网页提醒
    //提供接入cocos的提示，或者是ant的消息提示
    //需要一个统一的接入管理器
  } //自定义触点显示的文字
  // onDrawBackground(ctx) {
  //     //show the current value
  //     this.outputs[0].label = this.properties["value"] ? '真' : '假'
  // };
  //使用ctx绘制需要显示的内容
  // onDrawForeground(ctx){
  //     var size = this.size[1] * 0.5;
  //     var h = this.size[1] * 0.8;
  //     ctx.textAlign = "left";
  //     ctx.fillStyle = "#AAA";
  //     ctx.fillText('测试绘制文字', size * 1.2, h * 0.85);
  //     ctx.textAlign = "left";
  //     // this.outputs[0].label = this.properties["value"].toFixed(2);
  // }
  ;

  return showTextTip;
}(_litegraph.LGraphNode);

showTextTip.title = '文字提示';

_litegraph.LiteGraph.registerNodeType("output/tips/showTextTip", showTextTip);

var showConfirm = /*#__PURE__*/function (_LGraphNode2) {
  _inheritsLoose(showConfirm, _LGraphNode2);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  function showConfirm() {
    var _this2;

    _this2 = _LGraphNode2.call(this) || this;
    _this2.title = "确认框";
    _this2.desc = "弹出文字提示确认框，用户可点击确认或取消";
    _this2.color = '#510';
    _this2.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式
    // this.size = [80, 30];               //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")
    // this.addOutput("bool", "boolean")   //增加一个输出触点，  输出节点的名称， 值类型

    _this2.addProperty("msg", ""); //增加一个变量，    变量名称， 变量名称


    _this2.addInput("", _litegraph.LiteGraph.EVENT);

    _this2.widget = _this2.addWidget("text", "Text", "", "msg"); // this.widgets_up = true;
    // this.size = [200, 30];

    _this2.addOutput('确认', _litegraph.LiteGraph.EVENT);

    _this2.addOutput('取消', _litegraph.LiteGraph.EVENT); //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // this.widget = this.addWidget("toggle","value",true,"value");
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this2;
  } // Function to call when the node is executed
  //执行时的方法
  // onExecute() {
  // console.log("consoleInfo onExecute")
  //   var A = this.getInputData(0)
  //可以反向获取输入的值，不需要被动输入值，目前看来确实更合理
  // var msg = this.getInputData(0); //getInputDataByName("msg");
  // console.log('consoleInfo:', msg);
  // if (!msg) msg = this.properties.msg;
  // if (msg != null && typeof msg != "undefined") {
  //     this.properties.msg = msg;
  // }
  // }
  // onSelected(){
  //     console.log("consoleInfo onSelected")
  // }
  //动态返回卡片显示的title
  // getTitle() {
  //    var msg = this.getInputOrProperty('msg')
  //    if(msg != null)
  //    return this.title;
  // };
  //暂不清楚用处
  // setValue(v){
  // 	this.setProperty("value",v);
  // }
  // 获取可以接受的输入
  // onGetInputs() {
  // 	return [
  //         ["log", LiteGraph.ACTION],
  //         ["warn", LiteGraph.ACTION],
  //         ["error", LiteGraph.ACTION]
  //     ];
  // };
  // 当节点Toggle时调用


  var _proto2 = showConfirm.prototype;

  _proto2.onAction = function onAction(action, param) {
    var _this3 = this;

    var msg = this.properties.msg;
    CocosMgr.showConfirm(msg, function (result) {
      if (result == true) {
        _this3.trigger('确认');
      } else {
        _this3.trigger('取消');
      }
    }); // console.log('用户点击了result', result)
    //暂时调用网页提醒
    //提供接入cocos的提示，或者是ant的消息提示
    //需要一个统一的接入管理器
  } //自定义触点显示的文字
  // onDrawBackground(ctx) {
  //     //show the current value
  //     this.inputs[0].label = 'msg:' + this.msg
  // };
  //使用ctx绘制需要显示的内容
  // onDrawForeground(ctx){
  //     var size = this.size[1] * 0.5;
  //     var h = this.size[1] * 0.8;
  //     ctx.textAlign = "left";
  //     ctx.fillStyle = "#AAA";
  //     ctx.fillText('测试绘制文字', size * 1.2, h * 0.85);
  //     ctx.textAlign = "left";
  //     // this.outputs[0].label = this.properties["value"].toFixed(2);
  // }
  ;

  return showConfirm;
}(_litegraph.LGraphNode);

showConfirm.title = '确认框';

_litegraph.LiteGraph.registerNodeType("output/tips/showConfirm", showConfirm);

var showHandTip = /*#__PURE__*/function (_LGraphNode3) {
  _inheritsLoose(showHandTip, _LGraphNode3);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function showHandTip() {
    var _this4;

    _this4 = _LGraphNode3.call(this) || this; // this.serialize_widgets = true

    _this4.title = "触摸提示";
    _this4.desc = "播放一个触摸提示的动画";
    _this4.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式
    // this.size = [80, 30];               //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")
    // this.addOutput("bool", "boolean")   //增加一个输出触点，  输出节点的名称， 值类型
    // this.addProperty("msg", "");   //增加一个变量，    变量名称， 变量名称

    _this4.addInput("物体", 'codeNode');

    _this4.addInput("显示", _litegraph.LiteGraph.ACTION);

    _this4.addInput("关闭", _litegraph.LiteGraph.ACTION);

    _this4.addOutput('结束', _litegraph.LiteGraph.EVENT); // this.widget = this.addWidget("text", "Text", "", "msg");
    // this.widgets_up = true;
    // this.size = [200, 30];


    _this4.properties.modal = showHandTip.modalEnum[0];

    _this4.addWidget('combo', '类型', _this4.properties.modal, {
      property: "modal",
      values: showHandTip.modalEnum
    });

    _this4.properties.scale = 1;

    _this4.addWidget('number', '大小', _this4.properties.scale, 'scale', {
      precision: 1
    });

    _this4.properties.x = 0;

    _this4.addWidget('number', '拖拽终点-x', _this4.properties.x, 'x', {
      precision: 0
    });

    _this4.properties.y = 0;

    _this4.addWidget('number', '拖拽终点-y', _this4.properties.y, 'y', {
      precision: 0
    });

    _this4.properties.length = 100;

    _this4.addWidget('number', '长度或半径', _this4.properties.length, 'length', {
      precision: 0
    });

    _this4.properties.speed = 400;

    _this4.addWidget('number', '速度', _this4.properties.length, 'speed', {
      precision: 0
    }); // this.addOutput('取消', LiteGraph.EVENT)


    _this4.updateWidght();

    _this4.addWidget('button', '预览效果', "", function () {
      _this4.showTips();
    });

    _this4.addWidget('button', '创建触摸动画', "", function () {
      _this4.createLinkNode();
    }); // this.addWidget('button','重置起始位置', "", ()=>{
    //     this.oriX = null
    //     this.oriY = null
    //     this.
    // })
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // this.widget = this.addWidget("toggle","value",true,"value");
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1
    // this.isAnyOutputConnected()
    // this.isInputConnected()


    return _this4;
  } //当添加的时候自动生成物体组件并关联
  // onAdded(){
  //     if(CocosMgr.isInImport){
  //         //整体导入时不自动添加物体
  //         return
  //     }
  //     let aniNode = LiteGraph.createNode("objects/createObject");
  //     aniNode.pos = [this.pos[0] - this.width - 3, this.pos[1]]
  //     aniNode.setProperty('x', 0)
  //     aniNode.setProperty('y', 0)
  //     aniNode.setProperty('modal', CocosMgr.ObjectTypeEnum.spine)
  //     aniNode.setProperty('customeName', 'P0_Common_Finger')
  //     aniNode.properties.nodeConfig.x = 0
  //     aniNode.properties.nodeConfig.y = 0
  //     this.graph.add(aniNode);
  //     // aniNode.properties.customeName = 'P0_Common_Finger'
  //     aniNode.connect(0, this, 0)
  // }


  var _proto3 = showHandTip.prototype;

  _proto3.createLinkNode = function createLinkNode() {
    if (this.getInputNode(0) == null) {
      var aniNode = _litegraph.LiteGraph.createNode("objects/createObject");

      aniNode.pos = [this.pos[0] - this.width - 3, this.pos[1]];
      aniNode.setProperty('x', 0);
      aniNode.setProperty('y', 0);
      aniNode.setProperty('modal', CocosMgr.ObjectTypeEnum.spine);
      aniNode.setProperty('customeName', 'P0_Common_Finger');
      aniNode.properties.nodeConfig.x = 0;
      aniNode.properties.nodeConfig.y = 0;
      this.graph.add(aniNode); // aniNode.properties.customeName = 'P0_Common_Finger'

      aniNode.connect(0, this, 0);
    }
  } //更新模块
  ;

  _proto3.updateWidght = function updateWidght() {
    var value = this.properties.modal;
    this.widgets.map(function (widget) {
      if (widget.name == '拖拽终点-x' || widget.name == '拖拽终点-y') {
        widget.disabled = value != '拖拽';
      } else if (widget.name == '长度或半径') {
        widget.disabled = value == '拖拽' || value == '单次点击' || value == '快速点击' || value == '长按';
      } else if (widget.name == '速度') {
        widget.disabled = value == '单次点击' || value == '快速点击' || value == '长按';
      }
    });
  };

  _proto3.onWidgetChanged = function onWidgetChanged(name) {
    if (name == '类型') {
      this.updateWidght();
    }
  } // Function to call when the node is executed
  //执行时的方法
  // onExecute() {
  // console.log("consoleInfo onExecute")
  //   var A = this.getInputData(0)
  //可以反向获取输入的值，不需要被动输入值，目前看来确实更合理
  // var msg = this.getInputData(0); //getInputDataByName("msg");
  // console.log('consoleInfo:', msg);
  // if (!msg) msg = this.properties.msg;
  // if (msg != null && typeof msg != "undefined") {
  //     this.properties.msg = msg;
  // }
  // }
  // onSelected(){
  //     console.log("consoleInfo onSelected")
  // }
  //动态返回卡片显示的title
  // getTitle() {
  //    var msg = this.getInputOrProperty('msg')
  //    if(msg != null)
  //    return this.title;
  // };
  //暂不清楚用处
  // setValue(v){
  // 	this.setProperty("value",v);
  // }
  // 获取可以接受的输入
  // onGetInputs() {
  // 	return [
  //         ["log", LiteGraph.ACTION],
  //         ["warn", LiteGraph.ACTION],
  //         ["error", LiteGraph.ACTION]
  //     ];
  // };
  ;

  _proto3.onSelected = function onSelected() {
    this.showTips();
  } //更新起点位置
  ;

  _proto3.upDateOriPos = function upDateOriPos() {
    var curLink = this.getInputLink(0);

    if (curLink == null) {
      return;
    }

    var linkedNode = this.graph.getNodeById(curLink.origin_id);

    if (linkedNode == null) {
      return;
    }

    var codeNode = this.getInputData(0);

    if (linkedNode.properties.x != null && codeNode != null) {
      codeNode.x = linkedNode.properties.x;
      codeNode.y = linkedNode.properties.y;
    }
  };

  _proto3.onDeselected = function onDeselected() {
    this.hideTips(); // var curLink = this.getInputLink(0)
    // if(curLink == null){
    //     return
    // }
    // var linkedNode = this.graph.getNodeById(curLink.origin_id)
    // if(linkedNode == null){
    //     return
    // }
    // if(linkedNode != null){
    //     // if(linkedNode.codeNode != null){
    //     //     linkedNode.codeNode.active = true
    //     // } 
    //     linkedNode.resetSizeConfig()
    // }

    var codeNode = this.getInputData(0);

    if (this.oriX != null && codeNode != null) {
      codeNode.x = this.oriX;
      codeNode.y = this.oriY;
    }
  };

  _proto3.onPause = function onPause() {
    if (this.inShowTips == true) {
      this.hideTips();
    }
  };

  _proto3.onResume = function onResume() {
    if (this.inShowTips == true) {
      this.showTips();
    }
  };

  _proto3.onStop = function onStop() {// this.oriX = null
    // this.oriY = null
  };

  _proto3.showTips = function showTips() {
    var _this5 = this;

    var codeNode = this.getInputData(0);

    if (codeNode == null) {
      console.warn('showTips 当前没有关联codeNode');
      return;
    }

    codeNode.useCenterMode = false; //使用中心模式

    cc.Tween.stopAllByTarget(this);
    cc.Tween.stopAllByTag(this.getIdWithGraph());
    this.upDateOriPos(); // this.hideTips()  
    // this.oriX = codeNode.x
    // this.oriY = codeNode.y

    codeNode.center = [codeNode.x, codeNode.y];
    codeNode.active = true;
    codeNode.scale = this.properties.scale;
    var modal = showHandTip.modalEnum.indexOf(this.properties.modal);
    var spineCom = codeNode.spineCom; // console.log('准备showTips', modal)

    if (spineCom != null) {
      // ['单次点击','快速点击','拖拽','上下滑动','左右滑动','转圈','长按']
      if (modal == 0) {
        //单次点击
        spineCom.setAnimation(0, 'act1', true);
        spineCom.setCompleteListener(function (trackEntry) {
          // let ccompleteName = trackEntry.animation.name;
          _this5.outputHandle();
        });
      } else if (modal == 1) {
        //快速点击
        spineCom.setAnimation(0, 'act2', true);
        spineCom.setCompleteListener(function (trackEntry) {
          // let ccompleteName = trackEntry.animation.name;
          _this5.outputHandle();
        });
      } else if (modal == 2) {
        //拖拽
        spineCom.setAnimation(0, 'act3_1', false);
        spineCom.addAnimation(0, 'act3_2', true);
        var x = this.properties.x;
        var y = this.properties.y;
        var lengthx = codeNode.x - x;
        var lengthy = codeNode.y - y;

        if (this.properties.speed == 0) {
          return;
        }

        var time = Math.sqrt(lengthy * lengthy + lengthx * lengthx) / this.properties.speed;

        if (time == 0) {
          return;
        } // var oriX = codeNode.x 
        // var oriY = codeNode.y


        cc.tween(codeNode).tag(this.getIdWithGraph()).delay(0.3).to(time, {
          x: x,
          y: y
        }).call(function () {
          spineCom.loop = false;
          spineCom.addAnimation(0, 'act3_3', false);
          cc.tween(_this5).delay(1).call(function () {
            // codeNode.x = oriX
            // codeNode.y = oriY
            _this5.outputHandle();

            _this5.showTips();
          }).start();
        }).start();
      } else if (modal == 3) {
        //上下滑动
        var length = this.properties.length;

        if (this.properties.speed == 0) {
          return;
        }

        var time = length / this.properties.speed;
        spineCom.setAnimation(0, 'act3_2', true);

        if (time == 0) {
          return;
        }

        cc.tween(codeNode).tag(this.getIdWithGraph()).to(time, {
          y: codeNode.y - length
        }).to(time * 2, {
          y: codeNode.y + length
        }).to(time, {
          y: codeNode.y
        }).call(function () {
          _this5.outputHandle();

          _this5.showTips();
        }).start();
      } else if (modal == 4) {
        //左右滑动
        var length = this.properties.length;

        if (this.properties.speed == 0) {
          return;
        }

        var time = Math.abs(length / this.properties.speed);
        spineCom.setAnimation(0, 'act3_2', true);

        if (time == 0) {
          return;
        }

        cc.tween(codeNode).tag(this.getIdWithGraph()).to(time, {
          x: codeNode.x - length
        }).to(time * 2, {
          x: codeNode.x + length
        }).to(time, {
          x: codeNode.x
        }).call(function () {
          _this5.outputHandle();

          _this5.showTips();
        }).start();
      } else if (modal == 5) {
        //转圈
        codeNode.radius = this.properties.length;
        codeNode.useCenterMode = true;

        if (this.properties.speed == 0) {
          return;
        }

        var time = Math.abs(Math.PI * 2 / (this.properties.speed * 0.01));

        if (time == 0) {
          return;
        }

        spineCom.setAnimation(0, 'act3_2', true);
        var angle = this.properties.speed > 0 ? 360 : -360; // console.log('多少秒转一圈',time, angle)

        cc.tween(codeNode).tag(this.getIdWithGraph()).by(time, {
          angleToPos: angle
        }).call(function () {
          _this5.outputHandle();

          _this5.showTips();
        }).start();
      } else if (modal == 6) {
        //长按
        spineCom.setAnimation(0, 'act3_1', false);
        spineCom.addAnimation(0, 'act3_2', true);
        cc.tween(this).delay(2).call(function () {
          spineCom.loop = false;
          spineCom.addAnimation(0, 'act3_3', false);
          cc.tween(_this5).delay(0.8).call(function () {
            _this5.outputHandle();

            _this5.showTips();
          }).start();
        }).start();
      }
    } else {
      console.warn('showTip 目标没有spine');
    }
  };

  _proto3.outputHandle = function outputHandle() {
    this.triggerSlot(0);
  };

  _proto3.hideTips = function hideTips() {
    cc.Tween.stopAllByTarget(this);
    var codeNode = this.getInputData(0);

    if (codeNode == null) {
      console.warn('showTips 当前没有关联codeNode');
      return;
    }

    if (codeNode != null) {
      codeNode.useCenterMode = false; //使用中心模式
      // cc.Tween.stopAllByTarget(codeNode);

      cc.Tween.stopAllByTag(this.getIdWithGraph());

      if (codeNode.spineCom != null) {
        codeNode.spineCom.clearTrack(0);
      }

      codeNode.active = false;
    } // this.oriX = null
    // this.oriY = null

  };

  _proto3.onStart = function onStart() {
    //开始时默认是关闭引导的
    this.onAction('关闭');
  } // 当节点Toggle时调用
  ;

  _proto3.onAction = function onAction(action, param) {
    if (action == '显示') {
      this.inShowTips = true;
      this.showTips();
    } else if (action == '关闭') {
      this.inShowTips = false;
      this.hideTips();
    } //结束
    //this.trigger('结束')
    //暂时调用网页提醒
    //提供接入cocos的提示，或者是ant的消息提示
    //需要一个统一的接入管理器

  } //自定义触点显示的文字
  // onDrawBackground(ctx) {
  //     //show the current value
  //     this.outputs[0].label = this.properties["value"] ? '真' : '假'
  // };
  //使用ctx绘制需要显示的内容
  // onDrawForeground(ctx){
  //     var size = this.size[1] * 0.5;
  //     var h = this.size[1] * 0.8;
  //     ctx.textAlign = "left";
  //     ctx.fillStyle = "#AAA";
  //     ctx.fillText('测试绘制文字', size * 1.2, h * 0.85);
  //     ctx.textAlign = "left";
  //     // this.outputs[0].label = this.properties["value"].toFixed(2);
  // }
  ;

  return showHandTip;
}(_litegraph.LGraphNode);

showHandTip.title = '触摸提示';
showHandTip.modalEnum = ['单次点击', '快速点击', '拖拽', '上下滑动', '左右滑动', '转圈', '长按'];

_litegraph.LiteGraph.registerNodeType("output/tips/showHandTip", showHandTip); // blockTouch


var blockTouch = /*#__PURE__*/function (_LGraphNode4) {
  _inheritsLoose(blockTouch, _LGraphNode4);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function blockTouch() {
    var _this6;

    _this6 = _LGraphNode4.call(this) || this; // this.serialize_widgets = true

    _this6.title = "屏蔽触摸";
    _this6.desc = "屏蔽触摸事件，简化流程";
    _this6.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式

    _this6.size = [80, 30]; //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")
    // this.addOutput("bool", "boolean")   //增加一个输出触点，  输出节点的名称， 值类型
    // this.addProperty("msg", "");   //增加一个变量，    变量名称， 变量名称

    _this6.addInput("开启", _litegraph.LiteGraph.ACTION);

    _this6.addInput("关闭", _litegraph.LiteGraph.ACTION); //设置节点的进度，一般来说用于在执行的时候设置
    // this.widget = this.addWidget("toggle","value",true,"value");
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this6;
  } // Function to call when the node is executed
  //执行时的方法
  // onExecute() {
  // console.log("consoleInfo onExecute")
  //   var A = this.getInputData(0)
  //可以反向获取输入的值，不需要被动输入值，目前看来确实更合理
  // var msg = this.getInputData(0); //getInputDataByName("msg");
  // console.log('consoleInfo:', msg);
  // if (!msg) msg = this.properties.msg;
  // if (msg != null && typeof msg != "undefined") {
  //     this.properties.msg = msg;
  // }
  // }
  // onSelected(){
  //     console.log("consoleInfo onSelected")
  // }
  //动态返回卡片显示的title
  // getTitle() {
  //    var msg = this.getInputOrProperty('msg')
  //    if(msg != null)
  //    return this.title;
  // };
  // onStart(){
  // //    this.codeNode = CocosMgr.createObj(config, loadCb)
  // }


  var _proto4 = blockTouch.prototype;

  _proto4.onStop = function onStop() {
    CocosMgr.blockTouch(false);
  } //暂不清楚用处
  // setValue(v){
  // 	this.setProperty("value",v);
  // }
  // 获取可以接受的输入
  // onGetInputs() {
  // 	return [
  //         ["log", LiteGraph.ACTION],
  //         ["warn", LiteGraph.ACTION],
  //         ["error", LiteGraph.ACTION]
  //     ];
  // };
  // 当节点Toggle时调用
  ;

  _proto4.onAction = function onAction(action, param) {
    if (action == '开启') {
      CocosMgr.blockTouch(true);
    } else if (action == '关闭') {
      CocosMgr.blockTouch(false);
    } //结束
    //this.trigger('结束')
    //暂时调用网页提醒
    //提供接入cocos的提示，或者是ant的消息提示
    //需要一个统一的接入管理器

  } //自定义触点显示的文字
  // onDrawBackground(ctx) {
  //     //show the current value
  //     this.outputs[0].label = this.properties["value"] ? '真' : '假'
  // };
  //使用ctx绘制需要显示的内容
  // onDrawForeground(ctx){
  //     var size = this.size[1] * 0.5;
  //     var h = this.size[1] * 0.8;
  //     ctx.textAlign = "left";
  //     ctx.fillStyle = "#AAA";
  //     ctx.fillText('测试绘制文字', size * 1.2, h * 0.85);
  //     ctx.textAlign = "left";
  //     // this.outputs[0].label = this.properties["value"].toFixed(2);
  // }
  ;

  return blockTouch;
}(_litegraph.LGraphNode);

blockTouch.title = '屏蔽触摸';

_litegraph.LiteGraph.registerNodeType("output/blockTouch", blockTouch);

var consoleInfo = /*#__PURE__*/function (_LGraphNode5) {
  _inheritsLoose(consoleInfo, _LGraphNode5);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  function consoleInfo() {
    var _this7;

    _this7 = _LGraphNode5.call(this) || this;
    _this7.title = "输出控制台";
    _this7.desc = "打印内容到控制台";
    _this7.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式
    // this.size = [80, 30];               //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")
    // this.addOutput("bool", "boolean")   //增加一个输出触点，  输出节点的名称， 值类型

    _this7.addInput("msg", 0); //0表示可以是任何类型


    _this7.addInput("log", _litegraph.LiteGraph.ACTION);

    _this7.addInput("warn", _litegraph.LiteGraph.ACTION);

    _this7.addInput("error", _litegraph.LiteGraph.ACTION);

    _this7.addProperty("msg", ""); //增加一个变量，    变量名称， 变量名称


    _this7.addWidget("string", "msg", _this7.properties.msg, 'msg'); //增加一个变量，    变量名称， 变量名称
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // this.widget = this.addWidget("toggle","value",true,"value");
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定


    _this7.widgets_up = true; //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1

    return _this7;
  } // Function to call when the node is executed
  //执行时的方法


  var _proto5 = consoleInfo.prototype;

  _proto5.onExecute = function onExecute() {
    // console.log("consoleInfo onExecute")
    //   var A = this.getInputData(0)
    //可以反向获取输入的值，不需要被动输入值，目前看来确实更合理
    var msg = this.getInputOrProperty('msg'); //getInputDataByName("msg");

    console.log('consoleInfo:', msg); // if (!msg) msg = this.properties.msg;
    // if (msg != null && typeof msg != "undefined") {
    //     this.properties.msg = msg;
    // }
  } // onSelected(){
  //     console.log("consoleInfo onSelected")
  // }
  //动态返回卡片显示的title
  // getTitle() {
  //     if (this.flags.collapsed) {
  //         return this.properties.value;
  //     }
  //     return this.title;
  // };
  //暂不清楚用处
  ;

  _proto5.setValue = function setValue(v) {
    this.setProperty("value", v);
  } // 获取可以接受的输入
  ;

  _proto5.onGetInputs = function onGetInputs() {
    return [["log", _litegraph.LiteGraph.ACTION], ["warn", _litegraph.LiteGraph.ACTION], ["error", _litegraph.LiteGraph.ACTION]];
  };

  // 当节点Toggle时调用
  _proto5.onAction = function onAction(action, param) {
    // console.log("consoleInfo onAction", action, param)
    // param is the action
    var msg = this.getInputOrProperty('msg'); //getInputDataByName("msg");
    //if (msg == null || typeof msg == "undefined") return;
    //  if (!msg) msg = this.properties.msg;
    //  if (!msg) msg = "Event param: " + param; // msg is undefined if the slot is lost?

    if (action == "log") {
      console.log('consoleInfo', msg);
    } else if (action == "warn") {
      console.warn('consoleInfo', msg);
    } else if (action == "error") {
      console.error('consoleInfo', msg);
    }
  } //自定义触点显示的文字
  // onDrawBackground(ctx) {
  //     //show the current value
  //     this.outputs[0].label = this.properties["value"] ? '真' : '假'
  // };
  ;

  _proto5.onDrawBackground = function onDrawBackground(ctx) {
    //show the current value
    if (this.getInputData(0) != null) {
      this.inputs[0].label = 'msg:' + this.getInputData(0);
    } else {
      this.inputs[0].label = 'msg';
    }
  };

  return consoleInfo;
}(_litegraph.LGraphNode);

consoleInfo.title = '输出控制台';

_litegraph.LiteGraph.registerNodeType("output/tips/consoleInfo", consoleInfo);

var restartGame = /*#__PURE__*/function (_LGraphNode6) {
  _inheritsLoose(restartGame, _LGraphNode6);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function restartGame() {
    var _this8;

    _this8 = _LGraphNode6.call(this) || this; // this.serialize_widgets = true

    _this8.title = "重新开始";
    _this8.desc = "重新开始游戏流程";
    _this8.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式

    _this8.size = [80, 20]; //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")
    // this.addOutput("bool", "boolean")   //增加一个输出触点，  输出节点的名称， 值类型
    // this.addProperty("msg", "");   //增加一个变量，    变量名称， 变量名称

    _this8.addInput("重启", _litegraph.LiteGraph.ACTION); //设置节点的进度，一般来说用于在执行的时候设置
    // this.widget = this.addWidget("toggle","value",true,"value");
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this8;
  } // 当节点Toggle时调用


  var _proto6 = restartGame.prototype;

  _proto6.onAction = function onAction(action, param) {
    if (action == '重启') {
      this.graph.stop();
      this.graph.start();
    }
  };

  return restartGame;
}(_litegraph.LGraphNode);

restartGame.title = '重新开始';

_litegraph.LiteGraph.registerNodeType("output/game/restartGame", restartGame);

var changeGame = /*#__PURE__*/function (_LGraphNode7) {
  _inheritsLoose(changeGame, _LGraphNode7);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function changeGame() {
    var _this9;

    _this9 = _LGraphNode7.call(this) || this; // this.serialize_widgets = true

    _this9.title = "切换页面";
    _this9.desc = "切换到新的页面";
    _this9.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式

    _this9.size = [80, 20]; //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")
    // this.addOutput("bool", "boolean")   //增加一个输出触点，  输出节点的名称， 值类型

    _this9.addProperty("pageIndex", 0, 'number'); //增加一个变量，    变量名称， 变量名称


    _this9.addWidget("number", "页码", _this9.properties.pageIndex, "pageIndex", {
      precision: 0,
      min: 1
    }); //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称


    _this9.addProperty("gamePath", "", 'string');

    _this9.addWidget("string", '页面名称', _this9.properties.gamePath, "gamePath");

    _this9.addInput("切换", _litegraph.LiteGraph.ACTION); //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this9;
  } // 当节点Toggle时调用


  var _proto7 = changeGame.prototype;

  _proto7.onAction = function onAction(action, param) {
    if (action == '切换') {
      this.graph.stop();
      CocosMgr.changeGraph(this.properties.gamePath, this.properties.pageIndex - 1);
    }
  };

  return changeGame;
}(_litegraph.LGraphNode);

changeGame.title = '切换页面';

_litegraph.LiteGraph.registerNodeType("output/game/changeGame", changeGame);

var endGame = /*#__PURE__*/function (_LGraphNode8) {
  _inheritsLoose(endGame, _LGraphNode8);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function endGame() {
    var _this10;

    _this10 = _LGraphNode8.call(this) || this; // this.serialize_widgets = true

    _this10.title = "页面结束";
    _this10.desc = "这一页阅读结束了";
    _this10.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式

    _this10.size = [80, 20]; //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")
    // this.addOutput("bool", "boolean")   //增加一个输出触点，  输出节点的名称， 值类型
    // this.addProperty("pageIndex", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","页码", this.properties.pageIndex ,"pageIndex", {precision: 0});  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    // this.addProperty("gamePath", "", 'string');
    // this.addWidget("string", '页面路径', this.properties.gamePath, "gamePath");

    _this10.addInput("结束", _litegraph.LiteGraph.ACTION); //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this10;
  } // 当节点Toggle时调用


  var _proto8 = endGame.prototype;

  _proto8.onAction = function onAction(action, param) {
    if (action == '结束') {
      // this.graph.stop()
      if (CocosMgr.isInApp) {//通知StoryView页面结束了
        // EventCenter.emit(EventConst.PAGE_END)
      }
    }
  };

  return endGame;
}(_litegraph.LGraphNode);

endGame.title = '页面结束';

_litegraph.LiteGraph.registerNodeType("output/game/endGame", endGame);

var sendEventToBook = /*#__PURE__*/function (_LGraphNode9) {
  _inheritsLoose(sendEventToBook, _LGraphNode9);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function sendEventToBook() {
    var _this11;

    _this11 = _LGraphNode9.call(this) || this; // this.serialize_widgets = true

    _this11.title = "通知绘本操作";
    _this11.desc = "操作绘本相关事件";
    _this11.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式
    // this.size = [80, 20];               //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")
    // this.addOutput("bool", "boolean")   //增加一个输出触点，  输出节点的名称， 值类型
    // this.addProperty("pageIndex", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","页码", this.properties.pageIndex ,"pageIndex", {precision: 0});  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称

    _this11.addInput("触发", _litegraph.LiteGraph.ACTION);

    _this11.addInput('param', 0);

    _this11.addProperty("modal", "隐藏底部字幕", 'string');

    _this11.addWidget('combo', '事件', _this11.properties.modal, {
      property: "modal",
      values: sendEventToBook.modalEnum
    });

    _this11.addProperty("param", "", 'string');

    _this11.addWidget("string", '附加信息', _this11.properties.param, "param"); //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定


    _this11.widgets_up = true; //设置输入组件在顶部（覆盖input和output）
    // this.widgets_start_y = 2

    _this11.setSize(_this11.computeSize()); //   this.properties.precision = 1


    return _this11;
  } // 当节点Toggle时调用


  var _proto9 = sendEventToBook.prototype;

  _proto9.onAction = function onAction(action, param) {
    if (action == '触发') {
      // this.graph.stop()
      if (CocosMgr.isInApp) {
        //通知StoryView页面结束了
        var eventName = sendEventToBook.modalEnumDit[this.properties.modal];
        var exInfo = this.getInputOrProperty('param'); // EventCenter.emit(eventName, exInfo)
      }
    }
  };

  return sendEventToBook;
}(_litegraph.LGraphNode);

sendEventToBook.title = '通知绘本操作';
sendEventToBook.modalEnum = ['隐藏底部字幕'];
sendEventToBook.modalEnumDit = {
  '隐藏底部字幕': 'OnHideReadText'
};

_litegraph.LiteGraph.registerNodeType("output/game/sendEventToBook", sendEventToBook);

var sound = /*#__PURE__*/function (_LGraphNode10) {
  _inheritsLoose(sound, _LGraphNode10);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function sound() {
    var _this12;

    _this12 = _LGraphNode10.call(this) || this; // this.serialize_widgets = true

    _this12.title = "播放音频";
    _this12.desc = "播放一段音频";
    _this12.mode = _litegraph.LiteGraph.ALWAYS; //设置触发模式
    // this.size = [80, 20];               //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")
    // this.addProperty("pageIndex", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","页码", this.properties.pageIndex ,"pageIndex", {precision: 0});  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)

    _this12.addInput("播放", _litegraph.LiteGraph.ACTION);

    _this12.addInput("停止", _litegraph.LiteGraph.ACTION);

    _this12.addInput("字幕", 'array');

    _this12.addOutput("结束", _litegraph.LiteGraph.EVENT); //增加一个输出触点，  输出节点的名称， 值类型


    _this12.addOutput("是否结束", 'boolean');

    _this12.addProperty("modal", "自定义", 'string');

    _this12.addWidget('combo', '选择音频', _this12.properties.modal, {
      property: "modal",
      values: sound.modalEnum
    });

    _this12.addProperty("customeName", "", 'string');

    _this12.addWidget("string", '资源', _this12.properties.customeName, "customeName"); //当音轨为0时不限制播放，其它音轨同一时间只有一个音频在播放


    _this12.addProperty("yinggui", '无', 'enum');

    _this12.addWidget('combo', '选择音轨', _this12.properties.yinggui, {
      property: "yinggui",
      values: ['无', 'A', 'B', 'C', 'D', 'E', 'F', 'G']
    });

    _this12.addProperty("loop", false, "boolean");

    _this12.addWidget("toggle", '是否循环', _this12.properties.loop, "loop");

    _this12.addProperty("volume", 0.5, "number");

    _this12.addWidget("slider", '音量', _this12.properties.volume, "volume", {
      min: 0,
      max: 1,
      precision: 2,
      step2: 0.01
    });

    _this12.addProperty('autoRun', false, 'boolean');

    _this12.addWidget('toggle', '是否自动播放', _this12.properties.autoRun, 'autoRun');

    _this12.addProperty('delayTime', 0, 'number');

    _this12.addWidget('number', '延迟几秒播放', _this12.properties.delayTime, 'delayTime');

    _this12.addProperty('duration', 0, 'number');

    var durationWidget = _this12.addWidget('number', '音频时长', _this12.properties.duration, 'duration');

    durationWidget.disabled = true; //不可以修改

    _this12.addWidget('button', '', "", function (btnWidget) {
      console.log('btnWidget', btnWidget.clickeName);

      if (btnWidget.clickeName != '') {
        _this12.onAction(btnWidget.clickeName);
      }
    }, {
      buttons: ['播放', '停止']
    });

    _this12.addProperty('motionTextData', [], 'array');

    _this12.addWidget('button', '编辑字幕', "", function () {
      if (window.onGraphMenuClick != null) {
        window.onGraphMenuClick('editSoundText', {
          customeName: _this12.properties.customeName,
          motionTextData: _this12.properties.motionTextData,
          id: _this12.getIdWithGraph(),
          onValueChange: function onValueChange(data) {
            // this.setProperty('motionTextData', data)
            console.log('返回的data', data); // 点击这里其实是创建字幕，如果没有的话

            if (_this12.getInputNode(2) == null) {
              var emptyNode = _litegraph.LiteGraph.createNode('objects/createObject');

              emptyNode.pos = [_this12.pos[0] - 30, _this12.pos[1]];
              emptyNode.setProperty('zIndex', 996);
              emptyNode.setProperty('x', 0);
              emptyNode.setProperty('y', 0);

              _this12.graph.add(emptyNode);

              var textGroup = _litegraph.LiteGraph.createNode('objects/textGroup');

              textGroup.pos = [_this12.pos[0] - 10, _this12.pos[1]];

              _this12.graph.add(textGroup);

              for (var i = 0; i < data.length; i++) {
                textGroup.addLine();
                textGroup.setProperty('text' + (i + 1), data[i].text);
              }

              emptyNode.connect(0, textGroup, 0);
              textGroup.connect(0, _assertThisInitialized(_this12), 2);
              textGroup.freshTexts(data);

              if (window.onGraphMenuClick != null) {
                _this12.graph.setDirtyCanvas(true, true);

                window.onGraphMenuClick('layoutNodesJustX');
              }
            } else {
              //如果当前已经绑定了，动态增加或删除
              var _textGroup = _this12.getInputNode(2);

              while (_textGroup.properties.linesNum != 0) {
                _textGroup.removeLine();
              }

              for (var i = 0; i < data.length; i++) {
                _textGroup.addLine();

                _textGroup.setProperty('text' + (i + 1), data[i].text);
              }

              _textGroup.freshTexts(data);
            }
          }
        });
      }
    }); //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1
    // this.inputs[0].link != -


    return _this12;
  }

  var _proto10 = sound.prototype;

  _proto10.onPropertyChanged = function onPropertyChanged(property, value) {
    var _this13 = this;

    if (property == 'customeName') {
      var path = value; // if(this.properties.modal != '自定义'){
      //     path = this.properties.modal + '.mp3'
      // }

      this.clip = null;
      cc.assetManager.loadRemote(CocosMgr.rootHost + '/' + path, function (err, clip) {
        if (err != null) {
          console.warn('加载音频失败', err);
          return;
        } // console.log('加载出来的clip', clip)


        _this13.clip = clip;

        _this13.setProperty('duration', clip.duration);
      });
    } else if (property == 'modal') {
      if (value != '自定义') {
        this.setProperty('customeName', sound.modalDit[value]);
      }
    }
  };

  _proto10.onStart = function onStart() {
    // 部分声音在开始前播放了，但开始的时候又把audio变成空了，导致翻页声音还在，注意不需要在开始前播放，同时将初始化操作滞空
    // this.audioID = null
    // console.log('sound onStart', this.properties.customeName)
    // this.clip = null
    if (this.properties.motionTextData != null) {
      if (this.properties.motionTextData.length > 0) {
        var textGroup = this.getInputNode(2);

        if (textGroup != null) {
          textGroup.freshTexts(this.properties.motionTextData);
        }
      }
    }

    if (this.properties.autoRun) {
      this.onAction('播放');
    }
  };

  _proto10.onPause = function onPause() {
    if (this.audioID != null) {
      cc.audioEngine.pause(this.audioID);
    }
  };

  _proto10.onResume = function onResume() {
    if (this.audioID != null) {
      cc.audioEngine.resume(this.audioID);
    }
  };

  _proto10.getTitle = function getTitle() {
    if (this.flags.collapsed) {
      return "播放音频." + this.properties.customeName.split('.')[0];
    }

    return this.title;
  };

  _proto10.onConfigure = function onConfigure() {
    this.updateWidght();
  };

  _proto10.updateWidght = function updateWidght() {
    var value = this.properties.modal;
    this.widgets.map(function (widget) {
      if (widget.name == '资源') {
        widget.disabled = value != '自定义';
      }
    });
  };

  _proto10.onWidgetChanged = function onWidgetChanged(name) {
    if (name == '选择音频') {
      this.updateWidght();
    }
  };

  _proto10.onStop = function onStop() {
    this.onAction('停止');
  } //开始播放
  ;

  _proto10.realPlayAudio = function realPlayAudio() {
    var _this14 = this;

    var yinggui = this.properties.yinggui;
    var audioArray = this.graph.config.audioArray;
    var volume = this.properties.volume;

    if (this.graph.config.mute == true) {
      //静音模式所有音频声音为0
      volume = 0;
    }

    var path = this.properties.customeName; // if(this.properties.modal != '自定义'){
    //     path = this.properties.modal + '.mp3'
    // }

    console.log('准备播放音频', path);

    if (this.clip == null) {
      cc.assetManager.loadRemote(CocosMgr.rootHost + '/' + path, function (err, clip) {
        if (err != null) {
          console.warn('加载音频失败', err);
          return;
        }

        if (yinggui != '无') {
          if (audioArray[yinggui] != _this14.getIdWithGraph()) {
            return;
          }
        }

        clip.addRef(); // console.log('音频加载成功', path, volume, clip._name, clip.duration, clip.loaded, clip) //

        _this14.clip = clip;
        var audioID = cc.audioEngine.play(clip, _this14.properties.loop, volume);

        if (_this14.audioID != null) {
          cc.audioEngine.stop(_this14.audioID);
        }

        _this14.audioID = audioID; // console.log('我播放音频2', this.audioID, yinggui, this.properties.customeName)

        cc.audioEngine.setFinishCallback(_this14.audioID, function () {
          _this14.triggerSlot(0);

          _this14.setOutputData(1, true);

          if (_this14.playEndCb != null) {
            _this14.playEndCb();
          }
        });
      });
    } else {
      // console.log('已经加载了音频可以直接播放', this.clip)
      if (yinggui != '无') {
        if (audioArray[yinggui] != this.getIdWithGraph()) {
          return;
        }
      }

      var audioID = cc.audioEngine.play(this.clip, this.properties.loop, volume);

      if (this.audioID != null) {
        cc.audioEngine.stop(this.audioID);
      }

      this.audioID = audioID; // console.log('我播放音频3', this.audioID, yinggui, this.properties.customeName)

      cc.audioEngine.setFinishCallback(this.audioID, function () {
        _this14.triggerSlot(0);

        _this14.setOutputData(1, true);

        if (_this14.playEndCb != null) {
          _this14.playEndCb();
        }
      });
    }
  } // 当节点Toggle时调用
  ;

  _proto10.onAction = function onAction(action, param) {
    var yinggui = this.properties.yinggui;
    var audioArray = this.graph.config.audioArray; //console.log('audioArray 是否 为空', audioArray, audioArray == null, audioArray == undefined)

    if (audioArray == undefined) {
      this.graph.config.audioArray = {};
      audioArray = this.graph.config.audioArray;
    }

    if (action == '播放') {
      //播放前要先停止音频
      this.onAction('停止');
      var textGroupNode = this.getInputNode(2);

      if (textGroupNode != null) {
        if (textGroupNode.properties.showInPageBottom == true) {
          if (CocosMgr.isInApp) {//通知StoryView页面结束了
            // EventCenter.emit(EventConst.OnPlayReadText, this.properties.motionTextData)
          }
        } else {
          textGroupNode.onAction('播放');
        }
      } //不管有没有延迟都要先设置音轨，逻辑已经执行了


      if (yinggui != '无') {
        var curYingui = audioArray[yinggui];

        if (curYingui != null) {
          curYingui = this.graph.getNodeById(curYingui);

          if (curYingui != null) {
            curYingui.onAction('停止');
          }
        }

        audioArray[yinggui] = this.getIdWithGraph();
        console.log('设置音轨播放的id', yinggui, this.getIdWithGraph());
      }

      this.setOutputData(1, false); // console.log('我设置isSoundEnd',false)

      if (this.properties.delayTime > 0) {
        this.curWaitTime = this.properties.delayTime;
        this.mode = _litegraph.LiteGraph.ALWAYS;
      } else {
        this.realPlayAudio();
      }
    } else if (action == '停止') {
      var _textGroupNode = this.getInputNode(2);

      if (_textGroupNode != null) {
        if (_textGroupNode.properties.showInPageBottom == true) {
          if (CocosMgr.isInApp) {//通知StoryView页面结束了
            // EventCenter.emit(EventConst.OnHideReadText)
          }
        } else {
          _textGroupNode.onAction('停止');
        }
      }

      if (audioArray[yinggui] == this.getIdWithGraph()) {
        audioArray[yinggui] = null;
      }

      if (this.audioID != null) {
        // console.log('我收到了停止播放音频', this.audioID, yinggui, this.properties.customeName)
        cc.audioEngine.stop(this.audioID);
      }

      if (this.clip != null) {
        this.clip.decRef();
        this.clip = null;
      }

      this.audioID = null;
      this.curWaitTime = null;
    }
  };

  _proto10.onExecute = function onExecute() {
    if (this.curWaitTime != null) {
      var dt = this.graph.elapsed_time; //in ms
      // console.log('dt', dt)

      this.curWaitTime -= dt;

      if (this.curWaitTime <= 0) {
        // console.log('延迟结束播放了声音', this.curWaitTime)
        this.curWaitTime = null;
        this.realPlayAudio();
      }
    }
  };

  return sound;
}(_litegraph.LGraphNode);

sound.title = '播放音频';
sound.modalEnum = ['自定义', '胜利', '开始', '正确', '错误'];
sound.modalDit = {
  '胜利': 'WIN.d434ffea.mp3',
  '错误': '错误.4893a3c2.mp3',
  '开始': 'readygo.a873eb49.mp3',
  '正确': 'dinlin.1ac6169b.mp3'
};

_litegraph.LiteGraph.registerNodeType("output/sound", sound);

var textToSound = /*#__PURE__*/function (_LGraphNode11) {
  _inheritsLoose(textToSound, _LGraphNode11);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function textToSound() {
    var _this15;

    _this15 = _LGraphNode11.call(this) || this; // this.serialize_widgets = true

    _this15.title = "文本转音频";
    _this15.desc = "接入文本生成音频接口实现文本生成配音";
    _this15.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式
    // this.size = [80, 20];               //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")
    // this.addProperty("pageIndex", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","页码", this.properties.pageIndex ,"pageIndex", {precision: 0});  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)
    // this.addInput("震动", LiteGraph.ACTION);

    _this15.addProperty("text", "今天天气真不错");

    _this15.addWidget("text", "文本", _this15.properties.text, "text");

    _this15.addProperty("soundName", "xunfei");

    _this15.addWidget("text", "命名", _this15.properties.soundName, "soundName");

    _this15.addProperty("peopleSound", textToSound.peopleSounds[1], 'enum');

    _this15.widget = _this15.addWidget("combo", "音色", _this15.properties.peopleSound, {
      property: 'peopleSound',
      values: textToSound.peopleSounds
    }); //{'小明': 'xm', '塔塔': 'tata'}

    _this15.addProperty("speed", 50, 'number');

    _this15.addWidget("slider", "语速", _this15.properties.speed, "speed", {
      precision: 0,
      min: 0,
      max: 100
    });

    _this15.addProperty("volume", 50, 'number');

    _this15.addWidget("slider", "音量", _this15.properties.volume, "volume", {
      precision: 0,
      min: 0,
      max: 100
    });

    _this15.addProperty("pitch", 50, 'number');

    _this15.addWidget("slider", "语调", _this15.properties.pitch, "pitch", {
      precision: 0,
      min: 0,
      max: 100
    });

    _this15.addProperty('bgs', false, 'boolean');

    _this15.addWidget('toggle', '背景音', _this15.properties.bgs, 'bgs');

    _this15.btnWidget = _this15.addWidget('button', '生成音频', "", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
      var soundPeople, soundBlob;
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              // console.log('生成音频资源', this.properties.text, )
              soundPeople = textToSound.peopleSoundDit[_this15.properties.peopleSound];
              _this15.btnWidget.disabled = true;
              _context.next = 4;
              return VoiceGen.genSound({
                text: _this15.properties.text,
                vcn: soundPeople,
                speed: _this15.properties.speed,
                //语速：0对应默认语速的1/2，100对应默认语速的2倍
                volume: _this15.properties.volume,
                //音量：0是静音，1对应默认音量1/2，100对应默认音量的2倍
                pitch: _this15.properties.pitch,
                //语调：0对应默认语调的1/2，100对应默认语调的2倍
                bgs: _this15.properties.bgs == true ? 1 : 0 //是否有背景音，背景音：0无背景音（默认值），1有背景音

              });

            case 4:
              soundBlob = _context.sent;
              _this15.btnWidget.disabled = false;

              if (window.uploadGroupFile != null) {
                //上传文件到云端
                // window.setDropXY(this.pos[0] + this.width + 3, this.pos[1])
                window.uploadGroupFile([{
                  files: [soundBlob],
                  type: 'mp3',
                  name: _this15.properties.soundName,
                  x: _this15.pos[0] + _this15.width + 3,
                  y: _this15.pos[1]
                }]);
              }

            case 7:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    })));

    _this15.setSize(_this15.computeSize()); // this.addProperty("modal", 0, "number");
    // this.addWidget("slider", '振动强度', this.properties.modal, "modal", {min: 0, max: 1, precision: 0});
    //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this15;
  } // 当节点Toggle时调用


  var _proto11 = textToSound.prototype;

  _proto11.onAction = function onAction(action, param) {
    if (action == '生成') {}
  };

  return textToSound;
}(_litegraph.LGraphNode);

textToSound.title = '文本转音频';
textToSound.peopleSounds = ['聆飞逸', '聆小璇', '聆小玥', '聆玉昭', '聆玉言', '动漫少女'];
textToSound.peopleSoundDit = {
  '聆飞逸': 'x5_lingfeiyi_flow',
  '聆小璇': 'x5_lingxiaoxuan_flow',
  '聆小玥': 'x5_lingxiaoyue_flow',
  '聆玉昭': 'x5_lingyuzhao_flow',
  '聆玉言': 'x5_lingyuyan_flow',
  '动漫少女': 'x6_dongmanshaonv_pro'
};

_litegraph.LiteGraph.registerNodeType("output/textToSound", textToSound);

var vibrate = /*#__PURE__*/function (_LGraphNode12) {
  _inheritsLoose(vibrate, _LGraphNode12);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function vibrate() {
    var _this16;

    _this16 = _LGraphNode12.call(this) || this; // this.serialize_widgets = true

    _this16.title = "震动";
    _this16.desc = "调用设备振动";
    _this16.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式

    _this16.size = [80, 20]; //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")
    // this.addProperty("pageIndex", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","页码", this.properties.pageIndex ,"pageIndex", {precision: 0});  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)

    _this16.addInput("震动", _litegraph.LiteGraph.ACTION);

    _this16.addProperty("modal", 0, "number");

    _this16.addWidget("slider", '振动强度', _this16.properties.modal, "modal", {
      min: 0,
      max: 1,
      precision: 0
    }); //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this16;
  } // 当节点Toggle时调用


  var _proto12 = vibrate.prototype;

  _proto12.onAction = function onAction(action, param) {
    if (action == '震动') {
      if (this.properties.modal < 0.5) {
        CocosMgr.vibrate(false);
      } else {
        CocosMgr.vibrate(true);
      }
    }
  };

  return vibrate;
}(_litegraph.LGraphNode);

vibrate.title = '震动';

_litegraph.LiteGraph.registerNodeType("output/vibrate", vibrate);

var stopTime = /*#__PURE__*/function (_LGraphNode13) {
  _inheritsLoose(stopTime, _LGraphNode13);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function stopTime() {
    var _this17;

    _this17 = _LGraphNode13.call(this) || this; // this.serialize_widgets = true

    _this17.title = "停止时间";
    _this17.desc = "暂停游戏时间";
    _this17.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式

    _this17.size = [80, 30]; //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")
    // this.addProperty("pageIndex", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","页码", this.properties.pageIndex ,"pageIndex", {precision: 0});  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)

    _this17.addInput("停止", _litegraph.LiteGraph.ACTION);

    _this17.addInput("恢复", _litegraph.LiteGraph.ACTION); // this.addProperty("modal", 0, "number");
    // this.addWidget("slider", '振动强度', this.properties.modal, "modal", {min: 0, max: 1, precision: 0});
    //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this17;
  } // 当节点Toggle时调用


  var _proto13 = stopTime.prototype;

  _proto13.onAction = function onAction(action, param) {
    if (action == '停止') {
      this.graph.pause();
    } else if (action == '恢复') {
      this.graph.resume();
    }
  };

  return stopTime;
}(_litegraph.LGraphNode);

stopTime.title = '停止时间';

_litegraph.LiteGraph.registerNodeType("output/time/stopTime", stopTime);

var timeScale = /*#__PURE__*/function (_LGraphNode14) {
  _inheritsLoose(timeScale, _LGraphNode14);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function timeScale() {
    var _this18;

    _this18 = _LGraphNode14.call(this) || this; // this.serialize_widgets = true

    _this18.title = "时间缩放";
    _this18.desc = "加速或减慢时间效果";
    _this18.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式

    _this18.size = [80, 20]; //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型

    _this18.addInput("scale", "number");

    _this18.addProperty("scale", 1, 'number'); //增加一个变量，    变量名称， 变量名称


    _this18.addWidget("number", "缩放倍数", _this18.properties.scale, "scale", {
      precision: 1,
      min: 0
    }); //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)


    _this18.addInput("修改", _litegraph.LiteGraph.ACTION); // this.addProperty("modal", 0, "number");
    // this.addWidget("slider", '振动强度', this.properties.modal, "modal", {min: 0, max: 1, precision: 0});
    //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定


    _this18.widgets_up = true; //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1

    return _this18;
  } // 当节点Toggle时调用


  var _proto14 = timeScale.prototype;

  _proto14.onAction = function onAction(action, param) {
    if (action == '修改') {
      var scale = this.properties.scale || 1;

      if (scale < 0) {
        scale = 1;
      }

      this.graph.config.timeScale = scale;
      this.graph.sendEventToAllNodes('onChangeTimeScale');
    }
  };

  return timeScale;
}(_litegraph.LGraphNode);

timeScale.title = '时间缩放';

_litegraph.LiteGraph.registerNodeType("output/time/timeScale", timeScale);

var autoRunRecordTouch = /*#__PURE__*/function (_LGraphNode15) {
  _inheritsLoose(autoRunRecordTouch, _LGraphNode15);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function autoRunRecordTouch() {
    var _this19;

    _this19 = _LGraphNode15.call(this) || this; // this.serialize_widgets = true
    // this.mode = LiteGraph;     //设置触发模式

    _this19.title = "自动点击";
    _this19.desc = "自动执行点击事件";
    _this19.size = [80, 20]; //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型

    _this19.addProperty('active', false, 'boolean');

    _this19.addWidget('toggle', '是否激活', _this19.properties.active, 'active');

    _this19.addProperty('recordTouch', [], 'array');

    _this19.widgets_up = true; //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1
    // this.getOutputNodes(0)

    return _this19;
  }

  var _proto15 = autoRunRecordTouch.prototype;

  _proto15.onStart = function onStart() {
    this.curRunStepIndex = -1;
  } //开始执行
  ;

  _proto15.onExecute = function onExecute() {
    if (this.properties.active == false) {
      //不激活自动点击操作事件
      return;
    }

    if (this.properties.recordTouch == null) {
      return;
    }

    var curTime = this.graph.getTime();

    if (this.properties.recordTouch[this.curRunStepIndex + 1] != null) {
      if (curTime > this.properties.recordTouch[this.curRunStepIndex + 1].time) {
        this.curRunStepIndex += 1;
        var stepData = this.properties.recordTouch[this.curRunStepIndex]; //{nodeId: this.getIdWithGraph(),  time: this.graph.getTime(), funcName: 'onClick'}

        var node = this.graph.getNodeById(stepData.nodeId);

        if (node != null) {
          if (node[stepData.funcName] != null) {
            node[stepData.funcName]();
          }
        }
      }
    }
  };

  return autoRunRecordTouch;
}(_litegraph.LGraphNode);

autoRunRecordTouch.title = '自动点击';

_litegraph.LiteGraph.registerNodeType("output/autoRunRecordTouch", autoRunRecordTouch);

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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