
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/Common/LiteGraphCore/nodes/senser.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '0f6fetaZjBCBYwf/0bFNJ0k', 'senser');
// Script/Common/LiteGraphCore/nodes/senser.js

"use strict";

var _litegraph = require("../../litegraph/litegraph");

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

// import * as CocosMgr from '../CocosMgr';
var contact = /*#__PURE__*/function (_LGraphNode) {
  _inheritsLoose(contact, _LGraphNode);

  // Name to show
  function contact() {
    var _this;

    _this = _LGraphNode.call(this) || this; // this.addProperty("time_in_ms", 1000);
    // this.serialize_widgets = true;
    // this.serialize_widgets = true;

    _this.title = "接触感应器";
    _this.desc = "检测物体相互接触";
    _this.size = [250, 50]; // let slot = this.addOutput("A", 'codeNode')
    // slot.dir = LinkDirection.DOWN
    // this.addOutput("B", 'codeNode')

    _this.addInput("检测目标物体", 'codeNode');

    _this.addInput("其它可接触物体", 'codeNode');

    _this.getOutputNodes(); // this.getInputNode()
    // cardacSolt:{index: 0, type: 'number', info: '等待检测对象'},
    // // this.addInput("触发",  LiteGraph.ACTION)
    // // this.addInput("减少",  LiteGraph.ACTION)
    // // this.addInput("重置",  LiteGraph.ACTION)
    // this.addOutput("key", 0)  
    // // this.addOutput("index", 'number') 
    // this.addOutput("value", 0)


    _this.addOutput("接触数量", 'number');

    _this.addOutput("最后接触物体", 'codeNode');

    _this.addOutput("接触时", _litegraph.LiteGraph.EVENT);

    _this.addOutput("离开时", _litegraph.LiteGraph.EVENT); // this.addProperty("开始值", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","开始值", 0, "开始值", {precision: 0});
    // this.addProperty("modal", '无限制', 'enum', {values: ['无限制', '范围限制', '循环', '来回']});   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("combo","模式",this.properties.modal,{ property: "modal", values:['无限制', '范围限制', '循环', '来回'] } );
    // this.addProperty("min", 1,  'number')
    // this.addWidget("number","最小值", 1, "min", {precision: 0});
    // this.addProperty("max", 10,  'number')
    // this.addWidget("number","最大值", 10, "max", {precision: 0});
    // this.addProperty("upStepmodal", '不乘以时间', 'enum', {values: ['乘以时间', '不乘以时间']});   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("combo","步进模式",this.properties.upStepmodal,{ property: "upStepmodal", values:['乘以时间', '不乘以时间'] } );
    // this.addProperty("stepValue", 1,  'number')
    // this.addWidget("number","步进数值", 1, "stepValue", {precision: 0});
    // this.updateWidght()
    // this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // 
    // this.properties.precision = 1


    _this.curContactNum = 0;
    _this.bindTrackCodeNode = [];
    return _this;
  }

  var _proto = contact.prototype;

  _proto.onGetInputs = function onGetInputs() {
    console.log('我调用了onGetOutputs');
    return [["其它可接触物体", "codeNode"]];
  };

  //   onGetOutputs() {
  //     console.log('我调用了onGetOutputs')
  //     return [["number", "string"]];
  //   };
  _proto.onStart = function onStart() {
    // this.repetDir = 1
    // this.value = this.getInputOrProperty("开始值") | 0
    this.bindTrackCodeNode = []; // let otherSolts = this.slots.filter((slot)=>{
    //     return slot.name == '其它可接触物体' && slot.link != null
    // })
    // let linkNodes = otherSolts.map((solt)=>{
    //     return this.graph.links.get(solt.link)
    // }).map((link)=>{
    //     return this.graph.getNodeById(link.origin_id)
    // })

    var linkCodeNodes = [];

    for (var i = 1; i < this.inputs.length; i++) {
      linkCodeNodes.push(this.getInputData(i));

      if (this.getInputData(i) != null) {
        this.bindTrackCodeNode.push(this.getInputData(i));
      }
    }

    console.log('当前链接的solts', linkCodeNodes); // var bindChildRobot = this.linkDatas.cardacSolt
    // for(var i = 0; i < bindChildRobot.length; i++){
    //     var robot = bindChildRobot[i].robot
    //     if(robot.codeNode != null){
    //         this.bindTrackCodeNode.push(robot.codeNode)
    //     }
    // }

    this.onBindCodeNode(this.getInputData(0));
  };

  _proto.onBindCodeNode = function onBindCodeNode(codeNode) {
    var _this2 = this;

    // this.addOutput("是否接触", 'number')
    // this.addOutput("接触对象", 'codeNode')
    console.log('开始监听接触对象', codeNode);

    if (this.codeNode != null) {
      //如果有绑定旧的codeNode，先删除旧的codeNode绑定的id
      this.codeNode.removeRobotListener('contact', this.getIdWithGraph());
      this.codeNode.removeRobotListener('uncontact', this.getIdWithGraph());
    }

    this.curContactNum = 0;
    this.setOutputData(0, this.curContactNum);
    this.codeNode = codeNode;

    if (codeNode == null) {
      return;
    }

    this.codeNode.addRobotListener('contact', this.getIdWithGraph(), function (value) {
      // console.log('物体接触了', value, this.bindTrackCodeNode.indexOf(value))
      if (_this2.bindTrackCodeNode.indexOf(value) != -1) {
        _this2.curContactNum += 1; //会传送最后一个接触的对象

        _this2.setOutputData(0, _this2.curContactNum);

        _this2.setOutputData(1, value);

        _this2.triggerSlot(2); //接触对象时触发

      }
    });
    this.codeNode.addRobotListener('uncontact', this.getIdWithGraph(), function (value) {
      if (_this2.bindTrackCodeNode.indexOf(value) != -1) {
        _this2.curContactNum -= 1;

        _this2.setOutputData(0, _this2.curContactNum);

        _this2.setOutputData(1, value);

        if (_this2.curContactNum <= 0) {
          _this2.curContactNum = 0;

          _this2.triggerSlot(3); //离开所有接触对象

        }
      }
    });
  };

  _proto.onStop = function onStop() {
    console.log('移除监听事件', this.codeNode, this.getIdWithGraph());

    if (this.codeNode != null) {
      //如果有绑定旧的codeNode，先删除旧的codeNode绑定的id
      this.codeNode.removeRobotListener('contact', this.getIdWithGraph());
      this.codeNode.removeRobotListener('uncontact', this.getIdWithGraph());
    }
  } // updateWidght(){
  //   var value = this.properties.modal
  //   if(value != '无限制'){
  //       this.widgets.map((widget)=>{
  //         if(widget.name == '最大值' || widget.name == '最小值'){
  //             widget.disabled = false
  //         }
  //       })
  //     }else{
  //       this.widgets.map((widget)=>{
  //         if(widget.name == '最大值' || widget.name == '最小值'){
  //             widget.disabled = true
  //         }
  //       })
  //     }
  // }
  // onWidgetChanged(name, value, old_value, widget){
  //   // console.log('onWidgetChanged', node, name, value, old_value)
  //   // this.isWidgetVisible
  //   if(name == '模式'){
  //       this.updateWidght()
  //   }
  // }
  // Function to call when the node is executed
  // onAction(action, param, options) {
  // };
  //   onExecute() {
  // var data = this.getInputData(0)
  // if(data !== undefined){
  //   if(data instanceof Array){
  //     for(var i = 0; i < data.length; i++){
  //       this.setOutputData(0, i)
  //       this.setOutputData(1, data[i])
  //       this.triggerSlot(2)
  //     }
  //   }else if(data instanceof Object){
  //     for(var key in data){
  //       this.setOutputData(0, key)
  //       this.setOutputData(1, data[key])
  //       this.triggerSlot(2)
  //     }
  //   }
  // }
  //   }
  ;

  return contact;
}(_litegraph.LGraphNode);

contact.title = '接触感应器'; // Register the node type

_litegraph.LiteGraph.registerNodeType("objects/objectSensor/contact", contact);

var position = /*#__PURE__*/function (_LGraphNode2) {
  _inheritsLoose(position, _LGraphNode2);

  // Name to show
  function position() {
    var _this3;

    _this3 = _LGraphNode2.call(this) || this; // this.addProperty("time_in_ms", 1000);
    // this.serialize_widgets = true;
    // this.serialize_widgets = true;

    _this3.title = "位置感应器";
    _this3.desc = "检测物体位置变化";
    _this3.size = [250, 50];
    _this3.mode = _litegraph.LiteGraph.ON_EVENT; // let slot = this.addOutput("A", 'codeNode')
    // slot.dir = LinkDirection.DOWN
    // this.addOutput("B", 'codeNode')

    _this3.addInput("目标物体", 'codeNode');

    _this3.addInput("修改x", 'number');

    _this3.addInput("修改y", 'number');

    _this3.addInput("触发", _litegraph.LiteGraph.ACTION); // this.addInput("其它可接触物体", 'codeNode')
    // this.getOutputNodes()
    // this.getInputNode()
    // cardacSolt:{index: 0, type: 'number', info: '等待检测对象'},
    // // this.addInput("触发",  LiteGraph.ACTION)
    // // this.addInput("减少",  LiteGraph.ACTION)
    // // this.addInput("重置",  LiteGraph.ACTION)
    // this.addOutput("key", 0)  


    _this3.addOutput("x", 'number');

    _this3.addOutput("y", 'number');

    _this3.addOutput("变化", _litegraph.LiteGraph.EVENT); // this.addOutput("value", 0)
    // this.addOutput("是否接触", 'number')
    // this.addOutput("接触对象", 'codeNode')
    // this.addOutput("接触时", LiteGraph.EVENT)
    // this.addOutput("离开时", LiteGraph.EVENT)


    _this3.addProperty("xRange", '[-999999, 999999]', 'text'); //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","x范围", 0, "xRange", {precision: 0});


    _this3.xRangeWidget = _this3.addWidget("text", "x范围", _this3.properties.xRange, "xRange");

    _this3.addProperty("yRange", '[-999999, 999999]', 'text'); //增加一个变量，    变量名称， 变量名称


    _this3.yRangeWidget = _this3.addWidget("text", "y范围", _this3.properties.yRange, "yRange"); // this.addWidget("number","y范围", 0, "yRange", {precision: 0});
    // this.addProperty("yRange", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","y范围", 0, "yRange", {precision: 0});
    // this.addProperty("modal", '无限制', 'enum', {values: ['无限制', '范围限制', '循环', '来回']});   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("combo","模式",this.properties.modal,{ property: "modal", values:['无限制', '范围限制', '循环', '来回'] } );
    // this.addProperty("min", 1,  'number')
    // this.addWidget("number","最小值", 1, "min", {precision: 0});
    // this.addProperty("max", 10,  'number')
    // this.addWidget("number","最大值", 10, "max", {precision: 0});

    _this3.addProperty("modal", '直接修改', 'enum', {
      values: ['直接修改', '增量修改']
    }); //增加一个变量，    变量名称， 变量名称


    _this3.addWidget("combo", "修改方式", _this3.properties.modal, {
      property: "modal",
      values: ['直接修改', '增量修改']
    }); // this.addProperty("stepValue", 1,  'number')
    // this.addWidget("number","步进数值", 1, "stepValue", {precision: 0});


    _this3.addProperty('rangeWithSize', false, 'boolean');

    _this3.addWidget('toggle', '范围包含节点尺寸', _this3.properties.rangeWithSize, 'resetWhenToggle'); // this.updateWidght()
    // this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // 
    // this.properties.precision = 1
    // this.curContactNum = 0
    // this.bindTrackCodeNode = []


    return _this3;
  }

  var _proto2 = position.prototype;

  _proto2.onPropertyChanged = function onPropertyChanged(name, value) {
    // console.log("onPropertyChanged", name, value)
    if (name == 'xRange' || name == 'yRange') {
      try {
        this['_' + name] = JSON.parse(value);
        this.boxcolor = "#AEA";
      } catch (err) {
        this.boxcolor = "red";
      }
    }
  };

  // onGetInputs() {
  //     console.log('我调用了onGetOutputs')
  //     return [["其它可接触物体", "codeNode"]];
  // };
  //   onGetOutputs() {
  //     console.log('我调用了onGetOutputs')
  //     return [["number", "string"]];
  //   };
  _proto2.onStart = function onStart() {
    this._xRange = JSON.parse(this.properties.xRange);
    this._yRange = JSON.parse(this.properties.yRange); // this.repetDir = 1
    // this.value = this.getInputOrProperty("开始值") | 0
    // this.bindTrackCodeNode = []
    // let otherSolts = this.slots.filter((slot)=>{
    //     return slot.name == '其它可接触物体' && slot.link != null
    // })
    // let linkNodes = otherSolts.map((solt)=>{
    //     return this.graph.links.get(solt.link)
    // }).map((link)=>{
    //     return this.graph.getNodeById(link.origin_id)
    // })
    // let linkCodeNodes = []
    // for(var i = 1; i < this.inputs.length; i++){
    //     linkCodeNodes.push(this.getInputData(i))
    //     if(this.getInputData(i) != null){
    //         this.bindTrackCodeNode.push(this.getInputData(i))
    //     }
    // }
    // console.log('当前链接的solts', linkCodeNodes)
    // var bindChildRobot = this.linkDatas.cardacSolt
    // for(var i = 0; i < bindChildRobot.length; i++){
    //     var robot = bindChildRobot[i].robot
    //     if(robot.codeNode != null){
    //         this.bindTrackCodeNode.push(robot.codeNode)
    //     }
    // }

    this.onBindCodeNode(this.getInputData(0));
  };

  _proto2.onBindCodeNode = function onBindCodeNode(codeNode) {
    var _this4 = this;

    // this.addOutput("是否接触", 'number')
    // this.addOutput("接触对象", 'codeNode')
    // console.log('开始监听接触对象', codeNode)
    if (this.codeNode != null) {
      //如果有绑定旧的codeNode，先删除旧的codeNode绑定的id
      this.codeNode.removeRobotListener('x', this.getIdWithGraph());
      this.codeNode.removeRobotListener('y', this.getIdWithGraph());
    }

    this.codeNode = codeNode;

    if (codeNode == null) {
      return;
    }

    this.codeNode.addRobotListener('x', this.getIdWithGraph(), function (value) {
      _this4.setOutputData(0, value);

      _this4.triggerSlot(2);
    });
    this.codeNode.addRobotListener('y', this.getIdWithGraph(), function (value) {
      _this4.setOutputData(1, value);

      _this4.triggerSlot(2);
    });
  };

  _proto2.onStop = function onStop() {
    this.codeNode = null;
  } // updateWidght(){
  //   var value = this.properties.modal
  //   if(value != '无限制'){
  //       this.widgets.map((widget)=>{
  //         if(widget.name == '最大值' || widget.name == '最小值'){
  //             widget.disabled = false
  //         }
  //       })
  //     }else{
  //       this.widgets.map((widget)=>{
  //         if(widget.name == '最大值' || widget.name == '最小值'){
  //             widget.disabled = true
  //         }
  //       })
  //     }
  // }
  // onWidgetChanged(name, value, old_value, widget){
  //   // console.log('onWidgetChanged', node, name, value, old_value)
  //   // this.isWidgetVisible
  //   if(name == '模式'){
  //       this.updateWidght()
  //   }
  // }
  // Function to call when the node is executed
  // onAction(action, param, options) {
  // };
  //触发模式来更新
  ;

  _proto2.onAction = function onAction() {
    if (this.codeNode == null) {
      return;
    }

    var x = this.getInputData(1);
    var y = this.getInputData(2);
    var xRange = this._xRange;
    var yRange = this._yRange; // console.log('x', x, xRange)

    if (x != null) {
      if (this.properties.rangeWithSize == true) {
        var addWidth = this.codeNode.anchorX * this.codeNode.width * Math.abs(this.codeNode.scaleX); // console.log('addWith', addWidth, xRange[0], this.codeNode.anchorX, this.codeNode.width, this.codeNode.scaleX)

        xRange = [xRange[0] + addWidth, xRange[1] - addWidth]; //当目标物体的宽高小于父节点的宽高，这样子是正常的

        if (xRange[1] < xRange[0]) {
          xRange[1] = xRange[1] + xRange[0];
          xRange[0] = xRange[1] - xRange[0];
          xRange[1] = xRange[1] - xRange[0];
        } // console.log('xRange new', xRange[0], xRange[1])
        //当目标物体的宽高大于父节点的宽高，这样子就不正常了

      }

      if (this.properties.modal == '增量修改') {
        if (this.codeNode.realX + x >= xRange[1]) {
          x = xRange[1] - this.codeNode.realX;
        } else if (this.codeNode.realX + x <= xRange[0]) {
          x = xRange[0] - this.codeNode.realX;
        }

        this.codeNode.realX = this.codeNode.realX + x;
      } else {
        if (x > xRange[1]) {
          x = xRange[1];
        }

        if (x < xRange[0]) {
          x = xRange[0];
        }

        this.codeNode.realX = x; // console.log('直接修改数值', x)
      }
    }

    if (y != null) {
      //修改y轴相关
      if (this.properties.rangeWithSize == true) {
        var addHeight = this.codeNode.anchorY * this.codeNode.height * Math.abs(this.codeNode.scaleY);
        yRange = [yRange[0] + addHeight, yRange[1] - addHeight];

        if (yRange[1] < yRange[0]) {
          yRange[1] = yRange[1] + yRange[0];
          yRange[0] = yRange[1] - yRange[0];
          yRange[1] = yRange[1] - yRange[0];
        }
      }

      if (this.properties.modal == '增量修改') {
        if (this.codeNode.realY + y >= yRange[1]) {
          y = yRange[1] - this.codeNode.realY;
        } else if (this.codeNode.realY + y <= yRange[0]) {
          y = yRange[0] - this.codeNode.realY;
        }

        this.codeNode.realY = this.codeNode.realY + y;
      } else {
        if (y > yRange[1]) {
          y = yRange[1];
        }

        if (y < yRange[0]) {
          y = yRange[0];
        }

        this.codeNode.realY = y;
      }
    }
  };

  return position;
}(_litegraph.LGraphNode);

position.title = '位置感应器'; // Register the node type

_litegraph.LiteGraph.registerNodeType("objects/objectSensor/position", position);

var publicListen = /*#__PURE__*/function (_LGraphNode3) {
  _inheritsLoose(publicListen, _LGraphNode3);

  // Name to show
  function publicListen() {
    var _this5;

    _this5 = _LGraphNode3.call(this) || this; // this.addProperty("time_in_ms", 1000);
    // this.serialize_widgets = true;
    // this.serialize_widgets = true;
    // this.size = [250, 50]

    _this5.title = "属性感应器";
    _this5.desc = "检测物体各种属性变化";
    _this5.mode = _litegraph.LiteGraph.ON_EVENT; // let slot = this.addOutput("A", 'codeNode')
    // slot.dir = LinkDirection.DOWN
    // this.addOutput("B", 'codeNode')

    _this5.addInput("目标物体", 'codeNode');

    _this5.addInput("修改值", 'number');

    _this5.addInput("触发", _litegraph.LiteGraph.ACTION); // this.addInput("其它可接触物体", 'codeNode')
    // this.getOutputNodes()
    // this.getInputNode()
    // cardacSolt:{index: 0, type: 'number', info: '等待检测对象'},
    // // this.addInput("触发",  LiteGraph.ACTION)
    // // this.addInput("减少",  LiteGraph.ACTION)
    // // this.addInput("重置",  LiteGraph.ACTION)
    // this.addOutput("key", 0)  


    _this5.addOutput("数值", 'number');

    _this5.addOutput("变化", _litegraph.LiteGraph.EVENT); // this.addOutput("value", 0)
    // this.addOutput("是否接触", 'number')
    // this.addOutput("接触对象", 'codeNode')
    // this.addOutput("接触时", LiteGraph.EVENT)
    // this.addOutput("离开时", LiteGraph.EVENT)


    _this5.addProperty("range", '[-999999, 999999]', 'text'); //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","范围", 0, "range", {precision: 0});


    _this5.rangeWidget = _this5.addWidget("text", "范围", _this5.properties.range, "range"); // this.addProperty("yRange", '[-999999, 999999]', 'text');   //增加一个变量，    变量名称， 变量名称
    // this.yRangeWidget = this.addWidget("text","y范围",this.properties.yRange,"yRange");
    // this.addWidget("number","y范围", 0, "yRange", {precision: 0});
    // this.addProperty("yRange", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","y范围", 0, "yRange", {precision: 0});

    _this5.addProperty("customKey", '透明度', 'enum', {
      values: publicListen.selectEnums
    }); //增加一个变量，    变量名称， 变量名称


    _this5.addWidget("combo", "监听信息", _this5.properties.customKey, {
      property: "customKey",
      values: publicListen.selectEnums
    }); // this.addProperty("min", 1,  'number')
    // this.addWidget("number","最小值", 1, "min", {precision: 0});
    // this.addProperty("max", 10,  'number')
    // this.addWidget("number","最大值", 10, "max", {precision: 0});


    _this5.addProperty("modal", '直接修改', 'enum', {
      values: ['直接修改', '增量修改']
    }); //增加一个变量，    变量名称， 变量名称


    _this5.addWidget("combo", "修改方式", _this5.properties.modal, {
      property: "modal",
      values: ['直接修改', '增量修改']
    }); // this.addProperty("stepValue", 1,  'number')
    // this.addWidget("number","步进数值", 1, "stepValue", {precision: 0});
    // this.addProperty('rangeWithSize', false, 'boolean')
    // this.addWidget('toggle', '范围包含节点尺寸', this.properties.rangeWithSize, 'resetWhenToggle')
    // this.updateWidght()
    // this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // 
    // this.properties.precision = 1
    // this.curContactNum = 0
    // this.bindTrackCodeNode = []


    return _this5;
  }

  var _proto3 = publicListen.prototype;

  _proto3.onPropertyChanged = function onPropertyChanged(name, value) {
    // console.log("onPropertyChanged", name, value)
    if (name == 'range') {
      try {
        this['_' + name] = JSON.parse(value);
        this.boxcolor = "#AEA";
      } catch (err) {
        this.boxcolor = "red";
      }
    }
  };

  // onGetInputs() {
  //     console.log('我调用了onGetOutputs')
  //     return [["其它可接触物体", "codeNode"]];
  // };
  //   onGetOutputs() {
  //     console.log('我调用了onGetOutputs')
  //     return [["number", "string"]];
  //   };
  _proto3.onStart = function onStart() {
    this._range = JSON.parse(this.properties.range); // this._yRange = JSON.parse(this.properties.yRange)
    // this.repetDir = 1
    // this.value = this.getInputOrProperty("开始值") | 0
    // this.bindTrackCodeNode = []
    // let otherSolts = this.slots.filter((slot)=>{
    //     return slot.name == '其它可接触物体' && slot.link != null
    // })
    // let linkNodes = otherSolts.map((solt)=>{
    //     return this.graph.links.get(solt.link)
    // }).map((link)=>{
    //     return this.graph.getNodeById(link.origin_id)
    // })
    // let linkCodeNodes = []
    // for(var i = 1; i < this.inputs.length; i++){
    //     linkCodeNodes.push(this.getInputData(i))
    //     if(this.getInputData(i) != null){
    //         this.bindTrackCodeNode.push(this.getInputData(i))
    //     }
    // }
    // console.log('当前链接的solts', linkCodeNodes)
    // var bindChildRobot = this.linkDatas.cardacSolt
    // for(var i = 0; i < bindChildRobot.length; i++){
    //     var robot = bindChildRobot[i].robot
    //     if(robot.codeNode != null){
    //         this.bindTrackCodeNode.push(robot.codeNode)
    //     }
    // }

    this.onBindCodeNode(this.getInputData(0));
  };

  _proto3.onBindCodeNode = function onBindCodeNode(codeNode) {
    var _this6 = this;

    // this.addOutput("是否接触", 'number')
    // this.addOutput("接触对象", 'codeNode')
    // console.log('开始监听接触对象', codeNode)
    var index = publicListen.selectEnums.indexOf(this.properties.customKey);

    if (index == -1) {
      console.warn('没有对应的可监听事件', this.properties.customKey);
      return;
    }

    var bindKey = publicListen.chooseKey[index];

    if (this.codeNode != null) {
      //如果有绑定旧的codeNode，先删除旧的codeNode绑定的id
      this.codeNode.removeRobotListener(bindKey, this.getIdWithGraph());
    }

    this.codeNode = codeNode;

    if (codeNode == null) {
      return;
    }

    this.codeNode.addRobotListener(bindKey, this.getIdWithGraph(), function (value) {
      _this6.setOutputData(0, value);

      _this6.triggerSlot(1);
    });
  };

  _proto3.onStop = function onStop() {
    this.codeNode = null;
  } // updateWidght(){
  //   var value = this.properties.modal
  //   if(value != '无限制'){
  //       this.widgets.map((widget)=>{
  //         if(widget.name == '最大值' || widget.name == '最小值'){
  //             widget.disabled = false
  //         }
  //       })
  //     }else{
  //       this.widgets.map((widget)=>{
  //         if(widget.name == '最大值' || widget.name == '最小值'){
  //             widget.disabled = true
  //         }
  //       })
  //     }
  // }
  // onWidgetChanged(name, value, old_value, widget){
  //   // console.log('onWidgetChanged', node, name, value, old_value)
  //   // this.isWidgetVisible
  //   if(name == '模式'){
  //       this.updateWidght()
  //   }
  // }
  // Function to call when the node is executed
  // onAction(action, param, options) {
  // };
  //触发模式来更新
  ;

  _proto3.onAction = function onAction() {
    if (this.codeNode == null) {
      return;
    }

    var value = this.getInputData(1);
    var index = publicListen.selectEnums.indexOf(this.properties.customKey);

    if (index == -1) {
      console.warn('没有对应的可监听事件', this.properties.customKey);
      return;
    }

    var bindKey = publicListen.chooseKey[index];

    if (bindKey != null) {
      var range = this._range;

      if (this.properties.modal == '增量修改') {
        if (this.codeNode[bindKey] + value >= range[1]) {
          value = range[1] - this.codeNode[bindKey];
        }

        if (this.codeNode[bindKey] + value <= range[0]) {
          value = range[0] - this.codeNode[bindKey];
        }

        this.codeNode[bindKey] = this.codeNode[bindKey] + value;
      } else {
        if (value > range[1]) {
          value = range[1];
        }

        if (value < range[0]) {
          value = range[0];
        }

        this.codeNode[bindKey] = value;
      }
    } else {
      this.codeNode[bindKey] = value;
    }
  };

  return publicListen;
}(_litegraph.LGraphNode);

publicListen.title = '属性感应器';
publicListen.selectEnums = ['透明度', '层级', '缩放X', '缩放Y', '长度', '高度', '显隐', '角度'];
publicListen.chooseKey = ['opacity', 'zIndex', 'scaleX', 'scaleY', 'width', 'height', 'active', 'angle']; // Register the node type

_litegraph.LiteGraph.registerNodeType("objects/objectSensor/publicListen", publicListen);

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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