"use strict";
cc._RF.push(module, 'fa2f1s0twBD4Z7k+7chbDmg', 'poly-bezier');
// Script/Common/Bezier/poly-bezier.js

"use strict";

exports.__esModule = true;
exports.PolyBezier = void 0;

var _bezierUtils = require("./bezierUtils.js");

/**
 * Poly Bezier
 * @param {[type]} curves [description]
 */
var PolyBezier = /*#__PURE__*/function () {
  function PolyBezier(curves) {
    this.curves = [];
    this._3d = false;

    if (!!curves) {
      this.curves = curves;
      this._3d = this.curves[0]._3d;
    }
  }

  var _proto = PolyBezier.prototype;

  _proto.valueOf = function valueOf() {
    return this.toString();
  };

  _proto.toString = function toString() {
    return "[" + this.curves.map(function (curve) {
      return _bezierUtils.utils.pointsToString(curve.points);
    }).join(", ") + "]";
  };

  _proto.addCurve = function addCurve(curve) {
    this.curves.push(curve);
    this._3d = this._3d || curve._3d;
  };

  _proto.length = function length() {
    return this.curves.map(function (v) {
      return v.length();
    }).reduce(function (a, b) {
      return a + b;
    });
  };

  _proto.curve = function curve(idx) {
    return this.curves[idx];
  };

  _proto.bbox = function bbox() {
    var c = this.curves;
    var bbox = c[0].bbox();

    for (var i = 1; i < c.length; i++) {
      _bezierUtils.utils.expandbox(bbox, c[i].bbox());
    }

    return bbox;
  };

  _proto.offset = function offset(d) {
    var offset = [];
    this.curves.forEach(function (v) {
      offset.push.apply(offset, v.offset(d));
    });
    return new PolyBezier(offset);
  };

  return PolyBezier;
}();

exports.PolyBezier = PolyBezier;

cc._RF.pop();