"use strict";
cc._RF.push(module, '7957bOqxSZMRbikwHABBUv9', 'AngleCompoment');
// Script/Common/LiteGraphCore/AngleCompoment.ts

"use strict";
// const {ccclass, property} = cc._decorator;
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
// @ccclass
var AngleCompoment = /** @class */ (function (_super) {
    __extends(AngleCompoment, _super);
    function AngleCompoment() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.pointA = {
            X: 0,
            Y: 0
        };
        _this.pointB = { X: 0, Y: 0 };
        _this.pointC = { X: 0, Y: 0 }; // A,B,C分别代表中心点，起始点，结束点坐标
        _this.typeMouse = false;
        _this.allA = 0; // 存放鼠标旋转总共的度数
        _this.inputHandle = function (inputData) {
            console.log("进入了开启监听");
            //判断是否开启监听
            if (inputData.targetSolt == 'number1') {
                if (inputData.data == 0) {
                    //关闭监听
                    console.log("关闭了监听");
                    _this.node.targetOff(_this);
                }
                else {
                    //开启监听
                    _this.kaiqijiantin();
                }
            }
            else if (inputData.targetSolt == 'reset') {
                console.log("进入了重置");
                _this.allA = 0;
            }
        };
        //这个方法会在robot初始化该脚本时被覆盖
        _this.outputHandle = function (key, data) {
            // this.outputHandle('onclick', 1)
        };
        return _this;
        // update (dt) {}
    }
    AngleCompoment.prototype.onLoad = function () { };
    AngleCompoment.prototype.start = function () {
    };
    AngleCompoment.prototype.kaiqijiantin = function () {
        var _this = this;
        this.node.on(cc.Node.EventType.TOUCH_START, function (e) {
            // startX = e.getLocation().x
            var nodePos = _this.node.convertToNodeSpaceAR(e.getLocation());
            _this.pointB.X = nodePos.x;
            _this.pointB.Y = nodePos.y;
            // console.log('this.pointB.X',this.pointB.X, 'this.pointB.Y', this.pointB.Y)
            _this.typeMouse = true; //获取起始点坐标
        }, this);
        this.node.on(cc.Node.EventType.TOUCH_MOVE, function (e) {
            if (_this.typeMouse) {
                var nodePos = _this.node.convertToNodeSpaceAR(e.getLocation());
                _this.pointC.X = nodePos.x;
                _this.pointC.Y = nodePos.y; // 获取结束点坐标
                var AB = {};
                var AC = {};
                AB.X = (_this.pointB.X - _this.pointA.X);
                AB.Y = (_this.pointB.Y - _this.pointA.Y);
                AC.X = (_this.pointC.X - _this.pointA.X);
                AC.Y = (_this.pointC.Y - _this.pointA.Y); // 分别求出AB,AC的向量坐标表示
                var direct = (AB.X * AC.Y) - (AB.Y * AC.X); // AB与AC叉乘求出逆时针还是顺时针旋转
                var lengthAB = Math.sqrt(Math.pow(_this.pointA.X - _this.pointB.X, 2) +
                    Math.pow(_this.pointA.Y - _this.pointB.Y, 2)), lengthAC = Math.sqrt(Math.pow(_this.pointA.X - _this.pointC.X, 2) +
                    Math.pow(_this.pointA.Y - _this.pointC.Y, 2)), lengthBC = Math.sqrt(Math.pow(_this.pointB.X - _this.pointC.X, 2) +
                    Math.pow(_this.pointB.Y - _this.pointC.Y, 2));
                var cosA = (Math.pow(lengthAB, 2) + Math.pow(lengthAC, 2) - Math.pow(lengthBC, 2)) /
                    (2 * lengthAB * lengthAC); //   余弦定理求出旋转角
                var angleA = Math.round(Math.acos(cosA) * 180 / Math.PI);
                if (direct < 0) {
                    _this.allA -= angleA; //叉乘结果为负表示逆时针旋转， 逆时针旋转减度数
                }
                else {
                    _this.allA += angleA; //叉乘结果为正表示顺时针旋转，顺时针旋转加度数
                }
                _this.pointB.X = _this.pointC.X;
                _this.pointB.Y = _this.pointC.Y; //运算结束后将起始点重新赋值为结束点，作为下一次的起始点
                _this.outputHandle('number1', _this.allA);
                // console.log("输出")
            }
        }, this);
        this.node.on(cc.Node.EventType.TOUCH_END, function (e) {
            _this.typeMouse = false;
        }, this);
        this.node.on(cc.Node.EventType.TOUCH_CANCEL, function (e) {
            _this.typeMouse = false;
        }, this);
    };
    return AngleCompoment;
}(cc.Component));
exports.default = AngleCompoment;

cc._RF.pop();