"use strict";
cc._RF.push(module, '4c950V6+0dKVbXAbbiuy4ZL', 'CocosMgr');
// Script/Common/LiteGraphCore/CocosMgr.js

"use strict";

exports.__esModule = true;
exports.changeRunInmportState = changeRunInmportState;
exports.changeIsSinglePreview = changeIsSinglePreview;
exports.realBoot = realBoot;
exports.waitCocosInit = waitCocosInit;
exports.init = init;
exports.addNodeToScene = addNodeToScene;
exports.updateCanvasSize = updateCanvasSize;
exports.showOrHideFPS = showOrHideFPS;
exports.showOrHideColiderBox = showOrHideColiderBox;
exports.clearScene = clearScene;
exports.getNodeById = getNodeById;
exports.getChildren = getChildren;
exports.getHasChildrenNodeId = getHasChildrenNodeId;
exports.refreshTree = refreshTree;
exports.changePreviewMode = changePreviewMode;
exports.drawNodeRect = drawNodeRect;
exports.openCacheDialog = openCacheDialog;
exports.outputComponentHandler = outputComponentHandler;
exports.loadResHandle = loadResHandle;
exports.getFileType = getFileType;
exports.getExName = getExName;
exports.getName = getName;
exports.getBaseName = getBaseName;
exports.setValueByKey = setValueByKey;
exports.syncConfigToCodeNode = syncConfigToCodeNode;
exports.xorConfig = xorConfig;
exports.xorConfigZeroValue = xorConfigZeroValue;
exports.blockTouch = blockTouch;
exports.createObj = createObj;
exports.preLoadGraphAssest = preLoadGraphAssest;
exports.showConfirm = showConfirm;
exports.showAlert = showAlert;
exports.preLoad = preLoad;
exports.loadNetSpine = loadNetSpine;
exports.vibrate = vibrate;
exports.changeGraph = changeGraph;
exports.typeColorEnum = exports.robotNodeEnum = exports.objectTypes = exports.ObjectTypeEnum = exports.designViewHeight = exports.designViewWidth = exports.isSinglePreview = exports.isInImport = exports.isInApp = exports.isPreviewMode = exports.rootHost = exports.treeData = exports.selectedNode = exports.intervalId = exports.hasLoadScene = exports.hasInit = void 0;

var _CodeNodeLg = require("./CodeNodeLg");

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

var hasInit = false;
exports.hasInit = hasInit;
var hasLoadScene = false; //在游戏中直接设置为true

exports.hasLoadScene = hasLoadScene;
var intervalId = -1;
exports.intervalId = intervalId;
var selectedNode = null;
exports.selectedNode = selectedNode;
var treeData = [];
exports.treeData = treeData;
var rootHost = 'https://ywserver.oss-cn-shanghai.aliyuncs.com/bookEdit';
exports.rootHost = rootHost;
var isPreviewMode = false; //不显示摄像机

exports.isPreviewMode = isPreviewMode;
var isInApp = true; //是否在App中

exports.isInApp = isInApp;
var isInImport = false; //是否在导入中

exports.isInImport = isInImport;
var isSinglePreview = false; //单独的预览环境

exports.isSinglePreview = isSinglePreview;
var designViewWidth = 2560;
exports.designViewWidth = designViewWidth;
var designViewHeight = 1500;
exports.designViewHeight = designViewHeight;

function changeRunInmportState(state) {
  exports.isInImport = isInImport = state;
}

function changeIsSinglePreview(state) {
  exports.isSinglePreview = isSinglePreview = state;
}

if (isInApp == true) {
  exports.hasLoadScene = hasLoadScene = true;
}

var ObjectTypeEnum = {
  'empty': '空物体',
  'sprite': '图片',
  'graph': '绘制',
  'spine': 'spine',
  'text': '文本'
};
exports.ObjectTypeEnum = ObjectTypeEnum;
var objectTypes = [ObjectTypeEnum.empty, ObjectTypeEnum.sprite, ObjectTypeEnum.graph, ObjectTypeEnum.spine, ObjectTypeEnum.text];
exports.objectTypes = objectTypes;
var robotNodeEnum = {
  value: 'input/value',
  valueString: 'input/valueString',
  "boolean": 'input/boolean',
  gameStart: 'input/gameStart',
  customButton: 'input/button/customButton',
  controll: 'input/button/controll',
  touchStart: 'input/screen/touchStart',
  touchMove: 'input/screen/touchMove',
  touchEnd: 'input/screen/touchEnd',
  leftOrRightAct: 'input/leftOrRightAct',
  customData: 'input/getData/customData',
  systemData: 'input/getData/systemData',
  screenSize: 'input/screenSize',
  showTextTip: 'output/tips/showTextTip',
  showConfirm: 'output/tips/showConfirm',
  showHandTip: 'output/tips/showHandTip',
  blockTouch: 'output/blockTouch',
  consoleInfo: 'output/tips/consoleInfo',
  restartGame: 'output/game/restartGame',
  changeGame: 'output/game/changeGame',
  endGame: 'output/game/endGame',
  sound: 'output/sound',
  vibrate: 'output/vibrate',
  stopTime: 'output/time/stopTime',
  timeScale: 'output/time/timeScale',
  createObject: 'objects/createObject',
  animate: 'objects/animates/animate',
  tween: 'objects/animates/tween',
  bezierCurve: 'objects/animates/bezierCurve',
  camera: 'objects/camera',
  MotionText: 'output/customComponent/MotionText',
  CaiDanComponent: 'output/customComponent/CaiDanComponent',
  CaiDanComponent2: 'output/customComponent/CaiDanComponent2',
  ChatComponent: 'output/customComponent/ChatComponent',
  VoiceCheck: 'output/customComponent/VoiceCheck',
  AngleCompoment: 'output/customComponent/AngleCompoment',
  ScaleObj: 'output/customComponent/ScaleObj',
  ProgressCompoment: 'output/customComponent/ProgressCompoment',
  'cc.Mask': 'output/customComponent/ccMask',
  angleConvertVector: 'middle/angleCalculate/angleConvertVector',
  angleDifference: 'middle/angleCalculate/angleDifference',
  vectorToAngel: 'middle/angleCalculate/vectorToAngel',
  add: 'middle/calculate/add',
  chu: 'middle/calculate/chu',
  del: 'middle/calculate/del',
  length: 'middle/calculate/length',
  x: 'middle/calculate/x',
  checkTag: 'middle/change/checkTag',
  dataObject: 'middle/change/dataObject',
  getArrayValue: 'middle/change/getArrayValue',
  getKeyValue: 'middle/change/getKeyValue',
  randomNum: 'middle/change/randomNum',
  timeDown: 'middle/change/timeDown',
  timeDownCycle: 'middle/change/timeDownCycle',
  upCount: 'middle/change/upCount',
  bigger: 'middle/compare/bigger',
  equire: 'middle/compare/equire',
  inRange: 'middle/compare/inRange',
  litter: 'middle/compare/litter',
  abs: 'middle/covert/abs',
  revertNegative: 'middle/covert/revertNegative',
  squareRoot: 'middle/covert/squareRoot',
  toint: 'middle/covert/toint',
  input: 'middle/graph/input',
  output: 'middle/graph/output',
  subgraph: 'middle/graph/subgraph',
  allRight: 'middle/logic/allRight',
  allToggle: 'middle/logic/allToggle',
  notRight: 'middle/logic/notRight',
  orRight: 'middle/logic/orRight',
  orToggle: 'middle/logic/orToggle',
  acceptData: 'middle/tool/acceptData',
  lighting: 'middle/tool/lighting',
  lightingOut: 'middle/tool/lightingOut',
  outputLine: 'middle/tool/outputLine',
  sendData: 'middle/tool/sendData',
  textCode: 'middle/tool/textCode',
  contact: 'objects/objectSensor/contact',
  position: 'objects/objectSensor/position',
  speed: 'objects/objectSensor/publicListen',
  connection: 'objects/group/connection'
};
exports.robotNodeEnum = robotNodeEnum;
var typeColorEnum = {
  'input': 'green',
  'middle': 'cyan',
  'output': 'pink',
  'objects': 'orange'
};
exports.typeColorEnum = typeColorEnum;

function realBoot() {
  return _realBoot.apply(this, arguments);
}

function _realBoot() {
  _realBoot = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            return _context.abrupt("return", new Promise(function (resolve, reject) {
              var settings = window._CCSettings; // if(settings == null){
              //     return
              // }
              // window._CCSettings = undefined;

              // if(settings == null){
              //     return
              // }
              // window._CCSettings = undefined;
              var onProgress = null;
              var RESOURCES = cc.AssetManager.BuiltinBundleName.RESOURCES;
              var INTERNAL = cc.AssetManager.BuiltinBundleName.INTERNAL;
              var MAIN = cc.AssetManager.BuiltinBundleName.MAIN;

              function setLoadingDisplay() {
                // Loading splash scene
                var splash = document.getElementById('splash');

                if (splash == null) {
                  return;
                }

                var progressBar = splash.querySelector('.progress-bar span');

                onProgress = function onProgress(finish, total) {
                  var percent = 100 * finish / total;

                  if (progressBar) {
                    progressBar.style.width = percent.toFixed(2) + '%';
                  }
                };

                splash.style.display = 'block';
                progressBar.style.width = '0%';
                cc.director.once(cc.Director.EVENT_AFTER_SCENE_LAUNCH, function () {
                  splash.style.display = 'none';
                });
              }

              var onStart = function onStart() {
                cc.view.enableRetina(true); // cc.view.resizeWithBrowserSize(true);

                // cc.view.resizeWithBrowserSize(true);
                if (cc.sys.isBrowser) {
                  setLoadingDisplay();
                } // Limit downloading max concurrent task to 2,
                // more tasks simultaneously may cause performance draw back on some android system / browsers.
                // You can adjust the number based on your own test result, you have to set it before any loading process to take effect.


                // Limit downloading max concurrent task to 2,
                // more tasks simultaneously may cause performance draw back on some android system / browsers.
                // You can adjust the number based on your own test result, you have to set it before any loading process to take effect.
                if (cc.sys.isBrowser && cc.sys.os === cc.sys.OS_ANDROID) {
                  cc.assetManager.downloader.maxConcurrency = 2;
                  cc.assetManager.downloader.maxRequestsPerFrame = 2;
                }

                var launchScene = settings.launchScene;
                var bundle = cc.assetManager.bundles.find(function (b) {
                  return b.getSceneInfo(launchScene);
                });
                bundle.loadScene(launchScene, null, onProgress, function (err, scene) {
                  if (!err) {
                    cc.director.runSceneImmediate(scene);

                    if (cc.sys.isBrowser) {
                      // show canvas
                      // var canvas = document.getElementById('GameCanvas');
                      // canvas.style.visibility = '';
                      // var div = document.getElementById('GameDiv');
                      // if (div) {
                      //     div.style.backgroundImage = '';
                      // }
                      console.log('Success to load scene: ' + launchScene);
                    } // console.log('hasRead', )
                    //设置canvas design分辨率
                    // var canvas = cc.director.getScene().getChildByName('Canvas').getComponent(cc.Canvas)
                    // console.log('canvas', canvas)


                    // console.log('hasRead', )
                    //设置canvas design分辨率
                    // var canvas = cc.director.getScene().getChildByName('Canvas').getComponent(cc.Canvas)
                    // console.log('canvas', canvas)
                    cc.Canvas.instance.designResolution = cc.size(designViewWidth, designViewHeight);
                    exports.hasLoadScene = hasLoadScene = true;
                    clearScene();
                    resolve(true);
                  } else {
                    reject(err);
                  }
                });
              };

              var canvas = document.getElementById('GameCanvas');

              if (canvas == null) {
                console.warn('没有找到GameCanvas');
                reject('没有找到渲染画布GameCanvas');
                return;
              }

              var option = {
                id: 'GameCanvas',
                debugMode: settings.debug ? cc.debug.DebugMode.INFO : cc.debug.DebugMode.ERROR,
                showFPS: settings.debug,
                frameRate: 60,
                groupList: settings.groupList,
                collisionMatrix: settings.collisionMatrix
              };
              cc.assetManager.init({
                bundleVers: settings.bundleVers,
                remoteBundles: settings.remoteBundles,
                server: settings.server
              });
              var bundleRoot = [INTERNAL];
              settings.hasResourcesBundle && bundleRoot.push(RESOURCES);
              var count = 0;

              function cb(err) {
                if (err) return console.error(err.message, err.stack);
                count++;

                if (count === bundleRoot.length + 1) {
                  cc.assetManager.loadBundle(MAIN, function (err) {
                    if (!err) {
                      cc.game.run(option, onStart);
                    } else {
                      reject(err);
                    }
                  });
                }
              }

              console.log('需要加载的settings.jsList', settings.jsList);
              cc.assetManager.loadScript(settings.jsList.map(function (x) {
                return 'src/' + x;
              }), cb);
              console.log('需要加载的bundleRoot', bundleRoot);

              for (var i = 0; i < bundleRoot.length; i++) {
                cc.assetManager.loadBundle(bundleRoot[i], cb);
              }
            }));

          case 1:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _realBoot.apply(this, arguments);
}

function initConsoleUtil() {
  if (cc.tree) return;

  cc.tree = function (key) {
    var index = key || 0;

    var treeNode = function treeNode(node) {
      var nameStyle = "color: " + (node.parent === null || node.activeInHierarchy ? 'green' : 'grey') + "; font-size: 14px;font-weight:bold";
      var propStyle = "color: black; background: lightgrey;margin-left: 5px;border-radius:3px;padding: 0 3px;font-size: 10px;font-weight:bold";
      var indexStyle = "color: orange; background: black;margin-left: 5px;border-radius:3px;padding:0 3px;fonrt-size: 10px;font-weight:bold;";
      var nameValue = "%c" + node.name;
      var propValue = "%c" + (node.x.toFixed(0) + ',' + node.y.toFixed(0) + ',' + node.width.toFixed(0) + ',' + node.height.toFixed(0) + ',' + node.scale.toFixed(1));
      var indexValue = "%c" + index++;

      if (node.childrenCount > 0) {
        console.groupCollapsed(nameValue + propValue + indexValue, nameStyle, propStyle, indexStyle);

        for (var i = 0; i < node.childrenCount; i++) {
          treeNode(node.children[i]);
        }

        console.groupEnd();
      } else {
        console.log(nameValue + propValue + indexValue, nameStyle, propStyle, indexStyle);
      }
    };

    if (key) {
      var node = cc.cat(key);
      index = node['tempIndex'];
      treeNode(node);
    } else {
      var scene = cc.director.getScene();
      treeNode(scene);
    }

    return '属性依次为x,y,width,height,scale.使用cc.cat(id)查看详细属性.';
  };

  cc.cat = function (key) {
    var index = 0;
    var target;

    var sortId = function sortId(node) {
      if (target) return;

      if (cc.js.isNumber(key)) {
        if (key === index++) {
          target = node;
          return;
        }
      } else {
        if (key.toLowerCase() === node.name.toLowerCase()) {
          target = node;
          return;
        } else {
          index++;
        }
      }

      if (node.childrenCount > 0) {
        for (var i = 0; i < node.childrenCount; i++) {
          sortId(node.children[i]);
        }
      }
    };

    var scene = cc.director.getScene();
    sortId(scene);
    target['tempIndex'] = cc.js.isNumber(key) ? key : index;
    return target;
  };

  cc.list = function (key) {
    var targets = [];

    var step = function step(node) {
      if (node.name.toLowerCase().indexOf(key.toLowerCase()) > -1) {
        targets.push(node);
      }

      if (node.childrenCount > 0) {
        for (var i = 0; i < node.childrenCount; i++) {
          step(node.children[i]);
        }
      }
    };

    var scene = cc.director.getScene();
    step(scene);

    if (targets.length === 1) {
      return targets[0];
    } else {
      return targets;
    }
  };

  cc.where = function (key) {
    var target = key.name ? key : cc.cat(key);

    if (!target) {
      return null;
    }

    var rect = target.getBoundingBoxToWorld();
    var bgNode = new cc.Node();
    var graphics = bgNode.addComponent(cc.Graphics);
    var scene = cc.director.getScene();
    scene.addChild(bgNode);
    bgNode.position = rect.center;
    bgNode.group = target.group;
    bgNode.zIndex = cc.macro.MAX_ZINDEX;
    var isZeroSize = rect.width === 0 || rect.height === 0;

    if (isZeroSize) {
      graphics.circle(0, 0, 100);
      graphics.fillColor = cc.Color.GREEN;
      graphics.fill();
    } else {
      bgNode.width = rect.width;
      bgNode.height = rect.height;
      graphics.rect(-bgNode.width / 2, -bgNode.height / 2, bgNode.width, bgNode.height);
      graphics.fillColor = new cc.Color().fromHEX('#E91E6390');
      graphics.fill();
    }

    setTimeout(function () {
      if (cc.isValid(bgNode)) {
        bgNode.destroy();
      }
    }, 2000);
    return target;
  };

  cc.cache = function () {
    var rawCacheData = cc.assetManager.assets._map;
    var cacheData = [];
    var totalTextureSize = 0;

    for (var k in rawCacheData) {
      var item = rawCacheData[k];

      if (item.type !== 'js' && item.type !== 'json') {
        var itemName = '_';
        var preview = '';
        var content = item.__classname__;
        var formatSize = -1;

        if (item.type === 'png' || item.type === 'jpg') {
          var texture = rawCacheData[k.replace('.' + item.type, '.json')];

          if (texture && texture._owner && texture._owner._name) {
            itemName = texture._owner._name;
            preview = texture.content.url;
          }
        } else {
          if (item.name) {
            itemName = item.name;
          } else if (item._owner) {
            itemName = item._owner && item._owner.name || '_';
          }

          if (content === 'cc.Texture2D') {
            preview = item.nativeUrl;
            var textureSize = item.width * item.height * ((item._native === '.jpg' ? 3 : 4) / 1024 / 1024);
            totalTextureSize += textureSize; // sizeStr = textureSize.toFixed(3) + 'M';

            formatSize = Math.round(textureSize * 1000) / 1000;
          } else if (content === 'cc.SpriteFrame') {
            preview = item._texture.nativeUrl;
          }
        }

        cacheData.push({
          queueId: item.queueId,
          type: content,
          name: itemName,
          preview: preview,
          id: item._uuid,
          size: formatSize
        });
      }
    }

    var cacheTitle = "\u7F13\u5B58 [\u6587\u4EF6\u603B\u6570:" + cacheData.length + "][\u7EB9\u7406\u7F13\u5B58:" + (totalTextureSize.toFixed(2) + 'M') + "]";
    return [cacheData, cacheTitle];
  };

  cc.loopAllNode = function (handle, node) {
    var loop = function loop(node) {
      // console.log('grayNode', node.name)
      if (cc.isValid(node)) {
        handle(node);

        for (var i = 0; i < node.children.length; i++) {
          loop(node.children[i]);
        }
      }
    };

    if (node == null) {
      node = cc.director.getScene();

      if (cc.isValid(node) == true) {
        for (var i = 0; i < node.children.length; i++) {
          loop(node.children[i]);
        }
      }
    } else {
      loop(node);
    }
  };
}

function waitCocosInit() {
  return _waitCocosInit.apply(this, arguments);
}

function _waitCocosInit() {
  _waitCocosInit = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
    return regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            return _context2.abrupt("return", new Promise(function (resolve, reject) {
              var count = 0;

              var check = function check() {
                count += 1;

                if (hasLoadScene == true) {
                  resolve(true);
                } else {
                  if (count > 100) {
                    reject('等待cocos加载场景超时');
                  } else {
                    setTimeout(check, 100);
                  }
                }
              };

              check();
            }));

          case 1:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2);
  }));
  return _waitCocosInit.apply(this, arguments);
}

function init() {
  return _init.apply(this, arguments);
}

function _init() {
  _init = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3() {
    return regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            if (!(hasInit == true)) {
              _context3.next = 3;
              break;
            }

            console.log('CocosMgr已经初始化了');
            return _context3.abrupt("return", true);

          case 3:
            exports.hasInit = hasInit = true;

            if (typeof VConsole !== 'undefined') {
              window.vConsole = new VConsole();
            } // var debug = window._CCSettings.debug;
            // var physics = 'physics.js'


            console.log('window._CCSettings.debug', window._CCSettings);
            console.log('window.vConsole', window.vConsole);

            if (!(window.cc != null)) {
              _context3.next = 14;
              break;
            }

            console.log('cocos加载成功ENGINE_VERSION', window.cc.ENGINE_VERSION);
            _context3.next = 11;
            return realBoot();

          case 11:
            initConsoleUtil();
            _context3.next = 16;
            break;

          case 14:
            console.warn('cocos引擎没有被加载');
            return _context3.abrupt("return", false);

          case 16:
            exports.hasInit = hasInit = true;

          case 17:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee3);
  }));
  return _init.apply(this, arguments);
}

function addNodeToScene() {
  if (hasLoadScene == false) {
    return;
  }

  var canvas = cc.director.getScene().getChildByName('Canvas');
  var node = new cc.Node();
  node.addComponent(cc.Label).string = '这是新增节点';
  node.parent = canvas;
}

function updateCanvasSize(width, height) {
  if (hasLoadScene == false) {
    return;
  } // var canvas = cc.director.getScene().getChildByName('Canvas');
  // console.log(canvas.getComponent(cc.Canvas), cc.winSize)


  if (width == null || height == null) {
    //直接查询canvas元素获取
    var canvas = document.getElementById('GameCanvas');
    width = canvas.clientWidth;
    height = canvas.clientHeight;
    console.log('自动获取了canvas尺寸并更新', width, height);
  }

  cc.view.setCanvasSize(width, height); // var manager = cc.director.getCollisionManager();
  // if(manager._debugDrawer != null){
  //     manager._debugDrawer.lineWidth = 2 * (1 / cc.view.getScaleX())
  // }
  // console.log('dpi', cc.view.getScaleX(), cc.view.getScaleY())
}

function showOrHideFPS() {
  var show = !cc.debug.isDisplayStats();
  cc.debug.setDisplayStats(show);
  return show;
}

function showOrHideColiderBox() {
  var manager = cc.director.getCollisionManager();

  if (manager == null) {
    console.warn('getCollisionManager == null');
    return;
  } // manager.enabled = true;
  // this.lastDebugDrawState = manager.enabledDebugDraw 


  manager.enabledDebugDraw = !manager.enabledDebugDraw; // console.log('_debugDrawer', manager._debugDrawer)

  if (manager._debugDrawer != null) {
    manager._debugDrawer.lineWidth = 3 * (1 / cc.view.getScaleX());
  } // if(manager.enabledDebugDraw == false){
  //     manager._debugDrawer.node.destroy()
  // }
  // manager.enabledDrawBoundingBox = manager.enabledDebugDraw;


  return manager.enabledDebugDraw;
} //清空当前场景，只留下Canvas节点和Canvas下的摄像机


function clearScene() {
  if (hasLoadScene == false) {
    return;
  }

  var scene = cc.director.getScene();

  for (var i = 0; i < scene.children.length; i++) {
    var node = scene.children[i];

    if (node.name != 'Canvas') {
      node.destroy();
    } else {
      for (var j = 0; j < node.children.length; j++) {
        var node2 = node.children[j];

        if (node2.name != 'Main Camera') {
          node2.destroy();
        }
      }
    }
  }
}

function getNodeById(id) {
  var target;

  var search = function search(node) {
    if (node._id === id) {
      target = node;
      return;
    }

    if (node.childrenCount) {
      for (var i = 0; i < node.childrenCount; i++) {
        if (!target) {
          search(node.children[i]);
        }
      }
    }
  };

  var scene = cc.director.getScene();
  search(scene);
  return target;
}

function getChildren(node) {
  return node.children.map(function (child) {
    var children = child.children && child.children.length > 0 ? getChildren(child) : [];
    return {
      id: child._id,
      name: child.name,
      active: child.activeInHierarchy,
      children: children
    };
  });
}

function getHasChildrenNodeId() {
  if (hasLoadScene == false) {
    return [];
  }

  var nodeIds = [];
  cc.loopAllNode(function (node) {
    if (node.children.length > 0) {
      nodeIds.push(node._id);
    }
  }, cc.director.getScene());
  return nodeIds;
}

function refreshTree() {
  exports.treeData = treeData = getChildren(cc.director.getScene());
}

function changePreviewMode() {
  exports.isPreviewMode = isPreviewMode = !isPreviewMode;
} // export function startUpdateTree() {
//     stopUpdateTree()
//     intervalId = setInterval(() => {
//         refreshTree();
//     }, 200);
// }
// export function stopUpdateTree() {
//     clearInterval(intervalId);
// }


function drawNodeRect(node) {
  if (node != null) {
    exports.selectedNode = selectedNode = node;
    cc.where(node);
  } else {
    cc.where(selectedNode);
  }
}

function openCacheDialog() {
  // cc.where(selectedNode);
  var cacheInfo = cc.cache();
  console.log('cacheInfo', cacheInfo);
}

function outputComponentHandler(componentName) {
  var component = this.selectedNode.getComponent(componentName);
  console.log(component);
} //所有资源都不用Cocos打包翻到目录下了，应该采用加载网络资源的方案，不使用加载AssestBundle的方案，或者看看是否可以脱离引擎构建AssestBundle
//加载一个资源


function loadResHandle(name, type, cb, customBundle) {} //获取文件类型，一种文件类型可能有多个后缀，比如图片音频


function getFileType(fileEx) {
  if (fileEx == 'png' || fileEx == 'jpg' || fileEx == 'jpeg') {
    return '图片';
  } else if (fileEx == 'mp3' || fileEx == 'wav') {
    return '音频';
  } else if (fileEx == 'json') {
    return 'json';
  } else if (fileEx == 'atlas') {
    return '图集';
  } else if (fileEx == 'spine') {
    return 'spine';
  }

  return '空物体';
} //获取文件后缀名称


function getExName(fileName, withDot) {
  var fileEx = '';

  if (fileName.indexOf('.') != -1) {
    fileName = fileName.split('.');
    fileEx = fileName[fileName.length - 1];
  }

  if (withDot == true) {
    return '.' + fileEx;
  }

  return fileEx;
}

function getName(fileName) {
  if (fileName.indexOf('/') != -1) {
    fileName = fileName.split('/');
    fileName = fileName[fileName.length - 1];
  }

  return fileName;
} //获取文件不带后缀的名称


function getBaseName(fileName) {
  fileName = getName(fileName);
  return fileName.split('.')[0];
}

function setValueByKey(codeNode, config, key) {
  if (config[key] != null) {
    codeNode[key] = config[key];
  }
} //同步配置和节点


function syncConfigToCodeNode(codeNode, config) {
  setValueByKey(codeNode, config, 'modal');
  setValueByKey(codeNode, config, 'customeName');
  setValueByKey(codeNode, config, 'anchorX');
  setValueByKey(codeNode, config, 'anchorY');
  setValueByKey(codeNode, config, 'x');
  setValueByKey(codeNode, config, 'y');

  if (codeNode.useCenterMode) {
    if (config.x != null && config.y != null) {
      codeNode.center = [config.x, config.y];
    }
  }

  setValueByKey(codeNode, config, 'angle');
  setValueByKey(codeNode, config, 'color');
  setValueByKey(codeNode, config, 'zIndex');
  setValueByKey(codeNode, config, 'dynamiczIndex');
  setValueByKey(codeNode, config, 'group');
  setValueByKey(codeNode, config, 'overflow');
  setValueByKey(codeNode, config, 'height');
  setValueByKey(codeNode, config, 'width');
  setValueByKey(codeNode, config, 'opacity');
  setValueByKey(codeNode, config, 'outLineColor');
  setValueByKey(codeNode, config, 'outLineWidth');
  setValueByKey(codeNode, config, 'premulAlpha');
  setValueByKey(codeNode, config, 'scaleX');
  setValueByKey(codeNode, config, 'scaleY');
  setValueByKey(codeNode, config, 'string');
  setValueByKey(codeNode, config, 'zoomRatio');
  setValueByKey(codeNode, config, 'colliderValue'); // codeNode.modal = config.modal   //首先设置，涉及到增减组件
  // codeNode.customeName = config.customeName
  // codeNode.anchorX = config.anchorX
  // codeNode.anchorY = config.anchorY
  // codeNode.x = config.x
  // codeNode.y = config.y
  // codeNode.angle = config.angle
  // codeNode.color = config.color
  // codeNode.zIndex = config.zIndex
  // codeNode.dynamiczIndex = config.dynamiczIndex
  // codeNode.group = config.group
  // codeNode.height = config.height
  // codeNode.width = config.width
  // codeNode.opacity = config.opacity
  // codeNode.outLineColor = config.outLineColor
  // codeNode.outLineWidth = config.outLineWidth
  // codeNode.premulAlpha = config.premulAlpha
  // codeNode.scaleX = config.scaleX
  // codeNode.scaleY = config.scaleY
  // codeNode.string = config.string
} //剔除掉和节点一直的属性配置，多个tween修改不同的值互不影响


function xorConfig(codeNode, config) {
  for (var key in config) {
    if (codeNode[key] == config[key] || null == config[key]) {
      delete config[key];
    }
  }
} //剔除掉值为0的属性


function xorConfigZeroValue(config) {
  for (var key in config) {
    if (0 == config[key] || null == config[key]) {
      delete config[key];
    }
  }
}

function blockTouch(isBlock) {
  if (hasLoadScene == false) {
    console.warn('调用createObj时场景还未加载成功');
    return;
  }

  var scene = cc.director.getScene();
  var blockNode = scene.getChildByName('blockNode');

  if (blockNode == null) {
    blockNode = new cc.Node();
    blockNode.name = 'blockNode';
    blockNode.parent = scene;
    blockNode.width = cc.winSize.width;
    blockNode.height = cc.winSize.height;
    blockNode.addComponent(cc.BlockInputEvents);
    blockNode.x = cc.winSize.width * 0.5;
    blockNode.y = cc.winSize.height * 0.5;
  }

  blockNode.active = isBlock;
}

function createObj(config, cb) {
  // console.log('调用了创建物体', config)
  if (hasLoadScene == false) {
    console.warn('调用createObj时场景还未加载成功');
    return;
  }

  var parentNode = null;

  if (config.parent != null) {
    parentNode = config.parent;
  } else {
    parentNode = cc.director.getScene().getChildByName('Canvas');
  }

  if (parentNode == null) {
    return;
  }

  if (cc.isValid(parentNode) == false) {
    return;
  }

  var node = new cc.Node();
  node.parent = parentNode;
  var codeNode = node.addComponent(_CodeNodeLg.CodeNodeLg);
  codeNode.onAssstLoadCb = cb; // node.x = 0
  // node.y = 0

  syncConfigToCodeNode(codeNode, config); // node.x = -1621.984
  // node.y = -655
  // anchorX: 0
  // anchorY: 0
  // angle: 0
  // colliderValue: Proxy {}
  // color: "#ffffff"
  // customeName: "title8.5c395126.png"
  // dynamiczIndex: false
  // group: false
  // height: 50
  // modal: "图片"
  // opacity: 255
  // outLineColor: "#ffffff"
  // outLineWidth: 0
  // premulAlpha: false
  // scaleX: 0
  // scaleY: 0
  // showTime: "初始化时"
  // string: ""
  // width: 50
  // x: 0
  // y: 0
  // zIndex: 1
  // var modal = config.modal
  // node.addComponent(cc.Label).string = '我是新的节点'

  return codeNode;
} //预下载一个蓝图需要用到的资源


function preLoadGraphAssest(graph) {}

function showConfirm(_x, _x2) {
  return _showConfirm.apply(this, arguments);
}

function _showConfirm() {
  _showConfirm = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4(msg, cb) {
    var result;
    return regeneratorRuntime.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            if (isInApp == true) {// await 
            } else {
              result = confirm(msg);
              cb(result);
            }

          case 1:
          case "end":
            return _context4.stop();
        }
      }
    }, _callee4);
  }));
  return _showConfirm.apply(this, arguments);
}

function showAlert(_x3) {
  return _showAlert.apply(this, arguments);
} //预下载


function _showAlert() {
  _showAlert = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee5(msg) {
    return regeneratorRuntime.wrap(function _callee5$(_context5) {
      while (1) {
        switch (_context5.prev = _context5.next) {
          case 0:
            if (isInApp == true) {// await 
            } else {
              // alert(msg)
              if (window.antAleart != null) {
                window.antAleart(msg);
              }
            }

          case 1:
          case "end":
            return _context5.stop();
        }
      }
    }, _callee5);
  }));
  return _showAlert.apply(this, arguments);
}

function preLoad(groupFile) {
  var urls = [];

  for (var i = 0; i < groupFile.length; i++) {
    var oneGroup = groupFile[i];

    if (oneGroup.modal == ObjectTypeEnum.spine) {
      //目前只有spine资源是多个文件加载
      urls.push({
        url: rootHost + '/' + oneGroup.customeName + '.png',
        ext: '.png'
      });
      urls.push({
        url: rootHost + '/' + oneGroup.customeName + '.json',
        ext: '.json'
      });
      urls.push({
        url: rootHost + '/' + oneGroup.customeName + '.atlas',
        ext: '.atlas'
      });
    } else {
      //音频图片等都是单文件加载
      urls.push({
        url: rootHost + '/' + oneGroup.customeName,
        ext: getExName(oneGroup.customeName, true)
      });
    }
  }

  cc.assetManager.preloadAny(urls, function (finished, total, item) {
    console.log('预加载进度', finished, total);
  }, function (err, items) {
    console.log('预加载结束', items);
  });
}

function loadNetSpine(spineName, cb) {
  var image = rootHost + '/' + spineName + '.png';
  var ske = rootHost + '/' + spineName + '.json';
  var atlas = rootHost + '/' + spineName + '.atlas';
  var arr = image.split('/');
  var textureNames = arr[arr.length - 1];
  cc.assetManager.loadAny([{
    url: atlas,
    ext: '.atlas'
  }, {
    url: ske,
    ext: '.json'
  }], function (error, assets) {
    // let png = Utils.formatPng(url);
    cc.assetManager.loadRemote(image, function (error, texture) {
      var asset = new sp.SkeletonData();
      asset.skeletonJson = assets[1];
      asset.atlasText = assets[0];
      asset.textures = [texture];
      asset.textureNames = [textureNames]; // skeleton.skeletonData = asset;

      cb && cb(asset);
    });
  });
}

function vibrate(_long) {
  console.log('震动长短', _long);
}

function changeGraph(gamePath, orPageIndex) {
  //gamePath 的路径应该是怎么样的呢？
  //bundle, jsonName
  if (isInApp) {//在应用内的切换逻辑
    // UIManager.getInstance()._showingForms[UIManager.getInstance().currentScene].realJumpScene(orPageIndex)
  } else {
    //在编辑器中的切换逻辑
    if (window.onChangeGraph != null) {
      window.onChangeGraph(gamePath, orPageIndex, true);
    }
  }
}

cc._RF.pop();