"use strict";
cc._RF.push(module, 'caee6I4BiBPq4CtEWmQrOX1', 'MotionText');
// Script/Common/LiteGraphCore/MotionText.ts

"use strict";
// import BaseStoryScene from "../../../script/story/BaseStoryScene";
// import { EventCenter } from "../../../script/UIFrame/EventCenter";
// import { EventConst } from "../../../script/logic/EventConst";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
// import GlobalConfig from "../../../script/logic/GlobalConfig";
// const {ccclass, property, menu} = cc._decorator;
//使用方式
//该脚本挂载到页面prefab根结点上，并且物体类型设置为Label，或者Node节点需要添加Label
//为0时关闭并恢复到motionText
//this.node.getComponent('MotionText').inputHandle({data: 0})
//为1时播放（如果已经在播放状态则为重新播放）
//this.node.getComponent('MotionText').inputHandle({data: 1})
// @ccclass
// @menu('自定义组件/MotionText')
var MotionText = /** @class */ (function (_super) {
    __extends(MotionText, _super);
    function MotionText() {
        // LIFE-CYCLE CALLBACKS:
        var _this = _super !== null && _super.apply(this, arguments) || this;
        //初始化完成后自动bof
        // @property({ type: Boolean })
        _this.autoRun = false;
        // @property({ type: Boolean })
        _this.pause = false;
        // @property({ type: Number })
        _this.curTime = 0;
        // @property({ type: Boolean })
        _this.isActive = false;
        // @property({ type: String })
        _this.position = '0,0.6,1';
        // @property({ type: String })
        _this.positionTime = '0,1.4,2';
        // @property({ type: Boolean })
        _this.hideBaseLabel = false;
        // @property({ type: Boolean })
        _this.hideBeforRun = false;
        // @property({ type: Boolean })
        _this.hideAfterRun = false;
        _this.positionTimeArr = [];
        _this.positionArr = [];
        // @property({ type: Number })
        _this.dotIndex = 1;
        // @property({ type: Number })
        _this.delay = 0;
        // @property({ type: String })
        _this.maskColor = '88BF3D';
        // @property({ type: Boolean })
        _this.stopIsPlayEnd = false;
        //方向
        // @property({ type: Number })
        _this.dir = 0;
        _this.oriOpacity = 255;
        _this.hasInit = false;
        return _this;
    }
    MotionText.prototype.onLoad = function () {
        // console.log('motionText onLoad')
        // if(GlobalConfig.recordMode == true){
        //     //录音模式不开启字幕
        //     this.node.active = false
        // }
        if (this.node.getComponent('CodeNode') == null && this.node.getComponent('CodeNodeLg') == null) {
            //常规脚本OnLoad时候即可初始化
            // console.log('motionText在onload就初始化了')
            this.init();
            this.addEventListener();
        }
    };
    MotionText.prototype.init = function () {
        var _this = this;
        if (this.hasInit == true) {
            // console.log('motionText 已经初始化，不重复init')
            return;
        }
        // console.log('motionText init', this.node.name + ':' + this.node.opacity)
        this.oriOpacity = this.node.opacity;
        this.node.anchorX = 0;
        var childLabel = new cc.Node();
        var childLabelCom = childLabel.addComponent(cc.Label);
        var selfLabel = this.node.getComponent(cc.Label);
        childLabelCom.font = selfLabel.font;
        childLabelCom.fontSize = selfLabel.fontSize;
        // childLabel.anchorX = selfLabel.node.anchorX
        // childLabel.anchorY = selfLabel.node.anchorY
        childLabelCom.string = selfLabel.string;
        childLabelCom.lineHeight = selfLabel.lineHeight;
        childLabelCom.overflow = selfLabel.overflow;
        childLabelCom.enableBold = selfLabel.enableBold;
        childLabelCom.enableItalic = selfLabel.enableItalic;
        childLabelCom.enableUnderline = selfLabel.enableUnderline;
        childLabelCom.horizontalAlign = selfLabel.horizontalAlign;
        childLabelCom.verticalAlign = selfLabel.verticalAlign;
        if (this.hideBaseLabel == true) {
            this.scheduleOnce(function () {
                selfLabel.enabled = false;
            }, 0);
        }
        var selfLabelOutLine = this.node.getComponent(cc.LabelOutline);
        if (selfLabelOutLine != null) {
            var labelOutLine = childLabel.addComponent(cc.LabelOutline);
            labelOutLine.width = selfLabelOutLine.width;
            labelOutLine.color = selfLabelOutLine.color;
        }
        var maskNode = new cc.Node();
        // maskNode.anchorX = this.node.anchorX
        // maskNode.anchorY = this.node.anchorY
        //maskNode是颜色过渡方向，
        //横向文本固定从左到右
        //竖线文本固定从上到下
        if (this.dir == 0) {
            maskNode.anchorX = 0;
            maskNode.anchorY = 0.5;
        }
        else {
            maskNode.anchorX = 0.5;
            maskNode.anchorY = 1;
        }
        var mask = maskNode.addComponent(cc.Mask);
        maskNode.parent = this.node;
        childLabel.parent = maskNode;
        // maskNode.x = 0
        // maskNode.y = 0
        maskNode.width = this.node.width;
        maskNode.height = this.node.height;
        //有时候高度不会立马更新
        this.scheduleOnce(function () {
            childLabel.width = _this.node.width;
            childLabel.height = _this.node.height;
            //mask节点根据上一个节点的anchor设置位置
            if (_this.dir == 0) {
                maskNode.width = 0;
                maskNode.height = _this.node.height;
                //如果出现左右没对齐，大概率是这里的问题
                maskNode.x = -1 * _this.node.width * _this.node.anchorX;
                //如果出现上下没对齐，大概率是这里的问题
                maskNode.y = _this.node.height * (0.5 - _this.node.anchorY);
            }
            else {
                maskNode.y = _this.node.height * (1 - _this.node.anchorY);
                //如果出现上下没对齐，大概率是这里的问题
                maskNode.x = 0;
                maskNode.width = _this.node.width;
                maskNode.height = 0;
            }
        }, 0);
        childLabel.anchorX = maskNode.anchorX;
        childLabel.anchorY = maskNode.anchorY;
        childLabel.y = 0;
        childLabel.x = 0;
        this.positionTimeArr = this.positionTime.split(',');
        this.positionArr = this.position.split(',');
        // console.log('positionTimeArr', this.positionTimeArr, this.positionArr)
        if (this.dir == 0) {
            this.node.children[0].width = Number(this.positionArr[0]);
        }
        else {
            this.node.children[0].height = Number(this.positionArr[0]);
        }
        if (this.hideBeforRun == true) {
            this.node.opacity = 1;
        }
        childLabel.color = cc.Color.WHITE.fromHEX(this.maskColor);
        // setTimeout(() => {
        //     console.log('当前label尺寸', this.node.width, this.node.height)
        //     console.log('生成的蒙皮尺寸', maskNode.width, maskNode.height)
        //     console.log('生成的过渡label尺寸', childLabel.width, childLabel.height)
        // }, 1000);
        if (this.autoRun == true) {
            this.inputHandle({ data: 1 });
        }
        this.hasInit = true;
    };
    //重置时间
    // this.node.getComponent('AutoTips').inputHandle({data: 1, targetSolt: 'resetTime'})
    MotionText.prototype.inputHandle = function (inputData) {
        var _this = this;
        //接收输入的参数，输入0时关闭，不为0时开启
        // console.log('motionText inputHandle', inputData)
        if (inputData.targetSolt == 'hide') {
            this.hide();
            return;
        }
        if (inputData.data == 0) {
            // console.log("关闭字幕")
            this.isActive = false;
            this.stopRun();
            return;
        }
        // console.log("激活字幕", this.positionTime, this.positionTimeArr, this.position, this.positionArr)
        this.isActive = true;
        this.curTime = 0;
        this.dotIndex = 1;
        if (this.dir == 0) {
            this.node.children[0].width = Number(this.positionArr[0]);
        }
        else {
            this.node.children[0].height = Number(this.positionArr[0]);
        }
        cc.Tween.stopAllByTarget(this.node);
        if (this.hideBeforRun == true) {
            this.node.opacity = 1;
            cc.tween(this.node).to(0.4, { opacity: this.oriOpacity }).start();
        }
        this.scheduleOnce(function () {
            // console.log('开始播放字幕', this.node.getComponent(cc.Label).string)
            _this.startRun();
        }, 0);
    };
    // public outputHandle = (key , data)=>{
    //     // this.outputHandle('onclick', 1)
    // }
    MotionText.prototype.stopRun = function () {
        // console.log('motionText this.hasInit', this.hasInit, this.oriOpacity)
        if (this.hasInit == false) {
            // console.log("motionText 都没有初始化，不要继续执行了 stopRun")
            return;
        }
        cc.Tween.stopAllByTarget(this.node.children[0]);
        if (this.dir == 0) {
            // if(this.stopIsPlayEnd != true){
            // }else{
            //     this.node.children[0].width = this.node.width
            // }
            this.node.children[0].width = Number(this.positionArr[0]);
        }
        else {
            this.node.children[0].height = Number(this.positionArr[0]);
            // if(this.stopIsPlayEnd != true){
            // }else{
            //     this.node.children[0].height = this.node.height
            // }
        }
        if (this.stopIsPlayEnd == true) {
            if (this.node.oriColor == null) {
                this.node.oriColor = this.node.color.toHEX("#rrggbb");
            }
            this.node.color = cc.Color.WHITE.fromHEX(this.maskColor);
        }
        // console.log('motionText this.stopIsPlayEnd', this.stopIsPlayEnd, this.positionArr)
        if (this.hideBeforRun == true) {
            cc.Tween.stopAllByTarget(this.node);
            this.node.opacity = 1;
        }
        // console.log('字幕stopRun', this.node.getComponent(cc.Label).string)
    };
    MotionText.prototype.hide = function () {
        cc.Tween.stopAllByTarget(this.node);
        cc.tween(this.node).to(0.4, { opacity: 0 }).start();
    };
    MotionText.prototype.startRun = function () {
        var _this = this;
        if (this.node.oriColor != null) {
            this.node.color = cc.Color.WHITE.fromHEX(this.node.oriColor);
        }
        var width = this.positionArr[this.dotIndex];
        var obj = {};
        if (this.dir == 0) {
            obj = { width: width * this.node.width };
        }
        else {
            obj = { height: width * this.node.height };
        }
        var time = this.positionTimeArr[this.dotIndex] - this.positionTimeArr[this.dotIndex - 1];
        console.log('motionText startRun', this.dotIndex, this.node.width, this.delay, this.positionArr.join(','), obj);
        if (time < 0) {
            //时间不应该为0了吧
            time = 0.1;
            console.warn('时间点错误，后面的时间点小于前面的，自动设置为0.1', time);
        }
        cc.Tween.stopAllByTarget(this.node.children[0]);
        cc.tween(this.node.children[0]).delay(this.delay).to(time, obj).call(function () {
            if (_this.positionArr[_this.dotIndex + 1] != null) {
                _this.dotIndex += 1;
                _this.startRun();
            }
            else {
                //正常播放结束的话
                if (_this.outputHandle != null) {
                    _this.outputHandle('onend', 1);
                }
                // console.log('是否播放结束了', this.node.getComponent(cc.Label).string, this.hideAfterRun)
                if (_this.hideAfterRun == true) {
                    cc.tween(_this.node).to(0.4, { opacity: 0 }).start();
                }
            }
        }).start();
    };
    MotionText.prototype.addEventListener = function () {
        var _this = this;
        cc.game.targetOff(this);
        cc.game.on('replayPage', function () {
            if (_this.dir == 0) {
                _this.node.children[0].width = Number(_this.positionArr[0]);
            }
            else {
                _this.node.children[0].height = Number(_this.positionArr[0]);
            }
            if (_this.hideBeforRun == true) {
                _this.node.opacity = 1;
            }
            else {
                _this.node.opacity = _this.oriOpacity;
            }
            if (_this.autoRun == true) {
                _this.inputHandle({ data: 1 });
            }
        }, this);
        cc.game.on('pause', function () {
            _this.robotPause();
        }, this);
        cc.game.on('resume', function () {
            _this.robotResume();
        }, this);
    };
    MotionText.prototype.robotStart = function () {
        if (this.node == null) {
            console.warn('当前没有node', this);
            return;
        }
        if (this.node.children[0] == null) {
            this.init();
        }
        else {
            this.stopRun();
            if (this.autoRun == true) {
                this.inputHandle({ data: 1 });
            }
        }
        this.addEventListener();
    };
    MotionText.prototype.robotRelease = function () {
        this.pause = false;
        cc.game.targetOff(this);
        if (cc.isValid(this.node)) {
            cc.Tween.stopAllByTarget(this.node.children[0]);
            cc.Tween.stopAllByTarget(this.node);
        }
    };
    MotionText.prototype.robotPause = function () {
        this.pause = true;
        cc.director.getActionManager().pauseTarget(this.node.children[0]);
    };
    MotionText.prototype.robotResume = function () {
        this.pause = false;
        cc.director.getActionManager().resumeTarget(this.node.children[0]);
    };
    // update (dt) {
    //     if(this.pause == true){
    //         return
    //     }
    //     if(this.isActive == false){
    //         return
    //     }
    // }
    MotionText.prototype.onDestroy = function () {
        cc.game.targetOff(this);
        // EventCenter.targetOff(this);
    };
    return MotionText;
}(cc.Component));
exports.default = MotionText;

cc._RF.pop();