"use strict";
cc._RF.push(module, '75d97i2bTxLYqFTXEgwqTAC', 'games');
// Script/Common/LiteGraphCore/nodes/games.js

"use strict";

var _litegraph = require("../../litegraph/litegraph");

var CocosMgr = _interopRequireWildcard(require("../CocosMgr"));

var _BaseYwNode = require("./BaseYwNode");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var dragNumGame = /*#__PURE__*/function (_BaseYWNode) {
  _inheritsLoose(dragNumGame, _BaseYWNode);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  function dragNumGame() {
    var _this;

    _this = _BaseYWNode.call(this) || this; //   this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型    //不需要触发了
    //   this.addInput("B", "number")

    _this.title = "value";
    _this.desc = "这是一个拖拽数数游戏的模型";
    _this.name = '拖拽数数游戏控制器';

    _this.addInput("物体", "codeNode");

    _this.addOutput("播放问题", _litegraph.LiteGraph.EVENT); //增加一个输出触点，  输出节点的名称， 值类型


    _this.addOutput("当前正确数量", 'number'); //增加一个输出触点，  输出节点的名称， 值类型


    _this.addOutput("输出正确反馈", _litegraph.LiteGraph.EVENT);

    _this.addOutput("输出错误反馈", _litegraph.LiteGraph.EVENT);

    _this.addOutput("输出结束反馈", _litegraph.LiteGraph.EVENT);

    _this.addProperty("rightCount", 5); //增加一个变量，    变量名称， 变量名称
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置


    _this.widget = _this.addWidget("number", "正确选项数量", 5, "rightCount", {
      precision: 0,
      step2: 1
    }); //    this.serialize_widgets = true;
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //   this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.size = [180, 30];                                     //设置默认节点尺寸
    //   this.properties.precision = 1

    return _this;
  }

  var _proto = dragNumGame.prototype;

  _proto.onStart = function onStart() {
    this.trigger('播放问题');
    this.curRightCount = 0;
  };

  _proto.onAction = function onAction(state) {
    if (state == 'right') {
      this.curRightCount += 1;
      this.setOutputData(1, this.curRightCount);
      this.trigger('输出正确反馈');

      if (this.curRightCount == this.properties.rightCount) {
        this.trigger('输出结束反馈');
      }
    } else if (state == 'error') {
      this.trigger('输出错误反馈');
    }
  } // Function to call when the node is executed
  //执行时的方法
  // onExecute() {
  //   var A = this.getInputData(0)
  //   this.setOutputData(0, parseFloat(this.properties["value"])) //发送一个参数出去
  // }
  ;

  return dragNumGame;
}(_BaseYwNode.BaseYWNode); // Register the node type


dragNumGame.title = '拖拽数数游戏控制器'; //设置中文名称标题，是否需要实现多语言？

dragNumGame.nodeType = "output/tatagame/dragGame/dragGameControl";

_litegraph.LiteGraph.registerNodeType(dragNumGame.nodeType, dragNumGame); //第一个是唯一key，同时也是菜单选项路径


var dragNumObj = /*#__PURE__*/function (_BaseYWNode2) {
  _inheritsLoose(dragNumObj, _BaseYWNode2);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  function dragNumObj() {
    var _this2;

    _this2 = _BaseYWNode2.call(this) || this;
    _this2.title = "value";
    _this2.desc = "这是一个拖拽数数游戏的选项，关联到选项上";
    _this2.name = '拖拽数数游戏选项';

    _this2.addInput("物体", "codeNode"); //增加一个输入触点，  输入触点的名称， 值类型    //不需要触发了
    //this.addInput("B", "number")


    _this2.addProperty("isRight", true); //增加一个变量，    变量名称， 变量名称


    _this2.widget = _this2.addWidget("toggle", "是否为正确选项", true, "isRight"); //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    //   this.widget = this.addWidget("number","值",1,"value");
    //   this.serialize_widgets = true;
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称

    _this2.widgets_up = true; //设置输入组件在顶部（覆盖input和output）
    //   this.size = [180, 30];                                     //设置默认节点尺寸
    //   this.properties.precision = 1

    return _this2;
  } // Function to call when the node is executed
  //执行时的方法


  var _proto2 = dragNumObj.prototype;

  _proto2.onExecute = function onExecute() {//   var A = this.getInputData(0)
    //   this.setOutputData(0, parseFloat(this.properties["value"])) //发送一个参数出去
  };

  _proto2.onStart = function onStart() {
    var _this3 = this;

    _BaseYWNode2.prototype.onStart.call(this);

    var codeNode = this.getInputData(0); // let linkObjectNode = this.getInputNode(0)
    // if(linkObjectNode == null){
    //     console.log('当前没有连接节点', linkObjectNode)
    //     return
    // }

    this.touchIds = {};

    if (codeNode != null) {
      if (this.startPos == null) {
        this.startPos = cc.v2(codeNode.x, codeNode.y);
        this.startZIndex = codeNode.zIndex;
      }

      var lastMovePos = null;
      var moveCount = 5;
      var eventId = null;
      codeNode.targetOff(this);
      codeNode.on(cc.Node.EventType.TOUCH_START, function (event) {
        if (_this3.inAni == true) {
          return;
        }

        lastMovePos = null;
        eventId = event.getID();
        var eventid = event.getID();
        _this3.touchIds[eventid] = 1;
        codeNode.zIndex = 1999;
      }, this);
      codeNode.on(cc.Node.EventType.TOUCH_MOVE, function (event) {
        if (Object.keys(_this3.touchIds).length > 1) {
          //多点触摸时不响应
          return;
        }

        if (eventId != event.getID()) {
          return;
        }

        if (_this3.graph.config.pause == 1) {
          return;
        }

        if (_this3.inAni == true) {
          return;
        }

        if (_this3.instance != null && moveCount < 5) {
          moveCount += 1;
          return;
        }

        moveCount = 0;

        if (lastMovePos == null) {
          lastMovePos = codeNode.parent.convertToNodeSpaceAR(event.getLocation());
          return;
        }

        var nowMovePos = codeNode.parent.convertToNodeSpaceAR(event.getLocation()); //移动的时候检测，只在碰撞框内才出发移动

        var inTouch = true; // if(this.properties.needCheckIn.default == 1){
        //     var collider = codeNode.getComponent(cc.PolygonCollider)
        //     if(collider != null){
        //         var inNodePos = codeNode.node.convertToNodeSpaceAR(event.getLocation())
        //         var inTouch = cc.Intersection.pointInPolygon(inNodePos, collider.points)
        //     }
        // }

        var delta = nowMovePos.sub(lastMovePos);

        if (inTouch == true) {
          // this.setOutputData(0, delta.x)
          // this.setOutputData(1, delta.y)
          // this.triggerSlot(2, 1)
          // if(this.properties.controllObj == true){
          codeNode.x += delta.x;
          codeNode.y += delta.y; // }
        }

        lastMovePos = nowMovePos;
      }, this);
      codeNode.on(cc.Node.EventType.TOUCH_END, function (event) {
        if (_this3.inAni == true) {
          return;
        }

        var eventid = event.getID();
        delete _this3.touchIds[eventid]; //判断是否

        _this3.checkIsInTarget(codeNode, event);
      }, this);
      codeNode.on(cc.Node.EventType.TOUCH_CANCEL, function (event) {
        if (_this3.inAni == true) {
          return;
        }

        var eventid = event.getID();
        delete _this3.touchIds[eventid];

        _this3.checkIsInTarget(codeNode, event);
      }, this);
    } // if(this.touchEndNode == null){
    //     let touchEndNode = LiteGraph.createNode('input/screen/touchEnd')
    //     linkObjectNode.connect(0, touchEndNode, 0)
    //     touchEndNode.onAction('监听')
    //     this.touchEndNode = touchEndNode
    // }else{
    //     this.touchEndNode.onAction('监听')
    // }

  };

  _proto2.checkIsInTarget = function checkIsInTarget(codeNode, event) {
    var _this4 = this;

    var isIn = false;
    var dragNumGameControll = this.graph.findNodesByType(dragNumGame.nodeType)[0];

    if (dragNumGameControll == null) {
      return;
    }

    var targetNode = dragNumGameControll.getInputData(0, true);

    if (targetNode != null) {
      var collider = targetNode.getComponent(cc.PolygonCollider);

      if (collider != null) {
        var inNodePos = targetNode.node.convertToNodeSpaceAR(event.getLocation());
        isIn = cc.Intersection.pointInPolygon(inNodePos, collider.points);
        console.log('判断是否处于碰撞框内', isIn);
      } else {
        //没有添加碰撞框
        console.warn("目标对象没有添加碰撞框");

        if (CocosMgr.isInApp == false) {
          if (window.antAleart != null) {
            window.antAleart('目标对象没有添加碰撞框');
          }
        }
      }
    }

    if (isIn == false) {
      //如果没有拖到目标位置，不管正确错误都回到原来位置
      this.inAni = true;
      cc.tween(codeNode).to(0.5, {
        x: this.startPos.x,
        y: this.startPos.y
      }).call(function () {
        codeNode.zIndex = _this4.startZIndex;
        _this4.inAni = false;
      }).start();
    } else {
      //通知游戏控制器
      if (this.properties.isRight == true) {
        dragNumGameControll.onAction('right');
        codeNode.targetOff(this);
        cc.tween(codeNode).to(0.5, {
          opacity: 0
        }).start();
      } else {
        dragNumGameControll.onAction('error'); //错误选项回到原来位置

        this.inAni = true;
        cc.tween(codeNode).to(0.5, {
          x: this.startPos.x,
          y: this.startPos.y
        }).call(function () {
          codeNode.zIndex = _this4.startZIndex;
          _this4.inAni = false;
        }).start();
      }
    }
  };

  return dragNumObj;
}(_BaseYwNode.BaseYWNode); // Register the node type


dragNumObj.title = '拖拽数数游戏选项'; //设置中文名称标题，是否需要实现多语言？

dragNumObj.nodeType = "output/tatagame/dragGame/dragNumObj";

_litegraph.LiteGraph.registerNodeType(dragNumObj.nodeType, dragNumObj); //第一个是唯一key，同时也是菜单选项路径

cc._RF.pop();