"use strict";
cc._RF.push(module, '5c619rDtAhDWbgv0Gd78o1O', 'graphExtension');
// Script/Common/LiteGraphCore/nodes/graphExtension.js

"use strict";

var _litegraph = require("../../litegraph/litegraph");

function _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

//Subgraph: a node that contains a graph
var Subgraph = /*#__PURE__*/function (_LGraphNode) {
  _inheritsLoose(Subgraph, _LGraphNode);

  function Subgraph() {
    var _this;

    _this = _LGraphNode.call(this) || this;
    _this.title = "分支蓝图";
    _this.desc = "Graph inside a node";
    _this.color = "#334";

    _this.onResize = function (size) {
      size[1] += 20;
    };

    _this.serialize = function () {
      var data = _litegraph.LiteGraph.LGraphNode.prototype.serialize.call(this);

      data.subgraph = this.subgraph.serialize();
      return data;
    };

    _this.addProperty('enabled', true, 'boolean');

    _this.enabled = true; // this.addInput('触发', LiteGraph.ACTION)
    //create inner graph

    _this.subgraph = new _litegraph.LiteGraph.LGraph();
    _this.subgraph._subgraph_node = _assertThisInitialized(_this);
    _this.subgraph._is_subgraph = true;
    _this.subgraph.onTrigger = _this.onSubgraphTrigger.bind(_assertThisInitialized(_this)); //nodes input node added inside

    _this.subgraph.onInputAdded = _this.onSubgraphNewInput.bind(_assertThisInitialized(_this));
    _this.subgraph.onInputRenamed = _this.onSubgraphRenamedInput.bind(_assertThisInitialized(_this));
    _this.subgraph.onInputTypeChanged = _this.onSubgraphTypeChangeInput.bind(_assertThisInitialized(_this));
    _this.subgraph.onInputRemoved = _this.onSubgraphRemovedInput.bind(_assertThisInitialized(_this));
    _this.subgraph.onOutputAdded = _this.onSubgraphNewOutput.bind(_assertThisInitialized(_this));
    _this.subgraph.onOutputRenamed = _this.onSubgraphRenamedOutput.bind(_assertThisInitialized(_this));
    _this.subgraph.onOutputTypeChanged = _this.onSubgraphTypeChangeOutput.bind(_assertThisInitialized(_this));
    _this.subgraph.onOutputRemoved = _this.onSubgraphRemovedOutput.bind(_assertThisInitialized(_this));
    return _this;
  }

  var _proto = Subgraph.prototype;

  _proto.onGetInputs = function onGetInputs() {
    // console.log('subgraph获取了可以添加的输入')
    return [["enabled", "boolean"], ["触发", _litegraph.LiteGraph.ACTION]];
  };

  _proto.onGetOutputs = function onGetOutputs() {
    // console.log('subgraph获取了可以添加的输入')
    return [["结束", _litegraph.LiteGraph.EVENT], ['被引用', 'lgraphNode']];
  } // onGetInputs = function() {
  //     return [
  //         ["and", "boolean"]
  //     ];
  // };
  ;

  _proto.onDblClick = function onDblClick(e, pos, graphcanvas) {
    var that = this;
    setTimeout(function () {
      graphcanvas.openSubgraph(that.subgraph);
    }, 10);
  };

  _proto.onDrawTitle = function onDrawTitle(ctx, graph_mouse) {
    var node = this;

    if (!node.flags.collapsed && node.subgraph && !node.skip_subgraph_button) {
      var w = _litegraph.LiteGraph.NODE_TITLE_HEIGHT;
      var x = node.size[0] - w;

      var over = _litegraph.LiteGraph.isInsideRectangle(graph_mouse[0] - node.pos[0], graph_mouse[1] - node.pos[1], x + 2, -w + 2, w - 4, w - 4);

      ctx.fillStyle = over ? "#888" : "#555";
      if (this.renderingShape == _litegraph.LiteGraph.BOX_SHAPE) ctx.fillRect(x + 2, -w + 2, w - 4, w - 4);else {
        ctx.beginPath();
        ctx.roundRect(x + 2, -w + 2, w - 4, w - 4, [4]);
        ctx.fill();
      }
      ctx.fillStyle = "#333";
      ctx.beginPath();
      ctx.moveTo(x + w * 0.2, -w * 0.6);
      ctx.lineTo(x + w * 0.8, -w * 0.6);
      ctx.lineTo(x + w * 0.5, -w * 0.3);
      ctx.fill();
    }
  } //onToggle执行的是onExecute，其它事件在onAction中执行
  ;

  _proto.onAction = function onAction(action, param) {
    // console.log('Subgraph onAction',  action, param)
    this.subgraph.onAction(action, param);
  };

  _proto.onExecute = function onExecute() {
    // console.log('Subgraph onExecute')
    this.enabled = this.getInputOrProperty("enabled");

    if (!this.enabled) {
      return;
    } //send inputs to subgraph global inputs


    if (this.inputs) {
      for (var i = 0; i < this.inputs.length; i++) {
        var input = this.inputs[i];
        var value = this.getInputData(i);
        this.subgraph.setInputData(input.name, value);
      }
    } //execute


    this.subgraph.runStep(); //send subgraph global outputs to outputs

    if (this.outputs) {
      for (var i = 0; i < this.outputs.length; i++) {
        var output = this.outputs[i];
        var value = this.subgraph.getOutputData(output.name);
        this.setOutputData(i, value);
      }
    }
  };

  _proto.sendEventToAllNodes = function sendEventToAllNodes(eventname, param, mode) {
    console.log('sendEventToAllNodes', eventname, param, mode);

    if (this.enabled) {
      this.subgraph.sendEventToAllNodes(eventname, param, mode);
    }
  };

  _proto.onDrawBackground = function onDrawBackground(ctx, graphcanvas, canvas, pos) {
    if (this.flags.collapsed) return;
    var y = this.size[1] - _litegraph.LiteGraph.NODE_TITLE_HEIGHT + 0.5; // button

    var over = _litegraph.LiteGraph.isInsideRectangle(pos[0], pos[1], this.pos[0], this.pos[1] + y, this.size[0], _litegraph.LiteGraph.NODE_TITLE_HEIGHT);

    var overleft = _litegraph.LiteGraph.isInsideRectangle(pos[0], pos[1], this.pos[0], this.pos[1] + y, this.size[0] / 2, _litegraph.LiteGraph.NODE_TITLE_HEIGHT); // let over = true
    // let overleft = false


    ctx.fillStyle = over ? "#555" : "#222";
    ctx.beginPath();

    if (this._shape == _litegraph.LiteGraph.BOX_SHAPE) {
      if (overleft) {
        ctx.rect(0, y, this.size[0] / 2 + 1, _litegraph.LiteGraph.NODE_TITLE_HEIGHT);
      } else {
        ctx.rect(this.size[0] / 2, y, this.size[0] / 2 + 1, _litegraph.LiteGraph.NODE_TITLE_HEIGHT);
      }
    } else {
      if (overleft) {
        ctx.roundRect(0, y, this.size[0] / 2 + 1, _litegraph.LiteGraph.NODE_TITLE_HEIGHT, [0, 0, 8, 8]);
      } else {
        ctx.roundRect(this.size[0] / 2, y, this.size[0] / 2 + 1, _litegraph.LiteGraph.NODE_TITLE_HEIGHT, [0, 0, 8, 8]);
      }
    }

    if (over) {
      ctx.fill();
    } else {
      ctx.fillRect(0, y, this.size[0] + 1, _litegraph.LiteGraph.NODE_TITLE_HEIGHT);
    } // button


    ctx.textAlign = "center";
    ctx.font = "24px Arial";
    ctx.fillStyle = over ? "#DDD" : "#999";
    ctx.fillText("+", this.size[0] * 0.25, y + 24);
    ctx.fillText("+", this.size[0] * 0.75, y + 24);
  } // onMouseDown(e, pos, graphcanvas) {
  //     if (
  //         !this.flags.collapsed &&
  //         pos[0] > this.size[0] - LiteGraph.NODE_TITLE_HEIGHT &&
  //         pos[1] < 0
  //     ) {
  //         var that = this;
  //         setTimeout(function() {
  //             graphcanvas.openSubgraph(that.subgraph);
  //         }, 10);
  //     }
  // };
  ;

  _proto.onMouseDown = function onMouseDown(e, localpos, graphcanvas) {
    if (!this.flags.collapsed && localpos[0] > this.size[0] - _litegraph.LiteGraph.NODE_TITLE_HEIGHT && localpos[1] < 0) {
      var that = this;
      setTimeout(function () {
        graphcanvas.openSubgraph(that.subgraph);
      }, 10);
    }

    var y = this.size[1] - _litegraph.LiteGraph.NODE_TITLE_HEIGHT + 0.5;
    console.log(0);

    if (localpos[1] > y) {
      if (localpos[0] < this.size[0] / 2) {
        console.log(1);
        graphcanvas.showSubgraphPropertiesDialog(this);
      } else {
        console.log(2);
        graphcanvas.showSubgraphPropertiesDialogRight(this);
      }
    }
  };

  _proto.computeSize = function computeSize() {
    var num_inputs = this.inputs ? this.inputs.length : 0;
    var num_outputs = this.outputs ? this.outputs.length : 0;
    return [200, Math.max(num_inputs, num_outputs) * _litegraph.LiteGraph.NODE_SLOT_HEIGHT + _litegraph.LiteGraph.NODE_TITLE_HEIGHT];
  } //**** INPUTS ***********************************
  ;

  _proto.onSubgraphTrigger = function onSubgraphTrigger(event, param) {
    console.log('onSubgraphTrigger', event, param);
    var slot = this.findOutputSlot(event);

    if (slot != -1) {
      this.triggerSlot(slot);
    }
  };

  _proto.onSubgraphNewInput = function onSubgraphNewInput(name, type) {
    var slot = this.findInputSlot(name);

    if (slot == -1) {
      //add input to the node
      this.addInput(name, type);
    }
  };

  _proto.onSubgraphRenamedInput = function onSubgraphRenamedInput(oldname, name) {
    var slot = this.findInputSlot(oldname);

    if (slot == -1) {
      return;
    }

    var info = this.getInputInfo(slot);
    info.name = name;
  };

  _proto.onSubgraphTypeChangeInput = function onSubgraphTypeChangeInput(name, type) {
    var slot = this.findInputSlot(name);

    if (slot == -1) {
      return;
    }

    var info = this.getInputInfo(slot);
    info.type = type;
  };

  _proto.onSubgraphRemovedInput = function onSubgraphRemovedInput(name) {
    var slot = this.findInputSlot(name);

    if (slot == -1) {
      return;
    }

    this.removeInput(slot);
  };

  //**** OUTPUTS ***********************************
  _proto.onSubgraphNewOutput = function onSubgraphNewOutput(name, type) {
    var slot = this.findOutputSlot(name);

    if (slot == -1) {
      this.addOutput(name, type);
    }
  };

  _proto.onSubgraphRenamedOutput = function onSubgraphRenamedOutput(oldname, name) {
    var slot = this.findOutputSlot(oldname);

    if (slot == -1) {
      return;
    }

    var info = this.getOutputInfo(slot);
    info.name = name;
  };

  _proto.onSubgraphTypeChangeOutput = function onSubgraphTypeChangeOutput(name, type) {
    var slot = this.findOutputSlot(name);

    if (slot == -1) {
      return;
    }

    var info = this.getOutputInfo(slot);
    info.type = type;
  };

  _proto.onSubgraphRemovedOutput = function onSubgraphRemovedOutput(name) {
    var slot = this.findOutputSlot(name);

    if (slot == -1) {
      return;
    }

    this.removeOutput(slot);
  };

  // *****************************************************
  _proto.getExtraMenuOptions = function getExtraMenuOptions(graphcanvas) {
    var that = this;
    return [{
      content: "Open",
      callback: function callback() {
        graphcanvas.openSubgraph(that.subgraph);
      }
    }];
  };

  //no need to define node.configure, the default method detects node.subgraph and passes the object to node.subgraph.configure()
  _proto.reassignSubgraphUUIDs = function reassignSubgraphUUIDs(graph) {
    var idMap = {
      nodeIDs: {},
      linkIDs: {}
    };

    for (var _iterator = _createForOfIteratorHelperLoose(graph.nodes), _step; !(_step = _iterator()).done;) {
      var node = _step.value;
      var oldID = node.id;

      var newID = _litegraph.LiteGraph.uuidv4();

      node.id = newID;

      if (idMap.nodeIDs[oldID] || idMap.nodeIDs[newID]) {
        throw new Error("New/old node UUID wasn't unique in changed map! " + oldID + " " + newID);
      }

      idMap.nodeIDs[oldID] = newID;
      idMap.nodeIDs[newID] = oldID;
    }

    for (var _iterator2 = _createForOfIteratorHelperLoose(graph.links), _step2; !(_step2 = _iterator2()).done;) {
      var link = _step2.value;
      var _oldID = link[0];

      var _newID = _litegraph.LiteGraph.uuidv4();

      link[0] = _newID;

      if (idMap.linkIDs[_oldID] || idMap.linkIDs[_newID]) {
        throw new Error("New/old link UUID wasn't unique in changed map! " + _oldID + " " + _newID);
      }

      idMap.linkIDs[_oldID] = _newID;
      idMap.linkIDs[_newID] = _oldID;
      var nodeFrom = link[1];
      var nodeTo = link[3];

      if (!idMap.nodeIDs[nodeFrom]) {
        throw new Error("Old node UUID not found in mapping! " + nodeFrom);
      }

      link[1] = idMap.nodeIDs[nodeFrom];

      if (!idMap.nodeIDs[nodeTo]) {
        throw new Error("Old node UUID not found in mapping! " + nodeTo);
      }

      link[3] = idMap.nodeIDs[nodeTo];
    } // Reconnect links


    for (var _iterator3 = _createForOfIteratorHelperLoose(graph.nodes), _step3; !(_step3 = _iterator3()).done;) {
      var _node = _step3.value;

      if (_node.inputs) {
        for (var _iterator5 = _createForOfIteratorHelperLoose(_node.inputs), _step5; !(_step5 = _iterator5()).done;) {
          var input = _step5.value;

          if (input.link) {
            input.link = idMap.linkIDs[input.link];
          }
        }
      }

      if (_node.outputs) {
        for (var _iterator6 = _createForOfIteratorHelperLoose(_node.outputs), _step6; !(_step6 = _iterator6()).done;) {
          var output = _step6.value;

          if (output.links) {
            output.links = output.links.map(function (l) {
              return idMap.linkIDs[l];
            });
          }
        }
      }
    } // Recurse!


    for (var _iterator4 = _createForOfIteratorHelperLoose(graph.nodes), _step4; !(_step4 = _iterator4()).done;) {
      var _node2 = _step4.value;

      if (_node2.type === "middle/graph/subgraph") {
        var merge = reassignGraphUUIDs(_node2.subgraph);
        idMap.nodeIDs.assign(merge.nodeIDs);
        idMap.linkIDs.assign(merge.linkIDs);
      }
    }
  };

  _proto.clone = function clone() {
    var node = _litegraph.LiteGraph.createNode(this.type);

    var data = this.serialize();

    if (_litegraph.LiteGraph.use_uuids) {
      // LGraph.serialize() seems to reuse objects in the original graph. But we
      // need to change node IDs here, so clone it first.
      var subgraph = _litegraph.LiteGraph.cloneObject(data.subgraph);

      this.reassignSubgraphUUIDs(subgraph);
      data.subgraph = subgraph;
    }

    delete data["id"];
    delete data["inputs"];
    delete data["outputs"];
    node.configure(data);
    return node;
  };

  _proto.buildFromNodes = function buildFromNodes(nodes) {
    //clear all?
    //TODO
    //nodes that connect data between parent graph and subgraph
    var subgraph_inputs = [];
    var subgraph_outputs = []; //mark inner nodes

    var ids = {};
    var min_x = 0;
    var max_x = 0;

    for (var i = 0; i < nodes.length; ++i) {
      var node = nodes[i];
      ids[node.id] = node;
      min_x = Math.min(node.pos[0], min_x);
      max_x = Math.max(node.pos[0], min_x);
    }

    var last_input_y = 0;
    var last_output_y = 0;

    for (var i = 0; i < nodes.length; ++i) {
      var node = nodes[i]; //check inputs

      if (node.inputs) for (var j = 0; j < node.inputs.length; ++j) {
        var input = node.inputs[j];
        if (!input || !input.link) continue;
        var link = node.graph.links[input.link];
        if (!link) continue;
        if (ids[link.origin_id]) continue; //this.addInput(input.name,link.type);

        this.subgraph.addInput(input.name, link.type);
        /*
        var input_node = LiteGraph.createNode("graph/input");
        this.subgraph.add( input_node );
        input_node.pos = [min_x - 200, last_input_y ];
        last_input_y += 100;
        */
      } //check outputs

      if (node.outputs) for (var j = 0; j < node.outputs.length; ++j) {
        var output = node.outputs[j];
        if (!output || !output.links || !output.links.length) continue;
        var is_external = false;

        for (var k = 0; k < output.links.length; ++k) {
          var link = node.graph.links[output.links[k]];
          if (!link) continue;
          if (ids[link.target_id]) continue;
          is_external = true;
          break;
        }

        if (!is_external) continue; //this.addOutput(output.name,output.type);

        /*
        var output_node = LiteGraph.createNode("graph/output");
        this.subgraph.add( output_node );
        output_node.pos = [max_x + 50, last_output_y ];
        last_output_y += 100;
        */
      }
    } //detect inputs and outputs
    //split every connection in two data_connection nodes
    //keep track of internal connections
    //connect external connections
    //clone nodes inside subgraph and try to reconnect them
    //connect edge subgraph nodes to extarnal connections nodes

  };

  return Subgraph;
}(_litegraph.LGraphNode);

Subgraph.title = '分支蓝图';
Subgraph.input_node_type = "middle/graph/input";
Subgraph.output_node_type = "middle/graph/output";
_litegraph.LiteGraph.Subgraph = Subgraph;

_litegraph.LiteGraph.registerNodeType("middle/graph/subgraph", Subgraph);

var GraphInput = /*#__PURE__*/function (_LGraphNode2) {
  _inheritsLoose(GraphInput, _LGraphNode2);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function GraphInput() {
    var _this2;

    _this2 = _LGraphNode2.call(this) || this;
    _this2.title = "输入";
    _this2.desc = "用于对子蓝图输入参数";

    _this2.addOutput("", "number");

    _this2.name_in_graph = "";
    _this2.properties = {
      name: "",
      type: "number",
      value: 0
    };

    var that = _assertThisInitialized(_this2);

    _this2.name_widget = _this2.addWidget("text", "Name", _this2.properties.name, function (v) {
      if (!v) {
        return;
      }

      that.setProperty("name", v);
    });
    _this2.type_widget = _this2.addWidget("text", "Type", _this2.properties.type, function (v) {
      that.setProperty("type", v);
    });
    _this2.value_widget = _this2.addWidget("number", "Value", _this2.properties.value, function (v) {
      that.setProperty("value", v);
    });
    _this2.widgets_up = true;
    _this2.size = [180, 90];
    return _this2;
  }

  var _proto2 = GraphInput.prototype;

  _proto2.onConfigure = function onConfigure() {
    this.updateType();
  } //ensures the type in the node output and the type in the associated graph input are the same
  ;

  _proto2.updateType = function updateType() {
    var type = this.properties.type;
    this.type_widget.value = type; //update output

    if (this.outputs[0].type != type) {
      if (!_litegraph.LiteGraph.isValidConnection(this.outputs[0].type, type)) this.disconnectOutput(0);
      this.outputs[0].type = type;
    } //update widget


    if (type == "number") {
      this.value_widget.type = "number";
      this.value_widget.value = 0;
    } else if (type == "boolean") {
      this.value_widget.type = "toggle";
      this.value_widget.value = true;
    } else if (type == "string") {
      this.value_widget.type = "text";
      this.value_widget.value = "";
    } else {
      this.value_widget.type = null;
      this.value_widget.value = null;
    }

    this.properties.value = this.value_widget.value; //update graph

    if (this.graph && this.name_in_graph) {
      this.graph.changeInputType(this.name_in_graph, type);
    }
  } //this is executed AFTER the property has changed
  ;

  _proto2.onPropertyChanged = function onPropertyChanged(name, v) {
    if (name == "name") {
      if (v == "" || v == this.name_in_graph || v == "enabled") {
        return false;
      }

      if (this.graph) {
        if (this.name_in_graph) {
          //already added
          this.graph.renameInput(this.name_in_graph, v);
        } else {
          this.graph.addInput(v, this.properties.type);
        }
      } //what if not?!


      this.name_widget.value = v;
      this.name_in_graph = v;
    } else if (name == "type") {
      this.updateType();
    } else if (name == "value") {}
  } //
  ;

  _proto2.getTitle = function getTitle() {
    if (this.flags.collapsed) {
      return this.properties.name;
    }

    return this.title;
  };

  _proto2.onAction = function onAction(action, param) {
    console.log('graph input 收到了action', action, param);

    if (this.properties.type == _litegraph.LiteGraph.EVENT) {
      this.triggerSlot(0, param);
    }
  };

  //不同的子graph中的nodeid会出现相同的情况，cctween绑定了nodeid，会导致不同的子graph出现执行动画干扰的情况
  //需要处理这个问题
  _proto2.onExecute = function onExecute() {
    // console.log('this.graph.inputs', this.graph.inputs)
    var name = this.properties.name; //read from global input

    var data = this.graph.inputs[name];

    if (!data) {
      this.setOutputData(0, this.properties.value);
      return;
    }

    this.setOutputData(0, data.value !== undefined ? data.value : this.properties.value);
  };

  _proto2.onRemoved = function onRemoved() {
    if (this.name_in_graph) {
      this.graph.removeInput(this.name_in_graph);
    }
  };

  return GraphInput;
}(_litegraph.LGraphNode);

GraphInput.title = '输入';
_litegraph.LiteGraph.GraphInput = GraphInput;

_litegraph.LiteGraph.registerNodeType("middle/graph/input", GraphInput); //这是一个输出界面


var GraphOutput = /*#__PURE__*/function (_LGraphNode3) {
  _inheritsLoose(GraphOutput, _LGraphNode3);

  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function GraphOutput() {
    var _this3;

    _this3 = _LGraphNode3.call(this) || this;
    _this3.title = "输出";
    _this3.desc = "用于对子蓝图输出参数";

    _this3.addInput("", "");

    _this3.name_in_graph = "";
    _this3.properties = {
      name: "",
      type: ""
    };
    _this3.name_widget = _this3.addWidget("text", "Name", _this3.properties.name, "name");
    _this3.type_widget = _this3.addWidget("text", "Type", _this3.properties.type, "type");
    _this3.widgets_up = true;
    _this3.size = [180, 60];
    return _this3;
  }

  var _proto3 = GraphOutput.prototype;

  _proto3.onPropertyChanged = function onPropertyChanged(name, v) {
    if (name == "name") {
      if (v == "" || v == this.name_in_graph || v == "enabled") {
        return false;
      }

      if (this.graph) {
        if (this.name_in_graph) {
          //already added
          this.graph.renameOutput(this.name_in_graph, v);
        } else {
          this.graph.addOutput(v, this.properties.type);
        }
      } //what if not?!


      this.name_widget.value = v;
      this.name_in_graph = v;
    } else if (name == "type") {
      this.updateType();
    } else if (name == "value") {}
  };

  _proto3.updateType = function updateType() {
    var type = this.properties.type;
    if (this.type_widget) this.type_widget.value = type; //update output

    if (this.inputs[0].type != type) {
      if (type == "action" || type == "event") type = _litegraph.LiteGraph.EVENT;
      if (!_litegraph.LiteGraph.isValidConnection(this.inputs[0].type, type)) this.disconnectInput(0);
      this.inputs[0].type = type;
    } //update graph


    if (this.graph && this.name_in_graph) {
      this.graph.changeOutputType(this.name_in_graph, type);
    }
  };

  _proto3.onExecute = function onExecute() {
    this._value = this.getInputData(0);
    this.graph.setOutputData(this.properties.name, this._value);
  };

  _proto3.onAction = function onAction(action, param) {
    if (this.properties.type == _litegraph.LiteGraph.ACTION) {
      this.graph.trigger(this.properties.name, param);
    }
  };

  _proto3.onRemoved = function onRemoved() {
    if (this.name_in_graph) {
      this.graph.removeOutput(this.name_in_graph);
    }
  };

  _proto3.getTitle = function getTitle() {
    if (this.flags.collapsed) {
      return this.properties.name;
    }

    return this.title;
  };

  return GraphOutput;
}(_litegraph.LGraphNode);

GraphOutput.title = '输出';
_litegraph.LiteGraph.GraphOutput = GraphOutput;

_litegraph.LiteGraph.registerNodeType("middle/graph/output", GraphOutput);

cc._RF.pop();