"use strict";
cc._RF.push(module, '493eeWdicRJNYQZtEIAhQxP', 'middle');
// Script/Common/LiteGraphCore/nodes/middle.js

"use strict";

var _litegraph = require("../../litegraph/litegraph");

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

//将viewCode中的robot创建映射到litegraph
var AddRobot = /*#__PURE__*/function (_LGraphNode) {
  _inheritsLoose(AddRobot, _LGraphNode);

  // Name to show
  function AddRobot() {
    var _this;

    _this = _LGraphNode.call(this) || this;
    _this.title = "加";

    _this.addInput("A", "number");

    _this.addInput("B", "number");

    _this.addOutput("A + B", "number"); // this.properties.precision = 1


    return _this;
  } // Function to call when the node is executed


  var _proto = AddRobot.prototype;

  _proto.onExecute = function onExecute() {
    var A = this.getInputData(0);
    if (A === undefined) A = 0;
    var B = this.getInputData(1);
    if (B === undefined) B = 0;
    this.setOutputData(0, A + B); // console.log('AddRobot onExecute', A + B)
  };

  return AddRobot;
}(_litegraph.LGraphNode);

AddRobot.title = '加'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/calculate/add", AddRobot);

var delRobot = /*#__PURE__*/function (_LGraphNode2) {
  _inheritsLoose(delRobot, _LGraphNode2);

  // Name to show
  function delRobot() {
    var _this2;

    _this2 = _LGraphNode2.call(this) || this;
    _this2.title = "减";

    _this2.addInput("A", "number");

    _this2.addInput("B", "number");

    _this2.addOutput("A - B", "number"); // this.properties.precision = 1


    return _this2;
  } // Function to call when the node is executed


  var _proto2 = delRobot.prototype;

  _proto2.onExecute = function onExecute() {
    var A = this.getInputData(0);
    if (A === undefined) A = 0;
    var B = this.getInputData(1);
    if (B === undefined) B = 0;
    this.setOutputData(0, A - B); // console.log('AddRobot onExecute', A - B)
  };

  return delRobot;
}(_litegraph.LGraphNode);

delRobot.title = '减'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/calculate/del", delRobot);

var xRobot = /*#__PURE__*/function (_LGraphNode3) {
  _inheritsLoose(xRobot, _LGraphNode3);

  // Name to show
  function xRobot() {
    var _this3;

    _this3 = _LGraphNode3.call(this) || this;
    _this3.title = "乘";

    _this3.addInput("A", "number");

    _this3.addInput("B", "number");

    _this3.addOutput("A x B", "number"); // this.properties.precision = 1


    return _this3;
  } // Function to call when the node is executed


  var _proto3 = xRobot.prototype;

  _proto3.onExecute = function onExecute() {
    var A = this.getInputData(0);
    if (A === undefined) A = 0;
    var B = this.getInputData(1);
    if (B === undefined) B = 0;
    this.setOutputData(0, A * B); // console.log('xRobot onExecute', A * B)
  };

  return xRobot;
}(_litegraph.LGraphNode);

xRobot.title = '乘'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/calculate/x", xRobot);

var chuRobot = /*#__PURE__*/function (_LGraphNode4) {
  _inheritsLoose(chuRobot, _LGraphNode4);

  // Name to show
  function chuRobot() {
    var _this4;

    _this4 = _LGraphNode4.call(this) || this;
    _this4.title = "除";

    _this4.addInput("A", "number");

    _this4.addInput("B", "number");

    _this4.addOutput("A ÷ B", "number"); // this.properties.precision = 1


    return _this4;
  } // Function to call when the node is executed


  var _proto4 = chuRobot.prototype;

  _proto4.onExecute = function onExecute() {
    var A = this.getInputData(0);
    if (A === undefined) A = 0;
    var B = this.getInputData(1);
    if (B === undefined) B = 0;
    this.setOutputData(0, A / B); // console.log('chuRobot onExecute', A / B)
  };

  return chuRobot;
}(_litegraph.LGraphNode);

chuRobot.title = '除'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/calculate/chu", chuRobot);

var lengthRobot = /*#__PURE__*/function (_LGraphNode5) {
  _inheritsLoose(lengthRobot, _LGraphNode5);

  // Name to show
  function lengthRobot() {
    var _this5;

    _this5 = _LGraphNode5.call(this) || this;
    _this5.title = "向量长度";

    _this5.addInput("x", "number");

    _this5.addInput("y", "number");

    _this5.addOutput("长度", "number"); // this.properties.precision = 1


    return _this5;
  } // Function to call when the node is executed


  var _proto5 = lengthRobot.prototype;

  _proto5.onExecute = function onExecute() {
    var A = this.getInputData(0);
    if (A === undefined) A = 0;
    var B = this.getInputData(1);
    if (B === undefined) B = 0;
    var result = Math.sqrt(A * A + B * B);
    this.setOutputData(0, result); // console.log('lengthRobot onExecute', result)
  };

  return lengthRobot;
}(_litegraph.LGraphNode);

lengthRobot.title = '长度'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/calculate/length", lengthRobot); ///covert 系列的方法
// 没有任何地方用到，暂时关闭
// class mappingRobot extends LGraphNode {
//     // Name to show
//     title = "映射"
//     constructor() {
//       super()
//       this.addInput("目标数值", "number")
//       this.addInput("范围左", "number")
//       this.addInput("范围右", "number")
//       this.addOutput("结果", "number")
//       // this.properties.precision = 1
//     }
//     // Function to call when the node is executed
//     onExecute() {
//       var A = this.getInputData(0)
//       if (A === undefined) A = 0
//       var B = this.getInputData(1)
//       if (B === undefined) B = 0
//       var C = this.getInputData(2)
//       if (C === undefined) C = 0
//       var result = C - (A) % (C - B)
//       this.setOutputData(0, result)
//       // console.log('mappingRobot onExecute', result)
//     }
// }
// mappingRobot.title = '映射'
// // Register the node type
// LiteGraph.registerNodeType("middle/covert/mapping", mappingRobot)


var tointRobot = /*#__PURE__*/function (_LGraphNode6) {
  _inheritsLoose(tointRobot, _LGraphNode6);

  // Name to show
  function tointRobot() {
    var _this6;

    _this6 = _LGraphNode6.call(this) || this;
    _this6.title = "取整数";

    _this6.addInput("向下取整", "number");

    _this6.addInput("向上取整", "number");

    _this6.addInput("四舍五入", "number");

    _this6.addOutput("输出", "number"); // this.properties.precision = 1


    return _this6;
  } // Function to call when the node is executed


  var _proto6 = tointRobot.prototype;

  _proto6.onExecute = function onExecute() {
    var A = this.getInputData(0);
    var B = this.getInputData(1);
    var C = this.getInputData(2);

    if (A !== undefined) {
      this.setOutputData(0, Math.floor(A));
    } else if (B !== undefined) {
      this.setOutputData(0, Math.ceil(B));
    } else if (C !== undefined) {
      this.setOutputData(0, Math.round(C));
    } // console.log('tointRobot onExecute', A, B, C)

  };

  return tointRobot;
}(_litegraph.LGraphNode);

tointRobot.title = '取整数'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/covert/toint", tointRobot);

var squareRootRobot = /*#__PURE__*/function (_LGraphNode7) {
  _inheritsLoose(squareRootRobot, _LGraphNode7);

  // Name to show
  function squareRootRobot() {
    var _this7;

    _this7 = _LGraphNode7.call(this) || this;
    _this7.title = "平方根";

    _this7.addInput("输入", "number");

    _this7.addOutput("开平方", "number"); // this.properties.precision = 1


    return _this7;
  } // Function to call when the node is executed


  var _proto7 = squareRootRobot.prototype;

  _proto7.onExecute = function onExecute() {
    var A = this.getInputData(0);

    if (A !== undefined) {
      this.setOutputData(0, Math.sqrt(A)); // console.log('squareRootRobot onExecute', Math.sqrt(A))
    }
  };

  return squareRootRobot;
}(_litegraph.LGraphNode);

squareRootRobot.title = '平方根'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/covert/squareRoot", squareRootRobot);

var absRobot = /*#__PURE__*/function (_LGraphNode8) {
  _inheritsLoose(absRobot, _LGraphNode8);

  // Name to show
  function absRobot() {
    var _this8;

    _this8 = _LGraphNode8.call(this) || this;
    _this8.title = "绝对值";

    _this8.addInput("输入", "number");

    _this8.addOutput("绝对值", "number"); // this.properties.precision = 1


    return _this8;
  } // Function to call when the node is executed


  var _proto8 = absRobot.prototype;

  _proto8.onExecute = function onExecute() {
    var A = this.getInputData(0);

    if (A !== undefined) {
      this.setOutputData(0, Math.abs(A)); // console.log('absRobot onExecute', Math.abs(A))
    }
  };

  return absRobot;
}(_litegraph.LGraphNode);

absRobot.title = '绝对值'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/covert/abs", absRobot);

var revertNegativeRobot = /*#__PURE__*/function (_LGraphNode9) {
  _inheritsLoose(revertNegativeRobot, _LGraphNode9);

  // Name to show
  function revertNegativeRobot() {
    var _this9;

    _this9 = _LGraphNode9.call(this) || this;
    _this9.title = "正负反转";

    _this9.addInput("输入", "number");

    _this9.addOutput("输出", "number"); // this.properties.precision = 1


    return _this9;
  } // Function to call when the node is executed


  var _proto9 = revertNegativeRobot.prototype;

  _proto9.onExecute = function onExecute() {
    var A = this.getInputData(0);

    if (A !== undefined) {
      this.setOutputData(0, A * -1); // console.log('revertNegativeRobot onExecute', A * -1)
    }
  };

  return revertNegativeRobot;
}(_litegraph.LGraphNode);

revertNegativeRobot.title = '正负反转'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/covert/revertNegative", revertNegativeRobot); ///angleCalculate


var angleDifferenceRobot = /*#__PURE__*/function (_LGraphNode10) {
  _inheritsLoose(angleDifferenceRobot, _LGraphNode10);

  // Name to show
  function angleDifferenceRobot() {
    var _this10;

    _this10 = _LGraphNode10.call(this) || this;
    _this10.title = "角度差";

    _this10.addInput("角度A", "number");

    _this10.addInput("角度B", "number");

    _this10.addOutput("输出", "number");

    _this10.addProperty("inputType", '角度', 'enum', {
      values: ['角度', '向量']
    }); //增加一个变量，    变量名称， 变量名称
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置


    _this10.addWidget("combo", "输入的类型", _this10.properties.inputType, {
      property: "inputType",
      values: ['角度', '向量']
    }); // this.properties.precision = 1


    return _this10;
  } // Function to call when the node is executed


  var _proto10 = angleDifferenceRobot.prototype;

  _proto10.onExecute = function onExecute() {
    var number1 = this.getInputData(0);
    var number2 = this.getInputData(1);

    if (number1 !== undefined && number2 !== undefined) {
      var result = 0;

      if (this.properties.inputType == 0 || this.properties.inputType == '角度') {
        var number = Math.max(number1, number2) - Math.min(number1, number2);
        result = Math.min(360 - number, number);
      } else {
        //输入向量求夹角
        var x1 = number1.x;
        var y1 = number1.y;
        var x2 = number2.x;
        var y2 = number2.y; // 与v1起始向量方向相反
        // const _v1 = {x: -x1, y: -y1}

        var cosRadian = (Math.pow(x1, 2) + Math.pow(y1, 2) + Math.pow(x2, 2) + Math.pow(y2, 2) - (Math.pow(x2 - x1, 2) + Math.pow(y2 - y1, 2))) / (2 * Math.sqrt(Math.pow(x1, 2) + Math.pow(y1, 2)) * Math.sqrt(Math.pow(x2, 2) + Math.pow(y2, 2)));
        result = Math.acos(cosRadian) * (180 / Math.PI);
      }

      this.setOutputData(0, result); // console.log('angleDifferenceRobot onExecute', result)
    }
  };

  return angleDifferenceRobot;
}(_litegraph.LGraphNode);

angleDifferenceRobot.title = '角度差'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/angleCalculate/angleDifference", angleDifferenceRobot);

var vectorToAngelRobot = /*#__PURE__*/function (_LGraphNode11) {
  _inheritsLoose(vectorToAngelRobot, _LGraphNode11);

  // Name to show
  function vectorToAngelRobot() {
    var _this11;

    _this11 = _LGraphNode11.call(this) || this;
    _this11.title = "将位置转换为角度";

    _this11.addInput("x坐标", "number");

    _this11.addInput("y坐标", "number");

    _this11.addOutput("角度", "number"); //   this.addProperty("inputType", '角度', 'enum', {values: ['角度', '向量']});   //增加一个变量，    变量名称， 变量名称
    // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    //   this.addWidget("combo","输入的类型",this.properties.inputType,{ property: "inputType", values:['角度', '向量'] } );
    // this.properties.precision = 1


    return _this11;
  } // Function to call when the node is executed


  var _proto11 = vectorToAngelRobot.prototype;

  _proto11.onExecute = function onExecute() {
    var number1 = this.getInputData(0);
    var number2 = this.getInputData(1);

    if (number1 !== undefined && number2 !== undefined) {
      var result = Math.atan2(this.number2, this.number1) * (180 / Math.PI);
      this.setOutputData(0, result); // console.log('vectorToAngelRobot onExecute', result)
    }
  };

  return vectorToAngelRobot;
}(_litegraph.LGraphNode);

vectorToAngelRobot.title = '将位置转换为角度'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/angleCalculate/vectorToAngel", vectorToAngelRobot);

var angleConvertVectorRobot = /*#__PURE__*/function (_LGraphNode12) {
  _inheritsLoose(angleConvertVectorRobot, _LGraphNode12);

  // Name to show
  function angleConvertVectorRobot() {
    var _this12;

    _this12 = _LGraphNode12.call(this) || this;
    _this12.title = "将角度转换为位置";

    _this12.addInput("角度", "number");

    _this12.addInput("斜边长", "number");

    _this12.addOutput("x长", "number");

    _this12.addOutput("y长", "number"); //   this.addProperty("inputType", '角度', 'enum', {values: ['角度', '向量']});   //增加一个变量，    变量名称， 变量名称
    // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    //   this.addWidget("combo","输入的类型",this.properties.inputType,{ property: "inputType", values:['角度', '向量'] } );
    // this.properties.precision = 1


    return _this12;
  } // Function to call when the node is executed


  var _proto12 = angleConvertVectorRobot.prototype;

  _proto12.onExecute = function onExecute() {
    var number1 = this.getInputData(0);
    var number2 = this.getInputData(1);

    if (number1 !== undefined && number2 !== undefined) {
      var angle = 180 / Math.PI * number1;
      var x = Math.cos(angle) * number2;
      var y = Math.sin(angle) * number2;
      this.setOutputData(0, x);
      this.setOutputData(1, y); // console.log('angleConvertVectorRobot onExecute', x, y)
    }
  };

  return angleConvertVectorRobot;
}(_litegraph.LGraphNode);

angleConvertVectorRobot.title = '将角度转换为位置'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/angleCalculate/angleConvertVector", angleConvertVectorRobot); ///compare


var equireRobot = /*#__PURE__*/function (_LGraphNode13) {
  _inheritsLoose(equireRobot, _LGraphNode13);

  // Name to show
  function equireRobot() {
    var _this13;

    _this13 = _LGraphNode13.call(this) || this;
    _this13.title = "等于";

    _this13.addInput("A", "number");

    _this13.addInput("B", "number");

    _this13.addOutput("A == B?", "number"); //   this.addProperty("inputType", '角度', 'enum', {values: ['角度', '向量']});   //增加一个变量，    变量名称， 变量名称
    // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    //   this.addWidget("combo","输入的类型",this.properties.inputType,{ property: "inputType", values:['角度', '向量'] } );
    // this.properties.precision = 1


    return _this13;
  } // Function to call when the node is executed


  var _proto13 = equireRobot.prototype;

  _proto13.onExecute = function onExecute() {
    var number1 = this.getInputData(0);
    var number2 = this.getInputData(1);
    var result = 0;

    if (number1 == number2) {
      result = 1;
    }

    this.setOutputData(0, result); // console.log('equireRobot onExecute', result)
  };

  return equireRobot;
}(_litegraph.LGraphNode);

equireRobot.title = '等于'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/compare/equire", equireRobot);

var litterRobot = /*#__PURE__*/function (_LGraphNode14) {
  _inheritsLoose(litterRobot, _LGraphNode14);

  // Name to show
  function litterRobot() {
    var _this14;

    _this14 = _LGraphNode14.call(this) || this;
    _this14.title = "小于";

    _this14.addInput("A", "number");

    _this14.addInput("B", "number");

    _this14.addOutput("A < B?", "number"); //   this.addProperty("inputType", '角度', 'enum', {values: ['角度', '向量']});   //增加一个变量，    变量名称， 变量名称
    // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    //   this.addWidget("combo","输入的类型",this.properties.inputType,{ property: "inputType", values:['角度', '向量'] } );
    // this.properties.precision = 1


    return _this14;
  } // Function to call when the node is executed


  var _proto14 = litterRobot.prototype;

  _proto14.onExecute = function onExecute() {
    var number1 = this.getInputData(0);
    var number2 = this.getInputData(1);
    var result = 0;

    if (number1 < number2) {
      result = 1;
    }

    this.setOutputData(0, result); // console.log('litterRobot onExecute', result)
  };

  return litterRobot;
}(_litegraph.LGraphNode);

litterRobot.title = '小于'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/compare/litter", litterRobot);

var biggerRobot = /*#__PURE__*/function (_LGraphNode15) {
  _inheritsLoose(biggerRobot, _LGraphNode15);

  // Name to show
  function biggerRobot() {
    var _this15;

    _this15 = _LGraphNode15.call(this) || this;
    _this15.title = "大于";

    _this15.addInput("A", "number");

    _this15.addInput("B", "number");

    _this15.addOutput("A > B?", "number"); //   this.addProperty("inputType", '角度', 'enum', {values: ['角度', '向量']});   //增加一个变量，    变量名称， 变量名称
    // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    //   this.addWidget("combo","输入的类型",this.properties.inputType,{ property: "inputType", values:['角度', '向量'] } );
    // this.properties.precision = 1


    return _this15;
  } // Function to call when the node is executed


  var _proto15 = biggerRobot.prototype;

  _proto15.onExecute = function onExecute() {
    var number1 = this.getInputData(0);
    var number2 = this.getInputData(1);
    var result = 0;

    if (number1 > number2) {
      result = 1;
    }

    this.setOutputData(0, result); // console.log('biggerRobot onExecute', result)
  };

  return biggerRobot;
}(_litegraph.LGraphNode);

biggerRobot.title = '大于'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/compare/bigger", biggerRobot);

var inRangeRobot = /*#__PURE__*/function (_LGraphNode16) {
  _inheritsLoose(inRangeRobot, _LGraphNode16);

  // Name to show
  function inRangeRobot() {
    var _this16;

    _this16 = _LGraphNode16.call(this) || this;
    _this16.title = "范围内";

    _this16.addInput("A", "number");

    _this16.addInput("B", "number");

    _this16.addInput("C", "number");

    _this16.addOutput("结果", "number");

    _this16.addProperty("A", 0, 'number'); //增加一个变量，    变量名称， 变量名称


    _this16.addProperty("C", 10, 'number'); //增加一个变量，    变量名称， 变量名称


    _this16.addProperty("firstCompire", '<', 'enum', {
      values: ['<', '<=']
    }); //增加一个变量，    变量名称， 变量名称


    _this16.addProperty("secCompire", '<', 'enum', {
      values: ['<', '<=']
    });

    _this16.addWidget("number", '最小值A', 0, 'A', {
      precision: 0
    }); // this.addWidget("number", '比较值', 5, 'B')


    _this16.addWidget("number", '最大值C', 10, 'C', {
      precision: 0
    }); //   this.addProperty("inputType", '角度', 'enum', {values: ['角度', '向量']});   //增加一个变量，    变量名称， 变量名称
    // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置


    _this16.addWidget("combo", "A和B比较", _this16.properties.firstCompire, {
      property: "firstCompire",
      values: inRangeRobot.compireType
    });

    _this16.addWidget("combo", "B和C比较", _this16.properties.secCompire, {
      property: "secCompire",
      values: inRangeRobot.compireType
    }); // this.serialize_widgets = true;
    // this.properties.precision = 1


    return _this16;
  }

  var _proto16 = inRangeRobot.prototype;

  _proto16.getTitle = function getTitle() {
    var firstCompire = this.properties['firstCompire'];
    var secCompire = this.properties['secCompire'];
    return 'A' + firstCompire + 'B' + secCompire + 'C';
  } // Function to call when the node is executed
  ;

  _proto16.onExecute = function onExecute() {
    var number1 = this.getInputOrProperty('A');
    var number2 = this.getInputData(1);
    var number3 = this.getInputOrProperty('C');
    var result = 0;
    var firstCompire = this.properties['firstCompire'];
    var secCompire = this.properties['secCompire'];

    if (firstCompire == '<') {
      result = number1 < number2;
    }

    if (firstCompire == '<=') {
      result = number1 <= number2;
    }

    if (secCompire == '<') {
      result = number2 < number3;
    }

    if (secCompire == '<=') {
      result = number2 <= number3;
    }

    if (result == true) {
      result = 1;
    }

    this.setOutputData(0, result); // console.log('inRangeRobot onExecute', result)
  };

  return inRangeRobot;
}(_litegraph.LGraphNode);

inRangeRobot.title = '范围内';
inRangeRobot.compireType = ['<', '<=']; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/compare/inRange", inRangeRobot); //和上面的功能重复，暂时屏蔽
// class inRangeEquireRobot extends LGraphNode {
//     // Name to show
//     title = "闭区间范围内"
//     constructor() {
//       super()
//       this.addInput("A", "number")
//       this.addInput("B", "number")
//       this.addInput("C", "number")
//       this.addOutput("A <= B <= C?", "number")
//       this.addProperty("A和B对比", '<', 'enum', {values: ['<', '<=']});   //增加一个变量，    变量名称， 变量名称
//       this.addProperty("B和C对比", '<', 'enum', {values: ['<', '<=']});   //增加一个变量，    变量名称， 变量名称
//     //   this.addProperty("inputType", '角度', 'enum', {values: ['角度', '向量']});   //增加一个变量，    变量名称， 变量名称
//     // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
// 		//   this.addWidget("combo","输入的类型",this.properties.inputType,{ property: "inputType", values:['角度', '向量'] } );
//       // this.properties.precision = 1
//     }
//     // Function to call when the node is executed
//     onExecute() {
//       var number1 = this.getInputData(0)
//       var number2 = this.getInputData(1)
//       var number3 = this.getInputData(2)
//       var result = 0
//       if(number2 >= number1 && number2 <= number3){
//         result = 1
//       }
//       this.setOutputData(0, result)
//       // console.log('inRangeEquireRobot onExecute', result)
//     }
// }
// inRangeEquireRobot.title = '闭区间范围内'
// // Register the node type
// LiteGraph.registerNodeType("middle/compare/inRangeEquire", inRangeEquireRobot)
//logic


var allRightRobot = /*#__PURE__*/function (_LGraphNode17) {
  _inheritsLoose(allRightRobot, _LGraphNode17);

  // Name to show
  function allRightRobot() {
    var _this17;

    _this17 = _LGraphNode17.call(this) || this;
    _this17.title = "全部正确";

    _this17.addInput("A", "number");

    _this17.addInput("B", "number");

    _this17.addOutput("结果", "number"); //   this.addProperty("inputType", '角度', 'enum', {values: ['角度', '向量']});   //增加一个变量，    变量名称， 变量名称
    // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    //   this.addWidget("combo","输入的类型",this.properties.inputType,{ property: "inputType", values:['角度', '向量'] } );
    // this.properties.precision = 1


    return _this17;
  } // Function to call when the node is executed


  var _proto17 = allRightRobot.prototype;

  _proto17.onExecute = function onExecute() {
    var number1 = this.getInputData(0);
    var number2 = this.getInputData(1);
    var result = 0;

    if (number1 == 0 || number1 === undefined) {
      result = 0;
    }

    if (number2 == 0 || number2 === undefined) {
      result = 0;
    }

    this.setOutputData(0, result); // console.log('allRightRobot onExecute', result)
  };

  return allRightRobot;
}(_litegraph.LGraphNode);

allRightRobot.title = '全部正确'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/logic/allRight", allRightRobot);

var orRightRobot = /*#__PURE__*/function (_LGraphNode18) {
  _inheritsLoose(orRightRobot, _LGraphNode18);

  // Name to show
  function orRightRobot() {
    var _this18;

    _this18 = _LGraphNode18.call(this) || this;
    _this18.title = "任意一个正确";

    _this18.addInput("A", "number");

    _this18.addInput("B", "number");

    _this18.addInput("C", "number");

    _this18.addOutput("结果", "number"); //   this.addProperty("inputType", '角度', 'enum', {values: ['角度', '向量']});   //增加一个变量，    变量名称， 变量名称
    // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    //   this.addWidget("combo","输入的类型",this.properties.inputType,{ property: "inputType", values:['角度', '向量'] } );
    // this.properties.precision = 1


    return _this18;
  } // Function to call when the node is executed


  var _proto18 = orRightRobot.prototype;

  _proto18.onExecute = function onExecute() {
    var number1 = this.getInputData(0);
    var number2 = this.getInputData(1);
    var number3 = this.getInputData(2);
    var result = 0;

    if (number1 !== undefined) {
      if (number1 != 0) {
        result = 1;
      }
    }

    if (number2 !== undefined) {
      if (number2 != 0) {
        result = 1;
      }
    }

    if (number3 !== undefined) {
      if (number3 != 0) {
        result = 1;
      }
    }

    this.setOutputData(0, result); // console.log('orRightRobot onExecute', result)
  };

  return orRightRobot;
}(_litegraph.LGraphNode);

orRightRobot.title = '任意一个正确'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/logic/orRight", orRightRobot);

var allToggle = /*#__PURE__*/function (_LGraphNode19) {
  _inheritsLoose(allToggle, _LGraphNode19);

  // Name to show
  function allToggle() {
    var _this19;

    _this19 = _LGraphNode19.call(this) || this;
    _this19.title = "全部触发";
    _this19.mode = _litegraph.LiteGraph.ON_EVENT;

    _this19.addInput("触发_0", _litegraph.LiteGraph.ACTION);

    _this19.addInput("触发_1", _litegraph.LiteGraph.ACTION);

    _this19.addOutput("触发", _litegraph.LiteGraph.EVENT);

    _this19.addProperty('resetWhenToggle', false, 'boolean');

    _this19.addWidget('toggle', '触发后重置', _this19.properties.resetWhenToggle, 'resetWhenToggle'); // this.addProperty("inputType", '角度', 'enum', {values: ['角度', '向量']});   //增加一个变量，    变量名称， 变量名称
    // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    //   this.addWidget("combo","输入的类型",this.properties.inputType,{ property: "inputType", values:['角度', '向量'] } );
    // this.properties.precision = 1


    _this19.toggleFlag = {};
    return _this19;
  }

  var _proto19 = allToggle.prototype;

  _proto19.onStop = function onStop() {
    this.toggleFlag = {};
  };

  _proto19.onGetInputs = function onGetInputs() {
    return [["触发_" + this.inputs.length, _litegraph.LiteGraph.ACTION]];
  };

  _proto19.onAction = function onAction(action, param, options) {
    // console.log('allToggle', action, param, options)
    this.toggleFlag[action] = 1;

    if (Object.keys(this.toggleFlag).length == this.inputs.length) {
      this.triggerSlot(0);

      if (this.properties.resetWhenToggle == true) {
        this.toggleFlag = {};
      }
    }
  } // Function to call when the node is executed
  // onExecute() {
  //   var number1 = this.getInputData(0)
  //   var number2 = this.getInputData(1)
  //   var result = 0
  //   if(number1 == 0 || number1 === undefined){
  //       result = 0
  //   }
  //   if(number2 == 0 || number2 === undefined){
  //       result = 0
  //   }
  //   this.setOutputData(0, result)
  //   // console.log('allToggle onExecute', result)
  // }
  ;

  return allToggle;
}(_litegraph.LGraphNode);

allToggle.title = '全部触发'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/logic/allToggle", allToggle);

var orToggle = /*#__PURE__*/function (_LGraphNode20) {
  _inheritsLoose(orToggle, _LGraphNode20);

  // Name to show
  function orToggle() {
    var _this20;

    _this20 = _LGraphNode20.call(this) || this;
    _this20.title = "任意触发";
    _this20.mode = _litegraph.LiteGraph.ON_EVENT;

    _this20.addInput("触发_0", _litegraph.LiteGraph.ACTION);

    _this20.addInput("触发_1", _litegraph.LiteGraph.ACTION);

    _this20.addOutput("触发", _litegraph.LiteGraph.EVENT); //   this.addProperty("inputType", '角度', 'enum', {values: ['角度', '向量']});   //增加一个变量，    变量名称， 变量名称
    // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    //   this.addWidget("combo","输入的类型",this.properties.inputType,{ property: "inputType", values:['角度', '向量'] } );
    // this.properties.precision = 1
    // this.findInputSlotFree({typesNotAccepted: []})
    // this.findInputByType(LiteGraph.ACTION)
    // this.getInputNode()
    // this.getInputNode()
    // this.findSlotByType(true, LiteGraph.ACTION, false, true, true)
    // let oldLink = this.getInputLink(0)
    // oldLink.origin_slot


    return _this20;
  }

  var _proto20 = orToggle.prototype;

  _proto20.getFreeSoltIndex = function getFreeSoltIndex() {
    var soltIndex = this.findSlotByType(true, _litegraph.LiteGraph.ACTION, false, true, true);

    if (soltIndex == -1) {
      this.addInput('触发_' + this.inputs.length, _litegraph.LiteGraph.ACTION);
      soltIndex = this.inputs.length - 1;
    }

    return soltIndex;
  } //检查一个节点是否已经连接我的node了
  ;

  _proto20.checkHasConnectMyInput = function checkHasConnectMyInput(node) {
    var hasConnect = false;

    for (var i = 0; i < this.inputs.length; i++) {
      var connectNode = this.getInputNode(i);

      if (connectNode != null) {
        if (connectNode.id == node.id) {
          hasConnect = true;
          break;
        }
      }
    }

    return hasConnect;
  };

  _proto20.findConnectSoltIndex = function findConnectSoltIndex(nodeId) {
    var index = -1;

    for (var i = 0; i < this.inputs.length; i++) {
      var connectNode = this.getInputNode(i);

      if (connectNode != null) {
        if (connectNode.id == nodeId) {
          index = i;
          break;
        }
      }
    }

    return index;
  } // onConnectInput(inputIndex, outPutType, output, linkedNode, outputIndex){
  //     // console.log('onConnectInput', inputIndex, outPutType, output, linkedNode, outputIndex)
  // }
  ;

  _proto20.onGetInputs = function onGetInputs() {
    return [["触发_" + this.inputs.length, _litegraph.LiteGraph.ACTION]];
  };

  _proto20.onAction = function onAction(action, param, options) {
    // console.log('allToggle', action, param, options)
    this.triggerSlot(0);
  };

  return orToggle;
}(_litegraph.LGraphNode);

orToggle.title = '任意触发'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/logic/orToggle", orToggle);

var notRightRobot = /*#__PURE__*/function (_LGraphNode21) {
  _inheritsLoose(notRightRobot, _LGraphNode21);

  // Name to show
  function notRightRobot() {
    var _this21;

    _this21 = _LGraphNode21.call(this) || this;
    _this21.title = "反转结果";

    _this21.addInput("A", "number");

    _this21.addOutput("结果", "number"); //   this.addProperty("inputType", '角度', 'enum', {values: ['角度', '向量']});   //增加一个变量，    变量名称， 变量名称
    // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    //   this.addWidget("combo","输入的类型",this.properties.inputType,{ property: "inputType", values:['角度', '向量'] } );
    // this.properties.precision = 1


    return _this21;
  } // Function to call when the node is executed


  var _proto21 = notRightRobot.prototype;

  _proto21.onExecute = function onExecute() {
    var number1 = this.getInputData(0);
    var result = !number1 ? 1 : 0;
    this.setOutputData(0, result); // console.log('notRightRobot onExecute', result)
  };

  return notRightRobot;
}(_litegraph.LGraphNode);

notRightRobot.title = '反转结果'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/logic/notRight", notRightRobot); // change randomNum


var randomNumRobot = /*#__PURE__*/function (_LGraphNode22) {
  _inheritsLoose(randomNumRobot, _LGraphNode22);

  // Name to show
  function randomNumRobot() {
    var _this22;

    _this22 = _LGraphNode22.call(this) || this;
    _this22.title = "随机整数";
    _this22.des = '如果没有输入值，返回一个大于0的随机整数';

    _this22.addInput("随机范围", "number");

    _this22.addOutput("结果", "number");

    _this22.addProperty("modal", '每次随机', 'enum', {
      values: ['仅一次', '每次随机']
    }); //增加一个变量，    变量名称， 变量名称
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置


    _this22.addWidget("combo", "", _this22.properties.modal, {
      property: "modal",
      values: ['仅一次', '每次随机']
    }); // this.serialize_widgets = true;
    //   this.addProperty("inputType", '角度', 'enum', {values: ['角度', '向量']});   //增加一个变量，    变量名称， 变量名称
    // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    //   this.addWidget("combo","输入的类型",this.properties.inputType,{ property: "inputType", values:['角度', '向量'] } );
    // this.properties.precision = 1


    return _this22;
  } // Function to call when the node is executed


  var _proto22 = randomNumRobot.prototype;

  _proto22.onExecute = function onExecute() {
    var number1 = this.getInputData(0);

    if (number1 === undefined) {
      number1 = 10000000;
    }

    if (this.properties.modal == '每次随机') {
      var random = Math.floor(Math.random() * number1); // [0,输入值-1]

      this.setOutputData(0, random);
    } else {
      if (this.random == null) {
        this.random = Math.floor(Math.random() * number1);
        this.setOutputData(0, this.random);
      }
    } // console.log('randomNumRobot onExecute', random)

  };

  return randomNumRobot;
}(_litegraph.LGraphNode);

randomNumRobot.title = '随机整数'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/change/randomNum", randomNumRobot);

var timeDownRobot = /*#__PURE__*/function (_LGraphNode23) {
  _inheritsLoose(timeDownRobot, _LGraphNode23);

  // Name to show
  function timeDownRobot() {
    var _this23;

    _this23 = _LGraphNode23.call(this) || this;
    _this23.title = "延迟触发";
    _this23.desc = "等待时间如果为0的话表示等待1帧。输入的值不为0时即执行倒计时，输入值为0时停止倒计时，输出的值为当前输出帧和上一帧的时间差";

    _this23.addProperty("time_in_s", 1);

    _this23.widget = _this23.addWidget("number", "秒", 1, "time_in_s", {
      precision: 2,
      min: 0,
      step: 0.1
    }); // this.serialize_widgets = true;

    _this23.addInput("开始", _litegraph.LiteGraph.ACTION);

    _this23.addOutput("结束时", _litegraph.LiteGraph.EVENT);

    _this23._pending = []; //   this.addProperty("inputType", '角度', 'enum', {values: ['角度', '向量']});   //增加一个变量，    变量名称， 变量名称
    // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    //   this.addWidget("combo","输入的类型",this.properties.inputType,{ property: "inputType", values:['角度', '向量'] } );
    // this.properties.precision = 1

    return _this23;
  } // Function to call when the node is executed


  var _proto23 = timeDownRobot.prototype;

  _proto23.onAction = function onAction(action, param, options) {
    var time = this.properties.time_in_s;

    if (time <= 0) {
      // this.trigger(null, param, options);
      this.triggerSlot(0);
    } else {
      this._pending.push([time, param]);
    }
  };

  _proto23.onExecute = function onExecute() {
    var dt = this.graph.elapsed_time; //in ms

    if (this.isInputConnected(1)) {
      this.properties.time_in_s = this.getInputData(1);
    }

    for (var i = 0; i < this._pending.length; ++i) {
      var actionPass = this._pending[i];
      actionPass[0] -= dt;

      if (actionPass[0] > 0) {
        continue;
      } //remove


      this._pending.splice(i, 1);

      --i; //trigger
      // this.trigger(null, actionPass[1], options);

      this.triggerSlot(0);
    }
  };

  _proto23.onGetInputs = function onGetInputs() {
    return [["time_in_s", "number"]];
  };

  _proto23.onStop = function onStop() {
    //清空等待延迟触发的列队
    this._pending = [];
  };

  return timeDownRobot;
}(_litegraph.LGraphNode);

timeDownRobot.title = '延迟触发'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/change/timeDown", timeDownRobot);

var timerRobot = /*#__PURE__*/function (_LGraphNode24) {
  _inheritsLoose(timerRobot, _LGraphNode24);

  // Name to show
  function timerRobot() {
    var _this24;

    _this24 = _LGraphNode24.call(this) || this;
    _this24.title = "间隔触发";
    _this24.desc = "等待时间如果为0的话表示等待1帧。输入的值不为0时即执行倒计时，输入值为0时停止倒计时，输出的值为当前输出帧和上一帧的时间差";

    _this24.addProperty("interval", 1000);

    _this24.addProperty("event", "tick");

    _this24.widget = _this24.addWidget("number", "毫秒", 1000, "interval", {
      precision: 0
    }); // this.serialize_widgets = true;

    _this24.addOutput("触发", _litegraph.LiteGraph.EVENT);

    _this24.time = 0;
    _this24.last_interval = 1000;
    _this24.triggered = false; //   this.addProperty("inputType", '角度', 'enum', {values: ['角度', '向量']});   //增加一个变量，    变量名称， 变量名称
    // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    //   this.addWidget("combo","输入的类型",this.properties.inputType,{ property: "inputType", values:['角度', '向量'] } );
    // this.properties.precision = 1

    return _this24;
  }

  var _proto24 = timerRobot.prototype;

  _proto24.getTitle = function getTitle() {
    if (this.graph.state == _litegraph.LGraph.STATUS_RUNNING) {
      return "每隔" + this.last_interval.toString() + "ms";
    } else {
      return timerRobot.title;
    }
  };

  //node也是有开始事件的
  _proto24.onStart = function onStart() {
    this.time = 0;
  };

  // Function to call when the node is executed
  _proto24.onAction = function onAction(action, param, options) {
    var time = this.properties.interval;

    if (time <= 0) {
      this.trigger(null, param, options);
    } else {
      this._pending.push([time, param]);
    }
  };

  _proto24.onExecute = function onExecute() {
    var dt = this.graph.elapsed_time * 1000; //in ms

    var trigger = this.time == 0;
    this.time += dt;
    this.last_interval = Math.max(1, this.getInputOrProperty("interval") | 0);

    if (!trigger && (this.time < this.last_interval || isNaN(this.last_interval))) {
      if (this.inputs && this.inputs.length > 1 && this.inputs[1]) {
        this.setOutputData(1, false);
      }

      return;
    }

    this.triggered = true;
    this.time = this.time % this.last_interval; // this.trigger("on_tick", this.properties.event);

    this.triggerSlot(0, this.properties.event);

    if (this.inputs && this.inputs.length > 1 && this.inputs[1]) {
      this.setOutputData(1, true);
    }
  };

  _proto24.onDrawBackground = function onDrawBackground() {
    this.boxcolor = this.triggered ? timerRobot.on_color : timerRobot.off_color;
    this.triggered = false;
  };

  _proto24.onGetInputs = function onGetInputs() {
    return [["interval", "number"]];
  };

  return timerRobot;
}(_litegraph.LGraphNode);

timerRobot.on_color = "#AAA";
timerRobot.off_color = "#222";
timerRobot.title = '间隔触发'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/change/timeDownCycle", timerRobot);

var upCountRobot = /*#__PURE__*/function (_LGraphNode25) {
  _inheritsLoose(upCountRobot, _LGraphNode25);

  // Name to show
  function upCountRobot() {
    var _this25;

    _this25 = _LGraphNode25.call(this) || this; // this.serialize_widgets = true;

    _this25.title = "计数";
    _this25.desc = "等待时间如果为0的话表示等待1帧。输入的值不为0时即执行倒计时，输入值为0时停止倒计时，输出的值为当前输出帧和上一帧的时间差";
    _this25.mode = _litegraph.LiteGraph.ON_EVENT;

    _this25.addInput("开始值", 'number');

    _this25.addInput("增加", _litegraph.LiteGraph.ACTION);

    _this25.addInput("减少", _litegraph.LiteGraph.ACTION);

    _this25.addInput("重置", _litegraph.LiteGraph.ACTION);

    _this25.addOutput("数值", 'number');

    _this25.addOutput("变化", _litegraph.LiteGraph.EVENT);

    _this25.addProperty("开始值", 0, 'number'); //增加一个变量，    变量名称， 变量名称


    _this25.addWidget("number", "开始值", 0, "开始值", {
      precision: 0
    });

    _this25.addProperty("modal", '无限制', 'enum', {
      values: ['无限制', '范围限制', '循环', '来回']
    }); //增加一个变量，    变量名称， 变量名称


    _this25.addWidget("combo", "模式", _this25.properties.modal, {
      property: "modal",
      values: ['无限制', '范围限制', '循环', '来回']
    });

    _this25.addProperty("min", 1, 'number');

    _this25.addWidget("number", "最小值", 1, "min", {
      precision: 0
    });

    _this25.addProperty("max", 10, 'number');

    _this25.addWidget("number", "最大值", 10, "max", {
      precision: 0
    });

    _this25.addProperty("upStepmodal", '不乘以时间', 'enum', {
      values: ['乘以时间', '不乘以时间']
    }); //增加一个变量，    变量名称， 变量名称


    _this25.addWidget("combo", "步进模式", _this25.properties.upStepmodal, {
      property: "upStepmodal",
      values: ['乘以时间', '不乘以时间']
    });

    _this25.addProperty("stepValue", 1, 'number');

    _this25.addWidget("number", "步进数值", 1, "stepValue", {
      precision: 0
    });

    _this25.updateWidght(); // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // 
    // this.properties.precision = 1


    return _this25;
  }

  var _proto25 = upCountRobot.prototype;

  _proto25.onStart = function onStart() {
    this.repetDir = 1;
    this.value = this.getInputOrProperty("开始值") | 0;
  };

  _proto25.updateWidght = function updateWidght() {
    var value = this.properties.modal;

    if (value != '无限制') {
      this.widgets.map(function (widget) {
        if (widget.name == '最大值' || widget.name == '最小值') {
          widget.disabled = false;
        }
      });
    } else {
      this.widgets.map(function (widget) {
        if (widget.name == '最大值' || widget.name == '最小值') {
          widget.disabled = true;
        }
      });
    }
  };

  _proto25.onWidgetChanged = function onWidgetChanged(name, value, old_value, widget) {
    // console.log('onWidgetChanged', node, name, value, old_value)
    // this.isWidgetVisible
    if (name == '模式') {
      this.updateWidght();
    }
  } // Function to call when the node is executed
  ;

  _proto25.onAction = function onAction(action, param, options) {
    var startValue = this.getInputOrProperty("开始值") || 0;

    if (this.value == null) {
      this.value = startValue;
    } // var stepValue = this.properties.stepValue
    // console.log('action', action, param)  


    if (action == "增加") {
      this.upCount(1);
    } else if (action == '减少') {
      this.upCount(-1);
    } else if (action == '重置') {
      this.value = startValue;
      this.setOutputData(0, this.value);
    }
  };

  _proto25.upCount = function upCount(baseDir) {
    var stepValue = this.properties.stepValue;
    var min = this.properties.min;
    var max = this.properties.max; // var dt = this.graph.elapsed_time * 1000; //in ms

    var time = this.properties.upStepmodal == '不乘以时间' ? 1 : this.graph.elapsed_time * 1000; //in ms

    var modal = this.properties.modal; // console.log('增加的值', this.repetDir * time * stepValue * baseDir)
    // console.log('增加前的值', this.value)

    this.value += this.repetDir * time * stepValue * baseDir; // console.log('增加后的值', this.value, modal, max, min)
    // ['无限制', '范围限制', '循环', '来回']

    if (modal == '范围限制') {
      if (this.value > max) {
        this.value = max;
      }
    } else if (modal == '循环') {
      if (this.value > max) {
        this.value = min;
      }
    } else if (modal == '来回') {
      if (this.number >= max) {
        this.repetDir = -1;
      } else if (this.number <= min) {
        this.repetDir = 1;
      }
    } // console.log('当前技数值', this.value)


    this.setOutputData(0, this.value);
    this.triggerSlot(1);
  };

  _proto25.onExecute = function onExecute() {
    this.upCount(1);
  };

  return upCountRobot;
}(_litegraph.LGraphNode);

upCountRobot.title = '计数'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/change/upCount", upCountRobot);

var checkTagRobot = /*#__PURE__*/function (_LGraphNode26) {
  _inheritsLoose(checkTagRobot, _LGraphNode26);

  // Name to show
  function checkTagRobot() {
    var _this26;

    _this26 = _LGraphNode26.call(this) || this;
    _this26.title = "标记状态";
    _this26.des = '用于标记一个执行中的状态';

    _this26.addInput("值", 'number');

    _this26.addInput("修改", _litegraph.LiteGraph.ACTION);

    _this26.addOutput("输出", "number");

    _this26.addProperty("customeName", "", 'string');

    _this26.addWidget('text', '状态名称', "", 'customeName');

    _this26.addProperty("customeValue", "", 'string');

    _this26.addWidget('text', '初始值', "", 'customeValue');

    _this26.addProperty("container", checkTagRobot.GRAPH, 'enum', {
      values: checkTagRobot.containerEnum
    }); //增加一个变量，    变量名称， 变量名称


    _this26.addWidget("combo", "状态权限", _this26.properties.container, {
      property: "container",
      values: checkTagRobot.containerEnum
    });

    _this26.addProperty("modal", '自定义', 'enum', {
      values: checkTagRobot.modalEnum
    }); //增加一个变量，    变量名称， 变量名称


    _this26.addWidget("combo", "", _this26.properties.modal, {
      property: "modal",
      values: checkTagRobot.modalEnum
    });

    _this26.addProperty('initWithValue', false, 'boolean');

    _this26.addWidget('toggle', '初始化时将自定义状态值赋值', _this26.properties.initWithValue, 'initWithValue'); //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // this.serialize_widgets = true;


    _this26.updateWidght(); //   this.addProperty("inputType", '角度', 'enum', {values: ['角度', '向量']});   //增加一个变量，    变量名称， 变量名称
    // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    //   this.addWidget("combo","输入的类型",this.properties.inputType,{ property: "inputType", values:['角度', '向量'] } );
    // this.properties.precision = 1


    return _this26;
  }

  var _proto26 = checkTagRobot.prototype;

  _proto26.updateWidght = function updateWidght() {
    var value = this.properties.modal;

    if (value == '自定义') {
      this.widgets.map(function (widget) {
        if (widget.name == '状态名称') {
          widget.disabled = false;
        }
      });
    } else {
      this.widgets.map(function (widget) {
        if (widget.name == '状态名称') {
          widget.disabled = true;
        }
      });
    }
  };

  _proto26.onWidgetChanged = function onWidgetChanged(name, value, old_value, widget) {
    console.log('onWidgetChanged', name, value, old_value); // this.isWidgetVisible

    if (name == '') {
      this.updateWidght();
    }
  } //获取存放变量的位置，
  ;

  _proto26.getContainer = function getContainer() {
    switch (this.properties.container) {
      case checkTagRobot.GRAPH:
        if (this.graph) return this.graph.vars;
        return {};
        break;

      case checkTagRobot.GLOBALSCOPE:
        return window;
        break;

      case checkTagRobot.LITEGRAPH:
      default:
        return _litegraph.LiteGraph.Globals;
        break;
    }
  };

  _proto26.getVarName = function getVarName() {
    if (this.properties.modal != '自定义') {
      return this.properties.modal;
    } else {
      return this.properties.customeName;
    }
  };

  _proto26.getTitle = function getTitle() {
    return this.getVarName();
  };

  _proto26.onStart = function onStart() {
    var container = this.getContainer();
    var varName = this.getVarName();

    if (this.properties.customeValue != '') {
      //如果设置了初始值，就会在启动的时候设置初始化值
      this.value = this.properties.customeValue;
      container[varName] = this.value;
      this.setOutputData(0, this.value);
    }
  };

  _proto26.onAction = function onAction(action, param, options) {
    if (action == '修改') {
      var container = this.getContainer();
      var varName = this.getVarName(); //将状态修改为输入值，如果没有连接输入值，将状态修改为初始值(即使初始值为空)

      if (this.isInputConnected(0)) {
        this.value = this.getInputData(0);
      } else {
        this.value = this.properties.customeValue;
      }

      container[varName] = this.value;
      this.setOutputData(0, this.value);
    }
  } // Function to call when the node is executed
  ;

  _proto26.onExecute = function onExecute() {
    var container = this.getContainer();
    var varName = this.getVarName(); //只有Action会修改值。普通执行仅仅返回值
    // if(this.isInputConnected(0))
    // {
    //   this.value = this.getInputData(0);
    //   container[varName] = this.value;
    //   this.setOutputData(0, this.value );
    //   return;
    // }

    this.setOutputData(0, container[varName]);
  };

  return checkTagRobot;
}(_litegraph.LGraphNode);

checkTagRobot.modalEnum = ['自定义', '动画是否播放中', '是否不可交互', '游戏是否开始', '游戏是否结束', '引导是否显示', '当前执行逻辑', '逻辑A是否触发', '逻辑B是否触发', '逻辑C是否触发', '逻辑D是否触发'];
checkTagRobot.LITEGRAPH = '所有分镜'; //between all graphs

checkTagRobot.GRAPH = '仅当前分镜'; //only inside this graph

checkTagRobot.GLOBALSCOPE = 'Window'; //attached to Window

checkTagRobot.containerEnum = [checkTagRobot.GRAPH, checkTagRobot.LITEGRAPH, checkTagRobot.GLOBALSCOPE];
checkTagRobot.title = '标记状态'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/change/checkTag", checkTagRobot);

var dataObjectRobot = /*#__PURE__*/function (_LGraphNode27) {
  _inheritsLoose(dataObjectRobot, _LGraphNode27);

  // Name to show
  function dataObjectRobot() {
    var _this27;

    _this27 = _LGraphNode27.call(this) || this; // this.serialize_widgets = true;
    // this.serialize_widgets = true;

    _this27.title = "数据结构";
    _this27.desc = "输出对象的key和values，如果挂载的是对象，循环对象中每个key，如果是数组，循环数组每个i，每每次循环都会触发toggle事件";

    _this27.addInput("挂载", 'object'); // this.addInput("触发",  LiteGraph.ACTION)
    // this.addInput("减少",  LiteGraph.ACTION)
    // this.addInput("重置",  LiteGraph.ACTION)


    _this27.addOutput("key", 0); // this.addOutput("index", 'number') 


    _this27.addOutput("value", 0);

    _this27.addOutput("触发", _litegraph.LiteGraph.EVENT); // this.addProperty("开始值", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","开始值", 0, "开始值", {precision: 0});
    // this.addProperty("modal", '无限制', 'enum', {values: ['无限制', '范围限制', '循环', '来回']});   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("combo","模式",this.properties.modal,{ property: "modal", values:['无限制', '范围限制', '循环', '来回'] } );
    // this.addProperty("min", 1,  'number')
    // this.addWidget("number","最小值", 1, "min", {precision: 0});
    // this.addProperty("max", 10,  'number')
    // this.addWidget("number","最大值", 10, "max", {precision: 0});
    // this.addProperty("upStepmodal", '不乘以时间', 'enum', {values: ['乘以时间', '不乘以时间']});   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("combo","步进模式",this.properties.upStepmodal,{ property: "upStepmodal", values:['乘以时间', '不乘以时间'] } );
    // this.addProperty("stepValue", 1,  'number')
    // this.addWidget("number","步进数值", 1, "stepValue", {precision: 0});
    // this.updateWidght()
    // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // 
    // this.properties.precision = 1


    return _this27;
  }

  var _proto27 = dataObjectRobot.prototype;

  _proto27.onGetOutputs = function onGetOutputs() {
    console.log('我调用了onGetOutputs');
    return [["number", "string"], ['被引用', 'lgraphNode']];
  };

  _proto27.onStart = function onStart() {// this.repetDir = 1
    // this.value = this.getInputOrProperty("开始值") | 0
  } // updateWidght(){
  //   var value = this.properties.modal
  //   if(value != '无限制'){
  //       this.widgets.map((widget)=>{
  //         if(widget.name == '最大值' || widget.name == '最小值'){
  //             widget.disabled = false
  //         }
  //       })
  //     }else{
  //       this.widgets.map((widget)=>{
  //         if(widget.name == '最大值' || widget.name == '最小值'){
  //             widget.disabled = true
  //         }
  //       })
  //     }
  // }
  // onWidgetChanged(name, value, old_value, widget){
  //   // console.log('onWidgetChanged', node, name, value, old_value)
  //   // this.isWidgetVisible
  //   if(name == '模式'){
  //       this.updateWidght()
  //   }
  // }
  // Function to call when the node is executed
  // onAction(action, param, options) {
  // };
  ;

  _proto27.onExecute = function onExecute() {
    var data = this.getInputData(0);

    if (data !== undefined) {
      if (data instanceof Array) {
        for (var i = 0; i < data.length; i++) {
          this.setOutputData(0, i);
          this.setOutputData(1, data[i]);
          this.triggerSlot(2);
        }
      } else if (data instanceof Object) {
        for (var key in data) {
          this.setOutputData(0, key);
          this.setOutputData(1, data[key]);
          this.triggerSlot(2);
        }
      }
    }
  };

  return dataObjectRobot;
}(_litegraph.LGraphNode);

dataObjectRobot.title = '数据结构'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/change/dataObject", dataObjectRobot);

var getKeyValueRobot = /*#__PURE__*/function (_LGraphNode28) {
  _inheritsLoose(getKeyValueRobot, _LGraphNode28);

  // Name to show
  function getKeyValueRobot() {
    var _this28;

    _this28 = _LGraphNode28.call(this) || this; // this.serialize_widgets = true;

    _this28.title = "对象取值";
    _this28.desc = "和数据结构不同的是，这里取出特定的某个值";

    _this28.addInput("obj", "object"); // this.addInput("key", 'string')
    // this.addOutput("触发", LiteGraph.EVENT)
    // this.addOutput("value", 0)


    _this28.addOutput("property", 0);

    _this28.addProperty("value", 0);

    _this28.addWidget("text", "输入key", "", 'value');

    _this28.widgets_up = true;
    _this28.size = [140, 30];
    _this28._value = null;
    return _this28;
  }

  var _proto28 = getKeyValueRobot.prototype;

  _proto28.getTitle = function getTitle() {
    if (this.flags.collapsed) {
      return "获取." + this.properties.value;
    }

    return this.title;
  };

  _proto28.onGetOutputs = function onGetOutputs() {
    console.log('我调用了onGetOutputs');
    return [["number", "string"], ['被引用', 'lgraphNode']];
  };

  _proto28.onExecute = function onExecute() {
    var data = this.getInputData(0);

    if (data != null) {
      this.setOutputData(0, data[this.properties.value]);
    }
  };

  return getKeyValueRobot;
}(_litegraph.LGraphNode);

getKeyValueRobot.title = '对象取值'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/change/getKeyValue", getKeyValueRobot);

var getArrayValueRobot = /*#__PURE__*/function (_LGraphNode29) {
  _inheritsLoose(getArrayValueRobot, _LGraphNode29);

  // Name to show
  function getArrayValueRobot() {
    var _this29;

    _this29 = _LGraphNode29.call(this) || this; // this.serialize_widgets = true;

    _this29.title = "数组取值";
    _this29.desc = "和数据结构不同的是，这里取出特定的某个值";

    _this29.addInput("array", "array,table,string");

    _this29.addInput("index", "number");

    _this29.addOutput("value", "");

    _this29.addProperty("index", 0);

    _this29.addWidget('number', 'index', 0, 'index', {
      precision: 0
    });

    return _this29;
  }

  var _proto29 = getArrayValueRobot.prototype;

  _proto29.getTitle = function getTitle() {
    if (this.flags.collapsed) {
      return "获取." + this.properties.index;
    }

    return this.title; // this.getOutputNodes()
    // this.isInputConnected()
    // this.outputs[0].links
    // this.disconnectInput()
    // this.onGetOutputs()
    // this.addInput()
    // this.removeInput()
  };

  _proto29.onGetOutputs = function onGetOutputs() {
    console.log('我调用了onGetOutputs');
    return [["number", "string"], ['被引用', 'lgraphNode']];
  };

  _proto29.onExecute = function onExecute() {
    var array = this.getInputData(0);
    var index = this.getInputData(1);

    if (index == null) {
      index = this.properties.index;
    }

    if (array == null || index == null) {
      return;
    }

    this.setOutputData(0, array[Math.floor(Number(index))]);
  };

  return getArrayValueRobot;
}(_litegraph.LGraphNode);

getArrayValueRobot.title = '数组取值'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/change/getArrayValue", getArrayValueRobot);

var sendData = /*#__PURE__*/function (_LGraphNode30) {
  _inheritsLoose(sendData, _LGraphNode30);

  // Name to show
  function sendData() {
    var _this30;

    _this30 = _LGraphNode30.call(this) || this; // this.serialize_widgets = true;
    // this.size = [140, 30]; 

    _this30.title = "无线传送发射";
    _this30.desc = "用于无线连接节点";

    _this30.addInput("附带值", 0);

    _this30.addInput("发送", _litegraph.LiteGraph.ACTION); // this.addOutput("A", -1);


    _this30.addProperty("customeName", 'A', 'string');

    _this30.addWidget('string', '发送事件', _this30.properties.customeName, 'customeName'); // this.widgets_up = true


    return _this30;
  }

  var _proto30 = sendData.prototype;

  _proto30.getTitle = function getTitle() {
    if (this.flags.collapsed) {
      return "发送事件." + this.properties.customeName;
    }

    return this.title;
  };

  // onGetOutputs() {
  //   console.log('我调用了onGetOutputs')
  //   return [["number", "string"]];
  // };
  _proto30.onAction = function onAction(action, param) {
    var data = this.getInputData(0);
    this.graph.sendEventToAllNodes(this.properties.customeName, data);
  };

  return sendData;
}(_litegraph.LGraphNode);

sendData.title = '无线传送发射'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/tool/sendData", sendData);

var acceptData = /*#__PURE__*/function (_LGraphNode31) {
  _inheritsLoose(acceptData, _LGraphNode31);

  // Name to show
  function acceptData() {
    var _this31;

    _this31 = _LGraphNode31.call(this) || this; // this.widgets_up = true
    // this.serialize_widgets = true;
    // this.height = 

    _this31.title = "无线传送接收";
    _this31.desc = "用于无线连接节点";
    _this31.size = [140, 30]; // this.addInput("输入", -1);
    // this.addInput("index", "number");

    _this31.addOutput("接收值", 0);

    _this31.addOutput("接收", _litegraph.LiteGraph.EVENT);

    _this31.addProperty("customeName", 'A', 'string');

    _this31.addWidget('string', '接收事件', _this31.properties.customeName, 'customeName');

    return _this31;
  }

  var _proto31 = acceptData.prototype;

  _proto31.onStart = function onStart() {
    this[this.properties.customeName] = this.onEvent;
  };

  _proto31.getTitle = function getTitle() {
    if (this.flags.collapsed) {
      return "接收事件." + this.properties.customeName;
    }

    return this.title;
  };

  // onGetOutputs() {
  //   console.log('我调用了onGetOutputs')
  //   return [["number", "string"]];
  // };
  _proto31.onEvent = function onEvent(param) {
    console.log('我接收到了事件', param);
    this.setOutputData(0, param);
    this.triggerSlot(1, param);
  } // onAction(action, param){
  //   console.log('我接收到了事件', action)
  //   this.setOutputData(0, param)
  //   this.triggerSlot(0, param)
  // }
  ;

  return acceptData;
}(_litegraph.LGraphNode);

acceptData.title = '无线传送接收'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/tool/acceptData", acceptData);

var outputLine = /*#__PURE__*/function (_LGraphNode32) {
  _inheritsLoose(outputLine, _LGraphNode32);

  // Name to show
  function outputLine() {
    var _this32;

    _this32 = _LGraphNode32.call(this) || this; // this.serialize_widgets = true;
    // this.size = [140, 30]; 

    _this32.title = "输出逻辑线";
    _this32.desc = "根据输入值，触发不同的输出";

    _this32.addInput("输入值", 'number');

    _this32.addInput("触发", _litegraph.LiteGraph.ACTION);

    _this32.addOutput("output_0", _litegraph.LiteGraph.EVENT);

    _this32.addOutput("output_1", _litegraph.LiteGraph.EVENT); // this.addProperty("customeName",'A','string');
    // this.addWidget('string','发送事件', this.properties.customeName, 'customeName')
    // this.widgets_up = true


    return _this32;
  } // getTitle() {
  //     if (this.flags.collapsed) {
  //         return "发送事件." + this.properties.customeName;
  //     }
  //     return this.title;
  // };


  var _proto32 = outputLine.prototype;

  _proto32.onGetOutputs = function onGetOutputs() {
    // console.log('我调用了onGetOutputs')
    return [["output_" + this.outputs.length, _litegraph.LiteGraph.EVENT], ['被引用', 'lgraphNode']];
  };

  _proto32.onAction = function onAction(action, param) {
    var data = Number(this.getInputData(0)); // let soltName = 'output_' + data
    // this.graph.sendEventToAllNodes(this.properties.customeName, data)

    console.log('当前outputLine输入的值', data);

    if (this.outputs[data] != null) {
      this.triggerSlot(data);
    }
  };

  return outputLine;
}(_litegraph.LGraphNode);

outputLine.title = '输出逻辑线'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/tool/outputLine", outputLine);

var lightingOut = /*#__PURE__*/function (_LGraphNode33) {
  _inheritsLoose(lightingOut, _LGraphNode33);

  // Name to show
  function lightingOut() {
    var _this33;

    _this33 = _LGraphNode33.call(this) || this; // this.serialize_widgets = true;
    // this.size = [140, 30]; 

    _this33.title = "动态取值";
    _this33.desc = "动态输出需要的值";

    _this33.addInput("引用节点", 'lgraphNode'); // this.addProperty("customeName",'A','string');
    // this.addWidget('string','发送事件', this.properties.customeName, 'customeName')
    // this.widgets_up = true


    return _this33;
  } // getTitle() {
  //     if (this.flags.collapsed) {
  //         return "发送事件." + this.properties.customeName;
  //     }
  //     return this.title;
  // };


  var _proto33 = lightingOut.prototype;

  _proto33.onGetOutputs = function onGetOutputs() {
    // console.log('我调用了onGetOutputs')
    var inputNode = this.getInputNode(0);

    if (inputNode == null) {
      return [];
    } else {
      var alreadyAddDit = {};

      for (var i = 0; i < this.outputs.length; i++) {
        var output = this.outputs[i];
        alreadyAddDit[output.name] = 1;
      }

      var arr = [];

      for (var key in inputNode.properties) {
        if (alreadyAddDit[key] == null) {
          arr.push([key, 0]);
        }
      }

      return arr;
    }
  };

  _proto33.onExecute = function onExecute() {
    var inputNode = this.getInputNode(0);

    for (var i = 0; i < this.outputs.length; i++) {
      var output = this.outputs[i];
      this.setOutputData(i, inputNode.properties[output.name]);
    }
  } // onAction(action, param){
  //   let data = this.getInputData(0)
  //   // this.graph.sendEventToAllNodes(this.properties.customeName, data)
  //   if(this.outputs[data] != null){
  //     this.triggerSlot(data)
  //   }
  // }
  ;

  return lightingOut;
}(_litegraph.LGraphNode);

lightingOut.title = '动态取值'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/tool/lightingOut", lightingOut);

var lighting = /*#__PURE__*/function (_LGraphNode34) {
  _inheritsLoose(lighting, _LGraphNode34);

  // Name to show
  function lighting() {
    var _this34;

    _this34 = _LGraphNode34.call(this) || this; // this.serialize_widgets = true;
    // this.size = [140, 30]; 

    _this34.title = "动态赋值";
    _this34.desc = "动态设置引用节点的值";

    _this34.addInput("引用节点", 'lgraphNode');

    _this34.addInput("触发赋值", _litegraph.LiteGraph.ACTION); // this.addProperty("customeName",'A','string');
    // this.addWidget('string','发送事件', this.properties.customeName, 'customeName')
    // this.widgets_up = true


    return _this34;
  } // getTitle() {
  //     if (this.flags.collapsed) {
  //         return "发送事件." + this.properties.customeName;
  //     }
  //     return this.title;
  // };


  var _proto34 = lighting.prototype;

  _proto34.onGetInputs = function onGetInputs() {
    // console.log('我调用了onGetOutputs')
    var inputNode = this.getInputNode(0);

    if (inputNode == null) {
      return [];
    } else {
      var alreadyAddDit = {};

      for (var i = 0; i < this.inputs.length; i++) {
        var output = this.inputs[i];
        alreadyAddDit[output.name] = 1;
      }

      var arr = [];

      for (var key in inputNode.properties) {
        if (alreadyAddDit[key] == null) {
          arr.push([key, 0]);
        }
      }

      return arr;
    }
  };

  // onExecute(){
  //   let inputNode = this.getInputNode(0)
  //   for(var i = 0; i < this.outputs.length; i++){
  //     let output = this.outputs[i]
  //     this.setOutputData(i, inputNode.properties[output.name])
  //   }
  // }
  _proto34.onAction = function onAction(action, param) {
    var inputNode = this.getInputNode(0);

    if (inputNode == null) {
      return;
    }

    if (this.inputs.length < 2) {
      return;
    }

    for (var i = 2; i < this.inputs.length; i++) {
      var input = this.inputs[i];
      var value = this.getInputData(i);

      if (inputNode.properties[input.name] != null && value != null) {
        inputNode.setProperty(input.name, value);
      }
    }
  };

  return lighting;
}(_litegraph.LGraphNode);

lighting.title = '动态赋值'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/tool/lighting", lighting);

var textCode = /*#__PURE__*/function (_LGraphNode35) {
  _inheritsLoose(textCode, _LGraphNode35);

  // Name to show
  function textCode() {
    var _this35;

    _this35 = _LGraphNode35.call(this) || this;
    _this35.title = "js文本";
    _this35.desc = "直接运行代码片段";
    _this35.mode = _litegraph.LiteGraph.ON_TRIGGER; // this.serialize_widgets = true;
    // this.size = [140, 30]; 

    _this35.addInput("输入参数", 0); // this.addInput("触发赋值", LiteGraph.ACTION);


    _this35.addOutput('输出结果', 0);

    _this35.addProperty("codeString", '', 'string');

    _this35.addWidget("text", '执行代码片段', _this35.properties.codeString, 'codeString', {
      multiline: true
    }); // this.widgets_up = true


    return _this35;
  } // getTitle() {
  //     if (this.flags.collapsed) {
  //         return "发送事件." + this.properties.customeName;
  //     }
  //     return this.title;
  // };
  // onExecute(){
  //   let inputNode = this.getInputNode(0)
  //   for(var i = 0; i < this.outputs.length; i++){
  //     let output = this.outputs[i]
  //     this.setOutputData(i, inputNode.properties[output.name])
  //   }
  // }


  var _proto35 = textCode.prototype;

  _proto35.onExecute = function onExecute() {
    var valueA = this.getInputData(0);
    var valueB = 0;
    var codeString = this.properties.codeString;

    try {
      eval(codeString);
    } catch (error) {
      console.warn('文本代码执行失败', error);
    }

    this.setOutputData(0, valueB);
  };

  return textCode;
}(_litegraph.LGraphNode);

textCode.title = 'js文本'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/tool/textCode", textCode);

cc._RF.pop();