"use strict";
cc._RF.push(module, 'b87ebvs+rhFqYBhWRGG08PW', 'output');
// Script/Common/LiteGraphCore/nodes/output.js

"use strict";

var _litegraph = require("../../litegraph/litegraph");

var CocosMgr = _interopRequireWildcard(require("../CocosMgr"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

// import VoiceGen from '@/xfyun/VoiceGen';
//ONEVENT是节点自带的事件触发，ONToggle是通用的节点触发，节点自带的事件想要触发就只能设置为OnEvent模式，执行对应的Action
var showTextTip = /*#__PURE__*/function (_LGraphNode) {
  _inheritsLoose(showTextTip, _LGraphNode);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  function showTextTip() {
    var _this;

    _this = _LGraphNode.call(this) || this;
    _this.title = "文字提示";
    _this.desc = "弹出文字提示信息";
    _this.color = '#510';
    _this.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式
    // this.size = [80, 30];               //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")
    // this.addOutput("bool", "boolean")   //增加一个输出触点，  输出节点的名称， 值类型

    _this.addProperty("msg", ""); //增加一个变量，    变量名称， 变量名称


    _this.addInput("", _litegraph.LiteGraph.EVENT);

    _this.widget = _this.addWidget("text", "Text", "", "msg");
    _this.widgets_up = true;
    _this.size = [200, 30]; //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // this.widget = this.addWidget("toggle","value",true,"value");
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1

    return _this;
  } // Function to call when the node is executed
  //执行时的方法


  var _proto = showTextTip.prototype;

  _proto.onExecute = function onExecute() {// console.log("consoleInfo onExecute")
    //   var A = this.getInputData(0)
    //可以反向获取输入的值，不需要被动输入值，目前看来确实更合理
    // var msg = this.getInputData(0); //getInputDataByName("msg");
    // console.log('consoleInfo:', msg);
    // if (!msg) msg = this.properties.msg;
    // if (msg != null && typeof msg != "undefined") {
    //     this.properties.msg = msg;
    // }
  } // onSelected(){
  //     console.log("consoleInfo onSelected")
  // }
  //动态返回卡片显示的title
  // getTitle() {
  //    var msg = this.getInputOrProperty('msg')
  //    if(msg != null)
  //    return this.title;
  // };
  //暂不清楚用处
  ;

  _proto.setValue = function setValue(v) {
    this.setProperty("value", v);
  } // 获取可以接受的输入
  // onGetInputs() {
  // 	return [
  //         ["log", LiteGraph.ACTION],
  //         ["warn", LiteGraph.ACTION],
  //         ["error", LiteGraph.ACTION]
  //     ];
  // };
  // 当节点Toggle时调用
  ;

  _proto.onAction = function onAction(action, param) {
    var msg = this.properties.msg;
    CocosMgr.showAlert(msg); //暂时调用网页提醒
    //提供接入cocos的提示，或者是ant的消息提示
    //需要一个统一的接入管理器
  } //自定义触点显示的文字
  // onDrawBackground(ctx) {
  //     //show the current value
  //     this.outputs[0].label = this.properties["value"] ? '真' : '假'
  // };
  //使用ctx绘制需要显示的内容
  // onDrawForeground(ctx){
  //     var size = this.size[1] * 0.5;
  //     var h = this.size[1] * 0.8;
  //     ctx.textAlign = "left";
  //     ctx.fillStyle = "#AAA";
  //     ctx.fillText('测试绘制文字', size * 1.2, h * 0.85);
  //     ctx.textAlign = "left";
  //     // this.outputs[0].label = this.properties["value"].toFixed(2);
  // }
  ;

  return showTextTip;
}(_litegraph.LGraphNode);

showTextTip.title = '文字提示';

_litegraph.LiteGraph.registerNodeType("output/tips/showTextTip", showTextTip);

var showConfirm = /*#__PURE__*/function (_LGraphNode2) {
  _inheritsLoose(showConfirm, _LGraphNode2);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  function showConfirm() {
    var _this2;

    _this2 = _LGraphNode2.call(this) || this;
    _this2.title = "确认框";
    _this2.desc = "弹出文字提示确认框，用户可点击确认或取消";
    _this2.color = '#510';
    _this2.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式
    // this.size = [80, 30];               //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")
    // this.addOutput("bool", "boolean")   //增加一个输出触点，  输出节点的名称， 值类型

    _this2.addProperty("msg", ""); //增加一个变量，    变量名称， 变量名称


    _this2.addInput("", _litegraph.LiteGraph.EVENT);

    _this2.widget = _this2.addWidget("text", "Text", "", "msg"); // this.widgets_up = true;
    // this.size = [200, 30];

    _this2.addOutput('确认', _litegraph.LiteGraph.EVENT);

    _this2.addOutput('取消', _litegraph.LiteGraph.EVENT); //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // this.widget = this.addWidget("toggle","value",true,"value");
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this2;
  } // Function to call when the node is executed
  //执行时的方法
  // onExecute() {
  // console.log("consoleInfo onExecute")
  //   var A = this.getInputData(0)
  //可以反向获取输入的值，不需要被动输入值，目前看来确实更合理
  // var msg = this.getInputData(0); //getInputDataByName("msg");
  // console.log('consoleInfo:', msg);
  // if (!msg) msg = this.properties.msg;
  // if (msg != null && typeof msg != "undefined") {
  //     this.properties.msg = msg;
  // }
  // }
  // onSelected(){
  //     console.log("consoleInfo onSelected")
  // }
  //动态返回卡片显示的title
  // getTitle() {
  //    var msg = this.getInputOrProperty('msg')
  //    if(msg != null)
  //    return this.title;
  // };
  //暂不清楚用处
  // setValue(v){
  // 	this.setProperty("value",v);
  // }
  // 获取可以接受的输入
  // onGetInputs() {
  // 	return [
  //         ["log", LiteGraph.ACTION],
  //         ["warn", LiteGraph.ACTION],
  //         ["error", LiteGraph.ACTION]
  //     ];
  // };
  // 当节点Toggle时调用


  var _proto2 = showConfirm.prototype;

  _proto2.onAction = function onAction(action, param) {
    var _this3 = this;

    var msg = this.properties.msg;
    CocosMgr.showConfirm(msg, function (result) {
      if (result == true) {
        _this3.trigger('确认');
      } else {
        _this3.trigger('取消');
      }
    }); // console.log('用户点击了result', result)
    //暂时调用网页提醒
    //提供接入cocos的提示，或者是ant的消息提示
    //需要一个统一的接入管理器
  } //自定义触点显示的文字
  // onDrawBackground(ctx) {
  //     //show the current value
  //     this.inputs[0].label = 'msg:' + this.msg
  // };
  //使用ctx绘制需要显示的内容
  // onDrawForeground(ctx){
  //     var size = this.size[1] * 0.5;
  //     var h = this.size[1] * 0.8;
  //     ctx.textAlign = "left";
  //     ctx.fillStyle = "#AAA";
  //     ctx.fillText('测试绘制文字', size * 1.2, h * 0.85);
  //     ctx.textAlign = "left";
  //     // this.outputs[0].label = this.properties["value"].toFixed(2);
  // }
  ;

  return showConfirm;
}(_litegraph.LGraphNode);

showConfirm.title = '确认框';

_litegraph.LiteGraph.registerNodeType("output/tips/showConfirm", showConfirm);

var showHandTip = /*#__PURE__*/function (_LGraphNode3) {
  _inheritsLoose(showHandTip, _LGraphNode3);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function showHandTip() {
    var _this4;

    _this4 = _LGraphNode3.call(this) || this; // this.serialize_widgets = true

    _this4.title = "触摸提示";
    _this4.desc = "播放一个触摸提示的动画";
    _this4.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式
    // this.size = [80, 30];               //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")
    // this.addOutput("bool", "boolean")   //增加一个输出触点，  输出节点的名称， 值类型
    // this.addProperty("msg", "");   //增加一个变量，    变量名称， 变量名称

    _this4.addInput("物体", 'codeNode');

    _this4.addInput("显示", _litegraph.LiteGraph.ACTION);

    _this4.addInput("关闭", _litegraph.LiteGraph.ACTION);

    _this4.addOutput('结束', _litegraph.LiteGraph.EVENT); // this.widget = this.addWidget("text", "Text", "", "msg");
    // this.widgets_up = true;
    // this.size = [200, 30];


    _this4.properties.modal = showHandTip.modalEnum[0];

    _this4.addWidget('combo', '类型', _this4.properties.modal, {
      property: "modal",
      values: showHandTip.modalEnum
    });

    _this4.properties.scale = 1;

    _this4.addWidget('number', '大小', _this4.properties.scale, 'scale', {
      precision: 1
    });

    _this4.properties.x = 0;

    _this4.addWidget('number', '拖拽终点-x', _this4.properties.x, 'x', {
      precision: 0
    });

    _this4.properties.y = 0;

    _this4.addWidget('number', '拖拽终点-y', _this4.properties.y, 'y', {
      precision: 0
    });

    _this4.properties.length = 100;

    _this4.addWidget('number', '长度或半径', _this4.properties.length, 'length', {
      precision: 0
    });

    _this4.properties.speed = 400;

    _this4.addWidget('number', '速度', _this4.properties.length, 'speed', {
      precision: 0
    }); // this.addOutput('取消', LiteGraph.EVENT)


    _this4.updateWidght();

    _this4.addWidget('button', '预览效果', "", function () {
      _this4.showTips();
    });

    _this4.addWidget('button', '创建触摸动画', "", function () {
      _this4.createLinkNode();
    }); // this.addWidget('button','重置起始位置', "", ()=>{
    //     this.oriX = null
    //     this.oriY = null
    //     this.
    // })
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // this.widget = this.addWidget("toggle","value",true,"value");
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1
    // this.isAnyOutputConnected()
    // this.isInputConnected()


    return _this4;
  } //当添加的时候自动生成物体组件并关联
  // onAdded(){
  //     if(CocosMgr.isInImport){
  //         //整体导入时不自动添加物体
  //         return
  //     }
  //     let aniNode = LiteGraph.createNode("objects/createObject");
  //     aniNode.pos = [this.pos[0] - this.width - 3, this.pos[1]]
  //     aniNode.setProperty('x', 0)
  //     aniNode.setProperty('y', 0)
  //     aniNode.setProperty('modal', CocosMgr.ObjectTypeEnum.spine)
  //     aniNode.setProperty('customeName', 'P0_Common_Finger')
  //     aniNode.properties.nodeConfig.x = 0
  //     aniNode.properties.nodeConfig.y = 0
  //     this.graph.add(aniNode);
  //     // aniNode.properties.customeName = 'P0_Common_Finger'
  //     aniNode.connect(0, this, 0)
  // }


  var _proto3 = showHandTip.prototype;

  _proto3.createLinkNode = function createLinkNode() {
    if (this.getInputNode(0) == null) {
      var aniNode = _litegraph.LiteGraph.createNode("objects/createObject");

      aniNode.pos = [this.pos[0] - this.width - 3, this.pos[1]];
      aniNode.setProperty('x', 0);
      aniNode.setProperty('y', 0);
      aniNode.setProperty('modal', CocosMgr.ObjectTypeEnum.spine);
      aniNode.setProperty('customeName', 'P0_Common_Finger');
      aniNode.properties.nodeConfig.x = 0;
      aniNode.properties.nodeConfig.y = 0;
      this.graph.add(aniNode); // aniNode.properties.customeName = 'P0_Common_Finger'

      aniNode.connect(0, this, 0);
    }
  } //更新模块
  ;

  _proto3.updateWidght = function updateWidght() {
    var value = this.properties.modal;
    this.widgets.map(function (widget) {
      if (widget.name == '拖拽终点-x' || widget.name == '拖拽终点-y') {
        widget.disabled = value != '拖拽';
      } else if (widget.name == '长度或半径') {
        widget.disabled = value == '拖拽' || value == '单次点击' || value == '快速点击' || value == '长按';
      } else if (widget.name == '速度') {
        widget.disabled = value == '单次点击' || value == '快速点击' || value == '长按';
      }
    });
  };

  _proto3.onWidgetChanged = function onWidgetChanged(name) {
    if (name == '类型') {
      this.updateWidght();
    }
  } // Function to call when the node is executed
  //执行时的方法
  // onExecute() {
  // console.log("consoleInfo onExecute")
  //   var A = this.getInputData(0)
  //可以反向获取输入的值，不需要被动输入值，目前看来确实更合理
  // var msg = this.getInputData(0); //getInputDataByName("msg");
  // console.log('consoleInfo:', msg);
  // if (!msg) msg = this.properties.msg;
  // if (msg != null && typeof msg != "undefined") {
  //     this.properties.msg = msg;
  // }
  // }
  // onSelected(){
  //     console.log("consoleInfo onSelected")
  // }
  //动态返回卡片显示的title
  // getTitle() {
  //    var msg = this.getInputOrProperty('msg')
  //    if(msg != null)
  //    return this.title;
  // };
  //暂不清楚用处
  // setValue(v){
  // 	this.setProperty("value",v);
  // }
  // 获取可以接受的输入
  // onGetInputs() {
  // 	return [
  //         ["log", LiteGraph.ACTION],
  //         ["warn", LiteGraph.ACTION],
  //         ["error", LiteGraph.ACTION]
  //     ];
  // };
  ;

  _proto3.onSelected = function onSelected() {
    this.showTips();
  } //更新起点位置
  ;

  _proto3.upDateOriPos = function upDateOriPos() {
    var curLink = this.getInputLink(0);

    if (curLink == null) {
      return;
    }

    var linkedNode = this.graph.getNodeById(curLink.origin_id);

    if (linkedNode == null) {
      return;
    }

    var codeNode = this.getInputData(0);

    if (linkedNode.properties.x != null && codeNode != null) {
      codeNode.x = linkedNode.properties.x;
      codeNode.y = linkedNode.properties.y;
    }
  };

  _proto3.onDeselected = function onDeselected() {
    this.hideTips(); // var curLink = this.getInputLink(0)
    // if(curLink == null){
    //     return
    // }
    // var linkedNode = this.graph.getNodeById(curLink.origin_id)
    // if(linkedNode == null){
    //     return
    // }
    // if(linkedNode != null){
    //     // if(linkedNode.codeNode != null){
    //     //     linkedNode.codeNode.active = true
    //     // } 
    //     linkedNode.resetSizeConfig()
    // }

    var codeNode = this.getInputData(0);

    if (this.oriX != null && codeNode != null) {
      codeNode.x = this.oriX;
      codeNode.y = this.oriY;
    }
  };

  _proto3.onPause = function onPause() {
    if (this.inShowTips == true) {
      this.hideTips();
    }
  };

  _proto3.onResume = function onResume() {
    if (this.inShowTips == true) {
      this.showTips();
    }
  };

  _proto3.onStop = function onStop() {// this.oriX = null
    // this.oriY = null
  };

  _proto3.showTips = function showTips() {
    var _this5 = this;

    var codeNode = this.getInputData(0);

    if (codeNode == null) {
      console.warn('showTips 当前没有关联codeNode');
      return;
    }

    codeNode.useCenterMode = false; //使用中心模式

    cc.Tween.stopAllByTarget(this);
    cc.Tween.stopAllByTag(this.getIdWithGraph());
    this.upDateOriPos(); // this.hideTips()  
    // this.oriX = codeNode.x
    // this.oriY = codeNode.y

    codeNode.center = [codeNode.x, codeNode.y];
    codeNode.active = true;
    codeNode.scale = this.properties.scale;
    var modal = showHandTip.modalEnum.indexOf(this.properties.modal);
    var spineCom = codeNode.spineCom; // console.log('准备showTips', modal)

    if (spineCom != null) {
      // ['单次点击','快速点击','拖拽','上下滑动','左右滑动','转圈','长按']
      if (modal == 0) {
        //单次点击
        spineCom.setAnimation(0, 'act1', true);
        spineCom.setCompleteListener(function (trackEntry) {
          // let ccompleteName = trackEntry.animation.name;
          _this5.outputHandle();
        });
      } else if (modal == 1) {
        //快速点击
        spineCom.setAnimation(0, 'act2', true);
        spineCom.setCompleteListener(function (trackEntry) {
          // let ccompleteName = trackEntry.animation.name;
          _this5.outputHandle();
        });
      } else if (modal == 2) {
        //拖拽
        spineCom.setAnimation(0, 'act3_1', false);
        spineCom.addAnimation(0, 'act3_2', true);
        var x = this.properties.x;
        var y = this.properties.y;
        var lengthx = codeNode.x - x;
        var lengthy = codeNode.y - y;

        if (this.properties.speed == 0) {
          return;
        }

        var time = Math.sqrt(lengthy * lengthy + lengthx * lengthx) / this.properties.speed;

        if (time == 0) {
          return;
        } // var oriX = codeNode.x 
        // var oriY = codeNode.y


        cc.tween(codeNode).tag(this.getIdWithGraph()).delay(0.3).to(time, {
          x: x,
          y: y
        }).call(function () {
          spineCom.loop = false;
          spineCom.addAnimation(0, 'act3_3', false);
          cc.tween(_this5).delay(1).call(function () {
            // codeNode.x = oriX
            // codeNode.y = oriY
            _this5.outputHandle();

            _this5.showTips();
          }).start();
        }).start();
      } else if (modal == 3) {
        //上下滑动
        var length = this.properties.length;

        if (this.properties.speed == 0) {
          return;
        }

        var time = length / this.properties.speed;
        spineCom.setAnimation(0, 'act3_2', true);

        if (time == 0) {
          return;
        }

        cc.tween(codeNode).tag(this.getIdWithGraph()).to(time, {
          y: codeNode.y - length
        }).to(time * 2, {
          y: codeNode.y + length
        }).to(time, {
          y: codeNode.y
        }).call(function () {
          _this5.outputHandle();

          _this5.showTips();
        }).start();
      } else if (modal == 4) {
        //左右滑动
        var length = this.properties.length;

        if (this.properties.speed == 0) {
          return;
        }

        var time = Math.abs(length / this.properties.speed);
        spineCom.setAnimation(0, 'act3_2', true);

        if (time == 0) {
          return;
        }

        cc.tween(codeNode).tag(this.getIdWithGraph()).to(time, {
          x: codeNode.x - length
        }).to(time * 2, {
          x: codeNode.x + length
        }).to(time, {
          x: codeNode.x
        }).call(function () {
          _this5.outputHandle();

          _this5.showTips();
        }).start();
      } else if (modal == 5) {
        //转圈
        codeNode.radius = this.properties.length;
        codeNode.useCenterMode = true;

        if (this.properties.speed == 0) {
          return;
        }

        var time = Math.abs(Math.PI * 2 / (this.properties.speed * 0.01));

        if (time == 0) {
          return;
        }

        spineCom.setAnimation(0, 'act3_2', true);
        var angle = this.properties.speed > 0 ? 360 : -360; // console.log('多少秒转一圈',time, angle)

        cc.tween(codeNode).tag(this.getIdWithGraph()).by(time, {
          angleToPos: angle
        }).call(function () {
          _this5.outputHandle();

          _this5.showTips();
        }).start();
      } else if (modal == 6) {
        //长按
        spineCom.setAnimation(0, 'act3_1', false);
        spineCom.addAnimation(0, 'act3_2', true);
        cc.tween(this).delay(2).call(function () {
          spineCom.loop = false;
          spineCom.addAnimation(0, 'act3_3', false);
          cc.tween(_this5).delay(0.8).call(function () {
            _this5.outputHandle();

            _this5.showTips();
          }).start();
        }).start();
      }
    } else {
      console.warn('showTip 目标没有spine');
    }
  };

  _proto3.outputHandle = function outputHandle() {
    this.triggerSlot(0);
  };

  _proto3.hideTips = function hideTips() {
    cc.Tween.stopAllByTarget(this);
    var codeNode = this.getInputData(0);

    if (codeNode == null) {
      console.warn('showTips 当前没有关联codeNode');
      return;
    }

    if (codeNode != null) {
      codeNode.useCenterMode = false; //使用中心模式
      // cc.Tween.stopAllByTarget(codeNode);

      cc.Tween.stopAllByTag(this.getIdWithGraph());

      if (codeNode.spineCom != null) {
        codeNode.spineCom.clearTrack(0);
      }

      codeNode.active = false;
    } // this.oriX = null
    // this.oriY = null

  };

  _proto3.onStart = function onStart() {
    //开始时默认是关闭引导的
    this.onAction('关闭');
  } // 当节点Toggle时调用
  ;

  _proto3.onAction = function onAction(action, param) {
    if (action == '显示') {
      this.inShowTips = true;
      this.showTips();
    } else if (action == '关闭') {
      this.inShowTips = false;
      this.hideTips();
    } //结束
    //this.trigger('结束')
    //暂时调用网页提醒
    //提供接入cocos的提示，或者是ant的消息提示
    //需要一个统一的接入管理器

  } //自定义触点显示的文字
  // onDrawBackground(ctx) {
  //     //show the current value
  //     this.outputs[0].label = this.properties["value"] ? '真' : '假'
  // };
  //使用ctx绘制需要显示的内容
  // onDrawForeground(ctx){
  //     var size = this.size[1] * 0.5;
  //     var h = this.size[1] * 0.8;
  //     ctx.textAlign = "left";
  //     ctx.fillStyle = "#AAA";
  //     ctx.fillText('测试绘制文字', size * 1.2, h * 0.85);
  //     ctx.textAlign = "left";
  //     // this.outputs[0].label = this.properties["value"].toFixed(2);
  // }
  ;

  return showHandTip;
}(_litegraph.LGraphNode);

showHandTip.title = '触摸提示';
showHandTip.modalEnum = ['单次点击', '快速点击', '拖拽', '上下滑动', '左右滑动', '转圈', '长按'];

_litegraph.LiteGraph.registerNodeType("output/tips/showHandTip", showHandTip); // blockTouch


var blockTouch = /*#__PURE__*/function (_LGraphNode4) {
  _inheritsLoose(blockTouch, _LGraphNode4);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function blockTouch() {
    var _this6;

    _this6 = _LGraphNode4.call(this) || this; // this.serialize_widgets = true

    _this6.title = "屏蔽触摸";
    _this6.desc = "屏蔽触摸事件，简化流程";
    _this6.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式

    _this6.size = [80, 30]; //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")
    // this.addOutput("bool", "boolean")   //增加一个输出触点，  输出节点的名称， 值类型
    // this.addProperty("msg", "");   //增加一个变量，    变量名称， 变量名称

    _this6.addInput("开启", _litegraph.LiteGraph.ACTION);

    _this6.addInput("关闭", _litegraph.LiteGraph.ACTION); //设置节点的进度，一般来说用于在执行的时候设置
    // this.widget = this.addWidget("toggle","value",true,"value");
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this6;
  } // Function to call when the node is executed
  //执行时的方法
  // onExecute() {
  // console.log("consoleInfo onExecute")
  //   var A = this.getInputData(0)
  //可以反向获取输入的值，不需要被动输入值，目前看来确实更合理
  // var msg = this.getInputData(0); //getInputDataByName("msg");
  // console.log('consoleInfo:', msg);
  // if (!msg) msg = this.properties.msg;
  // if (msg != null && typeof msg != "undefined") {
  //     this.properties.msg = msg;
  // }
  // }
  // onSelected(){
  //     console.log("consoleInfo onSelected")
  // }
  //动态返回卡片显示的title
  // getTitle() {
  //    var msg = this.getInputOrProperty('msg')
  //    if(msg != null)
  //    return this.title;
  // };
  // onStart(){
  // //    this.codeNode = CocosMgr.createObj(config, loadCb)
  // }


  var _proto4 = blockTouch.prototype;

  _proto4.onStop = function onStop() {
    CocosMgr.blockTouch(false);
  } //暂不清楚用处
  // setValue(v){
  // 	this.setProperty("value",v);
  // }
  // 获取可以接受的输入
  // onGetInputs() {
  // 	return [
  //         ["log", LiteGraph.ACTION],
  //         ["warn", LiteGraph.ACTION],
  //         ["error", LiteGraph.ACTION]
  //     ];
  // };
  // 当节点Toggle时调用
  ;

  _proto4.onAction = function onAction(action, param) {
    if (action == '开启') {
      CocosMgr.blockTouch(true);
    } else if (action == '关闭') {
      CocosMgr.blockTouch(false);
    } //结束
    //this.trigger('结束')
    //暂时调用网页提醒
    //提供接入cocos的提示，或者是ant的消息提示
    //需要一个统一的接入管理器

  } //自定义触点显示的文字
  // onDrawBackground(ctx) {
  //     //show the current value
  //     this.outputs[0].label = this.properties["value"] ? '真' : '假'
  // };
  //使用ctx绘制需要显示的内容
  // onDrawForeground(ctx){
  //     var size = this.size[1] * 0.5;
  //     var h = this.size[1] * 0.8;
  //     ctx.textAlign = "left";
  //     ctx.fillStyle = "#AAA";
  //     ctx.fillText('测试绘制文字', size * 1.2, h * 0.85);
  //     ctx.textAlign = "left";
  //     // this.outputs[0].label = this.properties["value"].toFixed(2);
  // }
  ;

  return blockTouch;
}(_litegraph.LGraphNode);

blockTouch.title = '屏蔽触摸';

_litegraph.LiteGraph.registerNodeType("output/blockTouch", blockTouch);

var consoleInfo = /*#__PURE__*/function (_LGraphNode5) {
  _inheritsLoose(consoleInfo, _LGraphNode5);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  function consoleInfo() {
    var _this7;

    _this7 = _LGraphNode5.call(this) || this;
    _this7.title = "输出控制台";
    _this7.desc = "打印内容到控制台";
    _this7.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式
    // this.size = [80, 30];               //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")
    // this.addOutput("bool", "boolean")   //增加一个输出触点，  输出节点的名称， 值类型

    _this7.addInput("msg", 0); //0表示可以是任何类型


    _this7.addInput("log", _litegraph.LiteGraph.ACTION);

    _this7.addInput("warn", _litegraph.LiteGraph.ACTION);

    _this7.addInput("error", _litegraph.LiteGraph.ACTION);

    _this7.addProperty("msg", ""); //增加一个变量，    变量名称， 变量名称


    _this7.addWidget("string", "msg", _this7.properties.msg, 'msg'); //增加一个变量，    变量名称， 变量名称
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // this.widget = this.addWidget("toggle","value",true,"value");
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定


    _this7.widgets_up = true; //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1

    return _this7;
  } // Function to call when the node is executed
  //执行时的方法


  var _proto5 = consoleInfo.prototype;

  _proto5.onExecute = function onExecute() {
    // console.log("consoleInfo onExecute")
    //   var A = this.getInputData(0)
    //可以反向获取输入的值，不需要被动输入值，目前看来确实更合理
    var msg = this.getInputOrProperty('msg'); //getInputDataByName("msg");

    console.log('consoleInfo:', msg); // if (!msg) msg = this.properties.msg;
    // if (msg != null && typeof msg != "undefined") {
    //     this.properties.msg = msg;
    // }
  } // onSelected(){
  //     console.log("consoleInfo onSelected")
  // }
  //动态返回卡片显示的title
  // getTitle() {
  //     if (this.flags.collapsed) {
  //         return this.properties.value;
  //     }
  //     return this.title;
  // };
  //暂不清楚用处
  ;

  _proto5.setValue = function setValue(v) {
    this.setProperty("value", v);
  } // 获取可以接受的输入
  ;

  _proto5.onGetInputs = function onGetInputs() {
    return [["log", _litegraph.LiteGraph.ACTION], ["warn", _litegraph.LiteGraph.ACTION], ["error", _litegraph.LiteGraph.ACTION]];
  };

  // 当节点Toggle时调用
  _proto5.onAction = function onAction(action, param) {
    // console.log("consoleInfo onAction", action, param)
    // param is the action
    var msg = this.getInputOrProperty('msg'); //getInputDataByName("msg");
    //if (msg == null || typeof msg == "undefined") return;
    //  if (!msg) msg = this.properties.msg;
    //  if (!msg) msg = "Event param: " + param; // msg is undefined if the slot is lost?

    if (action == "log") {
      console.log('consoleInfo', msg);
    } else if (action == "warn") {
      console.warn('consoleInfo', msg);
    } else if (action == "error") {
      console.error('consoleInfo', msg);
    }
  } //自定义触点显示的文字
  // onDrawBackground(ctx) {
  //     //show the current value
  //     this.outputs[0].label = this.properties["value"] ? '真' : '假'
  // };
  ;

  _proto5.onDrawBackground = function onDrawBackground(ctx) {
    //show the current value
    if (this.getInputData(0) != null) {
      this.inputs[0].label = 'msg:' + this.getInputData(0);
    } else {
      this.inputs[0].label = 'msg';
    }
  };

  return consoleInfo;
}(_litegraph.LGraphNode);

consoleInfo.title = '输出控制台';

_litegraph.LiteGraph.registerNodeType("output/tips/consoleInfo", consoleInfo);

var restartGame = /*#__PURE__*/function (_LGraphNode6) {
  _inheritsLoose(restartGame, _LGraphNode6);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function restartGame() {
    var _this8;

    _this8 = _LGraphNode6.call(this) || this; // this.serialize_widgets = true

    _this8.title = "重新开始";
    _this8.desc = "重新开始游戏流程";
    _this8.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式

    _this8.size = [80, 20]; //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")
    // this.addOutput("bool", "boolean")   //增加一个输出触点，  输出节点的名称， 值类型
    // this.addProperty("msg", "");   //增加一个变量，    变量名称， 变量名称

    _this8.addInput("重启", _litegraph.LiteGraph.ACTION); //设置节点的进度，一般来说用于在执行的时候设置
    // this.widget = this.addWidget("toggle","value",true,"value");
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this8;
  } // 当节点Toggle时调用


  var _proto6 = restartGame.prototype;

  _proto6.onAction = function onAction(action, param) {
    if (action == '重启') {
      this.graph.stop();
      this.graph.start();
    }
  };

  return restartGame;
}(_litegraph.LGraphNode);

restartGame.title = '重新开始';

_litegraph.LiteGraph.registerNodeType("output/game/restartGame", restartGame);

var changeGame = /*#__PURE__*/function (_LGraphNode7) {
  _inheritsLoose(changeGame, _LGraphNode7);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function changeGame() {
    var _this9;

    _this9 = _LGraphNode7.call(this) || this; // this.serialize_widgets = true

    _this9.title = "切换页面";
    _this9.desc = "切换到新的页面";
    _this9.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式

    _this9.size = [80, 20]; //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")
    // this.addOutput("bool", "boolean")   //增加一个输出触点，  输出节点的名称， 值类型

    _this9.addProperty("pageIndex", 0, 'number'); //增加一个变量，    变量名称， 变量名称


    _this9.addWidget("number", "页码", _this9.properties.pageIndex, "pageIndex", {
      precision: 0,
      min: 1
    }); //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称


    _this9.addProperty("gamePath", "", 'string');

    _this9.addWidget("string", '页面名称', _this9.properties.gamePath, "gamePath");

    _this9.addInput("切换", _litegraph.LiteGraph.ACTION); //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this9;
  } // 当节点Toggle时调用


  var _proto7 = changeGame.prototype;

  _proto7.onAction = function onAction(action, param) {
    if (action == '切换') {
      this.graph.stop();
      CocosMgr.changeGraph(this.properties.gamePath, this.properties.pageIndex - 1);
    }
  };

  return changeGame;
}(_litegraph.LGraphNode);

changeGame.title = '切换页面';

_litegraph.LiteGraph.registerNodeType("output/game/changeGame", changeGame);

var endGame = /*#__PURE__*/function (_LGraphNode8) {
  _inheritsLoose(endGame, _LGraphNode8);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function endGame() {
    var _this10;

    _this10 = _LGraphNode8.call(this) || this; // this.serialize_widgets = true

    _this10.title = "页面结束";
    _this10.desc = "这一页阅读结束了";
    _this10.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式

    _this10.size = [80, 20]; //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")
    // this.addOutput("bool", "boolean")   //增加一个输出触点，  输出节点的名称， 值类型
    // this.addProperty("pageIndex", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","页码", this.properties.pageIndex ,"pageIndex", {precision: 0});  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    // this.addProperty("gamePath", "", 'string');
    // this.addWidget("string", '页面路径', this.properties.gamePath, "gamePath");

    _this10.addInput("结束", _litegraph.LiteGraph.ACTION); //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this10;
  } // 当节点Toggle时调用


  var _proto8 = endGame.prototype;

  _proto8.onAction = function onAction(action, param) {
    if (action == '结束') {
      // this.graph.stop()
      if (CocosMgr.isInApp) {//通知StoryView页面结束了
        // EventCenter.emit(EventConst.PAGE_END)
      }
    }
  };

  return endGame;
}(_litegraph.LGraphNode);

endGame.title = '页面结束';

_litegraph.LiteGraph.registerNodeType("output/game/endGame", endGame);

var sendEventToBook = /*#__PURE__*/function (_LGraphNode9) {
  _inheritsLoose(sendEventToBook, _LGraphNode9);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function sendEventToBook() {
    var _this11;

    _this11 = _LGraphNode9.call(this) || this; // this.serialize_widgets = true

    _this11.title = "通知绘本操作";
    _this11.desc = "操作绘本相关事件";
    _this11.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式
    // this.size = [80, 20];               //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")
    // this.addOutput("bool", "boolean")   //增加一个输出触点，  输出节点的名称， 值类型
    // this.addProperty("pageIndex", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","页码", this.properties.pageIndex ,"pageIndex", {precision: 0});  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称

    _this11.addInput("触发", _litegraph.LiteGraph.ACTION);

    _this11.addInput('param', 0);

    _this11.addProperty("modal", "隐藏底部字幕", 'string');

    _this11.addWidget('combo', '事件', _this11.properties.modal, {
      property: "modal",
      values: sendEventToBook.modalEnum
    });

    _this11.addProperty("param", "", 'string');

    _this11.addWidget("string", '附加信息', _this11.properties.param, "param"); //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定


    _this11.widgets_up = true; //设置输入组件在顶部（覆盖input和output）
    // this.widgets_start_y = 2

    _this11.setSize(_this11.computeSize()); //   this.properties.precision = 1


    return _this11;
  } // 当节点Toggle时调用


  var _proto9 = sendEventToBook.prototype;

  _proto9.onAction = function onAction(action, param) {
    if (action == '触发') {
      // this.graph.stop()
      if (CocosMgr.isInApp) {
        //通知StoryView页面结束了
        var eventName = sendEventToBook.modalEnumDit[this.properties.modal];
        var exInfo = this.getInputOrProperty('param'); // EventCenter.emit(eventName, exInfo)
      }
    }
  };

  return sendEventToBook;
}(_litegraph.LGraphNode);

sendEventToBook.title = '通知绘本操作';
sendEventToBook.modalEnum = ['隐藏底部字幕'];
sendEventToBook.modalEnumDit = {
  '隐藏底部字幕': 'OnHideReadText'
};

_litegraph.LiteGraph.registerNodeType("output/game/sendEventToBook", sendEventToBook);

var sound = /*#__PURE__*/function (_LGraphNode10) {
  _inheritsLoose(sound, _LGraphNode10);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function sound() {
    var _this12;

    _this12 = _LGraphNode10.call(this) || this; // this.serialize_widgets = true

    _this12.title = "播放音频";
    _this12.desc = "播放一段音频";
    _this12.mode = _litegraph.LiteGraph.ALWAYS; //设置触发模式
    // this.size = [80, 20];               //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")
    // this.addProperty("pageIndex", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","页码", this.properties.pageIndex ,"pageIndex", {precision: 0});  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)

    _this12.addInput("播放", _litegraph.LiteGraph.ACTION);

    _this12.addInput("停止", _litegraph.LiteGraph.ACTION);

    _this12.addInput("字幕", 'array');

    _this12.addOutput("结束", _litegraph.LiteGraph.EVENT); //增加一个输出触点，  输出节点的名称， 值类型


    _this12.addOutput("是否结束", 'boolean');

    _this12.addProperty("modal", "自定义", 'string');

    _this12.addWidget('combo', '选择音频', _this12.properties.modal, {
      property: "modal",
      values: sound.modalEnum
    });

    _this12.addProperty("customeName", "", 'string');

    _this12.addWidget("string", '资源', _this12.properties.customeName, "customeName"); //当音轨为0时不限制播放，其它音轨同一时间只有一个音频在播放


    _this12.addProperty("yinggui", '无', 'enum');

    _this12.addWidget('combo', '选择音轨', _this12.properties.yinggui, {
      property: "yinggui",
      values: ['无', 'A', 'B', 'C', 'D', 'E', 'F', 'G']
    });

    _this12.addProperty("loop", false, "boolean");

    _this12.addWidget("toggle", '是否循环', _this12.properties.loop, "loop");

    _this12.addProperty("volume", 0.5, "number");

    _this12.addWidget("slider", '音量', _this12.properties.volume, "volume", {
      min: 0,
      max: 1,
      precision: 2,
      step2: 0.01
    });

    _this12.addProperty('autoRun', false, 'boolean');

    _this12.addWidget('toggle', '是否自动播放', _this12.properties.autoRun, 'autoRun');

    _this12.addProperty('delayTime', 0, 'number');

    _this12.addWidget('number', '延迟几秒播放', _this12.properties.delayTime, 'delayTime');

    _this12.addProperty('duration', 0, 'number');

    var durationWidget = _this12.addWidget('number', '音频时长', _this12.properties.duration, 'duration');

    durationWidget.disabled = true; //不可以修改

    _this12.addWidget('button', '', "", function (btnWidget) {
      console.log('btnWidget', btnWidget.clickeName);

      if (btnWidget.clickeName != '') {
        _this12.onAction(btnWidget.clickeName);
      }
    }, {
      buttons: ['播放', '停止']
    });

    _this12.addProperty('motionTextData', [], 'array');

    _this12.addWidget('button', '编辑字幕', "", function () {
      if (window.onGraphMenuClick != null) {
        window.onGraphMenuClick('editSoundText', {
          customeName: _this12.properties.customeName,
          motionTextData: _this12.properties.motionTextData,
          id: _this12.getIdWithGraph(),
          onValueChange: function onValueChange(data) {
            // this.setProperty('motionTextData', data)
            console.log('返回的data', data); // 点击这里其实是创建字幕，如果没有的话

            if (_this12.getInputNode(2) == null) {
              var emptyNode = _litegraph.LiteGraph.createNode('objects/createObject');

              emptyNode.pos = [_this12.pos[0] - 30, _this12.pos[1]];
              emptyNode.setProperty('zIndex', 996);
              emptyNode.setProperty('x', 0);
              emptyNode.setProperty('y', 0);

              _this12.graph.add(emptyNode);

              var textGroup = _litegraph.LiteGraph.createNode('objects/textGroup');

              textGroup.pos = [_this12.pos[0] - 10, _this12.pos[1]];

              _this12.graph.add(textGroup);

              for (var i = 0; i < data.length; i++) {
                textGroup.addLine();
                textGroup.setProperty('text' + (i + 1), data[i].text);
              }

              emptyNode.connect(0, textGroup, 0);
              textGroup.connect(0, _assertThisInitialized(_this12), 2);
              textGroup.freshTexts(data);

              if (window.onGraphMenuClick != null) {
                _this12.graph.setDirtyCanvas(true, true);

                window.onGraphMenuClick('layoutNodesJustX');
              }
            } else {
              //如果当前已经绑定了，动态增加或删除
              var _textGroup = _this12.getInputNode(2);

              while (_textGroup.properties.linesNum != 0) {
                _textGroup.removeLine();
              }

              for (var i = 0; i < data.length; i++) {
                _textGroup.addLine();

                _textGroup.setProperty('text' + (i + 1), data[i].text);
              }

              _textGroup.freshTexts(data);
            }
          }
        });
      }
    }); //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1
    // this.inputs[0].link != -


    return _this12;
  }

  var _proto10 = sound.prototype;

  _proto10.onPropertyChanged = function onPropertyChanged(property, value) {
    var _this13 = this;

    if (property == 'customeName') {
      var path = value; // if(this.properties.modal != '自定义'){
      //     path = this.properties.modal + '.mp3'
      // }

      this.clip = null;
      cc.assetManager.loadRemote(CocosMgr.rootHost + '/' + path, function (err, clip) {
        if (err != null) {
          console.warn('加载音频失败', err);
          return;
        } // console.log('加载出来的clip', clip)


        _this13.clip = clip;

        _this13.setProperty('duration', clip.duration);
      });
    } else if (property == 'modal') {
      if (value != '自定义') {
        this.setProperty('customeName', sound.modalDit[value]);
      }
    }
  };

  _proto10.onStart = function onStart() {
    // 部分声音在开始前播放了，但开始的时候又把audio变成空了，导致翻页声音还在，注意不需要在开始前播放，同时将初始化操作滞空
    // this.audioID = null
    // console.log('sound onStart', this.properties.customeName)
    // this.clip = null
    if (this.properties.motionTextData != null) {
      if (this.properties.motionTextData.length > 0) {
        var textGroup = this.getInputNode(2);

        if (textGroup != null) {
          textGroup.freshTexts(this.properties.motionTextData);
        }
      }
    }

    if (this.properties.autoRun) {
      this.onAction('播放');
    }
  };

  _proto10.onPause = function onPause() {
    if (this.audioID != null) {
      cc.audioEngine.pause(this.audioID);
    }
  };

  _proto10.onResume = function onResume() {
    if (this.audioID != null) {
      cc.audioEngine.resume(this.audioID);
    }
  };

  _proto10.getTitle = function getTitle() {
    if (this.flags.collapsed) {
      return "播放音频." + this.properties.customeName.split('.')[0];
    }

    return this.title;
  };

  _proto10.onConfigure = function onConfigure() {
    this.updateWidght();
  };

  _proto10.updateWidght = function updateWidght() {
    var value = this.properties.modal;
    this.widgets.map(function (widget) {
      if (widget.name == '资源') {
        widget.disabled = value != '自定义';
      }
    });
  };

  _proto10.onWidgetChanged = function onWidgetChanged(name) {
    if (name == '选择音频') {
      this.updateWidght();
    }
  };

  _proto10.onStop = function onStop() {
    this.onAction('停止');
  } //开始播放
  ;

  _proto10.realPlayAudio = function realPlayAudio() {
    var _this14 = this;

    var yinggui = this.properties.yinggui;
    var audioArray = this.graph.config.audioArray;
    var volume = this.properties.volume;

    if (this.graph.config.mute == true) {
      //静音模式所有音频声音为0
      volume = 0;
    }

    var path = this.properties.customeName; // if(this.properties.modal != '自定义'){
    //     path = this.properties.modal + '.mp3'
    // }

    console.log('准备播放音频', path);

    if (this.clip == null) {
      cc.assetManager.loadRemote(CocosMgr.rootHost + '/' + path, function (err, clip) {
        if (err != null) {
          console.warn('加载音频失败', err);
          return;
        }

        if (yinggui != '无') {
          if (audioArray[yinggui] != _this14.getIdWithGraph()) {
            return;
          }
        }

        clip.addRef(); // console.log('音频加载成功', path, volume, clip._name, clip.duration, clip.loaded, clip) //

        _this14.clip = clip;
        var audioID = cc.audioEngine.play(clip, _this14.properties.loop, volume);

        if (_this14.audioID != null) {
          cc.audioEngine.stop(_this14.audioID);
        }

        _this14.audioID = audioID; // console.log('我播放音频2', this.audioID, yinggui, this.properties.customeName)

        cc.audioEngine.setFinishCallback(_this14.audioID, function () {
          _this14.triggerSlot(0);

          _this14.setOutputData(1, true);

          if (_this14.playEndCb != null) {
            _this14.playEndCb();
          }
        });
      });
    } else {
      // console.log('已经加载了音频可以直接播放', this.clip)
      if (yinggui != '无') {
        if (audioArray[yinggui] != this.getIdWithGraph()) {
          return;
        }
      }

      var audioID = cc.audioEngine.play(this.clip, this.properties.loop, volume);

      if (this.audioID != null) {
        cc.audioEngine.stop(this.audioID);
      }

      this.audioID = audioID; // console.log('我播放音频3', this.audioID, yinggui, this.properties.customeName)

      cc.audioEngine.setFinishCallback(this.audioID, function () {
        _this14.triggerSlot(0);

        _this14.setOutputData(1, true);

        if (_this14.playEndCb != null) {
          _this14.playEndCb();
        }
      });
    }
  } // 当节点Toggle时调用
  ;

  _proto10.onAction = function onAction(action, param) {
    var yinggui = this.properties.yinggui;
    var audioArray = this.graph.config.audioArray; //console.log('audioArray 是否 为空', audioArray, audioArray == null, audioArray == undefined)

    if (audioArray == undefined) {
      this.graph.config.audioArray = {};
      audioArray = this.graph.config.audioArray;
    }

    if (action == '播放') {
      //播放前要先停止音频
      this.onAction('停止');
      var textGroupNode = this.getInputNode(2);

      if (textGroupNode != null) {
        if (textGroupNode.properties.showInPageBottom == true) {
          if (CocosMgr.isInApp) {//通知StoryView页面结束了
            // EventCenter.emit(EventConst.OnPlayReadText, this.properties.motionTextData)
          }
        } else {
          textGroupNode.onAction('播放');
        }
      } //不管有没有延迟都要先设置音轨，逻辑已经执行了


      if (yinggui != '无') {
        var curYingui = audioArray[yinggui];

        if (curYingui != null) {
          curYingui = this.graph.getNodeById(curYingui);

          if (curYingui != null) {
            curYingui.onAction('停止');
          }
        }

        audioArray[yinggui] = this.getIdWithGraph();
        console.log('设置音轨播放的id', yinggui, this.getIdWithGraph());
      }

      this.setOutputData(1, false); // console.log('我设置isSoundEnd',false)

      if (this.properties.delayTime > 0) {
        this.curWaitTime = this.properties.delayTime;
        this.mode = _litegraph.LiteGraph.ALWAYS;
      } else {
        this.realPlayAudio();
      }
    } else if (action == '停止') {
      var _textGroupNode = this.getInputNode(2);

      if (_textGroupNode != null) {
        if (_textGroupNode.properties.showInPageBottom == true) {
          if (CocosMgr.isInApp) {//通知StoryView页面结束了
            // EventCenter.emit(EventConst.OnHideReadText)
          }
        } else {
          _textGroupNode.onAction('停止');
        }
      }

      if (audioArray[yinggui] == this.getIdWithGraph()) {
        audioArray[yinggui] = null;
      }

      if (this.audioID != null) {
        // console.log('我收到了停止播放音频', this.audioID, yinggui, this.properties.customeName)
        cc.audioEngine.stop(this.audioID);
      }

      if (this.clip != null) {
        this.clip.decRef();
        this.clip = null;
      }

      this.audioID = null;
      this.curWaitTime = null;
    }
  };

  _proto10.onExecute = function onExecute() {
    if (this.curWaitTime != null) {
      var dt = this.graph.elapsed_time; //in ms
      // console.log('dt', dt)

      this.curWaitTime -= dt;

      if (this.curWaitTime <= 0) {
        // console.log('延迟结束播放了声音', this.curWaitTime)
        this.curWaitTime = null;
        this.realPlayAudio();
      }
    }
  };

  return sound;
}(_litegraph.LGraphNode);

sound.title = '播放音频';
sound.modalEnum = ['自定义', '胜利', '开始', '正确', '错误'];
sound.modalDit = {
  '胜利': 'WIN.d434ffea.mp3',
  '错误': '错误.4893a3c2.mp3',
  '开始': 'readygo.a873eb49.mp3',
  '正确': 'dinlin.1ac6169b.mp3'
};

_litegraph.LiteGraph.registerNodeType("output/sound", sound);

var textToSound = /*#__PURE__*/function (_LGraphNode11) {
  _inheritsLoose(textToSound, _LGraphNode11);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function textToSound() {
    var _this15;

    _this15 = _LGraphNode11.call(this) || this; // this.serialize_widgets = true

    _this15.title = "文本转音频";
    _this15.desc = "接入文本生成音频接口实现文本生成配音";
    _this15.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式
    // this.size = [80, 20];               //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")
    // this.addProperty("pageIndex", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","页码", this.properties.pageIndex ,"pageIndex", {precision: 0});  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)
    // this.addInput("震动", LiteGraph.ACTION);

    _this15.addProperty("text", "今天天气真不错");

    _this15.addWidget("text", "文本", _this15.properties.text, "text");

    _this15.addProperty("soundName", "xunfei");

    _this15.addWidget("text", "命名", _this15.properties.soundName, "soundName");

    _this15.addProperty("peopleSound", textToSound.peopleSounds[1], 'enum');

    _this15.widget = _this15.addWidget("combo", "音色", _this15.properties.peopleSound, {
      property: 'peopleSound',
      values: textToSound.peopleSounds
    }); //{'小明': 'xm', '塔塔': 'tata'}

    _this15.addProperty("speed", 50, 'number');

    _this15.addWidget("slider", "语速", _this15.properties.speed, "speed", {
      precision: 0,
      min: 0,
      max: 100
    });

    _this15.addProperty("volume", 50, 'number');

    _this15.addWidget("slider", "音量", _this15.properties.volume, "volume", {
      precision: 0,
      min: 0,
      max: 100
    });

    _this15.addProperty("pitch", 50, 'number');

    _this15.addWidget("slider", "语调", _this15.properties.pitch, "pitch", {
      precision: 0,
      min: 0,
      max: 100
    });

    _this15.addProperty('bgs', false, 'boolean');

    _this15.addWidget('toggle', '背景音', _this15.properties.bgs, 'bgs');

    _this15.btnWidget = _this15.addWidget('button', '生成音频', "", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
      var soundPeople, soundBlob;
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              // console.log('生成音频资源', this.properties.text, )
              soundPeople = textToSound.peopleSoundDit[_this15.properties.peopleSound];
              _this15.btnWidget.disabled = true;
              _context.next = 4;
              return VoiceGen.genSound({
                text: _this15.properties.text,
                vcn: soundPeople,
                speed: _this15.properties.speed,
                //语速：0对应默认语速的1/2，100对应默认语速的2倍
                volume: _this15.properties.volume,
                //音量：0是静音，1对应默认音量1/2，100对应默认音量的2倍
                pitch: _this15.properties.pitch,
                //语调：0对应默认语调的1/2，100对应默认语调的2倍
                bgs: _this15.properties.bgs == true ? 1 : 0 //是否有背景音，背景音：0无背景音（默认值），1有背景音

              });

            case 4:
              soundBlob = _context.sent;
              _this15.btnWidget.disabled = false;

              if (window.uploadGroupFile != null) {
                //上传文件到云端
                // window.setDropXY(this.pos[0] + this.width + 3, this.pos[1])
                window.uploadGroupFile([{
                  files: [soundBlob],
                  type: 'mp3',
                  name: _this15.properties.soundName,
                  x: _this15.pos[0] + _this15.width + 3,
                  y: _this15.pos[1]
                }]);
              }

            case 7:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    })));

    _this15.setSize(_this15.computeSize()); // this.addProperty("modal", 0, "number");
    // this.addWidget("slider", '振动强度', this.properties.modal, "modal", {min: 0, max: 1, precision: 0});
    //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this15;
  } // 当节点Toggle时调用


  var _proto11 = textToSound.prototype;

  _proto11.onAction = function onAction(action, param) {
    if (action == '生成') {}
  };

  return textToSound;
}(_litegraph.LGraphNode);

textToSound.title = '文本转音频';
textToSound.peopleSounds = ['聆飞逸', '聆小璇', '聆小玥', '聆玉昭', '聆玉言', '动漫少女'];
textToSound.peopleSoundDit = {
  '聆飞逸': 'x5_lingfeiyi_flow',
  '聆小璇': 'x5_lingxiaoxuan_flow',
  '聆小玥': 'x5_lingxiaoyue_flow',
  '聆玉昭': 'x5_lingyuzhao_flow',
  '聆玉言': 'x5_lingyuyan_flow',
  '动漫少女': 'x6_dongmanshaonv_pro'
};

_litegraph.LiteGraph.registerNodeType("output/textToSound", textToSound);

var vibrate = /*#__PURE__*/function (_LGraphNode12) {
  _inheritsLoose(vibrate, _LGraphNode12);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function vibrate() {
    var _this16;

    _this16 = _LGraphNode12.call(this) || this; // this.serialize_widgets = true

    _this16.title = "震动";
    _this16.desc = "调用设备振动";
    _this16.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式

    _this16.size = [80, 20]; //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")
    // this.addProperty("pageIndex", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","页码", this.properties.pageIndex ,"pageIndex", {precision: 0});  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)

    _this16.addInput("震动", _litegraph.LiteGraph.ACTION);

    _this16.addProperty("modal", 0, "number");

    _this16.addWidget("slider", '振动强度', _this16.properties.modal, "modal", {
      min: 0,
      max: 1,
      precision: 0
    }); //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this16;
  } // 当节点Toggle时调用


  var _proto12 = vibrate.prototype;

  _proto12.onAction = function onAction(action, param) {
    if (action == '震动') {
      if (this.properties.modal < 0.5) {
        CocosMgr.vibrate(false);
      } else {
        CocosMgr.vibrate(true);
      }
    }
  };

  return vibrate;
}(_litegraph.LGraphNode);

vibrate.title = '震动';

_litegraph.LiteGraph.registerNodeType("output/vibrate", vibrate);

var stopTime = /*#__PURE__*/function (_LGraphNode13) {
  _inheritsLoose(stopTime, _LGraphNode13);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function stopTime() {
    var _this17;

    _this17 = _LGraphNode13.call(this) || this; // this.serialize_widgets = true

    _this17.title = "停止时间";
    _this17.desc = "暂停游戏时间";
    _this17.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式

    _this17.size = [80, 30]; //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")
    // this.addProperty("pageIndex", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","页码", this.properties.pageIndex ,"pageIndex", {precision: 0});  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)

    _this17.addInput("停止", _litegraph.LiteGraph.ACTION);

    _this17.addInput("恢复", _litegraph.LiteGraph.ACTION); // this.addProperty("modal", 0, "number");
    // this.addWidget("slider", '振动强度', this.properties.modal, "modal", {min: 0, max: 1, precision: 0});
    //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this17;
  } // 当节点Toggle时调用


  var _proto13 = stopTime.prototype;

  _proto13.onAction = function onAction(action, param) {
    if (action == '停止') {
      this.graph.pause();
    } else if (action == '恢复') {
      this.graph.resume();
    }
  };

  return stopTime;
}(_litegraph.LGraphNode);

stopTime.title = '停止时间';

_litegraph.LiteGraph.registerNodeType("output/time/stopTime", stopTime);

var timeScale = /*#__PURE__*/function (_LGraphNode14) {
  _inheritsLoose(timeScale, _LGraphNode14);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function timeScale() {
    var _this18;

    _this18 = _LGraphNode14.call(this) || this; // this.serialize_widgets = true

    _this18.title = "时间缩放";
    _this18.desc = "加速或减慢时间效果";
    _this18.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式

    _this18.size = [80, 20]; //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型

    _this18.addInput("scale", "number");

    _this18.addProperty("scale", 1, 'number'); //增加一个变量，    变量名称， 变量名称


    _this18.addWidget("number", "缩放倍数", _this18.properties.scale, "scale", {
      precision: 1,
      min: 0
    }); //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)


    _this18.addInput("修改", _litegraph.LiteGraph.ACTION); // this.addProperty("modal", 0, "number");
    // this.addWidget("slider", '振动强度', this.properties.modal, "modal", {min: 0, max: 1, precision: 0});
    //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定


    _this18.widgets_up = true; //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1

    return _this18;
  } // 当节点Toggle时调用


  var _proto14 = timeScale.prototype;

  _proto14.onAction = function onAction(action, param) {
    if (action == '修改') {
      var scale = this.properties.scale || 1;

      if (scale < 0) {
        scale = 1;
      }

      this.graph.config.timeScale = scale;
      this.graph.sendEventToAllNodes('onChangeTimeScale');
    }
  };

  return timeScale;
}(_litegraph.LGraphNode);

timeScale.title = '时间缩放';

_litegraph.LiteGraph.registerNodeType("output/time/timeScale", timeScale);

var autoRunRecordTouch = /*#__PURE__*/function (_LGraphNode15) {
  _inheritsLoose(autoRunRecordTouch, _LGraphNode15);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function autoRunRecordTouch() {
    var _this19;

    _this19 = _LGraphNode15.call(this) || this; // this.serialize_widgets = true
    // this.mode = LiteGraph;     //设置触发模式

    _this19.title = "自动点击";
    _this19.desc = "自动执行点击事件";
    _this19.size = [80, 20]; //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型

    _this19.addProperty('active', false, 'boolean');

    _this19.addWidget('toggle', '是否激活', _this19.properties.active, 'active');

    _this19.addProperty('recordTouch', [], 'array');

    _this19.widgets_up = true; //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1
    // this.getOutputNodes(0)

    return _this19;
  }

  var _proto15 = autoRunRecordTouch.prototype;

  _proto15.onStart = function onStart() {
    this.curRunStepIndex = -1;
  } //开始执行
  ;

  _proto15.onExecute = function onExecute() {
    if (this.properties.active == false) {
      //不激活自动点击操作事件
      return;
    }

    if (this.properties.recordTouch == null) {
      return;
    }

    var curTime = this.graph.getTime();

    if (this.properties.recordTouch[this.curRunStepIndex + 1] != null) {
      if (curTime > this.properties.recordTouch[this.curRunStepIndex + 1].time) {
        this.curRunStepIndex += 1;
        var stepData = this.properties.recordTouch[this.curRunStepIndex]; //{nodeId: this.getIdWithGraph(),  time: this.graph.getTime(), funcName: 'onClick'}

        var node = this.graph.getNodeById(stepData.nodeId);

        if (node != null) {
          if (node[stepData.funcName] != null) {
            node[stepData.funcName]();
          }
        }
      }
    }
  };

  return autoRunRecordTouch;
}(_litegraph.LGraphNode);

autoRunRecordTouch.title = '自动点击';

_litegraph.LiteGraph.registerNodeType("output/autoRunRecordTouch", autoRunRecordTouch);

cc._RF.pop();