"use strict";
cc._RF.push(module, '0f6fetaZjBCBYwf/0bFNJ0k', 'senser');
// Script/Common/LiteGraphCore/nodes/senser.js

"use strict";

var _litegraph = require("../../litegraph/litegraph");

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

// import * as CocosMgr from '../CocosMgr';
var contact = /*#__PURE__*/function (_LGraphNode) {
  _inheritsLoose(contact, _LGraphNode);

  // Name to show
  function contact() {
    var _this;

    _this = _LGraphNode.call(this) || this; // this.addProperty("time_in_ms", 1000);
    // this.serialize_widgets = true;
    // this.serialize_widgets = true;

    _this.title = "接触感应器";
    _this.desc = "检测物体相互接触";
    _this.size = [250, 50]; // let slot = this.addOutput("A", 'codeNode')
    // slot.dir = LinkDirection.DOWN
    // this.addOutput("B", 'codeNode')

    _this.addInput("检测目标物体", 'codeNode');

    _this.addInput("其它可接触物体", 'codeNode');

    _this.getOutputNodes(); // this.getInputNode()
    // cardacSolt:{index: 0, type: 'number', info: '等待检测对象'},
    // // this.addInput("触发",  LiteGraph.ACTION)
    // // this.addInput("减少",  LiteGraph.ACTION)
    // // this.addInput("重置",  LiteGraph.ACTION)
    // this.addOutput("key", 0)  
    // // this.addOutput("index", 'number') 
    // this.addOutput("value", 0)


    _this.addOutput("接触数量", 'number');

    _this.addOutput("最后接触物体", 'codeNode');

    _this.addOutput("接触时", _litegraph.LiteGraph.EVENT);

    _this.addOutput("离开时", _litegraph.LiteGraph.EVENT); // this.addProperty("开始值", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","开始值", 0, "开始值", {precision: 0});
    // this.addProperty("modal", '无限制', 'enum', {values: ['无限制', '范围限制', '循环', '来回']});   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("combo","模式",this.properties.modal,{ property: "modal", values:['无限制', '范围限制', '循环', '来回'] } );
    // this.addProperty("min", 1,  'number')
    // this.addWidget("number","最小值", 1, "min", {precision: 0});
    // this.addProperty("max", 10,  'number')
    // this.addWidget("number","最大值", 10, "max", {precision: 0});
    // this.addProperty("upStepmodal", '不乘以时间', 'enum', {values: ['乘以时间', '不乘以时间']});   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("combo","步进模式",this.properties.upStepmodal,{ property: "upStepmodal", values:['乘以时间', '不乘以时间'] } );
    // this.addProperty("stepValue", 1,  'number')
    // this.addWidget("number","步进数值", 1, "stepValue", {precision: 0});
    // this.updateWidght()
    // this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // 
    // this.properties.precision = 1


    _this.curContactNum = 0;
    _this.bindTrackCodeNode = [];
    return _this;
  }

  var _proto = contact.prototype;

  _proto.onGetInputs = function onGetInputs() {
    console.log('我调用了onGetOutputs');
    return [["其它可接触物体", "codeNode"]];
  };

  //   onGetOutputs() {
  //     console.log('我调用了onGetOutputs')
  //     return [["number", "string"]];
  //   };
  _proto.onStart = function onStart() {
    // this.repetDir = 1
    // this.value = this.getInputOrProperty("开始值") | 0
    this.bindTrackCodeNode = []; // let otherSolts = this.slots.filter((slot)=>{
    //     return slot.name == '其它可接触物体' && slot.link != null
    // })
    // let linkNodes = otherSolts.map((solt)=>{
    //     return this.graph.links.get(solt.link)
    // }).map((link)=>{
    //     return this.graph.getNodeById(link.origin_id)
    // })

    var linkCodeNodes = [];

    for (var i = 1; i < this.inputs.length; i++) {
      linkCodeNodes.push(this.getInputData(i));

      if (this.getInputData(i) != null) {
        this.bindTrackCodeNode.push(this.getInputData(i));
      }
    }

    console.log('当前链接的solts', linkCodeNodes); // var bindChildRobot = this.linkDatas.cardacSolt
    // for(var i = 0; i < bindChildRobot.length; i++){
    //     var robot = bindChildRobot[i].robot
    //     if(robot.codeNode != null){
    //         this.bindTrackCodeNode.push(robot.codeNode)
    //     }
    // }

    this.onBindCodeNode(this.getInputData(0));
  };

  _proto.onBindCodeNode = function onBindCodeNode(codeNode) {
    var _this2 = this;

    // this.addOutput("是否接触", 'number')
    // this.addOutput("接触对象", 'codeNode')
    console.log('开始监听接触对象', codeNode);

    if (this.codeNode != null) {
      //如果有绑定旧的codeNode，先删除旧的codeNode绑定的id
      this.codeNode.removeRobotListener('contact', this.getIdWithGraph());
      this.codeNode.removeRobotListener('uncontact', this.getIdWithGraph());
    }

    this.curContactNum = 0;
    this.setOutputData(0, this.curContactNum);
    this.codeNode = codeNode;

    if (codeNode == null) {
      return;
    }

    this.codeNode.addRobotListener('contact', this.getIdWithGraph(), function (value) {
      // console.log('物体接触了', value, this.bindTrackCodeNode.indexOf(value))
      if (_this2.bindTrackCodeNode.indexOf(value) != -1) {
        _this2.curContactNum += 1; //会传送最后一个接触的对象

        _this2.setOutputData(0, _this2.curContactNum);

        _this2.setOutputData(1, value);

        _this2.triggerSlot(2); //接触对象时触发

      }
    });
    this.codeNode.addRobotListener('uncontact', this.getIdWithGraph(), function (value) {
      if (_this2.bindTrackCodeNode.indexOf(value) != -1) {
        _this2.curContactNum -= 1;

        _this2.setOutputData(0, _this2.curContactNum);

        _this2.setOutputData(1, value);

        if (_this2.curContactNum <= 0) {
          _this2.curContactNum = 0;

          _this2.triggerSlot(3); //离开所有接触对象

        }
      }
    });
  };

  _proto.onStop = function onStop() {
    console.log('移除监听事件', this.codeNode, this.getIdWithGraph());

    if (this.codeNode != null) {
      //如果有绑定旧的codeNode，先删除旧的codeNode绑定的id
      this.codeNode.removeRobotListener('contact', this.getIdWithGraph());
      this.codeNode.removeRobotListener('uncontact', this.getIdWithGraph());
    }
  } // updateWidght(){
  //   var value = this.properties.modal
  //   if(value != '无限制'){
  //       this.widgets.map((widget)=>{
  //         if(widget.name == '最大值' || widget.name == '最小值'){
  //             widget.disabled = false
  //         }
  //       })
  //     }else{
  //       this.widgets.map((widget)=>{
  //         if(widget.name == '最大值' || widget.name == '最小值'){
  //             widget.disabled = true
  //         }
  //       })
  //     }
  // }
  // onWidgetChanged(name, value, old_value, widget){
  //   // console.log('onWidgetChanged', node, name, value, old_value)
  //   // this.isWidgetVisible
  //   if(name == '模式'){
  //       this.updateWidght()
  //   }
  // }
  // Function to call when the node is executed
  // onAction(action, param, options) {
  // };
  //   onExecute() {
  // var data = this.getInputData(0)
  // if(data !== undefined){
  //   if(data instanceof Array){
  //     for(var i = 0; i < data.length; i++){
  //       this.setOutputData(0, i)
  //       this.setOutputData(1, data[i])
  //       this.triggerSlot(2)
  //     }
  //   }else if(data instanceof Object){
  //     for(var key in data){
  //       this.setOutputData(0, key)
  //       this.setOutputData(1, data[key])
  //       this.triggerSlot(2)
  //     }
  //   }
  // }
  //   }
  ;

  return contact;
}(_litegraph.LGraphNode);

contact.title = '接触感应器'; // Register the node type

_litegraph.LiteGraph.registerNodeType("objects/objectSensor/contact", contact);

var position = /*#__PURE__*/function (_LGraphNode2) {
  _inheritsLoose(position, _LGraphNode2);

  // Name to show
  function position() {
    var _this3;

    _this3 = _LGraphNode2.call(this) || this; // this.addProperty("time_in_ms", 1000);
    // this.serialize_widgets = true;
    // this.serialize_widgets = true;

    _this3.title = "位置感应器";
    _this3.desc = "检测物体位置变化";
    _this3.size = [250, 50];
    _this3.mode = _litegraph.LiteGraph.ON_EVENT; // let slot = this.addOutput("A", 'codeNode')
    // slot.dir = LinkDirection.DOWN
    // this.addOutput("B", 'codeNode')

    _this3.addInput("目标物体", 'codeNode');

    _this3.addInput("修改x", 'number');

    _this3.addInput("修改y", 'number');

    _this3.addInput("触发", _litegraph.LiteGraph.ACTION); // this.addInput("其它可接触物体", 'codeNode')
    // this.getOutputNodes()
    // this.getInputNode()
    // cardacSolt:{index: 0, type: 'number', info: '等待检测对象'},
    // // this.addInput("触发",  LiteGraph.ACTION)
    // // this.addInput("减少",  LiteGraph.ACTION)
    // // this.addInput("重置",  LiteGraph.ACTION)
    // this.addOutput("key", 0)  


    _this3.addOutput("x", 'number');

    _this3.addOutput("y", 'number');

    _this3.addOutput("变化", _litegraph.LiteGraph.EVENT); // this.addOutput("value", 0)
    // this.addOutput("是否接触", 'number')
    // this.addOutput("接触对象", 'codeNode')
    // this.addOutput("接触时", LiteGraph.EVENT)
    // this.addOutput("离开时", LiteGraph.EVENT)


    _this3.addProperty("xRange", '[-999999, 999999]', 'text'); //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","x范围", 0, "xRange", {precision: 0});


    _this3.xRangeWidget = _this3.addWidget("text", "x范围", _this3.properties.xRange, "xRange");

    _this3.addProperty("yRange", '[-999999, 999999]', 'text'); //增加一个变量，    变量名称， 变量名称


    _this3.yRangeWidget = _this3.addWidget("text", "y范围", _this3.properties.yRange, "yRange"); // this.addWidget("number","y范围", 0, "yRange", {precision: 0});
    // this.addProperty("yRange", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","y范围", 0, "yRange", {precision: 0});
    // this.addProperty("modal", '无限制', 'enum', {values: ['无限制', '范围限制', '循环', '来回']});   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("combo","模式",this.properties.modal,{ property: "modal", values:['无限制', '范围限制', '循环', '来回'] } );
    // this.addProperty("min", 1,  'number')
    // this.addWidget("number","最小值", 1, "min", {precision: 0});
    // this.addProperty("max", 10,  'number')
    // this.addWidget("number","最大值", 10, "max", {precision: 0});

    _this3.addProperty("modal", '直接修改', 'enum', {
      values: ['直接修改', '增量修改']
    }); //增加一个变量，    变量名称， 变量名称


    _this3.addWidget("combo", "修改方式", _this3.properties.modal, {
      property: "modal",
      values: ['直接修改', '增量修改']
    }); // this.addProperty("stepValue", 1,  'number')
    // this.addWidget("number","步进数值", 1, "stepValue", {precision: 0});


    _this3.addProperty('rangeWithSize', false, 'boolean');

    _this3.addWidget('toggle', '范围包含节点尺寸', _this3.properties.rangeWithSize, 'resetWhenToggle'); // this.updateWidght()
    // this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // 
    // this.properties.precision = 1
    // this.curContactNum = 0
    // this.bindTrackCodeNode = []


    return _this3;
  }

  var _proto2 = position.prototype;

  _proto2.onPropertyChanged = function onPropertyChanged(name, value) {
    // console.log("onPropertyChanged", name, value)
    if (name == 'xRange' || name == 'yRange') {
      try {
        this['_' + name] = JSON.parse(value);
        this.boxcolor = "#AEA";
      } catch (err) {
        this.boxcolor = "red";
      }
    }
  };

  // onGetInputs() {
  //     console.log('我调用了onGetOutputs')
  //     return [["其它可接触物体", "codeNode"]];
  // };
  //   onGetOutputs() {
  //     console.log('我调用了onGetOutputs')
  //     return [["number", "string"]];
  //   };
  _proto2.onStart = function onStart() {
    this._xRange = JSON.parse(this.properties.xRange);
    this._yRange = JSON.parse(this.properties.yRange); // this.repetDir = 1
    // this.value = this.getInputOrProperty("开始值") | 0
    // this.bindTrackCodeNode = []
    // let otherSolts = this.slots.filter((slot)=>{
    //     return slot.name == '其它可接触物体' && slot.link != null
    // })
    // let linkNodes = otherSolts.map((solt)=>{
    //     return this.graph.links.get(solt.link)
    // }).map((link)=>{
    //     return this.graph.getNodeById(link.origin_id)
    // })
    // let linkCodeNodes = []
    // for(var i = 1; i < this.inputs.length; i++){
    //     linkCodeNodes.push(this.getInputData(i))
    //     if(this.getInputData(i) != null){
    //         this.bindTrackCodeNode.push(this.getInputData(i))
    //     }
    // }
    // console.log('当前链接的solts', linkCodeNodes)
    // var bindChildRobot = this.linkDatas.cardacSolt
    // for(var i = 0; i < bindChildRobot.length; i++){
    //     var robot = bindChildRobot[i].robot
    //     if(robot.codeNode != null){
    //         this.bindTrackCodeNode.push(robot.codeNode)
    //     }
    // }

    this.onBindCodeNode(this.getInputData(0));
  };

  _proto2.onBindCodeNode = function onBindCodeNode(codeNode) {
    var _this4 = this;

    // this.addOutput("是否接触", 'number')
    // this.addOutput("接触对象", 'codeNode')
    // console.log('开始监听接触对象', codeNode)
    if (this.codeNode != null) {
      //如果有绑定旧的codeNode，先删除旧的codeNode绑定的id
      this.codeNode.removeRobotListener('x', this.getIdWithGraph());
      this.codeNode.removeRobotListener('y', this.getIdWithGraph());
    }

    this.codeNode = codeNode;

    if (codeNode == null) {
      return;
    }

    this.codeNode.addRobotListener('x', this.getIdWithGraph(), function (value) {
      _this4.setOutputData(0, value);

      _this4.triggerSlot(2);
    });
    this.codeNode.addRobotListener('y', this.getIdWithGraph(), function (value) {
      _this4.setOutputData(1, value);

      _this4.triggerSlot(2);
    });
  };

  _proto2.onStop = function onStop() {
    this.codeNode = null;
  } // updateWidght(){
  //   var value = this.properties.modal
  //   if(value != '无限制'){
  //       this.widgets.map((widget)=>{
  //         if(widget.name == '最大值' || widget.name == '最小值'){
  //             widget.disabled = false
  //         }
  //       })
  //     }else{
  //       this.widgets.map((widget)=>{
  //         if(widget.name == '最大值' || widget.name == '最小值'){
  //             widget.disabled = true
  //         }
  //       })
  //     }
  // }
  // onWidgetChanged(name, value, old_value, widget){
  //   // console.log('onWidgetChanged', node, name, value, old_value)
  //   // this.isWidgetVisible
  //   if(name == '模式'){
  //       this.updateWidght()
  //   }
  // }
  // Function to call when the node is executed
  // onAction(action, param, options) {
  // };
  //触发模式来更新
  ;

  _proto2.onAction = function onAction() {
    if (this.codeNode == null) {
      return;
    }

    var x = this.getInputData(1);
    var y = this.getInputData(2);
    var xRange = this._xRange;
    var yRange = this._yRange; // console.log('x', x, xRange)

    if (x != null) {
      if (this.properties.rangeWithSize == true) {
        var addWidth = this.codeNode.anchorX * this.codeNode.width * Math.abs(this.codeNode.scaleX); // console.log('addWith', addWidth, xRange[0], this.codeNode.anchorX, this.codeNode.width, this.codeNode.scaleX)

        xRange = [xRange[0] + addWidth, xRange[1] - addWidth]; //当目标物体的宽高小于父节点的宽高，这样子是正常的

        if (xRange[1] < xRange[0]) {
          xRange[1] = xRange[1] + xRange[0];
          xRange[0] = xRange[1] - xRange[0];
          xRange[1] = xRange[1] - xRange[0];
        } // console.log('xRange new', xRange[0], xRange[1])
        //当目标物体的宽高大于父节点的宽高，这样子就不正常了

      }

      if (this.properties.modal == '增量修改') {
        if (this.codeNode.realX + x >= xRange[1]) {
          x = xRange[1] - this.codeNode.realX;
        } else if (this.codeNode.realX + x <= xRange[0]) {
          x = xRange[0] - this.codeNode.realX;
        }

        this.codeNode.realX = this.codeNode.realX + x;
      } else {
        if (x > xRange[1]) {
          x = xRange[1];
        }

        if (x < xRange[0]) {
          x = xRange[0];
        }

        this.codeNode.realX = x; // console.log('直接修改数值', x)
      }
    }

    if (y != null) {
      //修改y轴相关
      if (this.properties.rangeWithSize == true) {
        var addHeight = this.codeNode.anchorY * this.codeNode.height * Math.abs(this.codeNode.scaleY);
        yRange = [yRange[0] + addHeight, yRange[1] - addHeight];

        if (yRange[1] < yRange[0]) {
          yRange[1] = yRange[1] + yRange[0];
          yRange[0] = yRange[1] - yRange[0];
          yRange[1] = yRange[1] - yRange[0];
        }
      }

      if (this.properties.modal == '增量修改') {
        if (this.codeNode.realY + y >= yRange[1]) {
          y = yRange[1] - this.codeNode.realY;
        } else if (this.codeNode.realY + y <= yRange[0]) {
          y = yRange[0] - this.codeNode.realY;
        }

        this.codeNode.realY = this.codeNode.realY + y;
      } else {
        if (y > yRange[1]) {
          y = yRange[1];
        }

        if (y < yRange[0]) {
          y = yRange[0];
        }

        this.codeNode.realY = y;
      }
    }
  };

  return position;
}(_litegraph.LGraphNode);

position.title = '位置感应器'; // Register the node type

_litegraph.LiteGraph.registerNodeType("objects/objectSensor/position", position);

var publicListen = /*#__PURE__*/function (_LGraphNode3) {
  _inheritsLoose(publicListen, _LGraphNode3);

  // Name to show
  function publicListen() {
    var _this5;

    _this5 = _LGraphNode3.call(this) || this; // this.addProperty("time_in_ms", 1000);
    // this.serialize_widgets = true;
    // this.serialize_widgets = true;
    // this.size = [250, 50]

    _this5.title = "属性感应器";
    _this5.desc = "检测物体各种属性变化";
    _this5.mode = _litegraph.LiteGraph.ON_EVENT; // let slot = this.addOutput("A", 'codeNode')
    // slot.dir = LinkDirection.DOWN
    // this.addOutput("B", 'codeNode')

    _this5.addInput("目标物体", 'codeNode');

    _this5.addInput("修改值", 'number');

    _this5.addInput("触发", _litegraph.LiteGraph.ACTION); // this.addInput("其它可接触物体", 'codeNode')
    // this.getOutputNodes()
    // this.getInputNode()
    // cardacSolt:{index: 0, type: 'number', info: '等待检测对象'},
    // // this.addInput("触发",  LiteGraph.ACTION)
    // // this.addInput("减少",  LiteGraph.ACTION)
    // // this.addInput("重置",  LiteGraph.ACTION)
    // this.addOutput("key", 0)  


    _this5.addOutput("数值", 'number');

    _this5.addOutput("变化", _litegraph.LiteGraph.EVENT); // this.addOutput("value", 0)
    // this.addOutput("是否接触", 'number')
    // this.addOutput("接触对象", 'codeNode')
    // this.addOutput("接触时", LiteGraph.EVENT)
    // this.addOutput("离开时", LiteGraph.EVENT)


    _this5.addProperty("range", '[-999999, 999999]', 'text'); //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","范围", 0, "range", {precision: 0});


    _this5.rangeWidget = _this5.addWidget("text", "范围", _this5.properties.range, "range"); // this.addProperty("yRange", '[-999999, 999999]', 'text');   //增加一个变量，    变量名称， 变量名称
    // this.yRangeWidget = this.addWidget("text","y范围",this.properties.yRange,"yRange");
    // this.addWidget("number","y范围", 0, "yRange", {precision: 0});
    // this.addProperty("yRange", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","y范围", 0, "yRange", {precision: 0});

    _this5.addProperty("customKey", '透明度', 'enum', {
      values: publicListen.selectEnums
    }); //增加一个变量，    变量名称， 变量名称


    _this5.addWidget("combo", "监听信息", _this5.properties.customKey, {
      property: "customKey",
      values: publicListen.selectEnums
    }); // this.addProperty("min", 1,  'number')
    // this.addWidget("number","最小值", 1, "min", {precision: 0});
    // this.addProperty("max", 10,  'number')
    // this.addWidget("number","最大值", 10, "max", {precision: 0});


    _this5.addProperty("modal", '直接修改', 'enum', {
      values: ['直接修改', '增量修改']
    }); //增加一个变量，    变量名称， 变量名称


    _this5.addWidget("combo", "修改方式", _this5.properties.modal, {
      property: "modal",
      values: ['直接修改', '增量修改']
    }); // this.addProperty("stepValue", 1,  'number')
    // this.addWidget("number","步进数值", 1, "stepValue", {precision: 0});
    // this.addProperty('rangeWithSize', false, 'boolean')
    // this.addWidget('toggle', '范围包含节点尺寸', this.properties.rangeWithSize, 'resetWhenToggle')
    // this.updateWidght()
    // this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // 
    // this.properties.precision = 1
    // this.curContactNum = 0
    // this.bindTrackCodeNode = []


    return _this5;
  }

  var _proto3 = publicListen.prototype;

  _proto3.onPropertyChanged = function onPropertyChanged(name, value) {
    // console.log("onPropertyChanged", name, value)
    if (name == 'range') {
      try {
        this['_' + name] = JSON.parse(value);
        this.boxcolor = "#AEA";
      } catch (err) {
        this.boxcolor = "red";
      }
    }
  };

  // onGetInputs() {
  //     console.log('我调用了onGetOutputs')
  //     return [["其它可接触物体", "codeNode"]];
  // };
  //   onGetOutputs() {
  //     console.log('我调用了onGetOutputs')
  //     return [["number", "string"]];
  //   };
  _proto3.onStart = function onStart() {
    this._range = JSON.parse(this.properties.range); // this._yRange = JSON.parse(this.properties.yRange)
    // this.repetDir = 1
    // this.value = this.getInputOrProperty("开始值") | 0
    // this.bindTrackCodeNode = []
    // let otherSolts = this.slots.filter((slot)=>{
    //     return slot.name == '其它可接触物体' && slot.link != null
    // })
    // let linkNodes = otherSolts.map((solt)=>{
    //     return this.graph.links.get(solt.link)
    // }).map((link)=>{
    //     return this.graph.getNodeById(link.origin_id)
    // })
    // let linkCodeNodes = []
    // for(var i = 1; i < this.inputs.length; i++){
    //     linkCodeNodes.push(this.getInputData(i))
    //     if(this.getInputData(i) != null){
    //         this.bindTrackCodeNode.push(this.getInputData(i))
    //     }
    // }
    // console.log('当前链接的solts', linkCodeNodes)
    // var bindChildRobot = this.linkDatas.cardacSolt
    // for(var i = 0; i < bindChildRobot.length; i++){
    //     var robot = bindChildRobot[i].robot
    //     if(robot.codeNode != null){
    //         this.bindTrackCodeNode.push(robot.codeNode)
    //     }
    // }

    this.onBindCodeNode(this.getInputData(0));
  };

  _proto3.onBindCodeNode = function onBindCodeNode(codeNode) {
    var _this6 = this;

    // this.addOutput("是否接触", 'number')
    // this.addOutput("接触对象", 'codeNode')
    // console.log('开始监听接触对象', codeNode)
    var index = publicListen.selectEnums.indexOf(this.properties.customKey);

    if (index == -1) {
      console.warn('没有对应的可监听事件', this.properties.customKey);
      return;
    }

    var bindKey = publicListen.chooseKey[index];

    if (this.codeNode != null) {
      //如果有绑定旧的codeNode，先删除旧的codeNode绑定的id
      this.codeNode.removeRobotListener(bindKey, this.getIdWithGraph());
    }

    this.codeNode = codeNode;

    if (codeNode == null) {
      return;
    }

    this.codeNode.addRobotListener(bindKey, this.getIdWithGraph(), function (value) {
      _this6.setOutputData(0, value);

      _this6.triggerSlot(1);
    });
  };

  _proto3.onStop = function onStop() {
    this.codeNode = null;
  } // updateWidght(){
  //   var value = this.properties.modal
  //   if(value != '无限制'){
  //       this.widgets.map((widget)=>{
  //         if(widget.name == '最大值' || widget.name == '最小值'){
  //             widget.disabled = false
  //         }
  //       })
  //     }else{
  //       this.widgets.map((widget)=>{
  //         if(widget.name == '最大值' || widget.name == '最小值'){
  //             widget.disabled = true
  //         }
  //       })
  //     }
  // }
  // onWidgetChanged(name, value, old_value, widget){
  //   // console.log('onWidgetChanged', node, name, value, old_value)
  //   // this.isWidgetVisible
  //   if(name == '模式'){
  //       this.updateWidght()
  //   }
  // }
  // Function to call when the node is executed
  // onAction(action, param, options) {
  // };
  //触发模式来更新
  ;

  _proto3.onAction = function onAction() {
    if (this.codeNode == null) {
      return;
    }

    var value = this.getInputData(1);
    var index = publicListen.selectEnums.indexOf(this.properties.customKey);

    if (index == -1) {
      console.warn('没有对应的可监听事件', this.properties.customKey);
      return;
    }

    var bindKey = publicListen.chooseKey[index];

    if (bindKey != null) {
      var range = this._range;

      if (this.properties.modal == '增量修改') {
        if (this.codeNode[bindKey] + value >= range[1]) {
          value = range[1] - this.codeNode[bindKey];
        }

        if (this.codeNode[bindKey] + value <= range[0]) {
          value = range[0] - this.codeNode[bindKey];
        }

        this.codeNode[bindKey] = this.codeNode[bindKey] + value;
      } else {
        if (value > range[1]) {
          value = range[1];
        }

        if (value < range[0]) {
          value = range[0];
        }

        this.codeNode[bindKey] = value;
      }
    } else {
      this.codeNode[bindKey] = value;
    }
  };

  return publicListen;
}(_litegraph.LGraphNode);

publicListen.title = '属性感应器';
publicListen.selectEnums = ['透明度', '层级', '缩放X', '缩放Y', '长度', '高度', '显隐', '角度'];
publicListen.chooseKey = ['opacity', 'zIndex', 'scaleX', 'scaleY', 'width', 'height', 'active', 'angle']; // Register the node type

_litegraph.LiteGraph.registerNodeType("objects/objectSensor/publicListen", publicListen);

cc._RF.pop();