import { _decorator, Component, VideoPlayer, Asset, find, sys, director, log, __private, VideoClip } from 'cc';
const { ccclass, property } = _decorator;

@ccclass
export default class logoScene extends Component {
	@property(VideoPlayer)
	videoPlayer: VideoPlayer = null

	@property([VideoClip])
	videoClips: VideoClip[] = []

	private _idx = 0

	onLoad() {
		this.playVideo(this.videoClips[this._idx])
	}

	start() {
		if (sys.isBrowser) {
			let canvas = find('Canvas');
			canvas.on('touchstart', () => {
				if (!this.videoPlayer.isPlaying) {
					this.videoPlayer.play()
				}
			}, this);
		}
	}

	playVideo(asset: Asset) {
		this.videoPlayer.clip = asset as any
		this._idx++
	}

	onVideoPlayEvent(videoPlayer: VideoPlayer, eventType: __private._cocos_video_video_player_enums__EventType) {
		log('onVideoPlayEvent', eventType);
		if (eventType == VideoPlayer.EventType.COMPLETED) {
			if (this._idx < this.videoClips.length) {
				this.scheduleOnce(() => {
					this.playVideo(this.videoClips[this._idx])
				}, 0)
			} else {
				director.loadScene("game")
			}
		} else if (eventType == VideoPlayer.EventType.READY_TO_PLAY) {
			this.videoPlayer.play()
		}
	}
}
