
import { _decorator, Component, Node, SystemEventType, EventTouch, UITransform, Vec3, view, Animation} from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Move')
export class Move extends Component {

    @property({type: Node})
    sprite: Node = null!

    @property({type: Animation})
    animation: Animation = null!

    private _uiTransform: UITransform = null!
    private _minX: number = 0
    private _maxX: number = 0

    onLoad() {
        this._uiTransform = this.getComponent(UITransform)!
        this.sprite.on(SystemEventType.TOUCH_START, this.onTouchMove, this)
        this.sprite.on(SystemEventType.TOUCH_MOVE, this.onTouchMove, this)
        this.sprite.on(SystemEventType.TOUCH_END, this.onTouchMove, this)

        const halfScreen = view.getDesignResolutionSize().width / 2
        const ballWidth = this.sprite.getComponent(UITransform)!.width
        this._minX = ballWidth - halfScreen
        this._maxX = halfScreen - ballWidth        
    }

    public playAnimation(): void {
        this.animation.play()
    }

    private onTouchMove(evt: EventTouch): void {
        const localPos = evt.getUILocation()
        const newPos = this._uiTransform.convertToNodeSpaceAR(new Vec3(localPos.x, localPos.y))
        newPos.y = this.sprite.position.y
        newPos.z = this.sprite.position.z
        newPos.x = Math.min(Math.max(newPos.x, this._minX), this._maxX)       
        this.sprite.position = newPos
    }
}
