
import { _decorator, Component, Node, Label, director } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Preload')
export class Preload extends Component {
    @property({type: Label})
    private loadingNum: Label = null;

    start () {
        director.preloadScene('game',  this.onProgress.bind(this), this.OnSceneLoaded.bind(this))
    }

    private onProgress(completedCount, totalCount, item) {
        this.setProgress((completedCount / totalCount));
    }

    private setProgress(num: number) {
        this.loadingNum.string = `${Math.floor(num * 100)}%`;
    }

    private OnSceneLoaded(error) {
        if (error) {
            console.error(error);
            return;
        }

        director.loadScene('game', this.onLaunched.bind(this));
    }

    private onLaunched() {
    }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.0/manual/en/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.0/manual/en/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.0/manual/en/scripting/life-cycle-callbacks.html
 */
