import { _decorator, Component, Node, input, Input, EventKeyboard, KeyCode, PhysicsSystem2D, EPhysics2DDrawFlags, Prefab, instantiate, tween, Vec3, Quat } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Main')
export class Main extends Component {
    @property(Prefab)
    public prefet: Prefab |null = null;
    @property(Node)
    public space: Node |null = null;
    onLoad(){      
        PhysicsSystem2D.instance.debugDrawFlags = EPhysics2DDrawFlags.Aabb |
        EPhysics2DDrawFlags.Pair |
        EPhysics2DDrawFlags.CenterOfMass |
        EPhysics2DDrawFlags.Joint |
        EPhysics2DDrawFlags.Shape;
    }
    start() {
        let obj: Node;
        obj = instantiate(this.prefet);
        obj.parent = this.space;
        obj.position = new Vec3(0,960,0);        
        //一開始把物件設定進目標parent的時候剛體角度是正確的，但是只要之後一開始設定動畫旋轉或是直接調整該剛體角度，就會變成沒旋轉前的角度
        //如果將場景上的目標parent物件角度設成0就不會發生
        tween(obj)
        .to(5,{position:new Vec3(0,-960,0)})
        .to(5,{position:new Vec3(0,960,0)})
        .union()
        .repeatForever()
        .start();      

        tween(obj)
        .to(5,{eulerAngles:new Vec3(0,0,360)})  
        .to(5,{eulerAngles:new Vec3(0,0,0)}) 
        .union()            
        .repeatForever()
        .start();        
    }

    update(deltaTime: number) {
        
    }
 
}

