import { Director, director, ResolutionPolicy, screen, view } from "cc";

export default class GameManger {
    private static gm: GameManger = null;
    public static get instance() {
        if (!this.gm) {
            this.gm = new GameManger();
        }
        return this.gm;
    }
    private isInit: boolean = false;
    /**初始化 */
    public init() {
        let s = this;
        if (s.isInit) return;
        s.isInit = true;
        view.on("canvas-resize", s.resolution, s);
        director.on(Director.EVENT_AFTER_SCENE_LAUNCH, s.initScene, s);
    }

    private initScene() {
        let s = this;
        s.resolution();
    }

    /**更新游戏分辨率模式 */
    public resolution() {

        //改变分辨率
        console.log("改变分辨率");
        let size = screen.windowSize;
        if (size.width / size.height > 750 / 1334) {
            view.setResolutionPolicy(ResolutionPolicy.FIXED_HEIGHT);
        } else {
            view.setResolutionPolicy(ResolutionPolicy.FIXED_WIDTH);
        }
    }
}
