import { _decorator, Component, instantiate, Node, Prefab, size, tween, UIRenderer, UITransform, v3 } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('TestBug')
export class TestBug extends Component {
    @property(Prefab)
    prefab: Prefab
    @property(Node)
    content: Node
    /**被复制的对象 */
    public copyNode: Node = null;
    /**刷新对象 */
    public updateNode: Node = null;
    /**是否进行刷新 */
    public isUpdata: boolean = false;
    start() {
        this.scheduleOnce(() => {
            let node = new Node();
            let uiTrans = node.addComponent(UITransform);
            uiTrans.contentSize = size(400, 200)
            this.content.insertChild(node, 2);
            let scaleVal = 0;
            node.scale = v3(scaleVal, scaleVal, scaleVal);

            this.copyNode = instantiate(this.prefab);
            this.copyNode.setParent(node);
            this.copyNode.position = v3();

            this.updateNode = this.copy(this.copyNode);
            this.updateNode.setParent(this.node);
            this.isUpdata = true;

            //输出的这个节点的数据就有问题了，请查看
            console.warn(this.updateNode)

            tween(node).delay(1).to(0.3, { scale: v3(1, 1, 1) }).call(() => {
                node.scale = v3(1, 1, 1);
            }).start();
        }, 1)

    }

    private copy(copy: Node) {
        let node = instantiate(copy);
        node.removeAllChildren();
        copy.getComponent(UIRenderer).destroy();
        return node;
    }

    protected update(dt: number): void {
        if (this.isUpdata) {
            let scale = this.copyNode.worldScale.clone();
            this.updateNode.worldScale = scale;
            if (Number.isNaN(this.updateNode.scale.x)) {
            }
        }
    }
}

