import { _decorator, Button, Component, director, macro, Node, ResolutionPolicy, view ,screen, Size} from 'cc';
const { ccclass, property } = _decorator;

@ccclass('scene')
export class scene extends Component {
    @property(Node)
    public Node1: Node = null!;
    @property(Node)
    public Node2: Node = null!;
    @property(Node)
    public BtnNode1: Node = null!;
    @property(Node)
    public BtnNode2: Node = null!;
    start() {
        

        this.BtnNode1.on(Button.EventType.CLICK, this.onBtn1click, this);
        this.BtnNode2.on(Button.EventType.CLICK, this.onBtn2click, this);
        this.showNode1();
        
    }

    showNode1(){
        this.showPortrait()
        this.Node1.active = true;
        this.Node2.active = false;
        
    }

    showNode2(){
        this.showLandscape();
        this.Node1.active = false;
        this.Node2.active = true;
        
    }
    onBtn1click(){
        console.log("Btn1 clicked");
        //@ts-ignore
        if(wx){
            //@ts-ignore
            wx.setDeviceOrientation({
                value: 'landscape',
                complete: (res) => {
                    // this.showNode2();
                    director.loadScene("scene2");
                    console.log('setDeviceOrientation success', res);
                },
            });
        }
    }

    onBtn2click(){
        console.log("Btn2 clicked");
        //@ts-ignore
        if(wx){
            //@ts-ignore
            wx.setDeviceOrientation({
                value: 'portrait',
                complete: (res) => {
                    this.showNode1();
                    console.log('setDeviceOrientation success', res);
                },
            });
        }
    }

    showLandscape(){
        view.setOrientation(macro.ORIENTATION_LANDSCAPE);
        view.setDesignResolutionSize(1280, 720, ResolutionPolicy.FIXED_WIDTH);
        screen.windowSize = new Size(1280, 720);
    }
    showPortrait(){
        view.setOrientation(macro.ORIENTATION_PORTRAIT);
        view.setDesignResolutionSize(720, 1280, ResolutionPolicy.FIXED_HEIGHT);
        screen.windowSize = new Size(720, 1280);
    }


    update(deltaTime: number) {
        
    }
}

