import { _decorator, AudioClip, Component, Node, resources } from 'cc';
import AudioEngine from './AudioEngine';
const { ccclass, property } = _decorator;

@ccclass('Main')
export class Main extends Component {
    playMusic() {
        resources.load('win', AudioClip, (err, clip) => {
            AudioEngine.inst.playMusic(clip);
        });
    }

    start() {
        this.node.on(Node.EventType.TOUCH_START, this.playMusic, this, true);
        this.playMusic();
    }
}

