System.register(["cc"], function (_export, _context) {
  "use strict";

  var _cclegacy, __checkObsolete__, __checkObsoleteInNamespace__, AudioSource, Node, Audio, _crd;

  _export("default", void 0);

  return {
    setters: [function (_cc) {
      _cclegacy = _cc.cclegacy;
      __checkObsolete__ = _cc.__checkObsolete__;
      __checkObsoleteInNamespace__ = _cc.__checkObsoleteInNamespace__;
      AudioSource = _cc.AudioSource;
      Node = _cc.Node;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "a40e7emzaxEXKUMqM7SQR28", "Audio", undefined);

      __checkObsolete__(['AudioClip', 'AudioSource', 'Node']);

      _export("default", Audio = class Audio {
        constructor() {
          this.volume = 1;
          this.volumeScale = 1;
          this.mute = false;
          this.endedCallback = null;
          this.startedCallback = null;
          this.audioSource = null;
          const node = new Node('audio');
          this.audioSource = node.addComponent(AudioSource);
          node.on(AudioSource.EventType.ENDED, this.onAudioEnded, this);
          node.on(AudioSource.EventType.STARTED, this.onAudioStarted, this);
        }

        onAudioEnded() {
          if (this.endedCallback) {
            const endedCallback = this.endedCallback;
            this.endedCallback = null;
            endedCallback();
          }
        }

        onAudioStarted() {
          if (this.startedCallback) {
            const startedCallback = this.startedCallback;
            this.startedCallback = null;
            startedCallback();
          }
        }

        play(clip, onEnded = null, onStarted = null) {
          this.audioSource.clip = clip;
          this.endedCallback = onEnded;
          this.startedCallback = onStarted;
          this.audioSource.play();
          return this;
        }

        stop() {
          this.audioSource.stop();
          this.audioSource.node.emit(AudioSource.EventType.ENDED);
          return this;
        }

        pause() {
          this.audioSource.pause();
          return this;
        }

        resume() {
          this.audioSource.play();
          return this;
        }

        setVolume(volume = 1, scale) {
          this.volume = volume;
          if (typeof scale === 'number') this.volumeScale = scale;
          this.audioSource.volume = volume * this.volumeScale * (this.mute ? 0 : 1);
          return this;
        }

        getVolume() {
          return this.volume;
        }

        setVolumeScale(scale = 1) {
          this.volumeScale = scale;
          this.audioSource.volume = this.volume * scale * (this.mute ? 0 : 1);
          return this;
        }

        getVolumeScale() {
          return this.volumeScale;
        }

        setLoop(loop) {
          this.audioSource.loop = loop;
          return this;
        }

        getLoop() {
          return this.audioSource.loop;
        }

        setMute(mute = true) {
          this.mute = mute;
          this.setVolume(this.volume);
          return this;
        }

        getMute() {
          return this.mute;
        }

        onEnded(endedCallback) {
          this.endedCallback = endedCallback;
          return this;
        }

        clear() {
          this.volume = 1;
          this.volumeScale = 1;
          this.mute = false;
          this.endedCallback = null;
          this.startedCallback = null;

          if (this.audioSource) {
            this.audioSource.stop();
            this.audioSource.volume = 1;
            this.audioSource.clip = null;
            this.audioSource.loop = false;
          }

          return this;
        }

        destroy() {
          this.clear();
          this.audioSource.destroy();
          this.audioSource.node.destroy();
          this.audioSource = null;
        }

      });

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=ae6c8dd2cc296cc1cefa50305f1b9b65434ac157.js.map