/*
 * Decompiled with CFR 0.152.
 */
package com.cocos.service;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.os.Bundle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public final class SDKWrapper {
    private WeakReference<Activity> mActivity = null;
    private List<SDKInterface> serviceInstances;

    private SDKWrapper() {
    }

    public static SDKWrapper shared() {
        return SDKWrapperInstance.mInstance;
    }

    private void loadSDKInterface() {
        ArrayList<SDKInterface> instances = new ArrayList<SDKInterface>();
        try {
            String json = this.getJson("service.json");
            JSONObject jsonObject = new JSONObject(json);
            JSONArray serviceClasses = jsonObject.getJSONArray("serviceClasses");
            if (serviceClasses == null) {
                return;
            }
            int length = serviceClasses.length();
            for (int i = 0; i < length; ++i) {
                instances.add((SDKInterface)Class.forName(serviceClasses.getString(i)).newInstance());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.serviceInstances = instances;
    }

    private String getJson(String fileName) {
        StringBuilder sb = new StringBuilder();
        try {
            String next;
            AssetManager am = ((Activity)this.mActivity.get()).getAssets();
            BufferedReader br = new BufferedReader(new InputStreamReader(am.open(fileName)));
            while (null != (next = br.readLine())) {
                sb.append(next);
            }
        }
        catch (IOException e) {
            sb.delete(0, sb.length());
        }
        return sb.toString().trim();
    }

    public Activity getActivity() {
        return (Activity)this.mActivity.get();
    }

    public void init(Activity activity) {
        this.mActivity = new WeakReference<Activity>(activity);
        this.loadSDKInterface();
        for (SDKInterface sdk : this.serviceInstances) {
            sdk.init((Context)activity);
        }
    }

    public void onResume() {
        for (SDKInterface sdk : this.serviceInstances) {
            sdk.onResume();
        }
    }

    public void onPause() {
        for (SDKInterface sdk : this.serviceInstances) {
            sdk.onPause();
        }
    }

    public void onDestroy() {
        for (SDKInterface sdk : this.serviceInstances) {
            sdk.onDestroy();
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        for (SDKInterface sdk : this.serviceInstances) {
            sdk.onActivityResult(requestCode, resultCode, data);
        }
    }

    public void onNewIntent(Intent intent) {
        for (SDKInterface sdk : this.serviceInstances) {
            sdk.onNewIntent(intent);
        }
    }

    public void onRestart() {
        for (SDKInterface sdk : this.serviceInstances) {
            sdk.onRestart();
        }
    }

    public void onStop() {
        for (SDKInterface sdk : this.serviceInstances) {
            sdk.onStop();
        }
    }

    public void onBackPressed() {
        for (SDKInterface sdk : this.serviceInstances) {
            sdk.onBackPressed();
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        for (SDKInterface sdk : this.serviceInstances) {
            sdk.onConfigurationChanged(newConfig);
        }
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        for (SDKInterface sdk : this.serviceInstances) {
            sdk.onRestoreInstanceState(savedInstanceState);
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        for (SDKInterface sdk : this.serviceInstances) {
            sdk.onSaveInstanceState(outState);
        }
    }

    public void onStart() {
        for (SDKInterface sdk : this.serviceInstances) {
            sdk.onStart();
        }
    }

    public void onLowMemory() {
        for (SDKInterface sdk : this.serviceInstances) {
            sdk.onLowMemory();
        }
    }

    public static interface SDKInterface {
        default public void init(Context context) {
        }

        default public void onStart() {
        }

        default public void onPause() {
        }

        default public void onResume() {
        }

        default public void onStop() {
        }

        default public void onDestroy() {
        }

        default public void onRestart() {
        }

        default public void onNewIntent(Intent intent) {
        }

        default public void onActivityResult(int requestCode, int resultCode, Intent data) {
        }

        default public void onConfigurationChanged(Configuration newConfig) {
        }

        default public void onRestoreInstanceState(Bundle savedInstanceState) {
        }

        default public void onSaveInstanceState(Bundle outState) {
        }

        default public void onBackPressed() {
        }

        default public void onLowMemory() {
        }
    }

    private static class SDKWrapperInstance {
        private static final SDKWrapper mInstance = new SDKWrapper();

        private SDKWrapperInstance() {
        }
    }
}

