import { _decorator, Component, math, Node, UISkew, UITransform, view } from 'cc';
const { ccclass, property, requireComponent } = _decorator;

/**
 * spine阴影-rendertexture方案  
 * 保持阴影位置在spine脚底
 */
@ccclass('KeepRTPos')
export class KeepRTPos extends Component {
    @property(Node)
    targetSpineNode: Node = null;

    private _uiSkew: UISkew = null;
    private _sx: number = 1;

    protected onLoad(): void {
        this._uiSkew = this.getComponent(UISkew);
        this.targetSpineNode.on(Node.EventType.TRANSFORM_CHANGED, this.onChange, this);

        this._sx = Math.tan(math.toRadian(this._uiSkew.x));

        this.onChange();
    }

    private onChange(): void {
        this.node.x = this.targetSpineNode.y * this._sx;
    }
    
}


