import { _decorator, Component, EventTouch, Node, Vec2, screen, Vec3, sp, NodeEventType } from 'cc';
const { ccclass, property } = _decorator;

/**
 * 测试一些spine特殊表现效果
 */
@ccclass('LightLambert')
export class LightLambert extends Component {
    
    @property({type:Node, tooltip: '光源位置'})
    public lightNode: Node = null;

    @property({type:sp.Skeleton, tooltip: 'spine'})
    public spine: sp.Skeleton = null;

    start() {
        
        this.lightNode.on(NodeEventType.TRANSFORM_CHANGED, this.onTouchStart, this);
    }

    private _pos: Vec2 = new Vec2();
    onTouchStart() {
        this._pos.x = this.lightNode.x / screen.windowSize.width;
        this._pos.y = this.lightNode.y / screen.windowSize.height;

        this.spine.customMaterial.setProperty("lightPos", this._pos);
        // @ts-ignore
        this.spine.updateMaterial();
    }
}

