import { _decorator, Component, EventTouch, Node, Vec2, screen, Vec3, sp, NodeEventType, CCFloat, Color, Material, UITransform } from 'cc';
const { ccclass, property } = _decorator;

/**
 * 外描边-5pass版本
 * emm 简单测试而已
 */
@ccclass('Demo3Outline5Pass')
export class Demo3Outline5Pass extends Component {
    private _spine: sp.Skeleton;
    private _mat: Material = null;

    @property({ serializable: true })
    private _outlineWidth: number = 5.0;
    @property({ serializable: true })
    private _outlineColor: Color = new Color(0, 0, 0, 255);

    @property({type:CCFloat, tooltip: '描边宽度'})
    get outlineWidth(): number {
        return this._outlineWidth;
    }
    set outlineWidth(value: number) {
        if (this._outlineWidth !== value) {
            this._outlineWidth = value;
            this._onUpdateOutlineWidth();
        }
    }

    @property({type:Color, tooltip: '描边颜色'})
    get outlineColor(): Color {
        return this._outlineColor;
    }
    set outlineColor(value: Color) {
        if (this._outlineColor !== value) {
            this._outlineColor = value;
            this._onUpdateOutlineColor();
        }
    }

    @property({type:Material, tooltip: 'spine材质'})
    public material: Material = null;

    private _timer = null;
    start() {
        if (!this.enabled) return;
        
        this._spine = this.node.getComponent(sp.Skeleton);

        this._timer = setTimeout(() => {
            this._buildMaterial();
        }, 40);
    }

    public onDestroy(): void {
        if (this._timer) {
            clearTimeout(this._timer);
            this._timer = null;
        }
    }

    private _onUpdateOutlineWidth() {
        if (this._mat) {
            for (let index = 0; index < 4; index++) {
                this._mat.setProperty("outlineWidth", this._outlineWidth, index);
            }
            this._updateSpineMaterial();
        }
    }
    private _onUpdateOutlineColor() {
        if (this._mat) {
            for (let index = 0; index < 4; index++) {
                this._mat.setProperty("outlineColor", this._outlineColor, index);
            }
            this._updateSpineMaterial();
        }
    }
    private _updateSpineMaterial(): void {
        //@ts-ignore
        this._spine?.updateMaterial();
    }


    private _buildMaterial() {
        const mat = new Material();
        mat.copy(this.material);

        if (!mat) {
            console.error("[SpineShadowComp] buildMaterial error");
            return;
        }

        for (let index = 0; index < 4; index++) {
            mat.setProperty("outlineWidth", this._outlineWidth, index);
            mat.setProperty("outlineColor", this._outlineColor, index);
        }

        this._spine.customMaterial = mat;
        this._mat = this._spine.customMaterial;
    }
}

