import { _decorator, Component, EventTouch, Node, Vec2, screen, Vec3, sp, NodeEventType, CCFloat, Color, Material, UITransform, Sprite } from 'cc';
const { ccclass, property } = _decorator;

/**
 * 外描边-RenderTexture版本
 * emm 简单测试而已
 */
@ccclass('Demo3OutlineRT')
export class Demo3OutlineRT extends Component {
    private _sprite: Sprite;
    private _mat: Material = null;

    @property({ serializable: true })
    private _outlineWidth: number = 5.0;
    @property({ serializable: true })
    private _outlineColor: Color = new Color(0, 0, 0, 128);

    @property({type:CCFloat, tooltip: '描边宽度'})
    get outlineWidth(): number {
        return this._outlineWidth;
    }
    set outlineWidth(value: number) {
        if (this._outlineWidth !== value) {
            this._outlineWidth = value;
            this._onUpdateOutlineWidth();
        }
    }

    @property({type:Color, tooltip: '描边颜色'})
    get outlineColor(): Color {
        return this._outlineColor;
    }
    set outlineColor(value: Color) {
        if (this._outlineColor !== value) {
            this._outlineColor = value;
            this._onUpdateOutlineColor();
        }
    }

    private _timer = null;
    start() {
        if (!this.enabled) return;
        
        this._sprite = this.node.getComponent(Sprite);
        this._mat = this._sprite.customMaterial;
    }

    public onDestroy(): void {
        if (this._timer) {
            clearTimeout(this._timer);
            this._timer = null;
        }
    }

    private _onUpdateOutlineWidth() {
        if (this._mat) {
            for (let index = 0; index < 4; index++) {
                this._mat.setProperty("outlineWidth", this._outlineWidth, index);
            }
            
        }
    }
    private _onUpdateOutlineColor() {
        if (this._mat) {
            for (let index = 0; index < 4; index++) {
                this._mat.setProperty("outlineColor", this._outlineColor, index);
            }
        }
    }
}

