import { _decorator, Component, instantiate, Prefab, randomRangeInt, v3, Vec3 } from 'cc';

const { ccclass, property } = _decorator;

@ccclass('MonsterSpawner')
export class MonsterSpawner extends Component {
    // 怪物预制体
    @property({ type: Prefab })
    monsterPrefab: Prefab = null;

    // 生成计时器
    private timer: number = 0;

    // 存储怪物数量
    private monsterCount: number = 0;

    private static ins:MonsterSpawner;

    protected onLoad(): void {
        MonsterSpawner.ins = this;
    }

    public static GetMonsters()
    {
        return this.ins.node.children.slice();
    }

    public static ChongXinKaiShi()
    {
        let _ins = this.ins;
        _ins.timer = 0;
        _ins.monsterCount = 0;
        _ins.node.destroyAllChildren();
    }

    update(deltaTime: number) 
    {
        // 更新计时器
        this.timer += deltaTime;
        if(this.timer >= 0.1)
        {
            this.timer = 0; // 重置计时器
            MonsterSpawner.spawnMonster(false);
        }
    }

    // 生成怪物的方法
    public static async spawnMonster(_isBoss) 
    {
        let _ins = this.ins;
        let _prefab =_ins.monsterPrefab;
        let _newMonster = instantiate(_prefab);
        _newMonster.setParent(_ins.node); 
        let _pos:Vec3;
        _pos = v3();
        _ins.monsterCount ++;
        console.log("生成：" + _ins.monsterCount);
    }
}
