import { Config, FILETYPE } from "./Config";
import { EventConst } from "./EventConst";
import MovieinfoItem, { MovieinfoItemParam } from "./MovieinfoItem";
import ArchiveSystem from "./Utils/ArchiveSystem";
import { EventManager } from "./Utils/EventManager";
import List from "./Utils/List";


import { _decorator, assetManager, Component, EventTouch, Label,  native, Node, path,  Slider,  sys,  UITransform,  VideoClip, VideoPlayer, Widget } from 'cc';
const { ccclass, property } = _decorator;

@ccclass
export default class MovieInfoComp extends Component {
    @property(List)
    fileList: List = null;

    @property(VideoPlayer)
    video_player:VideoPlayer = null;

    @property(Label)
    lb_path: Label = null;

    @property(Node)
    node_info: Node = null;

    @property(Slider)
    movieSlider: Slider = null;

    movielistArr:[] = []
    selectMoveLink:Array<Boolean> = []
    listfiles:Array<string> = [];
    curPlayFileName = ""


    protected onLoad(): void { 
        Config.CurPath = Config.MovieRootPath;
        this.refreshUI();
        this.movieSlider.progress = 0;
        this.video_player.node.on(VideoPlayer.EventType.PLAYING,this.onVideoPlayerPlayingEvent,this);
        this.video_player.node.on(VideoPlayer.EventType.COMPLETED,this.onVideoPlayerPlayCompletedEvent,this);
        this.video_player.node.on(VideoPlayer.EventType.READY_TO_PLAY,this.onVideoReadyToPlay,this);
        EventManager.getInstance().on(EventConst.DOWNER_FILE_SUCESS,this.onDownerOneSucess,this);
    }
 
    protected onDestroy(): void {
        this.video_player.node.targetOff(this);
        EventManager.getInstance().targetOff(this);
    }

    refreshUI(){
        if (sys.isBrowser){
            return;
        }
        if (!native.fileUtils.isDirectoryExist(Config.CurPath)){
            native.fileUtils.createDirectory(Config.CurPath);
        }
        this.listfiles = native.fileUtils.listFiles(Config.CurPath);
        this.listfiles = this.listfiles.filter(v=>{
            return !(v.endsWith(".") || v.endsWith("/.") || v.endsWith("./") || v.endsWith("../") || v.endsWith("/.."))
        })
        this.listfiles.sort();
        this.fileList.numItems = this.listfiles.length;
        this.lb_path.string = Config.CurPath.replace(Config.MovieRootPath,"")
    }

    onMovieItemReader(node:Node,index){
        let filename = this.listfiles[index];
        let data:MovieinfoItemParam = {
            type: native.fileUtils.isDirectoryExist(filename) ? FILETYPE.DIR : FILETYPE.FILE,
            filename: filename,
            callback: this.onClickItem.bind(this),
        }
        node.getComponent(MovieinfoItem).dataChange(data)
    }

    onClickItem(data:MovieinfoItemParam,mvi:MovieinfoItem){
        let filename = path.basename(data.filename);
        if (native.fileUtils.isDirectoryExist(data.filename)){
            Config.CurPath = path.join(Config.CurPath,filename);
            this.refreshUI();
        }else if(path.extname(data.filename) == ".mp4"){
            this.onplay(data.filename);
        }
    }

    onDownerOneSucess(){
        this.refreshUI();
    }

    onplay(filename){
        assetManager.loadRemote<VideoClip>(filename,(err,ass:any)=>{
            if (err){
            }else{
                this.curPlayFileName = filename;
                this.video_player.resourceType = VideoPlayer.ResourceType.LOCAL;
                if (ass instanceof VideoClip){
                    this.video_player.clip = ass;
                    this.lb_path.string = "VideoClip"
                }else if (ass instanceof Array){
                    this.video_player.clip = ass[0];
                    this.lb_path.string = "Array"
                }
                // this.video_player.play();
            }
        })
    }
    //播放下一个视频
    onPlayNext(){
        let index = this.listfiles.findIndex(v=>{
            return v == this.curPlayFileName;
        })
        for (let i = index+1;i<this.listfiles.length-1;i++){
            if(path.extname(this.listfiles[i]) == ".mp4"){
                this.onplay(this.listfiles[i]);
            }
        }
    }

    inaaa = 0;
    private onVideoPlayerPlayingEvent(){
        this.inaaa++
        console.log("播放中...")
        this.lb_path.string = "播放中..." + this.inaaa
    }
    private onVideoPlayerPlayCompletedEvent(){
        console.log("播放中完成")
        this.lb_path.string = "播放完成"
    }

    private onVideoReadyToPlay(){
        this.lb_path.string = "准备好了"
        this.video_player.play();
    }
}