
## 功能特点
- 让Cocos Creator像Unity一样简单使用协程效果，快速实现分帧处理效果。


## 已适配平台

| H5   | 微信小游戏 | Android原生 | iOS原生 | 抖音小游戏 | OPPO小游戏 | vivo小游戏 |
| ---- | ---------| ----------- | -------|-------|-------|-------|
| ✔    | ✔        | ✔           | ✔       |✔       |✔       |✔       |

本资源仅支持测试通过平台，其他平台不做默认支持，请自行适配。


## 文档教程
- 按引擎版本把如下路径中的Coroutine.ts放到你的项目中。
|引擎|路径|Demo版本|
|--|--|--|
|3.x|Coroutine3x/assets/scripts/librarys/Coroutine.ts|3.7.1
|2.x|Coroutine2x/assets/Script/librarys/Coroutine.ts|2.4.6
```
    import Coroutine from "./Coroutine";
    class Test extends cc.Component{
        start(){
            //字符串调起方法
            Coroutine.instance.start(this,'_TestLog',{obj:1},'param2',null);

            //函数调起方法
            Coroutine.instance.start(this,this._TestLog,{obj:1},'param2',null);

            //字符串停止指定协程
            Coroutine.instance.stop(this,'_TestLog');

            //函数停用指定协程
            Coroutine.instance.stop(this,this._TestLog);

            //停用该component下所有协程
            Coroutine.instance.stop(this); 
        }

        private *_TestLog(p1:any,p2:any,p3:any){
            console.log('开始等待5秒');
            yield Coroutine.createWaitForSecond(5);
            console.log('开始等待10帧');
            yield Coroutine.createWaitForFrame(10);
            console.log('等待下一帧');
            yield;
            console.log('输出参数',p1,p2,p3)
        }
    }
```

## 使用注意
- 禁止在update函数中调用 Coroutine.instance.start．
- start与stop的第一个参数对像与函数必须同作用域，且对像必须继承cc.Component．
- 函数开头必须带有*号，否则和普通函数没有区别
- 启用线程后，若果只是component移除，但node节点仍然存在时，协程函数仍然有效，否则会自动停止。
- 每个协程只要内部不是死循环，执行完后会自动释放。
- 协程的执行时机与cc.Director.EVENT_AFTER_UPDATE一样。
- 协程不是线程，是在主线程跑的，所以两者可以互相卡死的。

## 联系作者
- 邮箱: tkhoi0128@gmail.com
- QQ: 2092403923

## 版权声明
- 该资源中的源代码可商业使用，商业授权范围仅限于在您自行开发的游戏作品中使用，不得进行任何形式的转售、租赁、传播等。

## 购买须知
- 本产品为付费虚拟商品，一经购买成功概不退款，请支付前谨慎确认购买内容。

## 更新声明
- 1.0 新发版本
