
## Feature Introduction
- Allows Cocos Creator to use coroutines as easily as Unity, quickly achieving frame-by-frame processing effects.

## Supported Platforms
| H5   | WeChat Games | Android Native | iOS Native | TikTok Games | OPPO Games | Vivo Games |
| ---- | ---------| ----------- | -------|-------|-------|-------|
| ✔    | ✔        | ✔           | ✔       |✔       |✔       |✔       |


## Documentation and Tutorials
- Place the Coroutine.ts from the following path into your project according to the engine version.
|Engine|Path|Demo Version| 
|--|--|--|  
|3.x|Coroutine3x/assets/scripts/librarys/Coroutine.ts|3.7.1|
|2.x|Coroutine2x/assets/Script/librarys/Coroutine.ts|2.4.6|
```
    import Coroutine from "./Coroutine";
    class Test extends cc.Component{
        start(){
            // Method invocation using a string
            Coroutine.instance.start(this,'_TestLog',{obj:1},'param2',null);

            // Method invocation using a function
            Coroutine.instance.start(this,this._TestLog,{obj:1},'param2',null);

            // Stop a specific coroutine using a string
            Coroutine.instance.stop(this,'_TestLog');

            // Stop a specific coroutine using a function
            Coroutine.instance.stop(this,this._TestLog);

            // Stop all coroutines under this component
            Coroutine.instance.stop(this); 
        }

        private *_TestLog(p1:any,p2:any,p3:any){
            console.log('开始等待5秒');
            yield Coroutine.createWaitForSecond(5);
            console.log('开始等待10帧');
            yield Coroutine.createWaitForFrame(10);
            console.log('等待下一帧');
            yield;
            console.log('输出参数',p1,p2,p3)
        }
    }
```

## Usage Notice
- Do not call Coroutine.instance.start in the update function.
- The first parameter object at function start/stop must be in the same scope, and the object must inherit from cc.Component.
- Functions must start with an asterisk (*), otherwise, there is no difference from ordinary functions.
- Once a coroutine is started, if only the component is removed but the node still exists, the coroutine function remains valid; otherwise, it will automatically stop.
- Each coroutine will automatically be released after execution unless there is an internal infinite loop.
- The execution timing of coroutines is the same as cc.Director.EVENT_AFTER_UPDATE.
- Coroutines are not threads; they run on the main thread, so they can block each other.

## Contact the Author
- Email: tkhoi0128@gmail.com
- QQ: 2092403923

## Copyright Statement
- The source code in this resource can be used commercially, but the commercial license is limited to use within your own game developments. It cannot be resold, rented, or distributed in any form.

## Purchase Notice
- This product is a paid virtual good and is non-refundable once purchased. Please confirm your purchase carefully before payment.##

## Update Statement
- 1.0 New release version