import Coroutine from "./librarys/Coroutine";

const { ccclass, property } = cc._decorator;

@ccclass
export default class Helloworld extends cc.Component {

    @property(cc.Label)
    label: cc.Label = null;

    @property
    text: string = '';

    start() {
        //字符串调用
        Coroutine.instance.start(this, '_displayText', 'hello coroutine, 协程文字!');
        //函数名调用
        Coroutine.instance.start(this, this._showLog, [5, 4, 2, 3, 4]);

        Coroutine.instance.start(this, this._test, 1);


        window['test'] = this
        this.test1()
        this.schedule(() => {
            this.test1()
        }, 10)
    }

    /**简单分帧显示文案 */
    private *_displayText(str: string) {
        const arr = Array.from(str);
        for (let i = 0; i < arr.length; ++i) {
            this.label.string = arr.slice(0, i).join('');
            if (i < Math.floor(arr.length / 2)) {
                yield;
            } else {
                yield Coroutine.createWaitForFrame(10);
            }
        }
    }
    /**按参数进行等待 */
    private *_showLog(timers: number[]) {
        console.log('showLog start');
        for (let i = 0; i < timers.length; ++i) {
            //按参数自定
            console.log(new Date().toTimeString(), `showLog==> idx:${i},start wait for ${timers[i]} sec`);
            yield Coroutine.createWaitForSecond(timers[i]);
            console.log(new Date().toTimeString(), `showLog==> idx:${i},wait for ${timers[i]} sec end`);
        }
    }
    test1() {
        Coroutine.instance.start(this, this._test);
    }
    test2() {
        Coroutine.instance.start(this, this._test2, cc.director._lastUpdate);
    }
    private *_test2(last) {
        let now = performance.now()
        console.log("_test2 " + (now - last))
    }
    private *_test() {
        let n = 0
        let lastUpdate = cc.director._lastUpdate
        let checkNext = function () {
            let now = performance.now()
            if (now - lastUpdate > 1000 / cc.game.getFrameRate()) {
                console.log("wait for next frame " + n)
                // n = 0
                return false
            } else {
                return true
            }
        }
        while (true) {
            n++
            if (!checkNext()) {
                yield;
            }
            lastUpdate = cc.director._lastUpdate
            if (n > 20000000) {
                console.log('done')
                break;
            }
        }
    }
    // update(dt){
    //     this.test2()
    // }
}
