const { ccclass, property } = cc._decorator;

@ccclass
export default class Wave2 extends cc.Component {

    @property(cc.Camera)
    camera: cc.Camera = null;

    @property(cc.Sprite)
    sprite: cc.Sprite = null;

    renderTex: cc.RenderTexture;

    start(): void {
        this.renderTex = new cc.RenderTexture();
        this.renderTex.initWithSize(cc.visibleRect.width, cc.visibleRect.height);
        this.camera.targetTexture = this.renderTex;

        this.sprite.getMaterial(0).define('CUSTOM_RT_FLIPY', true);
        this.sprite.spriteFrame = new cc.SpriteFrame(this.renderTex);
        // this.sprite.spriteFrame.setFlipY(true);
    }
}
