const basex = require('./basex')

const BASE58_ALPHABET = '123456789abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ'
const base58 = basex(BASE58_ALPHABET)

// encode set of parts Id.
// parts = base58('1,2,3,4,5,6')
// parts = base58('1,2,,4,,6')
const decode = (parts) => {
  const ids = Buffer.from(base58.decode(parts)).toString()
  return ids.split(',').map(s => s.trim().toLowerCase())
}

const encode = (...parts) => {
  return base58.encode(Buffer.from(parts.join(',')))
}

module.exports = {
  encode, decode
}
