
import { _decorator, Component, Node, Vec3, EventTouch } from 'cc';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = NewComponent
 * DateTime = Thu Dec 02 2021 15:01:23 GMT+0800 (中国标准时间)
 * Author = Koei
 * FileBasename = NewComponent.ts
 * FileBasenameNoExtension = NewComponent
 * URL = db://assets/NewComponent.ts
 * ManualUrl = https://docs.cocos.com/creator/3.3/manual/zh/
 *
 */
 
@ccclass('NewComponent')
export class NewComponent extends Component {
    // [1]
    // dummy = '';

    // [2]
    // @property
    // serializableDummy = 0;
    tempPos = new Vec3();
    start () {
        // [3]
        
    }

    onEnable(){
        this.node.on(Node.EventType.TOUCH_START,this._onTouchStart,this);
        this.node.on(Node.EventType.TOUCH_MOVE,this._onTouchMove,this);
        this.node.on(Node.EventType.TOUCH_CANCEL,this._onTouchCancel,this);
        this.node.on(Node.EventType.TOUCH_END,this._onTouchEnd,this);

    }
    onDisable(){
        this.node.off(Node.EventType.TOUCH_START,this._onTouchStart,this);
        this.node.off(Node.EventType.TOUCH_MOVE,this._onTouchMove,this);
        this.node.off(Node.EventType.TOUCH_CANCEL,this._onTouchCancel,this);
        this.node.off(Node.EventType.TOUCH_END,this._onTouchEnd,this);
    
        
    }
    _onTouchStart(event:EventTouch){
        console.log('_onTouchStart')

    }

    _onTouchMove(event:EventTouch){
        console.log('_onTouchMove')
        let tempPos = this.node.getPosition();
        this.node.setPosition(tempPos.x+event.getDeltaX(),tempPos.y+event.getDeltaY(),tempPos.z)
    }
    _onTouchCancel(event:EventTouch){
        console.log('_onTouchCancel')

    }
    _onTouchEnd(event:EventTouch){
        console.log('_onTouchEnd')
    }
    // update (deltaTime: number) {
    //     // [4]
    // }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.3/manual/zh/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.3/manual/zh/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.3/manual/zh/scripting/life-cycle-callbacks.html
 */
