import { _decorator, Component, error, EventTouch, instantiate, Node, Prefab, resources } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Main')
export class Main extends Component {
    @property(Node) layer2: Node = null!;

    pop: Node | undefined;
    start() {
        this.node.on(Node.EventType.TOUCH_END, this.onTouchEnd, this);
    }

    onTouchEnd(event: EventTouch) {
        console.log(event.target.name);

        if (event.target.name == `Button`) {
            resources.load(`prefab/pop`, Prefab, (err: Error | null, prefab: Prefab) => {
                if (err) {
                    error(`cannot found pop`)
                    return;
                }
                if (this.pop && this.pop.isValid) {
                    this.pop.destroy();
                }
                let pop = instantiate(prefab);
                pop.parent = this.layer2;
                this.pop = pop;

            })
        } 
    }

    update(deltaTime: number) {

    }
}


