import FileList from "./FileList.js";
import FileTool from "./FileTool.js";

const pngMeta = ".png.meta"

const I18PreloadData =   {
    "__type__": "",
    "_name": "",
    "_objFlags": 0,
    "__editorExtras__": {},
    "node": {
      "__id__": 0
    },
    "_enabled": true,
    "__prefab": null,
    "_infos": [],
    "_id": ""
};

const I18UrlInfoData = {
    "__type__": "I18UrlInfo",
    "url": "",
    "arrType": []
};

export class I18PreUrl {

    _assetDir = "";
    _cnDir = "";

    _assetFiles = [];
    _i18CmptType = "";
    _i18PreType = "";

    _mapCNRes = new Map();
    _mapUrlInfo = new Map();

    constructor( assetDir, cnDir, i18CmptType, i18PreType ){
        const self = this;
        self._assetDir = assetDir;
        self._i18CmptType = i18CmptType;
        self._i18PreType = i18PreType;
        self._cnDir = cnDir;
    }

    initData(){
        const self = this;
        self.initAsset( self._assetDir );
        self.initCNDir( self._cnDir );
    }

    initAsset( dir ){
        console.log( "-------init asset dir-------" );
        const self = this;
        self._assetFiles = [];
        
        const fl = new FileList();
        fl.initData( dir );
        const allScene = fl.filterByType( "scene" );
        for( const fileName of allScene ){
            self._assetFiles.push( fileName );
        }

        const allPrefab = fl.filterByType( "prefab" );
        for( const fileName of allPrefab ){
            self._assetFiles.push( fileName );
        }
    }

    getPngMetaUrl( fileName ){
        const idx = fileName.indexOf( pngMeta );
        if( idx > 0 ){
            return fileName.replace( pngMeta, "" );
        }
        return "";
    }

    initCNDir( dir ){
        console.log( "-------init cn dir-------" );
        const self = this;
        self._mapCNRes.clear();

        const fl = new FileList();
        fl.initData( dir );
        const arrFile = fl.filterByStr( pngMeta );
        for( const file of arrFile ){
            const fullPath = self._cnDir + file;
            const jsonData = FileTool.readJsonInFile( fullPath );
            if( jsonData == null ){
                console.log( "read json file error:" + fullPath );
                continue;
            }

            const uuid = jsonData[ "uuid" ];
            if( uuid == null ) continue;
            if( self._mapCNRes.get(uuid) != null ) continue;
            
            const url = self.getPngMetaUrl( file );
            if( url != "" ){
                self._mapCNRes.set( uuid, url );
            }

        }
    }

    addUrlInfo( mapInfo, url, key, count = 1, exctType = null ){
        let info = mapInfo.get( url );
        if( info == null ){
            info = {};
            info[ key ] = 0;
            info[ "exctType" ] = [];
            mapInfo.set( url, info );
        }

        if( info[key] != null ){
            info[key] += count;
        }else{
            info[key] = count;
        }

        if( exctType != null ){
            const arrExctType = info[ "exctType" ];
            if( arrExctType.indexOf(exctType) == -1 ){
                arrExctType.push( exctType );
            }
        }
    }

    addUrlByI18Cmpt( mapInfo, jsonData ){
        if( jsonData == null ) return;

        const self = this;
        const jsonType = jsonData[ "__type__" ];
        if( jsonType != self._i18CmptType ) return;
        const url = jsonData[ "_key" ];
        if( url == null || url == "" ) return;
        self.addUrlInfo( mapInfo, url, "i18Cmpt", 1, "cc.SpriteFrame" );
    }

    addUrlByI18Pre( mapInfo, jsonData ){
        if( jsonData == null ) return;

        const self = this;
        const urls = jsonData[ "_urls" ];
        if( !Array.isArray(urls) ) return;

        urls.forEach( (url)=>{
            self.addUrlInfo( mapInfo, url, "i18Pre", 1 );
        } );
    }

    addUrlByJsonData( mapInfo, jsonData ){
        if( jsonData == null ) return;

        const self = this;
        const jsonType = jsonData[ "__type__" ];
        if( jsonType != null ){
            if( jsonType == self._i18CmptType ) return;
            if( jsonType == self._i18PreType ) return;
            if( jsonType == "cc.Node" ) return;
            if( jsonType == "cc.Prefab" ) return;
            if( jsonType == "cc.Scene" ) return;
            if( jsonType == "cc.SceneAsset" ) return;
            if( jsonType == "cc.Camera" ) return;
            if( jsonType == "cc.UIOpacity" ) return;
            if( jsonType == "cc.UITransform" ) return;
            if( jsonType == "cc.Vec3" ) return;
            if( jsonType == "cc.Quat" ) return;
        }

        self.addUrlByUUID( mapInfo, jsonData );
    }

    addUrlByUUID( mapInfo, jsonData ){
        if( jsonData == null ) return;
        if( typeof jsonData != "object" ) return;

        const self = this;
        for( const k in jsonData ){
            if( k == "__uuid__" ){
                const value = jsonData[k];
                const idx = value.indexOf( "@" );
                let uuid = k;
                if( idx != -1 ){
                    uuid = value.substring( 0, idx );
                }

                const url = self._mapCNRes.get( uuid );
                if( url == null ) continue;
                self.addUrlInfo( mapInfo, url, "uuid", 1, jsonData["__expectedType__"] );
            }else{
                self.addUrlByUUID( mapInfo, jsonData[k] );
            }
        }
    }

    getI18PreCmpt( jsonData ){
        if( jsonData == null ) return null;
        if( !Array.isArray(jsonData) ) return null;

        const self = this;
        for( const jsData of jsonData ){
            if( jsData[ "__type__" ] == self._i18PreType ){
                return jsData;
            }
        }
        return null;
    }

    //深度拷贝
    clone(obj) {
        if (typeof obj !== 'object' || obj === null) {
            return obj;
        }

        let newObj = Array.isArray(obj)? [] : {};

        for (let key in obj) {
            newObj[key] = this.clone(obj[key]);
        }

        return newObj;
    }

    getFirstObjByType( jsonData, type ){
        if( jsonData == null ) return [ null, -1 ];
        if( !Array.isArray(jsonData) ) return [ null, -1 ];

        for( let idx=0; idx<jsonData.length; ++idx ){
            const obj = jsonData[ idx ];
            if( obj[ "__type__" ] == type ){
                return  [ obj, idx ];
            }
        }
        return [ null, -1 ];
    }

    getFirstNode( jsonData ){
        return this.getFirstObjByType( jsonData, "cc.Node" );
    }

    getFirstI18Pre( jsonData ){
        const self = this
        return self.getFirstObjByType( jsonData, self._i18PreType );
    }

    removeI18PreInJsonData( jsonData ){
        if( jsonData == null ) return false;
        if( !Array.isArray(jsonData) ) return false;

        const self = this;
        const firstI18Info = self.getFirstI18Pre( jsonData );
        if( firstI18Info[0] == null ) return false;

        const firstNodeInfo = self.getFirstNode( jsonData );
        if( firstNodeInfo[0] == null ) return false;

        const componets = firstNodeInfo[0][ "_components" ];
        for( let i=0; i<componets.length; ++i ){
            const cmpt = componets[ i ];
            if( cmpt["__id__"] == firstI18Info[1]  ){
                componets.splice( i, 1 );
                break;
            }
        }

        for( const info of firstI18Info[0][ "_infos" ] ){
            const idx = info[ "__id__" ];
            jsonData[ idx ] = {};
        }
        jsonData[ firstI18Info[1] ] = {};
        return true;
    }


    /**
     * @param { JsonObj } jsonData 
     * @param { [ { url:string, exctType:[string] } ] } arrUrlData 
     * @returns 
     */
    addI18PreToJsonData( jsonData, arrUrlData ){
        if( jsonData == null ) return false;
        if( !Array.isArray(jsonData) ) return false;
        if( arrUrlData.length <= 0 ) return false;

        const self = this;
        const firstNodeInfo = self.getFirstNode( jsonData );
        const nodeData = firstNodeInfo[0];
        if( nodeData == null ) return false;

        let currIdx = jsonData.length;
        nodeData[ "_components" ].push( { "__id__": currIdx } );
        currIdx += 1;

        const i18PreData = self.clone( I18PreloadData );
        i18PreData[ "__type__" ] = self._i18PreType;
        i18PreData[ "node" ][ "__id__" ] = firstNodeInfo[1];
        const arrData = [ i18PreData ];
        for( const urlInfo of arrUrlData ){
            i18PreData[ "_infos" ].push({ "__id__": currIdx });
            const i18UrlData = self.clone( I18UrlInfoData );
            i18UrlData.url = urlInfo.url;
            i18UrlData.arrType = urlInfo.exctType;
            arrData.push( i18UrlData );
            ++currIdx;
        }

        for( const data of arrData ){
            jsonData.push( data );
        }

        return true;
    }

    addI18PreToFile(){
        console.log( "-------add i18Pre-------" );
        const self = this
        const arrModifyFile = [];
        for( const fileName of self._assetFiles ){
            const arrJsonData = FileTool.readJsonInFile( self._assetDir + fileName );
            if( arrJsonData == null ) continue;
            if( !Array.isArray(arrJsonData) ){
                console.log( "arrJsonData is not a array" );
                continue;
            }

            /**
             * {
             *   "dir/url" : {
             *      i18Cmpt: 0,
             *      uuid: 0,
             *      exctType:[ "cc.SpriteFrame" ]
             *   }
             * }
             */
            const mapInfo = new Map();
            arrJsonData.forEach(( jsonData )=>{
                const type = jsonData[ "__type__" ];
                if( type == self._i18CmptType ){
                    self.addUrlByI18Cmpt( mapInfo, jsonData );
                }else if( type == self._i18PreType ){
                    //self.addUrlByI18Pre( mapInfo, jsonData );
                }else{
                    self.addUrlByJsonData( mapInfo, jsonData );
                }
            });

            const arrAddInfo = [];
            mapInfo.forEach( ( info, url )=>{
                if( info.i18Cmpt > 0 ) return;
                arrAddInfo.push( { url:url, exctType:info.exctType } );
            } );

            const bRemove = self.removeI18PreInJsonData( arrJsonData );
            const bAdd = self.addI18PreToJsonData( arrJsonData, arrAddInfo );

            if( bRemove || bAdd ){
                console.log( self._assetDir + fileName );
                FileTool.writeJsonToFile( self._assetDir + fileName, arrJsonData );
                arrModifyFile.push( self._assetDir + fileName );
            }
        }

        if( arrModifyFile.length > 0 ){
            console.log( "\n-------modify file list-------" );
            for( const name of arrModifyFile ){
                console.log( name );
            }
        }
    }

    run(){
        console.log( "===========start handle I18Pre===========" );
        const self = this;

        self.initData();
        self.addI18PreToFile();
        
        console.log( "\n===========Handle I18Pre finished===========" );
    }
}