import { I18ChangeBundle } from "./I18ChangeBundle.js";
import { I18CheckTxt } from "./I18CheckTxt.js";
import I18DeleteCmpt from "./I18DeleteCmpt.js";
import I18FindI18Key from "./I18FindI18Key.js";
import I18FindRichTxt from "./I18FindRichTxt.js";
import { I18PreUrl } from "./I18PreUrl.js";
import I18Texture from "./I18Texture.js";
import I18Texture2SpriteFrame from "./I18Texture2SpriteFrame.js";
import I18TxtInCreator from "./I18TxtInCreator.js";
import * as fs from "fs";

//美术目录
const _artPath = "D:/DOC/bountyHunter/CN/";

//项目Assets目录
const _projectAssetsPath = "D:/Project/bountyHunter/assets/";

//默认语言目录
const _defaultLanguageDir = "resources/EN/";

//目标语言目录
const _languageDir = "CN/";

//项目中所有多语言目录
const _allLanguageDir = [ "CN", "EN" ];

//I18Cmpt UUID
const _i18CmptType = "3fe30JOx/1KXL1kWSoLiFgZ";
const _i18CmptData =   {
    "__type__": _i18CmptType,
    "_name": "",
    "_objFlags": 0,
    "__editorExtras__": {},
    "node": {
        "__id__": 0
    },
    "_enabled": true,
    "__prefab": null,
    "_key": "",
    "_refresh": true,
    "_id": ""
};

//I18Preload UUID
const _i18PrelaodType = "e2a40vt9j1CXrlUAOi9ziYN";

const checkParams = function( ...params ){
    for( const param of params ){
        if( param == null || param == "" ){
            console.log( "please input params !" );
            return false;
        }
    }
    return true;
}


const printHelp = function(){
    const str = fs.readFileSync( "./README.txt", "utf-8" );
    console.log( str );
}

const doLabelInCreator = function(){
    const i18 = new I18TxtInCreator( _projectAssetsPath, _i18CmptData, _defaultLanguageDir + "txt.json" );
    i18.run();
}

const doTexture = function(){
    const i18 = new I18Texture();
    i18.init({
        artPath: _artPath,
        assetsPath: _projectAssetsPath,
        defaultDir: _defaultLanguageDir,
        languageDir: _languageDir,
        allLanguageDir: _allLanguageDir,
        i18CmptType: _i18CmptType,
        i18CmptData: _i18CmptData,
    });
    i18.run();
}

const doTexture2SpriteFrame = function( dir ){
    if( !checkParams( dir ) ) return;
    const i18 = new I18Texture2SpriteFrame( dir );
    i18.run();
}

const doFindRichTxt = function( dir ){
    if( !checkParams( dir ) ) return;

    const tool = new I18FindRichTxt( dir );
    tool.run();
}

const doFindI18Key = function( dir, key ){
    if( !checkParams( dir, key ) ) return;

    const tool = new I18FindI18Key( _projectAssetsPath, key );
    tool.setI18CmptType( _i18CmptType );
    tool.run();
}

const doDeleteCmpt = function( dir, cmptType, outFile ){
    if( !checkParams( dir, cmptType ) ) return;

    const tool = new I18DeleteCmpt( dir, cmptType, outFile );
    tool.run();
}

const doCheckTxt = function( txtFile1, txtFile2 ){
    if( !checkParams( txtFile1, txtFile2 ) ) return;

    const tool = new I18CheckTxt( txtFile1, txtFile2 );
    tool.run();
}

const doAddI18Pre = function( assetDir, cnDir ){
    if( !checkParams( assetDir, cnDir ) ) return;

    const tool = new I18PreUrl( assetDir, cnDir, _i18CmptType, _i18PrelaodType );
    tool.run();
}

const doChangeBundle = function( assetDir, defaultBundle, newBundleDir ){
    if( !checkParams( assetDir, defaultBundle, newBundleDir ) ) return;

    const tool = new I18ChangeBundle( assetDir, defaultBundle, newBundleDir );
    tool.run();
}

const params = process.argv.splice(2);
switch( params[0] ){
    case "AddI18Label":
        doLabelInCreator();
    break;

    case "ImportTexture":
        doTexture();
    break;

    case "Texture2Sprite":
        doTexture2SpriteFrame( params[1] );
    break;

    case "FindRichTxt":
        doFindRichTxt( params[1] );
    break;

    case "FindI18Key":
        doFindI18Key( params[1], params[2] );
    break;
    
    case "DeleteCmpt":
        doDeleteCmpt( params[1], params[2] );
    break;

    case "CheckTxt":
        doCheckTxt( params[1], params[2] );
    break;

    case "AddI18Pre":
        doAddI18Pre( params[1], params[2] );
    break;

    case "ChangeBundle":
        doChangeBundle( params[1], params[2], params[3] );
    break;

    default:
        printHelp();
        //doTexture();
}