import { _decorator, CapsuleCharacterController, Component, EventKeyboard, Input, input, KeyCode, math, Node } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('PlayerControlTs')
export class PlayerControlTs extends Component {
    private _selfControl:CapsuleCharacterController=null;
    private vel:math.Vec3=math.v3(0,-10,0);
    start() {
        input.on(Input.EventType.KEY_DOWN,(evt:EventKeyboard)=>{
            if(evt.keyCode==KeyCode.KEY_W){
               this.vel.z=-5;
            }else if(evt.keyCode==KeyCode.KEY_S){
                this.vel.z=5;
            }else if(evt.keyCode==KeyCode.KEY_A){
                this.vel.x=-5;
            }else if(evt.keyCode==KeyCode.KEY_D){
                this.vel.x=5;
            }

        },this);
        input.on(Input.EventType.KEY_UP,(evt:EventKeyboard)=>{
           this.vel.set(0,-10,0);
        },this);
    }

    protected onLoad(): void {
        this._selfControl=this.node.getComponent(CapsuleCharacterController);
    }

    update(deltaTime: number) {
        this._selfControl?.move(this.vel.clone().multiplyScalar(deltaTime));
    }
}


