const { ccclass, property } = cc._decorator;
 
@ccclass
export default class FollowSpot extends cc.Component {
  @property(cc.Node)
  shader: cc.Node = null;
  material: cc.Material = null;
  center: number[] = [0.5, 0.5];

  onLoad() {
    const renderComponent:cc.RenderComponent = this.shader.getComponent(cc.RenderComponent);
    this.material = renderComponent.getMaterial(0);

    console.log(this.material)

    this.material.setProperty('center', this.center);
    this.material.setProperty("radius", (this.shader.width / 10) / this.shader.width);

    this.shader.on(cc.Node.EventType.TOUCH_MOVE, this.touchMoveEvent, this);
  }
 
  touchMoveEvent(evt: cc.Event.EventTouch) {
    let position: cc.Vec2 = evt.getLocation();
    position = this.shader.convertToNodeSpaceAR(position);
    this.center[0] = position.x / this.shader.width;
    this.center[1] = 1 - (position.y / this.shader.height);
    this.material.setProperty('center', this.center);
  }
}