import { Button, Component, EventTouch, Node, _decorator } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('TestDoubleTouch')
export class TestDoubleTouch extends Component {
    isShowButton: boolean = false;

    touchNode: Node;
    buttonNode: Node;

    onLoad() {
        this.touchNode = this.node.getChildByName('Touch');
        this.buttonNode = this.node.getChildByName('Button');
    }

    start() {
        this.touchNode.on(Node.EventType.TOUCH_START, this.onTouchStart, this);
        this.touchNode.on(Node.EventType.TOUCH_END, this.onTouchEnd, this);

        this.buttonNode.active = false;
        this.buttonNode.on(Button.EventType.CLICK, () => {
            this.isShowButton = false;
            this.buttonNode.active = this.isShowButton;
        });
    }

    private onTouchStart(e: EventTouch) {
        console.log('==> onTouchStart id: ', e.getID(), e);

        if (!this.isShowButton) {
            this.isShowButton = true;
            this.scheduleOnce(() => {
                this.buttonNode.active = this.isShowButton;
            }, 0.5);
        }
    }

    private onTouchEnd(e: EventTouch) {
        console.log('==> onTouchEnd id: ', e.getID(), e);
    }
}
