
import { _decorator, Component, Node, Sprite, assetManager, ImageAsset, isValid, Texture2D } from 'cc';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = SpriteRoot
 * DateTime = Wed Mar 30 2022 21:49:52 GMT+0800 (中国标准时间)
 * Author = he258369
 * FileBasename = SpriteRoot.ts
 * FileBasenameNoExtension = SpriteRoot
 * URL = db://assets/scripts/SpriteRoot.ts
 * ManualUrl = https://docs.cocos.com/creator/3.4/manual/zh/
 *
 */
 
@ccclass('SpriteRoot')
export class SpriteRoot extends Component {
    // [1]
    // dummy = '';

    // [2]
    // @property
    // serializableDummy = 0;

    start () {
        // [3]

        // 修改 Sprite_2
        this.createBuilding('Sprite_2')
    }


    createBuilding(nodeName:string) {        
        const blockNode = this.node.getChildByName(nodeName);
        const url  = "https://img.zcool.cn/community/01824b59db07e3a80121ae0caa7f33.jpg@1280w_1l_2o_100sh.jpg";
        const sprite = blockNode.getComponent(Sprite)
        if (blockNode) {
            assetManager.loadRemote<ImageAsset>( url, (err, imageAsset) => {
                if (err) {
                    console.error('set sprite frame failed! err:', url, err);
                    return;
                }
                if (sprite && isValid(sprite)) {
                    const texture = new Texture2D();
                    texture.image = imageAsset;
                    sprite.spriteFrame.texture = texture

                }
            });
        } 
    }


    // update (deltaTime: number) {
    //     // [4]
    // }
}

