System.register(["__unresolved_0", "cc", "__unresolved_1", "__unresolved_2"], function (_export, _context) {
  "use strict";

  var _reporterNs, _cclegacy, AudioClip, assert, clamp01, warn, Configuration, ResourceUtil, AudioManager, _crd;

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  function _reportPossibleCrUseOfConfiguration(extras) {
    _reporterNs.report("Configuration", "./Configuration", _context.meta, extras);
  }

  function _reportPossibleCrUseOfResourceUtil(extras) {
    _reporterNs.report("ResourceUtil", "./ResourceUtil", _context.meta, extras);
  }

  _export("AudioManager", void 0);

  return {
    setters: [function (_unresolved_) {
      _reporterNs = _unresolved_;
    }, function (_cc) {
      _cclegacy = _cc.cclegacy;
      AudioClip = _cc.AudioClip;
      assert = _cc.assert;
      clamp01 = _cc.clamp01;
      warn = _cc.warn;
    }, function (_unresolved_2) {
      Configuration = _unresolved_2.Configuration;
    }, function (_unresolved_3) {
      ResourceUtil = _unresolved_3.ResourceUtil;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "dec00Hr0xVOZIk4xaRskl5D", "AudioManager", undefined);

      _export("AudioManager", AudioManager = class AudioManager {
        constructor() {
          _defineProperty(this, "soundVolume", 1);
        }

        static get instance() {
          if (this._instance) {
            return this._instance;
          }

          this._instance = new AudioManager();
          return this._instance;
        }

        // 初始化音量
        init(audioSource) {
          this.soundVolume = this.getConfiguration(false) ? 1 : 0;
          AudioManager._audioSource = audioSource;
        }
        /**
         * 获取音乐状态
         * @param isMusic 是否是音乐
         * @returns 
         */


        getConfiguration(isMusic) {
          let state;

          if (isMusic) {
            state = (_crd && Configuration === void 0 ? (_reportPossibleCrUseOfConfiguration({
              error: Error()
            }), Configuration) : Configuration).instance.getGlobalData('music');
          } else {
            state = (_crd && Configuration === void 0 ? (_reportPossibleCrUseOfConfiguration({
              error: Error()
            }), Configuration) : Configuration).instance.getGlobalData('sound');
          }

          return state === undefined || state === 'true' ? true : false;
        }
        /**
         * 播放音乐
         * @param {String} name 音乐名称可通过constants.AUDIO_MUSIC 获取
         * @param {Boolean} loop 是否循环播放
         */


        playMusic(loop) {
          const audioSource = AudioManager._audioSource;
          assert(audioSource, 'AudioManager not inited!');
          audioSource.loop = loop;

          if (!audioSource.playing) {
            audioSource.play();
          }
        }
        /**
         * 播放音效
         * @param {String} name 音效名称可通过constants.AUDIO_SOUND 获取
         */


        playSound(name) {
          const audioSource = AudioManager._audioSource;
          assert(audioSource, 'AudioManager not inited!'); //音效一般是多个的，不会只有一个

          let path = 'gamePackage/audio/sound/'; // if (name !== 'click') {
          //     path = 'gamePackage/' + path; //微信特殊处理，除一开场的音乐，其余的放在子包里头
          // }

          (_crd && ResourceUtil === void 0 ? (_reportPossibleCrUseOfResourceUtil({
            error: Error()
          }), ResourceUtil) : ResourceUtil).loadRes(path + name, AudioClip, (err, clip) => {
            if (err) {
              warn('load audioClip failed: ', err);
              return;
            }

            audioSource.playOneShot(clip, audioSource.volume ? this.soundVolume / audioSource.volume : 0);
          });
        }
        /**
         * 设置音乐的音量
         * @param flag 音量
         */


        setMusicVolume(flag) {
          const audioSource = AudioManager._audioSource;
          assert(audioSource, 'AudioManager not inited!');
          flag = clamp01(flag);
          audioSource.volume = flag;
        }
        /**
         * 设置音频的音量
         * @param flag 音量
         */


        setSoundVolume(flag) {
          this.soundVolume = flag;
        }
        /**
         * 打开音乐
         */


        openMusic() {
          this.setMusicVolume(0.8);
          (_crd && Configuration === void 0 ? (_reportPossibleCrUseOfConfiguration({
            error: Error()
          }), Configuration) : Configuration).instance.setGlobalData('music', 'true');
        }
        /**
         * 关闭音乐
         */


        closeMusic() {
          this.setMusicVolume(0);
          (_crd && Configuration === void 0 ? (_reportPossibleCrUseOfConfiguration({
            error: Error()
          }), Configuration) : Configuration).instance.setGlobalData('music', 'false');
        }
        /**
         * 打开音频
         */


        openSound() {
          this.setSoundVolume(1);
          (_crd && Configuration === void 0 ? (_reportPossibleCrUseOfConfiguration({
            error: Error()
          }), Configuration) : Configuration).instance.setGlobalData('sound', 'true');
        }
        /**
         * 关闭音频
         */


        closeSound() {
          this.setSoundVolume(0);
          (_crd && Configuration === void 0 ? (_reportPossibleCrUseOfConfiguration({
            error: Error()
          }), Configuration) : Configuration).instance.setGlobalData('sound', 'false');
        }

      });

      _defineProperty(AudioManager, "_instance", void 0);

      _defineProperty(AudioManager, "_audioSource", void 0);

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=AudioManager.js.map