System.register(["cc"], function (_export, _context) {
  "use strict";

  var _cclegacy, Camera, color, isValid, Node, RenderTexture, UITransform, RenderUtil, _crd;

  _export("default", void 0);

  return {
    setters: [function (_cc) {
      _cclegacy = _cc.cclegacy;
      Camera = _cc.Camera;
      color = _cc.color;
      isValid = _cc.isValid;
      Node = _cc.Node;
      RenderTexture = _cc.RenderTexture;
      UITransform = _cc.UITransform;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "47b43S/G+5N/IJ3CTlENdW3", "RenderUtil", undefined);

      /**
       * 渲染工具
       */
      _export("default", RenderUtil = class RenderUtil {
        /**
         * 获取节点的 RenderTexture
         * @param node 节点
         * @param out 输出
         */
        static getRenderTexture(node, out) {
          // 检查参数
          if (!isValid(node)) {
            return null;
          }

          if (!out || !(out instanceof RenderTexture)) {
            out = new RenderTexture();
          }

          const nodeUI = node.getComponent(UITransform); // 获取宽高

          const width = Math.floor(nodeUI.width),
                height = Math.floor(nodeUI.height); // 初始化 RenderTexture
          // out.initWithSize(width, height);
          // 创建临时摄像机用于渲染目标节点

          const cameraNode = new Node();
          cameraNode.parent = node;
          const camera = cameraNode.addComponent(Camera);
          camera.clearFlags |= Camera.ClearFlag.SOLID_COLOR;
          camera.clearColor = color(0, 0, 0, 0); // camera.zoomRatio = view.getVisibleSize().height / height;
          // 将节点渲染到 RenderTexture 中

          camera.targetTexture = out; // camera.render(node);
          // 销毁临时对象

          cameraNode.destroy(); // 返回 RenderTexture

          return out;
        }
        /**
         * 获取像素数据
         * @param node 节点
         * @param flipY 垂直翻转数据
         */


        static getPixelsData(node, flipY = true) {
          if (!isValid(node)) {
            return null;
          }

          const nodeUI = node.getComponent(UITransform); // 节点宽高

          console.log("nodeUI.width"), nodeUI.width;
          const width = Math.floor(nodeUI.width),
                height = Math.floor(nodeUI.height);
          console.log("width", width); // 创建临时摄像机用于渲染目标节点

          const cameraNode = new Node();
          console.log("width", width);
          cameraNode.parent = node;
          console.log("width", width);
          const camera = cameraNode.addComponent(Camera);
          console.log("width", width);
          camera.clearFlags |= Camera.ClearFlag.SOLID_COLOR;
          console.log("width", width);
          camera.clearColor = color(0, 0, 0, 0); // camera.zoomRatio = view.getVisibleSize().height / height;
          // 将节点渲染到 RenderTexture 中

          const renderTexture = new RenderTexture();
          console.log("width", width);
          renderTexture.initDefault();
          renderTexture.resize(width, height);
          console.log("renderTexture", renderTexture);
          console.log("camera", camera);
          camera.targetTexture = renderTexture;
          console.log("width", width); // camera.render(node);
          // 获取像素数据

          const pixelsData = renderTexture.readPixels();
          console.log("pixelsData", pixelsData); // 销毁临时对象并返回数据

          renderTexture.destroy();
          cameraNode.destroy(); // 垂直翻转数据

          if (flipY) {
            const length = pixelsData.length,
                  lineWidth = width * 4,
                  data = new Uint8Array(length);

            for (let i = 0, j = length - lineWidth; i < length; i += lineWidth, j -= lineWidth) {
              for (let k = 0; k < lineWidth; k++) {
                data[i + k] = pixelsData[j + k];
              }
            }

            return data;
          }

          return pixelsData;
        }
        /**
         * 垂直翻转图像数据
         * @param array 数据
         * @param width 行宽
         */


        static flipY(array, width) {
          const length = array.length,
                flipped = new Uint8Array(length);

          for (let i = 0, j = length - width; i < length; i += width, j -= width) {
            for (let k = 0; k < width; k++) {
              flipped[i + k] = array[j + k];
            }
          }

          return flipped;
        }

      });

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=RenderUtil.js.map