System.register(["__unresolved_0", "cc"], function (_export, _context) {
  "use strict";

  var _reporterNs, _cclegacy, _decorator, Prefab, SpriteFrame, Texture2D, error, instantiate, find, resources, isValid, assetManager, _dec, _class, _crd, ccclass, filePath, ResourceUtil;

  function _reportPossibleCrUseOfAssetType(extras) {
    _reporterNs.report("AssetType", "./Configuration", _context.meta, extras);
  }

  return {
    setters: [function (_unresolved_) {
      _reporterNs = _unresolved_;
    }, function (_cc) {
      _cclegacy = _cc.cclegacy;
      _decorator = _cc._decorator;
      Prefab = _cc.Prefab;
      SpriteFrame = _cc.SpriteFrame;
      Texture2D = _cc.Texture2D;
      error = _cc.error;
      instantiate = _cc.instantiate;
      find = _cc.find;
      resources = _cc.resources;
      isValid = _cc.isValid;
      assetManager = _cc.assetManager;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "44c12PgKOFNU4v75IN2oISI", "ResourceUtil", undefined);

      ({
        ccclass
      } = _decorator); // 文件路径

      filePath = 'https://topcity.oss-cn-hangzhou.aliyuncs.com';

      _export("ResourceUtil", ResourceUtil = (_dec = ccclass("ResourceUtil"), _dec(_class = class ResourceUtil {
        /**
         * 动态加载资源
         * @param url 资源路径
         * @param type 资源类型
         * @param callback 回调
         */
        static loadRes(url, type, callback) {
          if (type) {
            resources.load(url, type, (err, res) => {
              if (err) {
                error(err.message || err);

                if (callback) {
                  callback(err, res);
                }

                return;
              }

              if (callback) {
                callback(err, res);
              }
            });
          } else {
            resources.load(url, (err, res) => {
              if (err) {
                error(err.message || err);

                if (callback) {
                  callback(err, res);
                }

                return;
              }

              if (callback) {
                callback(err, res);
              }
            });
          }
        }
        /**
         * 获取地图
         * @param level 等级
         * @param callback 回调
         */


        static getMap(level, callback) {
          let levelStr = 'map'; //前面补0

          if (level >= 100) {
            levelStr += level;
          } else if (level >= 10) {
            levelStr += '0' + level;
          } else {
            levelStr += '00' + level;
          }

          this.loadRes(`gamePackage/map/config/${levelStr}`, null, (err, txtAsset) => {
            if (err) {
              callback(err, txtAsset);
              return;
            }

            const txt = txtAsset;
            let content = '';

            if (txt._file) {
              if (window['LZString']) {
                content = window['LZString'].decompressFromEncodedURIComponent(txt._file);
              }

              const objJson = JSON.parse(content);
              callback(null, objJson);
            } else if (txt.text) {
              if (window['LZString']) {
                content = window['LZString'].decompressFromEncodedURIComponent(txt.text);
              }

              const objJson = JSON.parse(content);
              callback(null, objJson);
            } else if (txt.json) {
              callback(null, txt.json);
            } else {
              const errObj = new Error('failed');
              callback(errObj, null);
            }
          });
        }

        static getMapObjs(type, arrName, progressCallback, completeCallback) {
          let arrUrls = [];

          for (let idx = 0; idx < arrName.length; idx++) {
            arrUrls.push(`gamePackage/map/${type}/${arrName[idx]}`);
          }

          resources.load(arrUrls, Prefab, progressCallback, completeCallback);
        }
        /**
         * 获取预制体资源
         * @param prefabsPath 预制体路径
         * @param callback 
         */


        static getUIPrefabRes(prefabsPath, callback) {
          this.loadRes("prefabs/ui/" + prefabsPath, Prefab, callback);
        }
        /**
         * 创建UI
         * @param path UI路径
         * @param callback 
         * @param parent 父节点
         */


        static createUI(path, callback, parent) {
          this.getUIPrefabRes(path, (err, prefabs) => {
            if (err) return;
            const node = instantiate(prefabs);
            node.setPosition(0, 0, 0);

            if (!parent) {
              parent = find("Canvas");
            }

            parent.addChild(node);

            if (callback) {
              callback(null, node);
            }
          });
        }
        /**
         * 获取一些
         * @param arrName 
         * @param progressCallback 进度条
         * @param completeCallback 完成
         */


        static getCarsBatch(arrName, progressCallback, completeCallback) {
          let arrUrls = [];

          for (let idx = 0; idx < arrName.length; idx++) {
            arrUrls.push(`prefabs/car/car${arrName[idx]}`);
          }

          for (let i = 0; i < arrUrls.length; i++) {
            const url = arrUrls[i];

            if (!progressCallback) {
              resources.load(url, Prefab, completeCallback);
            } else {
              resources.load(url, Prefab, progressCallback, completeCallback);
            }
          }
        }
        /**
         * 获取本地JSON文件内容
         * @param fileName 文件名称
         * @param callback 
         */


        static getJsonData(fileName, callback) {
          resources.load("datas/" + fileName, (err, content) => {
            if (err) {
              error(err.message || err);
              return;
            }

            const txt = content;

            if (txt.json) {
              callback(err, txt.json);
            } else {
              const errObj = new Error('failed!!!');
              callback(errObj, null);
            }
          });
        }
        /**
         * 获取内容
         * @param fileName 文件名称
         * @param callback 
         */


        static getData(fileName, callback) {
          resources.load("datas/" + fileName, function (err, content) {
            if (err) {
              error(err.message || err);
              return;
            }

            const txt = content;
            let text = txt.text;

            if (!text) {
              resources.load(content.nativeUrl, (err, content) => {
                text = content;
                callback(err, text);
              });
              return;
            }

            callback(err, text);
          });
        }
        /**
         * 给某一个节点设置精灵
         * @param path 路径
         * @param sprite 节点的精灵
         * @param callback 
         */


        static setSpriteFrame(path, sprite, callback) {
          this.loadRes(path + '/spriteFrame', SpriteFrame, (err, spriteFrame) => {
            if (err) {
              console.error('set sprite frame failed! err:', path, err);
              callback(err, spriteFrame);
              return;
            }

            if (sprite && isValid(sprite)) {
              sprite.spriteFrame = spriteFrame;
              callback(null, spriteFrame);
            }
          });
        }
        /**
         * 给某一个节点设置y远程精灵
         * @param path 路径
         * @param sprite 节点的精灵
         * @param callback 
         */


        static setReomteSpriteFrame(path, sprite, callback) {
          assetManager.loadRemote(path, (err, imageAsset) => {
            if (err) {
              console.error('set sprite frame failed! err:', path, err);

              if (callback) {
                callback(err, imageAsset);
              }

              return;
            }

            if (sprite && isValid(sprite)) {
              const texture = new Texture2D();
              texture.image = imageAsset;
              sprite.spriteFrame.texture = texture; // sprite.node.getComponent(UITransform).setContentSize(imageAsset.width, imageAsset.height)

              if (callback) {
                callback(null, imageAsset);
              }
            }
          });
        }
        /**
         * 根据英雄的文件名获取头像
         */


        static setRemoteImage(url, sprite, callback) {
          if (!url || !url.startsWith('http')) {
            return;
          }

          let suffix = "png";
          assetManager.loadAny([{
            url: url,
            type: suffix
          }], null, (err, image) => {
            if (err) {
              console.error('set avatar failed! err:', url, err);
              callback(err, image);
              return;
            }

            let texture = new Texture2D();
            texture.image = image;
            let spriteFrame = new SpriteFrame();
            spriteFrame.texture = texture;
            callback && callback(null, spriteFrame);
          });
        }
        /**
         * 设置更多游戏的游戏图标
         */


        static setGameIcon(game, sprite, callback) {
          if (game.startsWith('http')) {
            this.setRemoteImage(game, sprite, callback);
          } else {
            this.setSpriteFrame('gamePackage/textures/icons/games/' + game, sprite, callback);
          }
        }
        /**
         * 获取顾客预制体
         *
         * @static
         * @param {string} name
         * @param {Function} callback
         * @memberof ResourceUtil
         */


        static getCustomer(name, callback) {
          this.loadRes(`gamePackage/map/customer/customer${name}`, Prefab, callback);
        }

        static setCustomerIcon(name, sprite, callback) {
          let path = `gamePackage/texture/head/head${name}`;
          this.setSpriteFrame(path, sprite, callback);
        }

        static getEffect(name, callback) {
          this.loadRes(`prefabs/effect/${name}`, Prefab, callback);
        }

      }) || _class));

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=ResourceUtil.js.map