System.register(["__unresolved_0", "cc", "__unresolved_1"], function (_export, _context) {
  "use strict";

  var _reporterNs, _cclegacy, _decorator, find, isValid, ResourceUtil, _dec, _class, _class2, _temp, _crd, ccclass, property, SHOW_STR_INTERVAL_TIME, UIManager;

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  function _reportPossibleCrUseOfResourceUtil(extras) {
    _reporterNs.report("ResourceUtil", "./ResourceUtil", _context.meta, extras);
  }

  return {
    setters: [function (_unresolved_) {
      _reporterNs = _unresolved_;
    }, function (_cc) {
      _cclegacy = _cc.cclegacy;
      _decorator = _cc._decorator;
      find = _cc.find;
      isValid = _cc.isValid;
    }, function (_unresolved_2) {
      ResourceUtil = _unresolved_2.ResourceUtil;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "d0e0bL8eDRJhpIBAACNHEmx", "UIManager", undefined);

      // import { Toast } from "../ui/common/Toast";
      ({
        ccclass,
        property
      } = _decorator);
      SHOW_STR_INTERVAL_TIME = 800;

      _export("UIManager", UIManager = (_dec = ccclass("UIManager"), _dec(_class = (_temp = _class2 = class UIManager {
        constructor() {
          _defineProperty(this, "dictSharedPanel", {});

          _defineProperty(this, "dictLoading", {});

          _defineProperty(this, "arrPopupDialog", []);

          _defineProperty(this, "showToastTime", 0);
        }

        static get instance() {
          if (this._instance) {
            return this._instance;
          }

          this._instance = new UIManager();
          return this._instance;
        }
        /**
         * 显示单例界面
         * @param {String} panelPath
         * @param {Array} args
         * @param {Function} callback 回调函数，创建完毕后回调
         */


        showDialog(panelPath, args, callback) {
          if (this.dictLoading[panelPath]) {
            return;
          }

          let idxSplit = panelPath.lastIndexOf('/');
          let scriptName = panelPath.slice(idxSplit + 1);

          if (!args) {
            args = [];
          }

          if (this.dictSharedPanel.hasOwnProperty(panelPath)) {
            let panel = this.dictSharedPanel[panelPath];

            if (isValid(panel)) {
              panel.parent = find("Canvas");
              panel.active = true;
              let script = panel.getComponent(scriptName);

              if (script.show) {
                script.show.apply(script, args);
              }

              callback && callback(script);
              return;
            }
          }

          this.dictLoading[panelPath] = true;
          (_crd && ResourceUtil === void 0 ? (_reportPossibleCrUseOfResourceUtil({
            error: Error()
          }), ResourceUtil) : ResourceUtil).createUI(panelPath, (err, node) => {
            //判断是否有可能在显示前已经被关掉了？
            let isCloseBeforeShow = false;

            if (!this.dictLoading[panelPath]) {
              //已经被关掉
              isCloseBeforeShow = true;
            }

            this.dictLoading[panelPath] = false;

            if (err) {
              console.error(err);
              return;
            } // node.zIndex = 100;


            this.dictSharedPanel[panelPath] = node;
            let script = node.getComponent(scriptName);

            if (script.show) {
              script.show.apply(script, args);
            }

            callback && callback(script);

            if (isCloseBeforeShow) {
              //如果在显示前又被关闭，则直接触发关闭掉
              this.hideDialog(panelPath);
            }
          });
        }
        /**
         * 隐藏单例界面
         * @param {String} panelPath
         * @param {fn} callback
         */


        hideDialog(panelPath, callback) {
          if (this.dictSharedPanel.hasOwnProperty(panelPath)) {
            let panel = this.dictSharedPanel[panelPath];

            if (panel && isValid(panel)) {
              // let ani = panel.getComponent('animationUI');
              // if (ani) {
              //     ani.close(() => {
              //         panel.parent = null;
              //         if (callback && typeof callback === 'function') {
              //             callback();
              //         }
              //     });
              // } else {
              panel.parent = null;

              if (callback && typeof callback === 'function') {
                callback();
              } // }

            } else if (callback && typeof callback === 'function') {
              callback();
            }
          }

          this.dictLoading[panelPath] = false;
        }
        /**
         * 将弹窗加入弹出窗队列
         * @param {string} panelPath
         * @param {string} scriptName
         * @param {*} param
         */


        pushToPopupSeq(panelPath, scriptName, param) {
          let popupDialog = {
            panelPath: panelPath,
            scriptName: scriptName,
            param: param,
            isShow: false
          };
          this.arrPopupDialog.push(popupDialog);
          this.checkPopupSeq();
        }
        /**
         * 将弹窗加入弹出窗队列
         * @param {number} index
         * @param {string} panelPath
         * @param {string} scriptName
         * @param {*} param
         */


        insertToPopupSeq(index, panelPath, param) {
          let popupDialog = {
            panelPath: panelPath,
            param: param,
            isShow: false
          };
          this.arrPopupDialog.splice(index, 0, popupDialog); //this.checkPopupSeq();
        }
        /**
         * 将弹窗从弹出窗队列中移除
         * @param {string} panelPath
         */


        shiftFromPopupSeq(panelPath) {
          this.hideDialog(panelPath, () => {
            if (this.arrPopupDialog[0] && this.arrPopupDialog[0].panelPath === panelPath) {
              this.arrPopupDialog.shift();
              this.checkPopupSeq();
            }
          });
        }
        /**
         * 检查当前是否需要弹窗
         */


        checkPopupSeq() {
          if (this.arrPopupDialog.length > 0) {
            let first = this.arrPopupDialog[0];

            if (!first.isShow) {
              this.showDialog(first.panelPath, first.param);
              this.arrPopupDialog[0].isShow = true;
            }
          }
        }
        /**
         * 显示提示
         * @param {String} content
         * @param {Function} callback
         */


        showToast(content, callback) {
          var now = Date.now();

          if (now - this.showToastTime < SHOW_STR_INTERVAL_TIME) {
            var spareTime = SHOW_STR_INTERVAL_TIME - (now - this.showToastTime);
            const self = this;
            setTimeout(function (toastLabel, callback) {
              self._showToastAni(toastLabel, callback);
            }.bind(this, content, callback), spareTime);
            this.showToastTime = now + spareTime;
          } else {
            this._showToastAni(content, callback);

            this.showToastTime = now;
          }
        }
        /**
         * 内部函数
         * @param {String} content
         * @param {Function} callback
         */


        _showToastAni(content, callback) {
          // todo 临时添加方案，后期需要将这些代码移到具体界面
          (_crd && ResourceUtil === void 0 ? (_reportPossibleCrUseOfResourceUtil({
            error: Error()
          }), ResourceUtil) : ResourceUtil).getUIPrefabRes('common/Toast', (err, prefab) => {
            if (err) {
              return;
            } // let toastNode = PoolManager.instance.getNode(prefab!, find("Canvas")!) as Node;
            // let toastScript = toastNode.getComponent(Toast)!;
            // toastScript.show(content, callback);

          });
        }

      }, _defineProperty(_class2, "_instance", void 0), _temp)) || _class));

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=UIManager.js.map