System.register(["__unresolved_0", "cc", "__unresolved_1"], function (_export, _context) {
  "use strict";

  var _reporterNs, _cclegacy, Component, Util, NativeUtil, _crd;

  function _reportPossibleCrUseOfUtil(extras) {
    _reporterNs.report("Util", "./Util", _context.meta, extras);
  }

  _export("NativeUtil", void 0);

  return {
    setters: [function (_unresolved_) {
      _reporterNs = _unresolved_;
    }, function (_cc) {
      _cclegacy = _cc.cclegacy;
      Component = _cc.Component;
    }, function (_unresolved_2) {
      Util = _unresolved_2.Util;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "d2f7enJaspJFqzTO2jlzySb", "NativeUtil", undefined);

      _export("NativeUtil", NativeUtil = class NativeUtil extends Component {
        /**
        * 获取当前平台名称
        * @returns 平台的名称
        */
        static platformName() {
          var u = navigator.userAgent,
              app = navigator.appVersion;
          var isAndroid = u.indexOf('Android') > -1 || u.indexOf('Linux') > -1; //g

          var isIOS = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/); //ios终端

          if (isAndroid) {
            return 'android';
          } else {
            return 'ios';
          }
        }
        /**
           * 获取用户token
           */


        static getUserToken() {
          try {
            if (this.platformName() == 'android') {
              // @ts-ignore
              return android.getUserInfo();
            } else if (this.platformName() == 'ios') {
              // @ts-ignore
              return window.webkit.messageHandlers.getUserInfo.postMessage({});
            }
          } catch (error) {
            return (_crd && Util === void 0 ? (_reportPossibleCrUseOfUtil({
              error: Error()
            }), Util) : Util).getQueryVariable("token");
          }
        }
        /**
         * 跳转
         * @param name 名称
         * @param link 路径地址
         */


        static nativeJumpFn(name, link) {
          try {
            if (this.platformName() == 'android') {
              // @ts-ignore
              android.intoOtherActivity(name, link);
            } else if (this.platformName() == 'ios') {
              // @ts-ignore
              window.webkit.messageHandlers.calliOSNative.postMessage({
                type: name,
                url: link
              });
            }
          } catch (error) {
            window.location.href = link;
          }
        }
        /**
         * 跳转企业大楼
         * @param id ID
         * @param url 
         */


        static enterBuildingCheck(id, url) {
          try {
            if (this.platformName() == 'android') {
              // @ts-ignore
              android.enterBuildingCheck(id, url);
            } else if (this.platformName() == 'ios') {
              // @ts-ignore
              window.webkit.messageHandlers.enterBuildingCheck.postMessage({
                id: id,
                url: url
              });
            }
          } catch (error) {
            if (url) {
              window.location.href = url;
            }
          }
        }
        /**
         * 调用原生方法（初始化）
         */


        static nativeInitGame() {
          try {
            if (this.platformName() == 'android') {
              // @ts-ignore
              android.onMustUpdate();
            } else if (this.platformName() == 'ios') {
              // @ts-ignore
              window.webkit.messageHandlers.onFinished.postMessage({});
            }
          } catch (error) {}
        }
        /**
         * 进入某个页面
         * @param name 页面名称
         */


        static nativeEnterGame(name) {
          if (this.platformName() == 'android') {
            // @ts-ignore
            android.enterGame(name);
          } else if (this.platformName() == 'ios') {// @ts-ignore
          }
        }

      });

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=NativeUtil.js.map