
import { _decorator, Component, Node, Color, director, log, Director } from 'cc';
import { EDITOR } from 'cc/env';
const { ccclass, property } = _decorator;

function EVENT_AFTER_SCENE_LAUNCH() {
    if (EDITOR)
        console.log("EDITOR::EVENT_AFTER_SCENE_LAUNCH " + new Date().getTime());
    else
        console.log("RT::EVENT_AFTER_SCENE_LAUNCH " + new Date().getTime());
}


if (director.hasEventListener(Director.EVENT_AFTER_SCENE_LAUNCH, EVENT_AFTER_SCENE_LAUNCH)) {
    director.off(Director.EVENT_AFTER_SCENE_LAUNCH, EVENT_AFTER_SCENE_LAUNCH);
}

director.on(Director.EVENT_AFTER_SCENE_LAUNCH, EVENT_AFTER_SCENE_LAUNCH)


/**
 * Predefined variables
 * Name = Test
 * DateTime = Thu Dec 16 2021 17:50:51 GMT+0800 (中国标准时间)
 * Author = linruimin
 * FileBasename = test.ts
 * FileBasenameNoExtension = test
 * URL = db://assets/test.ts
 * ManualUrl = https://docs.cocos.com/creator/3.3/manual/zh/
 *
 */

@ccclass('Test')
export class Test extends Component {
    // [1]
    // dummy = '';

    // [2]
    // @property
    // serializableDummy = 0;
    @property(Color)
    _color: Color = new Color().fromHEX('0xffffff');
    @property(Color)
    get color() {
        return this._color;
    }
    set color(value) {
        this._color = value;
        this.delayInit();
    }

    count = 0;

    delayInit() {

        if (this.count == 5) {
            director.emit('fire');
        }

        this.count++;
        console.log('aa');
        let that = this;
        director.off('fire');
        director.on('fire', function () {
            log("fire in the hole" + that.count);
        }, this.node);
    }

    onDirect() {

    }

    // update (deltaTime: number) {
    //     // [4]
    // }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.3/manual/zh/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.3/manual/zh/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.3/manual/zh/scripting/life-cycle-callbacks.html
 */
