
cc.Class({
    extends: cc.Component,

    properties: {
        water: cc.Prefab,
        waterLayer: cc.Node,
        ground: cc.Node,

    },

    // LIFE-CYCLE CALLBACKS:

    onLoad() {
        //
        this._touchStartPos = cc.Vec2;
        this.polyEx = this.ground.getComponent("PhysicsCollider");
        //
        this.DIG_RADIUS = 50;
        this.DIG_FRAGMENT = 12;
        //
        this.DIG_OPTIMIZE_SIZE = 1;
        //
        //调节物理系统
        cc.macro.ENABLE_MULTI_TOUCH = false;
        let manager = cc.director.getPhysicsManager();
        manager.enabled = true;
        cc.director.getPhysicsManager().debugDrawFlags = true;
        manager.enabledAccumulator = true;
        cc.PhysicsManager.FIXED_TIME_STEP = 1 / 30;
        manager.VELOCITY_ITERATIONS = 8;
        manager.POSITION_ITERATIONS = 8;
        //
        this.registerEvent();
        //
        this.graphics = this.ground.getComponent(cc.Mask)['_graphics'];
        //
        // this.node.on("touchstart", this.creatWater, this);
    },
    start() {
        //

        this.scheduleOnce(() => {
            this.reset();
        }, 0.01)
        // this.schedule(this.creatWater, 0.5);
        // this.reset();
    },
    registerEvent() {
        this.ground.on("touchstart", this._touchStart, this);
        this.ground.on("touchmove", this._touchMove, this);
        this.ground.on("touchend", this._touchEnd, this);
        this.ground.on("touchcancel", this._touchEnd, this);
    },
    reset() {
        this.polyEx.init([
            [-cc.winSize.width / 2, -320], [-cc.winSize.width / 2, 250], [cc.winSize.width / 2, 250], [cc.winSize.width / 2, -320]
        ]);
        this.polyEx.polyDifference([], this.graphics);
    },
    _touchMove(touch) {
        let regions = [];
        let pos = this.graphics.node.convertToNodeSpaceAR(touch.getLocation());

        let count = this.DIG_FRAGMENT;
        if (!this._touchStartPos) {
            for (let index = 0; index < count; index++) {
                let r = 2 * Math.PI * index / count;
                let x = pos.x + this.DIG_RADIUS * Math.cos(r);
                let y = pos.y + this.DIG_RADIUS * Math.sin(r);
                regions.push(this._optimizePoint([x, y]));
            }
            this._touchStartPos = pos;
        } else {
            let delta = pos.sub(this._touchStartPos);
            // 手指移动的距离太小的话忽略
            if (delta.lengthSqr() > 25) {

                let startPos = this._touchStartPos;
                for (let index = 0; index < count; index++) {
                    let r = 2 * Math.PI * index / count;
                    let vec_x = this.DIG_RADIUS * Math.cos(r);
                    let vec_y = this.DIG_RADIUS * Math.sin(r);
                    let x, y;
                    if (delta.dot(cc.v2(vec_x, vec_y)) > 0) {
                        x = pos.x + vec_x;
                        y = pos.y + vec_y;
                    } else {
                        x = startPos.x + vec_x;
                        y = startPos.y + vec_y;
                    }
                    regions.push(this._optimizePoint([x, y]));
                }
                this._touchStartPos = pos;
            }
        }

        if (regions.length)
            this.polyEx.pushCommand('polyDifference', [regions, this.graphics]);
    },
    _touchStart(touch) {
        this._touchStartPos = undefined;
        this._touchMove(touch);
    },

    _touchEnd() {
        this._touchStartPos = undefined;
    },

    _optimizePoint(point) {
        return cc.v2(Math.floor(point[0] * this.DIG_OPTIMIZE_SIZE) / this.DIG_OPTIMIZE_SIZE, Math.floor(point[1] * this.DIG_OPTIMIZE_SIZE) / this.DIG_OPTIMIZE_SIZE);
    },
    debug() {
        cc.debug.setDisplayStats(!cc.debug.isDisplayStats());
        cc.director.getPhysicsManager().debugDrawFlags = cc.debug.isDisplayStats() ? 1 : 0;
    },
    creatWater(event) {
        let waterNum = 5;
        for (let i = 0; i < waterNum; i++) {
            let waterPre = cc.instantiate(this.water);
            waterPre.x = Math.random() * (cc.winSize.width - waterPre.width) + (-cc.winSize.width / 2 + waterPre.width / 2);
            waterPre.y = Math.random()
            this.waterLayer.addChild(waterPre);
        }
    },


    // update (dt) {},
});
