const { SSL_OP_NETSCAPE_CHALLENGE_BUG } = require("constants");

cc.Class({
    extends: cc.Component,

    editor: CC_EDITOR && {
        executeInEditMode: true,
    },
    
    properties: {
        spriteFrame: cc.SpriteFrame,
    },

    // LIFE-CYCLE CALLBACKS:

    onLoad() {
        this.radius = 50;
        this.vertCount = 12;
        // this.openStreak = false;
        //
        let renderer = this.node.getComponent(cc.MeshRenderer);
        if (!renderer) {
            renderer = this.node.addComponent(cc.MeshRenderer);
        }
        renderer.mesh = null;
        this.renderer = renderer;
        this._updateMaterial()
        cc.log(1)
        this._updateMesh();
        cc.log(2)
        this._applySpriteFrame();
        cc.log(3)
        this._applyVertexes();
        cc.log(4)

        // this.node.on('size-changed', () => {
        //     this._updateMesh();
        //     this._applyVertexes();
        // }, this);

    },

    start() {
        // this.schedule(this.streakShader, 0.1);
        // this.schedule(this.streak, 0.1);
    },
    streakShader() {
        let material = this.getMaterial(0);
        let velocity = this.node.getComponent(cc.RigidBody).velocity;
        material.setProperty("velocity", velocity);
    },
    _updateMesh() {
        //确定顶点坐标
        this._vertexes = [];
        let pos = this.node.position;
        //放入原点
        this._vertexes.push(pos);
        //画圆放点
        let rotateVec2 = cc.v2(0, this.radius);
        let angle = 2 * Math.PI / this.vertCount;
        for (let i = 0; i < this.vertCount; i++) {

            this._vertexes.push(cc.v2(pos.add(rotateVec2)));
            rotateVec2.rotateSelf(angle);

        };

        //绑定
        let gfx = cc.gfx;
        let mesh = new cc.Mesh();

        mesh.init(new gfx.VertexFormat([
            { name: gfx.ATTR_POSITION, type: gfx.ATTR_TYPE_FLOAT32, num: 2 },
            { name: gfx.ATTR_UV0, type: gfx.ATTR_TYPE_FLOAT32, num: 2 },
        ]), this._vertexes.length, true);

        this.mesh = mesh;
        this._updateMaterial();
    },
    _applySpriteFrame() {
        if (this.spriteFrame) {
            let texture = this.spriteFrame.getTexture();
            this.texture = texture;
            this._updateMaterial();
        }
    },
    _updateMaterial() {
        let material = this.renderer._materials[0];
        if (material) {
            if (this.texture) {
                // material.define("USE_TEXTURE", true);
                // material.setProperty('texture', this.texture);
            }
        }

        //设置uniform参数
        // material.setProperty()
    },
    _applyVertexes() {
        let mesh = this.mesh;
        let gfx = cc.gfx;
        mesh.setVertices(gfx.ATTR_POSITION, this._vertexes);
        if (this.texture) {
            let uvs = [];
            this._vertexes.forEach(element => {
                const u = (element.x) / this.texture.width;
                //+ this.offset.x
                const v = 1.0 - (element.y) / this.texture.height;
                // + this.offset.y
                uvs.push(cc.v2(u, v));
            })
            mesh.setVertices(gfx.ATTR_UV0, uvs);

            //计算顶点索引
            if (this._vertexes.length >= 3) {
                let ids = [];
                for (let i = 0; i, this.vertCount; i++) {
                    ids.push(this.vertCount[i], this.vertCount[i + 1], this.vertCount[0]);
                };
                mesh.setIndices(ids);

                if (this.renderer.mesh != mesh) {
                    this.renderer.mesh = mesh;
                }
            }
        }

    }

    // onBeginContact(contact, selfCollider, otherCollider) {
    //     if (otherCollider.node.group == "water") {
    //         // this.node.children[0].active = false;
    //     }
    // },
    // streak() {
    //     // cc.log(this.node.getComponent(cc.RigidBody).linearVelocity.mag())
    //     if (this.node.getComponent(cc.RigidBody).linearVelocity.mag() > 600 && !this.openStreak) {
    //         this.openStreak = true;
    //         this.node.children[0].active = true;
    //         cc.log(true)
    //     }
    //     else if (this.node.getComponent(cc.RigidBody).linearVelocity.mag() <= 200 && this.openStreak) {
    //         this.node.children[0].getComponent(cc.MotionStreak).fadeTime *= 0.95;
    //         if (this.node.getComponent(cc.RigidBody).linearVelocity.mag() < 10) {
    //             this.openStreak = false;
    //             this.node.children[0].active = false;
    //         }
    //     }
    // },
    // update (dt) {},
});
