"use strict";
cc._RF.push(module, '6ea46IR6IRP/Z1ps3HwpFZl', 'MetaBallsRenderer');
// MetaBalls/Shader/MetaBalls/MetaBallsRenderer.ts

Object.defineProperty(exports, "__esModule", { value: true });
/****************************************************************************
 Author: GT <caogtaa@gmail.com>
 https://caogtaa.github.io
****************************************************************************/
//关键
var MetaBallsAssembler_1 = require("./MetaBallsAssembler");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
//继承cc.Sprite
var MetaBallsRenderer = /** @class */ (function (_super) {
    __extends(MetaBallsRenderer, _super);
    function MetaBallsRenderer() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.materialWeb = null;
        _this.materialNative = null;
        return _this;
    }
    MetaBallsRenderer.prototype.onLoad = function () {
        //根据是否是客户端渲染选择设置web端材质或native材质
        if (CC_NATIVERENDERER) {
            this.materialNative && this.setMaterial(0, this.materialNative);
        }
        else {
            this.materialWeb && this.setMaterial(0, this.materialWeb);
        }
    };
    MetaBallsRenderer.prototype.SetParticles = function (particles) {
        //@ts-ignore
        //???
        this._assembler.particles = particles;
        //获得材质
        var material = this.getMaterial(0);
        if (particles && material) {
            var PTM_RATIO = cc.PhysicsManager.PTM_RATIO;
            if (CC_NATIVERENDERER) {
                // native渲染时以节点anchor为世界空间原点
                material.setProperty("offset", [0.5, 0.5]);
            }
            else {
                // web默认以左下为世界空间原点。两个平台内shader内通过offset实现坐标统一
                material.setProperty("offset", [0.0, 0.0]);
            }
            // particles.GetRadius() * PTM_RATIO 是相对于场景(世界空间)的大小
            // particles.GetRadius() * PTM_RATIO / this.node.width 是相对于纹理的大小(纹理和屏幕同宽)，范围[0, 1]
            material.setProperty("radius", particles.GetRadius() * PTM_RATIO / this.node.width);
            material.setProperty("yratio", this.node.height / this.node.width);
            material.setProperty("reverseRes", [1.0 / this.node.width, 1.0 / this.node.height]);
        }
        this.setVertsDirty();
    };
    MetaBallsRenderer.prototype._resetAssembler = function () {
        this.setVertsDirty();
        var assembler = this._assembler = new MetaBallsAssembler_1.default();
        assembler.init(this);
    };
    MetaBallsRenderer.prototype.update = function () {
        this.setVertsDirty();
    };
    __decorate([
        property(cc.Material)
    ], MetaBallsRenderer.prototype, "materialWeb", void 0);
    __decorate([
        property(cc.Material)
    ], MetaBallsRenderer.prototype, "materialNative", void 0);
    MetaBallsRenderer = __decorate([
        ccclass
    ], MetaBallsRenderer);
    return MetaBallsRenderer;
}(cc.Sprite));
exports.default = MetaBallsRenderer;

cc._RF.pop();