"use strict";
cc._RF.push(module, 'b966cllGNNEA7loFRhDfuaQ', 'test');
// script/test.js

"use strict";

cc.Class({
  "extends": cc.Component,
  properties: {
    water: cc.Prefab,
    waterLayer: cc.Node,
    ground: cc.Node,
    graphics: cc.Graphics
  },
  // LIFE-CYCLE CALLBACKS:
  onLoad: function onLoad() {
    //
    this.DIG_RADIUS = 50;
    this.DIG_FRAGMENT = 12; //

    this.DIG_OPTIMIZE_SIZE = 1; //

    cc.macro.ENABLE_MULTI_TOUCH = false;
    var manager = cc.director.getPhysicsManager();
    manager.enabled = true; // cc.director.getPhysicsManager().debugDrawFlags = true;

    manager.enabledAccumulator = true;
    cc.PhysicsManager.FIXED_TIME_STEP = 1 / 30;
    manager.VELOCITY_ITERATIONS = 8;
    manager.POSITION_ITERATIONS = 8; //

    for (var index = 0; index < 100; index++) {
      c = this.ground.addComponent(cc.PhysicsChainCollider);
      c.loop = true;
      c.enabled = false;
    } // this.node.on("touchstart", this.creatWater, this);

  },
  start: function start() {
    //
    this.ground.on(cc.Node.EventType.TOUCH_START, this._touchMove, this);
    this.ground.on(cc.Node.EventType.TOUCH_MOVE, this._touchMove, this); //

    this.reset(); //

    this.schedule(this.creatWater, 0.5);
  },
  _optimizePoint: function _optimizePoint(point) {
    return [Math.floor(point[0] * this.DIG_OPTIMIZE_SIZE) / this.DIG_OPTIMIZE_SIZE, Math.floor(point[1] * this.DIG_OPTIMIZE_SIZE) / this.DIG_OPTIMIZE_SIZE];
  },
  _optimizeRegions: function _optimizeRegions() {
    var _this = this;

    var regions = [];

    var _loop = function _loop(index) {
      var pos = _this._regions[index];
      var newPos = [];
      pos.forEach(function (p, i) {
        p = _this._optimizePoint(p);

        var p_pre = _this._optimizePoint(pos[(i - 1 + pos.length) % pos.length]);

        var p_next = _this._optimizePoint(pos[(i + 1) % pos.length]);

        var vec1 = cc.v2(p[0] - p_pre[0], p[1] - p_pre[1]);
        var vec2 = cc.v2(p_next[0] - p[0], p_next[1] - p[1]);

        if (vec1.lengthSqr() != 0 && vec2.lengthSqr() != 0 && vec1.cross(vec2) != 0) {
          newPos.push(p);
        }
      });

      if (newPos.length > 2) {
        regions.push(newPos);
      }
    };

    for (var index = 0; index < this._regions.length; index++) {
      _loop(index);
    }

    this._regions = regions;
  },
  reset: function reset() {
    this._regions = [[[-cc.winSize.width / 2, -320], [-cc.winSize.width / 2, 250], [cc.winSize.width / 2, 250], [cc.winSize.width / 2, -320]]];
    this.draw();
  },
  draw: function draw() {
    var _this2 = this;

    var chains = this.ground.getComponents(cc.PhysicsChainCollider);
    chains.forEach(function (c) {
      c.enabled = false;
    });
    var enabled_chains_points = [[]];

    for (var index = 0; index < this._regions.length; index++) {
      var pos = this._regions[index];
      var poly = chains[index];

      if (!poly) {
        poly = this.ground.addComponent(cc.PhysicsChainCollider);
        poly.loop = true;
      }

      poly.points.length = 0;
      poly.points = pos.map(function (v, i) {
        var v2 = cc.v2(v[0], v[1]);
        return v2;
      });
      poly.enabled = true;
      enabled_chains_points[index] = poly.points;
    } //


    this.graphics.clear(true);
    var enabled_chains_points_sort = enabled_chains_points.map(function (curPoly, curPoly_i) {
      var count = enabled_chains_points.reduce(function (pre, nextPoly, nextPoly_i) {
        if (curPoly_i != nextPoly_i) {
          var length = curPoly.length;

          for (var i = 0; i < length; ++i) {
            var p0 = curPoly[i];
            if (!cc.Intersection.pointInPolygon(p0, nextPoly)) return pre;
          }

          return pre + 1;
        }

        return pre;
      }, 0);
      return {
        curPoly: curPoly,
        count: count
      };
    }).sort(function (a, b) {
      return a.count - b.count;
    });
    enabled_chains_points_sort.forEach(function (_ref) {
      var curPoly = _ref.curPoly,
          count = _ref.count;
      _this2.graphics.fillColor = count % 2 === 0 ? cc.Color.ORANGE : cc.Color.BLACK;

      _this2._drawPoly(_this2.graphics, curPoly);

      _this2.graphics.fill();
    });
  },
  _touchMove: function _touchMove(touch) {
    // let regions = [[]];
    // let pos = this.ground.convertToNodeSpaceAR(touch.getLocation());
    // let count = this.DIG_FRAGMENT;
    // for (let index = 0; index < count; index++) {
    //     let r = 2 * Math.PI * index / count;
    //     let x = pos.x + this.DIG_RADIUS * Math.cos(r);
    //     let y = pos.y + this.DIG_RADIUS * Math.sin(r);
    //     regions[0].push([x, y]);
    // }
    var regions = [[]];
    var pos = this.graphics.node.convertToNodeSpaceAR(touch.getLocation());
    var delta = touch.getDelta();
    var count = this.DIG_FRAGMENT;

    if (delta.lengthSqr() < 5) {
      for (var index = 0; index < count; index++) {
        var r = 2 * Math.PI * index / count;
        var x = pos.x + this.DIG_RADIUS * Math.cos(r);
        var y = pos.y + this.DIG_RADIUS * Math.sin(r);
        regions[0].push(this._optimizePoint([x, y]));
      }
    } else {
      var startPos = pos.sub(delta);

      for (var _index = 0; _index < count; _index++) {
        var _r = 2 * Math.PI * _index / count;

        var vec_x = this.DIG_RADIUS * Math.cos(_r);
        var vec_y = this.DIG_RADIUS * Math.sin(_r);

        var _x = void 0,
            _y = void 0;

        if (delta.dot(cc.v2(vec_x, vec_y)) > 0) {
          _x = pos.x + vec_x;
          _y = pos.y + vec_y;
        } else {
          _x = startPos.x + vec_x;
          _y = startPos.y + vec_y;
        }

        regions[0].push(this._optimizePoint([_x, _y]));
      }
    } // let result = PolyBool.difference({
    //     regions: this._regions,
    //     inverted: false
    // }, {
    //     regions,
    //     inverted: false
    // });


    var seg1 = PolyBool.segments({
      regions: this._regions,
      inverted: false
    });
    var seg2 = PolyBool.segments({
      regions: regions,
      inverted: false
    });
    var comb = PolyBool.combine(seg1, seg2);
    var result = PolyBool.polygon(PolyBool.selectDifference(comb)); //

    this._regions = result.regions;

    this._optimizeRegions();

    this.draw();
  },
  _drawPoly: function _drawPoly(ctx, poly) {
    poly.forEach(function (pos, i) {
      if (i === 0) ctx.moveTo(pos.x, pos.y);else ctx.lineTo(pos.x, pos.y);
      ctx.close();
    });
  },
  creatWater: function creatWater() {
    var waterNum = 1;

    for (var i = 0; i < waterNum; i++) {
      var waterPre = cc.instantiate(this.water);
      waterPre.x = 0;
      waterPre.y = cc.winSize.height;
      this.waterLayer.addChild(waterPre);
    }
  } // update (dt) {},

});

cc._RF.pop();